/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.EncoderUtil;
import io.trino.spi.block.VariableWidthBlock;
import java.util.Arrays;
import java.util.Objects;

public class VariableWidthBlockEncoding
implements BlockEncoding {
    public static final String NAME = "VARIABLE_WIDTH";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Class<? extends Block> getBlockClass() {
        return VariableWidthBlock.class;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        VariableWidthBlock variableWidthBlock = (VariableWidthBlock)block;
        int positionCount = variableWidthBlock.getPositionCount();
        sliceOutput.appendInt(positionCount);
        int arrayBaseOffset = variableWidthBlock.getRawArrayBase();
        boolean[] isNull = variableWidthBlock.getRawValueIsNull();
        int[] rawOffsets = variableWidthBlock.getRawOffsets();
        Objects.checkFromIndexSize(arrayBaseOffset, positionCount + 1, rawOffsets.length);
        int[] lengths = new int[positionCount];
        int totalLength = 0;
        int nonNullsCount = 0;
        for (int position = 0; position < positionCount; ++position) {
            int length = rawOffsets[position + arrayBaseOffset + 1] - rawOffsets[position + arrayBaseOffset];
            totalLength += length;
            lengths[nonNullsCount] = length;
            nonNullsCount += isNull != null && isNull[position + arrayBaseOffset] ? 0 : 1;
        }
        sliceOutput.appendInt(nonNullsCount).writeInts(lengths, 0, nonNullsCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, isNull, arrayBaseOffset, positionCount);
        sliceOutput.appendInt(totalLength).writeBytes(variableWidthBlock.getRawSlice(), variableWidthBlock.getPositionOffset(0), totalLength);
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        int nonNullsCount = sliceInput.readInt();
        if (nonNullsCount > positionCount) {
            throw new IllegalArgumentException(String.format("nonNullsCount must be <= positionCount, found: %s > %s", nonNullsCount, positionCount));
        }
        int[] offsets = new int[positionCount + 1];
        int lengthIndex = offsets.length - nonNullsCount;
        sliceInput.readInts(offsets, lengthIndex, nonNullsCount);
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).orElse(null);
        if (valueIsNull == null) {
            if (positionCount != nonNullsCount || lengthIndex != 1) {
                throw new IllegalArgumentException(String.format("nonNullsCount must equal positionCount, found: %s <> %s", nonNullsCount, positionCount));
            }
            for (int i = 1; i < offsets.length; ++i) {
                int n = i;
                offsets[n] = offsets[n] + offsets[i - 1];
            }
        } else {
            VariableWidthBlockEncoding.computeOffsetsFromLengths(offsets, valueIsNull, lengthIndex);
        }
        int blockSize = sliceInput.readInt();
        Slice slice = Slices.allocate((int)blockSize);
        sliceInput.readBytes(slice);
        return new VariableWidthBlock(0, positionCount, slice, offsets, valueIsNull);
    }

    private static void computeOffsetsFromLengths(int[] offsets, boolean[] valueIsNull, int lengthIndex) {
        if (lengthIndex < 0 || lengthIndex > offsets.length) {
            throw new IllegalArgumentException(String.format("Invalid lengthIndex %s for offsets %s", lengthIndex, offsets.length));
        }
        int currentOffset = 0;
        for (int i = 1; i < offsets.length; ++i) {
            if (lengthIndex == offsets.length) {
                Arrays.fill(offsets, i, offsets.length, currentOffset);
                break;
            }
            boolean isNull = valueIsNull[i - 1];
            int length = offsets[lengthIndex];
            lengthIndex += isNull ? 0 : 1;
            offsets[i] = currentOffset += isNull ? 0 : length;
        }
        if (lengthIndex != offsets.length) {
            throw new IllegalArgumentException(String.format("Failed to consume all length entries, found %s <> %s", lengthIndex, offsets.length));
        }
    }
}

