/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.airlift.slice.SizeOf;
import java.util.Objects;

public record CatalogVersion(String version) {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(CatalogVersion.class);

    @JsonCreator
    public CatalogVersion {
        Objects.requireNonNull(version, "version is null");
        if (version.isEmpty()) {
            throw new IllegalArgumentException("version is empty");
        }
        for (int i = 0; i < version.length(); ++i) {
            if (CatalogVersion.isAllowedCharacter(version.charAt(i))) continue;
            throw new IllegalArgumentException("invalid version: " + version);
        }
    }

    private static boolean isAllowedCharacter(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'z' || c == '_' || c == '-';
    }

    @Override
    @JsonValue
    public String toString() {
        return this.version;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.version);
    }
}

