/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import java.util.List;

public interface ConnectorSplit {
    default public boolean isRemotelyAccessible() {
        return true;
    }

    default public List<HostAddress> getAddresses() {
        if (!this.isRemotelyAccessible()) {
            throw new IllegalStateException("getAddresses must be implemented when for splits with isRemotelyAccessible=false");
        }
        return List.of();
    }

    default public SplitWeight getSplitWeight() {
        return SplitWeight.standard();
    }

    default public long getRetainedSizeInBytes() {
        throw new UnsupportedOperationException("This connector does not provide memory accounting capabilities for ConnectorSplit");
    }
}

