/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableSchema;
import io.trino.spi.connector.SchemaTableName;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ConnectorTableMetadata {
    private final SchemaTableName table;
    private final Optional<String> comment;
    private final List<ColumnMetadata> columns;
    private final Map<String, Object> properties;
    private final List<String> checkConstraints;

    public ConnectorTableMetadata(SchemaTableName table, List<ColumnMetadata> columns) {
        this(table, columns, Collections.emptyMap());
    }

    public ConnectorTableMetadata(SchemaTableName table, List<ColumnMetadata> columns, Map<String, Object> properties) {
        this(table, columns, properties, Optional.empty(), List.of());
    }

    public ConnectorTableMetadata(SchemaTableName table, List<ColumnMetadata> columns, Map<String, Object> properties, Optional<String> comment) {
        this(table, columns, properties, comment, List.of());
    }

    public ConnectorTableMetadata(SchemaTableName table, List<ColumnMetadata> columns, Map<String, Object> properties, Optional<String> comment, List<String> checkConstraints) {
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(comment, "comment is null");
        Objects.requireNonNull(checkConstraints, "checkConstraints is null");
        this.table = table;
        this.columns = List.copyOf(columns);
        this.properties = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(properties));
        this.comment = comment;
        this.checkConstraints = List.copyOf(checkConstraints);
    }

    public SchemaTableName getTable() {
        return this.table;
    }

    public List<ColumnMetadata> getColumns() {
        return this.columns;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public List<String> getCheckConstraints() {
        return this.checkConstraints;
    }

    public ConnectorTableSchema getTableSchema() {
        return new ConnectorTableSchema(this.table, this.columns.stream().map(ColumnMetadata::getColumnSchema).collect(Collectors.toUnmodifiableList()), this.checkConstraints);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConnectorTableMetadata{");
        sb.append("table=").append(this.table);
        sb.append(", columns=").append(this.columns);
        sb.append(", properties=").append(this.properties);
        this.comment.ifPresent(value -> sb.append(", comment='").append((String)value).append("'"));
        sb.append(", checkConstraints=").append(this.checkConstraints);
        sb.append('}');
        return sb.toString();
    }
}

