/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.connector.ColumnSchema;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public class ConnectorTableSchema {
    private final SchemaTableName table;
    private final List<ColumnSchema> columns;
    private final List<String> checkConstraints;

    public ConnectorTableSchema(SchemaTableName table, List<ColumnSchema> columns) {
        this(table, columns, List.of());
    }

    public ConnectorTableSchema(SchemaTableName table, List<ColumnSchema> columns, List<String> checkConstraints) {
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(checkConstraints, "checkConstraints is null");
        this.table = table;
        this.columns = List.copyOf(columns);
        this.checkConstraints = List.copyOf(checkConstraints);
    }

    public SchemaTableName getTable() {
        return this.table;
    }

    public List<ColumnSchema> getColumns() {
        return this.columns;
    }

    public List<String> getCheckConstraints() {
        return this.checkConstraints;
    }

    public String toString() {
        return new StringJoiner(", ", ConnectorTableSchema.class.getSimpleName() + "[", "]").add("table=" + String.valueOf(this.table)).add("columns=" + String.valueOf(this.columns)).add("checkConstraints=" + String.valueOf(this.checkConstraints)).toString();
    }
}

