/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.eventlistener;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.Unstable;
import io.trino.spi.connector.CatalogVersion;
import io.trino.spi.eventlistener.OutputColumnMetadata;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QueryOutputMetadata {
    private final String catalogName;
    private final CatalogVersion catalogVersion;
    private final String schema;
    private final String table;
    private final Optional<List<OutputColumnMetadata>> columns;
    private final Optional<String> connectorOutputMetadata;
    private final Optional<Boolean> jsonLengthLimitExceeded;

    @JsonCreator
    @Unstable
    public QueryOutputMetadata(String catalogName, CatalogVersion catalogVersion, String schema, String table, Optional<List<OutputColumnMetadata>> columns, Optional<String> connectorOutputMetadata, Optional<Boolean> jsonLengthLimitExceeded) {
        this.catalogVersion = Objects.requireNonNull(catalogVersion, "catalogVersion is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.columns = Objects.requireNonNull(columns, "columns is null");
        this.connectorOutputMetadata = Objects.requireNonNull(connectorOutputMetadata, "connectorOutputMetadata is null");
        this.jsonLengthLimitExceeded = Objects.requireNonNull(jsonLengthLimitExceeded, "jsonLengthLimitExceeded is null");
    }

    @JsonProperty
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    public CatalogVersion getCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public Optional<List<OutputColumnMetadata>> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Optional<String> getConnectorOutputMetadata() {
        return this.connectorOutputMetadata;
    }

    @JsonProperty
    public Optional<Boolean> getJsonLengthLimitExceeded() {
        return this.jsonLengthLimitExceeded;
    }
}

