/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.Signature;
import io.trino.spi.type.Type;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BoundSignature {
    private final CatalogSchemaFunctionName name;
    private final Type returnType;
    private final List<Type> argumentTypes;

    @JsonCreator
    public BoundSignature(@JsonProperty(value="name") CatalogSchemaFunctionName name, @JsonProperty(value="returnType") Type returnType, @JsonProperty(value="argumentTypes") List<Type> argumentTypes) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.argumentTypes = List.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
    }

    @JsonProperty
    public CatalogSchemaFunctionName getName() {
        return this.name;
    }

    @JsonProperty
    public Type getReturnType() {
        return this.returnType;
    }

    public int getArity() {
        return this.argumentTypes.size();
    }

    public Type getArgumentType(int index) {
        return this.argumentTypes.get(index);
    }

    @JsonProperty
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    public Signature toSignature() {
        return Signature.builder().returnType(this.returnType).argumentTypes(this.argumentTypes.stream().map(Type::getTypeSignature).collect(Collectors.toUnmodifiableList())).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundSignature that = (BoundSignature)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.returnType, that.returnType) && Objects.equals(this.argumentTypes, that.argumentTypes);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.returnType, this.argumentTypes);
    }

    public String toString() {
        return String.valueOf(this.name) + this.argumentTypes.stream().map((Function<Type, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/trino/spi/type/Type;)Ljava/lang/String;)()).collect(Collectors.joining(", ", "(", "):")) + String.valueOf(this.returnType);
    }
}

