/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.DoNotCall;
import java.util.Objects;

public class LongVariableConstraint {
    private final String name;
    private final String expression;

    LongVariableConstraint(String name, String expression) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.expression = Objects.requireNonNull(expression, "expression is null");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.name + ":" + this.expression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongVariableConstraint that = (LongVariableConstraint)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.expression, that.expression);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.expression);
    }

    @JsonCreator
    @Deprecated
    @DoNotCall
    public static LongVariableConstraint fromJson(@JsonProperty(value="name") String name, @JsonProperty(value="expression") String expression) {
        return new LongVariableConstraint(name, expression);
    }
}

