/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function.table;

import io.trino.spi.function.table.ArgumentSpecification;
import io.trino.spi.function.table.Preconditions;
import io.trino.spi.function.table.Primitives;
import io.trino.spi.type.Type;
import java.util.Objects;

public class ScalarArgumentSpecification
extends ArgumentSpecification {
    private final Type type;

    private ScalarArgumentSpecification(String name, Type type, boolean required, Object defaultValue) {
        super(name, required, defaultValue);
        this.type = Objects.requireNonNull(type, "type is null");
        if (defaultValue != null) {
            Preconditions.checkArgument(Primitives.wrap(type.getJavaType()).isInstance(defaultValue), String.format("default value %s does not match the declared type: %s", defaultValue, type));
        }
    }

    public Type getType() {
        return this.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private Type type;
        private boolean required = true;
        private Object defaultValue;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder defaultValue(Object defaultValue) {
            this.required = false;
            this.defaultValue = defaultValue;
            return this;
        }

        public ScalarArgumentSpecification build() {
            return new ScalarArgumentSpecification(this.name, this.type, this.required, this.defaultValue);
        }
    }
}

