/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.function.table.Argument;
import io.trino.spi.type.RowType;
import java.util.List;
import java.util.Objects;

public class TableArgument
extends Argument {
    private final RowType rowType;
    private final List<String> partitionBy;
    private final List<String> orderBy;

    @JsonCreator
    public TableArgument(@JsonProperty(value="rowType") RowType rowType, @JsonProperty(value="partitionBy") List<String> partitionBy, @JsonProperty(value="orderBy") List<String> orderBy) {
        this.rowType = Objects.requireNonNull(rowType, "rowType is null");
        this.partitionBy = Objects.requireNonNull(partitionBy, "partitionBy is null");
        this.orderBy = Objects.requireNonNull(orderBy, "orderBy is null");
    }

    @JsonProperty
    public RowType getRowType() {
        return this.rowType;
    }

    @JsonProperty
    public List<String> getPartitionBy() {
        return this.partitionBy;
    }

    @JsonProperty
    public List<String> getOrderBy() {
        return this.orderBy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private RowType rowType;
        private List<String> partitionBy = List.of();
        private List<String> orderBy = List.of();

        private Builder() {
        }

        public Builder rowType(RowType rowType) {
            this.rowType = rowType;
            return this;
        }

        public Builder partitionBy(List<String> partitionBy) {
            this.partitionBy = partitionBy;
            return this;
        }

        public Builder orderBy(List<String> orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public TableArgument build() {
            return new TableArgument(this.rowType, this.partitionBy, this.orderBy);
        }
    }
}

