/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.predicate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.airlift.slice.SizeOf;
import io.trino.spi.block.Block;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.predicate.AllOrNone;
import io.trino.spi.predicate.DiscreteValues;
import io.trino.spi.predicate.Ranges;
import io.trino.spi.predicate.Utils;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.predicate.ValuesProcessor;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EquatableValueSet
implements ValueSet {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(EquatableValueSet.class);
    private final Type type;
    private final boolean inclusive;
    private final Set<ValueEntry> entries;

    @JsonCreator
    public EquatableValueSet(@JsonProperty(value="type") Type type, @JsonProperty(value="inclusive") boolean inclusive, @JsonProperty(value="entries") Set<ValueEntry> entries) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(entries, "entries is null");
        if (!type.isComparable()) {
            throw new IllegalArgumentException("Type is not comparable: " + String.valueOf(type));
        }
        if (type.isOrderable()) {
            throw new IllegalArgumentException("Use SortedRangeSet instead");
        }
        this.type = type;
        this.inclusive = inclusive;
        this.entries = Collections.unmodifiableSet(new LinkedHashSet<ValueEntry>(entries));
    }

    static EquatableValueSet none(Type type) {
        return new EquatableValueSet(type, true, Collections.emptySet());
    }

    static EquatableValueSet all(Type type) {
        return new EquatableValueSet(type, false, Collections.emptySet());
    }

    static EquatableValueSet of(Type type, Object first, Object ... rest) {
        LinkedHashSet<ValueEntry> set = new LinkedHashSet<ValueEntry>(rest.length + 1);
        set.add(ValueEntry.create(type, first));
        for (Object value : rest) {
            set.add(ValueEntry.create(type, value));
        }
        return new EquatableValueSet(type, true, set);
    }

    static EquatableValueSet copyOf(Type type, Collection<?> values) {
        return new EquatableValueSet(type, true, values.stream().map(value -> ValueEntry.create(type, value)).collect(EquatableValueSet.toLinkedSet()));
    }

    @Override
    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public boolean inclusive() {
        return this.inclusive;
    }

    @JsonProperty
    public Set<ValueEntry> getEntries() {
        return this.entries;
    }

    public Collection<Object> getValues() {
        return this.entries.stream().map(ValueEntry::getValue).collect(Collectors.toUnmodifiableList());
    }

    public int getValuesCount() {
        return this.entries.size();
    }

    @Override
    public boolean isNone() {
        return this.inclusive && this.entries.isEmpty();
    }

    @Override
    public boolean isAll() {
        return !this.inclusive && this.entries.isEmpty();
    }

    @Override
    public boolean isSingleValue() {
        return this.inclusive && this.entries.size() == 1;
    }

    @Override
    public Object getSingleValue() {
        if (!this.isSingleValue()) {
            throw new IllegalStateException("EquatableValueSet does not have just a single value");
        }
        return this.entries.iterator().next().getValue();
    }

    @Override
    public boolean isDiscreteSet() {
        return this.inclusive && !this.entries.isEmpty();
    }

    @Override
    public List<Object> getDiscreteSet() {
        if (!this.isDiscreteSet()) {
            throw new IllegalStateException("EquatableValueSet is not a discrete set");
        }
        return this.entries.stream().map(ValueEntry::getValue).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public boolean containsValue(Object value) {
        return this.inclusive == this.entries.contains(ValueEntry.create(this.type, value));
    }

    @Override
    public DiscreteValues getDiscreteValues() {
        return new DiscreteValues(){

            @Override
            public boolean isInclusive() {
                return EquatableValueSet.this.inclusive();
            }

            @Override
            public Collection<Object> getValues() {
                return EquatableValueSet.this.getValues();
            }

            @Override
            public int getValuesCount() {
                return EquatableValueSet.this.getValuesCount();
            }
        };
    }

    @Override
    public ValuesProcessor getValuesProcessor() {
        return new ValuesProcessor(){

            @Override
            public <T> T transform(Function<Ranges, T> rangesFunction, Function<DiscreteValues, T> valuesFunction, Function<AllOrNone, T> allOrNoneFunction) {
                return valuesFunction.apply(EquatableValueSet.this.getDiscreteValues());
            }

            @Override
            public void consume(Consumer<Ranges> rangesConsumer, Consumer<DiscreteValues> valuesConsumer, Consumer<AllOrNone> allOrNoneConsumer) {
                valuesConsumer.accept(EquatableValueSet.this.getDiscreteValues());
            }
        };
    }

    @Override
    public EquatableValueSet intersect(ValueSet other) {
        EquatableValueSet otherValueSet = this.checkCompatibility(other);
        if (this.inclusive && otherValueSet.inclusive()) {
            return new EquatableValueSet(this.type, true, EquatableValueSet.intersect(this.entries, otherValueSet.entries));
        }
        if (this.inclusive) {
            return new EquatableValueSet(this.type, true, EquatableValueSet.subtract(this.entries, otherValueSet.entries));
        }
        if (otherValueSet.inclusive()) {
            return new EquatableValueSet(this.type, true, EquatableValueSet.subtract(otherValueSet.entries, this.entries));
        }
        return new EquatableValueSet(this.type, false, EquatableValueSet.union(otherValueSet.entries, this.entries));
    }

    @Override
    public boolean overlaps(ValueSet other) {
        EquatableValueSet otherValueSet = this.checkCompatibility(other);
        if (this.inclusive && otherValueSet.inclusive()) {
            return EquatableValueSet.setsOverlap(this.entries, otherValueSet.entries);
        }
        if (this.inclusive) {
            return !otherValueSet.entries.containsAll(this.entries);
        }
        if (otherValueSet.inclusive()) {
            return !this.entries.containsAll(otherValueSet.entries);
        }
        return true;
    }

    @Override
    public EquatableValueSet union(ValueSet other) {
        EquatableValueSet otherValueSet = this.checkCompatibility(other);
        if (this.inclusive && otherValueSet.inclusive()) {
            return new EquatableValueSet(this.type, true, EquatableValueSet.union(this.entries, otherValueSet.entries));
        }
        if (this.inclusive) {
            return new EquatableValueSet(this.type, false, EquatableValueSet.subtract(otherValueSet.entries, this.entries));
        }
        if (otherValueSet.inclusive()) {
            return new EquatableValueSet(this.type, false, EquatableValueSet.subtract(this.entries, otherValueSet.entries));
        }
        return new EquatableValueSet(this.type, false, EquatableValueSet.intersect(otherValueSet.entries, this.entries));
    }

    @Override
    public boolean contains(ValueSet other) {
        EquatableValueSet otherValueSet = this.checkCompatibility(other);
        if (this.inclusive && otherValueSet.inclusive()) {
            return this.entries.containsAll(otherValueSet.entries);
        }
        if (this.inclusive) {
            return false;
        }
        if (otherValueSet.inclusive()) {
            return !EquatableValueSet.setsOverlap(this.entries, otherValueSet.entries);
        }
        return otherValueSet.entries.containsAll(this.entries);
    }

    @Override
    public EquatableValueSet complement() {
        return new EquatableValueSet(this.type, !this.inclusive, this.entries);
    }

    @Override
    public String toString() {
        return this.toString(10);
    }

    @Override
    public String toString(int limit) {
        return new StringJoiner(", ", EquatableValueSet.class.getSimpleName() + "[", "]").add("type=" + String.valueOf(this.type)).add("values=" + this.getValuesCount()).add(this.formatValues(limit)).toString();
    }

    @Override
    public Optional<Collection<Object>> tryExpandRanges(int valuesLimit) {
        if (this.inclusive() && this.getValuesCount() <= valuesLimit) {
            return Optional.of(this.getValues());
        }
        return Optional.empty();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.entries, ValueEntry::getRetainedSizeInBytes);
    }

    private String formatValues(int limit) {
        return Stream.concat(this.entries.stream().map(entry -> this.type.getObjectValue(entry.getBlock(), 0).toString()).limit(limit), limit < this.getValuesCount() ? Stream.of("...") : Stream.of(new String[0])).collect(Collectors.joining(", ", this.inclusive ? "{" : "EXCLUDES{", "}"));
    }

    private static <T> Set<T> intersect(Set<T> set1, Set<T> set2) {
        if (set1.size() > set2.size()) {
            return EquatableValueSet.intersect(set2, set1);
        }
        return set1.stream().filter(set2::contains).collect(EquatableValueSet.toLinkedSet());
    }

    private static <T> boolean setsOverlap(Set<T> set1, Set<T> set2) {
        if (set1.size() > set2.size()) {
            return EquatableValueSet.setsOverlap(set2, set1);
        }
        for (T element : set1) {
            if (!set2.contains(element)) continue;
            return true;
        }
        return false;
    }

    private static <T> Set<T> union(Set<T> set1, Set<T> set2) {
        return Stream.concat(set1.stream(), set2.stream()).collect(EquatableValueSet.toLinkedSet());
    }

    private static <T> Set<T> subtract(Set<T> set1, Set<T> set2) {
        return set1.stream().filter(value -> !set2.contains(value)).collect(EquatableValueSet.toLinkedSet());
    }

    private EquatableValueSet checkCompatibility(ValueSet other) {
        if (!this.getType().equals(other.getType())) {
            throw new IllegalStateException(String.format("Mismatched types: %s vs %s", this.getType(), other.getType()));
        }
        if (!(other instanceof EquatableValueSet)) {
            throw new IllegalStateException(String.format("ValueSet is not a EquatableValueSet: %s", other.getClass()));
        }
        EquatableValueSet equatableValueSet = (EquatableValueSet)other;
        return equatableValueSet;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.inclusive, this.entries);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EquatableValueSet other = (EquatableValueSet)obj;
        return Objects.equals(this.type, other.type) && this.inclusive == other.inclusive && Objects.equals(this.entries, other.entries);
    }

    private static <T> Collector<T, ?, Set<T>> toLinkedSet() {
        return Collectors.toCollection(LinkedHashSet::new);
    }

    public static class ValueEntry {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(ValueEntry.class);
        private final Type type;
        private final Block block;
        private final MethodHandle equalOperator;
        private final MethodHandle hashCodeOperator;

        @JsonCreator
        public ValueEntry(@JsonProperty(value="type") Type type, @JsonProperty(value="block") Block block) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.block = Objects.requireNonNull(block, "block is null");
            if (block.getPositionCount() != 1) {
                throw new IllegalArgumentException("Block should only have one position");
            }
            this.equalOperator = Utils.TUPLE_DOMAIN_TYPE_OPERATORS.getEqualOperator(type, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.DEFAULT_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
            this.hashCodeOperator = Utils.TUPLE_DOMAIN_TYPE_OPERATORS.getHashCodeOperator(type, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
        }

        public static ValueEntry create(Type type, Object value) {
            return new ValueEntry(type, Utils.nativeValueToBlock(type, value));
        }

        @JsonProperty
        public Type getType() {
            return this.type;
        }

        @JsonProperty
        public Block getBlock() {
            return this.block;
        }

        public Object getValue() {
            return Utils.blockToNativeValue(this.type, this.block);
        }

        public int hashCode() {
            try {
                return (int)this.hashCodeOperator.invokeExact(this.block, 0);
            }
            catch (Throwable throwable) {
                throw Utils.handleThrowable(throwable);
            }
        }

        public boolean equals(Object obj) {
            boolean result;
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ValueEntry other = (ValueEntry)obj;
            if (!Objects.equals(this.type, other.type)) {
                return false;
            }
            try {
                result = this.equalOperator.invokeExact(this.block, 0, other.block, 0);
            }
            catch (Throwable throwable) {
                throw Utils.handleThrowable(throwable);
            }
            return result;
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + this.block.getRetainedSizeInBytes();
        }
    }
}

