/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.block.Block;
import io.trino.spi.type.AbstractIntType;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.util.Optional;

public final class DateType
extends AbstractIntType {
    public static final DateType DATE = new DateType();

    private DateType() {
        super(new TypeSignature("date", new TypeSignatureParameter[0]));
    }

    @Override
    public Object getObjectValue(Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        int days = this.getInt(block, position);
        return new SqlDate(days);
    }

    @Override
    public Optional<Type.Range> getRange() {
        return Optional.of(new Type.Range(Integer.MIN_VALUE, Integer.MAX_VALUE));
    }

    @Override
    public Optional<Object> getPreviousValue(Object object) {
        long value = (Long)object;
        this.checkValueValid(value);
        if (value == Integer.MIN_VALUE) {
            return Optional.empty();
        }
        return Optional.of(value - 1L);
    }

    @Override
    public Optional<Object> getNextValue(Object object) {
        long value = (Long)object;
        this.checkValueValid(value);
        if (value == Integer.MAX_VALUE) {
            return Optional.empty();
        }
        return Optional.of(value + 1L);
    }

    @Override
    public boolean equals(Object other) {
        return other == DATE;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

