/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.XxHash64;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.function.FlatFixed;
import io.trino.spi.function.FlatFixedOffset;
import io.trino.spi.function.FlatVariableOffset;
import io.trino.spi.function.FlatVariableWidth;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractLongType;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Optional;

public final class TimeType
extends AbstractLongType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(TimeType.class, MethodHandles.lookup(), Long.TYPE);
    private static final VarHandle LONG_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    public static final int MAX_PRECISION = 12;
    public static final int DEFAULT_PRECISION = 3;
    private static final TimeType[] TYPES = new TimeType[13];
    public static final TimeType TIME_SECONDS;
    public static final TimeType TIME_MILLIS;
    public static final TimeType TIME_MICROS;
    public static final TimeType TIME_NANOS;
    public static final TimeType TIME_PICOS;
    private final int precision;

    private TimeType(int precision) {
        super(new TypeSignature("time", TypeSignatureParameter.numericParameter(precision)));
        this.precision = precision;
    }

    public static TimeType createTimeType(int precision) {
        if (precision < 0 || precision > 12) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("TIME precision must be in range [0, %s]: %s", 12, precision));
        }
        return TYPES[precision];
    }

    public int getPrecision() {
        return this.precision;
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public Object getObjectValue(Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return SqlTime.newInstance(this.precision, this.getLong(block, position));
    }

    @Override
    public Optional<Type.Range> getRange() {
        return Optional.of(new Type.Range(0, 86400000000000000L));
    }

    @Override
    public Optional<Object> getPreviousValue(Object object) {
        long value = (Long)object;
        if (0L == value) {
            return Optional.empty();
        }
        return Optional.of(value - Timestamps.rescale(1000000000000L, this.getPrecision(), 0));
    }

    @Override
    public Optional<Object> getNextValue(Object object) {
        long value = (Long)object;
        if (86400000000000000L == value) {
            return Optional.empty();
        }
        return Optional.of(value + Timestamps.rescale(1000000000000L, this.getPrecision(), 0));
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static long readFlat(@FlatFixed byte[] fixedSizeSlice, @FlatFixedOffset int fixedSizeOffset, @FlatVariableWidth byte[] unusedVariableSizeSlice, @FlatVariableOffset int unusedVariableSizeOffset) {
        return LONG_HANDLE.get(fixedSizeSlice, fixedSizeOffset);
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void writeFlat(long value, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] unusedVariableSizeSlice, int unusedVariableSizeOffset) {
        LONG_HANDLE.set(fixedSizeSlice, fixedSizeOffset, value);
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    public static boolean equalOperator(long left, long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    public static long hashCodeOperator(long value) {
        return AbstractLongType.hash(value);
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    public static long xxHash64Operator(long value) {
        return XxHash64.hash((long)value);
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(long left, long right) {
        return Long.compare(left, right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    public static boolean lessThan(long left, long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    public static boolean lessThanOrEqual(long left, long right) {
        return left <= right;
    }

    static {
        for (int precision = 0; precision <= 12; ++precision) {
            TimeType.TYPES[precision] = new TimeType(precision);
        }
        TIME_SECONDS = TimeType.createTimeType(0);
        TIME_MILLIS = TimeType.createTimeType(3);
        TIME_MICROS = TimeType.createTimeType(6);
        TIME_NANOS = TimeType.createTimeType(9);
        TIME_PICOS = TimeType.createTimeType(12);
    }
}

