/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spooling.filesystem;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import io.azam.ulidj.ULID;
import io.trino.filesystem.encryption.EncryptionKey;
import io.trino.spi.protocol.SpooledSegmentHandle;
import io.trino.spi.protocol.SpoolingContext;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;

public record FileSystemSpooledSegmentHandle(String encoding, byte[] uuid, Optional<EncryptionKey> encryptionKey) implements SpooledSegmentHandle
{
    public FileSystemSpooledSegmentHandle {
        Objects.requireNonNull(encryptionKey, "encryptionKey is null");
        Verify.verify((uuid.length == 16 ? 1 : 0) != 0, (String)"uuid must be 128 bits", (Object[])new Object[0]);
    }

    public static FileSystemSpooledSegmentHandle random(Random random, SpoolingContext context, Instant expireAt) {
        return FileSystemSpooledSegmentHandle.random(random, context, expireAt, Optional.empty());
    }

    public static FileSystemSpooledSegmentHandle random(Random random, SpoolingContext context, Instant expireAt, Optional<EncryptionKey> encryptionKey) {
        return new FileSystemSpooledSegmentHandle(context.encoding(), ULID.generateBinary((long)expireAt.toEpochMilli(), (byte[])FileSystemSpooledSegmentHandle.entropy(random)), encryptionKey);
    }

    public Instant expirationTime() {
        return Instant.ofEpochMilli(ULID.getTimestampBinary((byte[])this.uuid()));
    }

    public String identifier() {
        return ULID.fromBinary((byte[])this.uuid);
    }

    private static byte[] entropy(Random random) {
        byte[] entropy = new byte[16];
        random.nextBytes(entropy);
        return entropy;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("encoding", (Object)this.encoding).add("expires", (Object)Instant.ofEpochMilli(ULID.getTimestampBinary((byte[])this.uuid))).add("identifier", (Object)this.identifier()).add("encoding", (Object)this.encoding).add("encryptionKey", (Object)this.encryptionKey.map(encryptionKey -> "[redacted]").orElse("[none")).toString();
    }
}

