/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.filesystem.Location;
import io.trino.filesystem.s3.S3Location;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;

public final class S3SecurityMapping {
    private final Predicate<String> user;
    private final Predicate<Collection<String>> group;
    private final Predicate<S3Location> prefix;
    private final Optional<String> iamRole;
    private final Optional<String> roleSessionName;
    private final Set<String> allowedIamRoles;
    private final Optional<String> kmsKeyId;
    private final Set<String> allowedKmsKeyIds;
    private final Optional<String> sseCustomerKey;
    private final Set<String> allowedSseCustomerKeys;
    private final Optional<AwsCredentials> credentials;
    private final boolean useClusterDefault;
    private final Optional<String> endpoint;
    private final Optional<String> region;

    @JsonCreator
    public S3SecurityMapping(@JsonProperty(value="user") Optional<Pattern> user, @JsonProperty(value="group") Optional<Pattern> group, @JsonProperty(value="prefix") Optional<String> prefix, @JsonProperty(value="iamRole") Optional<String> iamRole, @JsonProperty(value="roleSessionName") Optional<String> roleSessionName, @JsonProperty(value="allowedIamRoles") Optional<List<String>> allowedIamRoles, @JsonProperty(value="kmsKeyId") Optional<String> kmsKeyId, @JsonProperty(value="allowedKmsKeyIds") Optional<List<String>> allowedKmsKeyIds, @JsonProperty(value="sseCustomerKey") Optional<String> sseCustomerKey, @JsonProperty(value="allowedSseCustomerKeys") Optional<List<String>> allowedSseCustomerKeys, @JsonProperty(value="accessKey") Optional<String> accessKey, @JsonProperty(value="secretKey") Optional<String> secretKey, @JsonProperty(value="useClusterDefault") Optional<Boolean> useClusterDefault, @JsonProperty(value="endpoint") Optional<String> endpoint, @JsonProperty(value="region") Optional<String> region) {
        this.user = user.map(S3SecurityMapping::toPredicate).orElse(string -> true);
        this.group = group.map(S3SecurityMapping::toPredicate).map(S3SecurityMapping::anyMatch).orElse(collection -> true);
        this.prefix = prefix.map(Location::of).map(S3Location::new).map(S3SecurityMapping::prefixPredicate).orElse(s3Location -> true);
        this.iamRole = Objects.requireNonNull(iamRole, "iamRole is null");
        this.roleSessionName = Objects.requireNonNull(roleSessionName, "roleSessionName is null");
        Preconditions.checkArgument((roleSessionName.isEmpty() || iamRole.isPresent() ? 1 : 0) != 0, (Object)"iamRole must be provided when roleSessionName is provided");
        this.allowedIamRoles = ImmutableSet.copyOf((Collection)allowedIamRoles.orElse((List<String>)ImmutableList.of()));
        this.kmsKeyId = Objects.requireNonNull(kmsKeyId, "kmsKeyId is null");
        this.allowedKmsKeyIds = ImmutableSet.copyOf((Collection)allowedKmsKeyIds.orElse((List<String>)ImmutableList.of()));
        this.sseCustomerKey = Objects.requireNonNull(sseCustomerKey, "sseCustomerKey is null");
        this.allowedSseCustomerKeys = (Set)allowedSseCustomerKeys.map(ImmutableSet::copyOf).orElse(ImmutableSet.of());
        Objects.requireNonNull(accessKey, "accessKey is null");
        Objects.requireNonNull(secretKey, "secretKey is null");
        Preconditions.checkArgument((accessKey.isPresent() == secretKey.isPresent() ? 1 : 0) != 0, (Object)"accessKey and secretKey must be provided together");
        this.credentials = accessKey.map(access -> AwsBasicCredentials.create((String)access, (String)((String)secretKey.get())));
        this.useClusterDefault = useClusterDefault.orElse(false);
        boolean roleOrCredentialsArePresent = !this.allowedIamRoles.isEmpty() || iamRole.isPresent() || this.credentials.isPresent();
        Preconditions.checkArgument((this.useClusterDefault != roleOrCredentialsArePresent ? 1 : 0) != 0, (Object)"must either allow useClusterDefault role or provide role and/or credentials");
        Preconditions.checkArgument((!this.useClusterDefault || this.kmsKeyId.isEmpty() ? 1 : 0) != 0, (Object)"KMS key ID cannot be provided together with useClusterDefault");
        Preconditions.checkArgument((!this.useClusterDefault || this.sseCustomerKey.isEmpty() ? 1 : 0) != 0, (Object)"SSE Customer key cannot be provided together with useClusterDefault");
        Preconditions.checkArgument((this.kmsKeyId.isEmpty() || this.sseCustomerKey.isEmpty() ? 1 : 0) != 0, (Object)"SSE Customer key cannot be provided together with KMS key ID");
        this.endpoint = Objects.requireNonNull(endpoint, "endpoint is null");
        this.region = Objects.requireNonNull(region, "region is null");
    }

    boolean matches(ConnectorIdentity identity, S3Location location) {
        return this.user.test(identity.getUser()) && this.group.test(identity.getGroups()) && this.prefix.test(location);
    }

    public Optional<String> iamRole() {
        return this.iamRole;
    }

    public Optional<String> roleSessionName() {
        return this.roleSessionName;
    }

    public Set<String> allowedIamRoles() {
        return this.allowedIamRoles;
    }

    public Optional<String> kmsKeyId() {
        return this.kmsKeyId;
    }

    public Set<String> allowedKmsKeyIds() {
        return this.allowedKmsKeyIds;
    }

    public Optional<String> sseCustomerKey() {
        return this.sseCustomerKey;
    }

    public Set<String> allowedSseCustomerKeys() {
        return this.allowedSseCustomerKeys;
    }

    public Optional<AwsCredentials> credentials() {
        return this.credentials;
    }

    public boolean useClusterDefault() {
        return this.useClusterDefault;
    }

    public Optional<String> endpoint() {
        return this.endpoint;
    }

    public Optional<String> region() {
        return this.region;
    }

    private static Predicate<S3Location> prefixPredicate(S3Location prefix) {
        return value -> prefix.bucket().equals(value.bucket()) && value.key().startsWith(prefix.key());
    }

    private static Predicate<String> toPredicate(Pattern pattern) {
        return value -> pattern.matcher((CharSequence)value).matches();
    }

    private static <T> Predicate<Collection<T>> anyMatch(Predicate<T> predicate) {
        return values -> values.stream().anyMatch(predicate);
    }
}

