/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spooling.filesystem;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import jakarta.validation.constraints.AssertTrue;
import java.util.concurrent.TimeUnit;

public class FileSystemSpoolingConfig {
    private boolean azureEnabled;
    private boolean s3Enabled;
    private boolean gcsEnabled;
    private String location;
    private Layout layout = Layout.SIMPLE;
    private Duration ttl = new Duration(12.0, TimeUnit.HOURS);
    private Duration directAccessTtl = new Duration(1.0, TimeUnit.HOURS);
    private boolean encryptionEnabled = true;
    private boolean explicitAckEnabled = true;
    private boolean pruningEnabled = true;
    private Duration pruningInterval = new Duration(5.0, TimeUnit.MINUTES);
    private long pruningBatchSize = 250L;

    public boolean isAzureEnabled() {
        return this.azureEnabled;
    }

    @Config(value="fs.azure.enabled")
    public FileSystemSpoolingConfig setAzureEnabled(boolean azureEnabled) {
        this.azureEnabled = azureEnabled;
        return this;
    }

    public boolean isS3Enabled() {
        return this.s3Enabled;
    }

    @Config(value="fs.s3.enabled")
    public FileSystemSpoolingConfig setS3Enabled(boolean nativeS3Enabled) {
        this.s3Enabled = nativeS3Enabled;
        return this;
    }

    public boolean isGcsEnabled() {
        return this.gcsEnabled;
    }

    @Config(value="fs.gcs.enabled")
    public FileSystemSpoolingConfig setGcsEnabled(boolean gcsEnabled) {
        this.gcsEnabled = gcsEnabled;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    @Config(value="fs.location")
    public FileSystemSpoolingConfig setLocation(String location) {
        this.location = location;
        return this;
    }

    public Layout getLayout() {
        return this.layout;
    }

    @Config(value="fs.layout")
    @ConfigDescription(value="File system layout for spooled segments storage")
    public FileSystemSpoolingConfig setLayout(Layout layout) {
        this.layout = layout;
        return this;
    }

    public Duration getTtl() {
        return this.ttl;
    }

    @Config(value="fs.segment.ttl")
    @ConfigDescription(value="Maximum duration for the client to retrieve spooled segment before it expires")
    public FileSystemSpoolingConfig setTtl(Duration ttl) {
        this.ttl = ttl;
        return this;
    }

    public Duration getDirectAccessTtl() {
        return this.directAccessTtl;
    }

    @ConfigDescription(value="Maximum duration for the client to retrieve spooled segment from the direct URI")
    @Config(value="fs.segment.direct.ttl")
    public FileSystemSpoolingConfig setDirectAccessTtl(Duration directAccessTtl) {
        this.directAccessTtl = directAccessTtl;
        return this;
    }

    public boolean isEncryptionEnabled() {
        return this.encryptionEnabled;
    }

    @Config(value="fs.segment.encryption")
    @ConfigDescription(value="Encrypt segments with ephemeral keys")
    public FileSystemSpoolingConfig setEncryptionEnabled(boolean encryptionEnabled) {
        this.encryptionEnabled = encryptionEnabled;
        return this;
    }

    public boolean isExplicitAckEnabled() {
        return this.explicitAckEnabled;
    }

    @ConfigDescription(value="Enables deletion of segments on client acknowledgment")
    @Config(value="fs.segment.explicit-ack")
    public FileSystemSpoolingConfig setExplicitAckEnabled(boolean explicitAckEnabled) {
        this.explicitAckEnabled = explicitAckEnabled;
        return this;
    }

    public boolean isPruningEnabled() {
        return this.pruningEnabled;
    }

    @Config(value="fs.segment.pruning.enabled")
    @ConfigDescription(value="Prune expired segments periodically")
    public FileSystemSpoolingConfig setPruningEnabled(boolean pruningEnabled) {
        this.pruningEnabled = pruningEnabled;
        return this;
    }

    public Duration getPruningInterval() {
        return this.pruningInterval;
    }

    @Config(value="fs.segment.pruning.interval")
    @ConfigDescription(value="Interval to prune expired segments")
    public FileSystemSpoolingConfig setPruningInterval(Duration pruningInterval) {
        this.pruningInterval = pruningInterval;
        return this;
    }

    public long getPruningBatchSize() {
        return this.pruningBatchSize;
    }

    @Config(value="fs.segment.pruning.batch-size")
    @ConfigDescription(value="Prune expired segments in batches of provided size")
    public FileSystemSpoolingConfig setPruningBatchSize(long pruningBatchSize) {
        this.pruningBatchSize = pruningBatchSize;
        return this;
    }

    @AssertTrue(message="At least one storage file system must be enabled")
    public @AssertTrue(message="At least one storage file system must be enabled") boolean isEitherNativeFileSystemEnabled() {
        return this.azureEnabled || this.s3Enabled || this.gcsEnabled;
    }

    @AssertTrue(message="Location must end with a slash")
    public @AssertTrue(message="Location must end with a slash") boolean locationEndsWithSlash() {
        return this.location.endsWith("/");
    }

    public static enum Layout {
        SIMPLE,
        PARTITIONED;

    }
}

