/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spooling.filesystem;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import io.trino.filesystem.Location;
import io.trino.spooling.filesystem.FileSystemSpooledSegmentHandle;
import io.trino.spooling.filesystem.PartitionedLayoutConfig;
import io.trino.spooling.filesystem.SimpleFileSystemLayout;
import java.util.List;
import java.util.Objects;

public class PartitionedFileSystemLayout
extends SimpleFileSystemLayout {
    private final int partitions;

    public PartitionedFileSystemLayout(PartitionedLayoutConfig layoutConfig) {
        this.partitions = Objects.requireNonNull(layoutConfig, "layoutConfig is null").getPartitions();
    }

    @Override
    public Location location(Location rootLocation, FileSystemSpooledSegmentHandle segmentHandle) {
        return super.location(rootLocation.appendPath(this.partition(segmentHandle)), segmentHandle);
    }

    @Override
    public List<Location> searchPaths(Location rootLocation) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.partitions);
        for (int i = 0; i < this.partitions; ++i) {
            builder.add((Object)rootLocation.appendPath(this.partition(i)));
        }
        return builder.build();
    }

    private String partition(FileSystemSpooledSegmentHandle handle) {
        HashCode hashCode = Hashing.murmur3_32_fixed().hashBytes(handle.uuid());
        return this.partition(Hashing.consistentHash((HashCode)hashCode, (int)this.partitions));
    }

    private String partition(int partition) {
        return Strings.padEnd((String)Integer.toString(partition), (int)3, (char)'0') + "-spooled";
    }
}

