/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spooling.filesystem.encryption;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import io.trino.filesystem.encryption.EncryptionKey;
import io.trino.spooling.filesystem.encryption.EncryptionHeadersTranslator;
import io.trino.spooling.filesystem.encryption.HeadersUtils;
import java.util.Base64;
import java.util.List;
import java.util.Map;

class AzureEncryptionHeadersTranslator
implements EncryptionHeadersTranslator {
    AzureEncryptionHeadersTranslator() {
    }

    @Override
    public EncryptionKey extractKey(Map<String, List<String>> headers) {
        byte[] key = Base64.getDecoder().decode(HeadersUtils.getOnlyHeader(headers, "x-ms-encryption-key"));
        String sha256Checksum = HeadersUtils.getOnlyHeader(headers, "x-ms-encryption-key-sha256");
        EncryptionKey encryption = new EncryptionKey(key, HeadersUtils.getOnlyHeader(headers, "x-ms-encryption-algorithm"));
        Preconditions.checkArgument((boolean)AzureEncryptionHeadersTranslator.sha256(encryption).equals(sha256Checksum), (Object)"Key SHA256 checksum does not match");
        return encryption;
    }

    @Override
    public Map<String, List<String>> createHeaders(EncryptionKey key) {
        return ImmutableMap.of((Object)"x-ms-encryption-key", List.of(AzureEncryptionHeadersTranslator.encoded(key)), (Object)"x-ms-encryption-key-sha256", List.of(AzureEncryptionHeadersTranslator.sha256(key)), (Object)"x-ms-encryption-algorithm", List.of(key.algorithm()));
    }

    private static String sha256(EncryptionKey key) {
        return Base64.getEncoder().encodeToString(Hashing.sha256().hashBytes(key.key()).asBytes());
    }

    private static String encoded(EncryptionKey key) {
        return Base64.getEncoder().encodeToString(key.key());
    }
}

