/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableSet;
import io.airlift.units.Duration;
import io.trino.plugin.jdbc.CachingJdbcClient;
import io.trino.plugin.jdbc.DefaultJdbcMetadata;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcMetadata;
import io.trino.plugin.jdbc.JdbcMetadataFactory;
import io.trino.plugin.jdbc.JdbcQueryEventListener;
import io.trino.plugin.jdbc.JdbcTransactionHandle;
import io.trino.plugin.jdbc.SingletonIdentityCacheMapping;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class DefaultJdbcMetadataFactory
implements JdbcMetadataFactory {
    private final JdbcClient jdbcClient;
    private final Set<JdbcQueryEventListener> jdbcQueryEventListeners;

    @Inject
    public DefaultJdbcMetadataFactory(JdbcClient jdbcClient, Set<JdbcQueryEventListener> jdbcQueryEventListeners) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        this.jdbcQueryEventListeners = ImmutableSet.copyOf((Collection)Objects.requireNonNull(jdbcQueryEventListeners, "queryEventListeners is null"));
    }

    @Override
    public JdbcMetadata create(JdbcTransactionHandle transaction) {
        return this.create(new CachingJdbcClient(this.jdbcClient, Set.of(), new SingletonIdentityCacheMapping(), new Duration(1.0, TimeUnit.DAYS), true, Integer.MAX_VALUE));
    }

    protected JdbcMetadata create(JdbcClient transactionCachingJdbcClient) {
        return new DefaultJdbcMetadata(transactionCachingJdbcClient, true, this.jdbcQueryEventListeners);
    }
}

