/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Preconditions;
import io.trino.plugin.jdbc.JdbcMetadataSessionProperties;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.DiscreteValues;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Ranges;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public interface PredicatePushdownController {
    public static final PredicatePushdownController FULL_PUSHDOWN = (session, domain) -> {
        if (PredicatePushdownController.getDomainSize(domain) > JdbcMetadataSessionProperties.getDomainCompactionThreshold(session)) {
            return new DomainPushdownResult(domain.simplify(JdbcMetadataSessionProperties.getDomainCompactionThreshold(session)), domain);
        }
        return new DomainPushdownResult(domain, Domain.all((Type)domain.getType()));
    };
    public static final PredicatePushdownController DISABLE_PUSHDOWN = (session, domain) -> new DomainPushdownResult(Domain.all((Type)domain.getType()), domain);
    public static final PredicatePushdownController CASE_INSENSITIVE_CHARACTER_PUSHDOWN = (session, domain) -> {
        Preconditions.checkArgument((domain.getType() instanceof VarcharType || domain.getType() instanceof CharType ? 1 : 0) != 0, (Object)"CASE_INSENSITIVE_CHARACTER_PUSHDOWN can be used only for chars and varchars");
        if (domain.isOnlyNull()) {
            return FULL_PUSHDOWN.apply(session, domain);
        }
        if (!domain.getValues().isDiscreteSet()) {
            return DISABLE_PUSHDOWN.apply(session, domain);
        }
        Domain simplifiedDomain = domain.simplify(JdbcMetadataSessionProperties.getDomainCompactionThreshold(session));
        if (!simplifiedDomain.getValues().isDiscreteSet()) {
            return DISABLE_PUSHDOWN.apply(session, domain);
        }
        return new DomainPushdownResult(simplifiedDomain, domain);
    };

    public static PredicatePushdownController pushdownDiscreteValues(Type type) {
        return (session, domain) -> {
            Optional expandedRange = domain.getValues().tryExpandRanges(JdbcMetadataSessionProperties.getDomainCompactionThreshold(session));
            if (expandedRange.isPresent()) {
                Domain convertedDiscreteDomain = Domain.create((ValueSet)ValueSet.copyOf((Type)type, (Collection)((Collection)expandedRange.get())), (boolean)domain.isNullAllowed());
                return new DomainPushdownResult(convertedDiscreteDomain, Domain.all((Type)domain.getType()));
            }
            return FULL_PUSHDOWN.apply(session, domain);
        };
    }

    public DomainPushdownResult apply(ConnectorSession var1, Domain var2);

    private static int getDomainSize(Domain domain) {
        return (Integer)domain.getValues().getValuesProcessor().transform(Ranges::getRangeCount, DiscreteValues::getValuesCount, allOrNone -> 0);
    }

    public static final class DomainPushdownResult {
        private final Domain pushedDown;
        private final Domain remainingFilter;

        public DomainPushdownResult(Domain pushedDown, Domain remainingFilter) {
            this.pushedDown = Objects.requireNonNull(pushedDown, "pushedDown is null");
            this.remainingFilter = Objects.requireNonNull(remainingFilter, "remainingFilter is null");
        }

        public Domain getPushedDown() {
            return this.pushedDown;
        }

        public Domain getRemainingFilter() {
            return this.remainingFilter;
        }
    }
}

