/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.inject.Inject;
import dev.failsafe.Failsafe;
import dev.failsafe.FailsafeException;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.ForRetrying;
import io.trino.spi.connector.ConnectorSession;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;

public class RetryingConnectionFactory
implements ConnectionFactory {
    private final ConnectionFactory delegate;
    private final RetryPolicy<Object> retryPolicy;

    @Inject
    public RetryingConnectionFactory(@ForRetrying ConnectionFactory delegate, RetryPolicy<Object> retryPolicy) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.retryPolicy = Objects.requireNonNull(retryPolicy, "retryPolicy is null");
    }

    @Override
    public Connection openConnection(ConnectorSession session) throws SQLException {
        try {
            return (Connection)Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this.delegate.openConnection(session));
        }
        catch (FailsafeException ex) {
            if (ex.getCause() instanceof SQLException) {
                throw (SQLException)ex.getCause();
            }
            throw ex;
        }
    }

    @Override
    public void close() throws SQLException {
        this.delegate.close();
    }
}

