/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.jdbc.QueryParameter;
import io.trino.plugin.jdbc.expression.ExpressionMappingParser;
import io.trino.plugin.jdbc.expression.ExpressionPattern;
import io.trino.plugin.jdbc.expression.MatchContext;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.expression.ConnectorExpression;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;

public class GenericRewrite
implements ConnectorExpressionRule<ConnectorExpression, ParameterizedExpression> {
    private static final java.util.regex.Pattern REWRITE_TOKENS = java.util.regex.Pattern.compile("(?<![a-zA-Z0-9_$])[a-zA-Z_$][a-zA-Z0-9_$]*(?![a-zA-Z0-9_$])");
    private final Predicate<ConnectorSession> condition;
    private final ExpressionPattern expressionPattern;
    private final String rewritePattern;

    public GenericRewrite(Map<String, Set<String>> typeClasses, Predicate<ConnectorSession> condition, String expressionPattern, String rewritePattern) {
        this.condition = Objects.requireNonNull(condition, "condition is null");
        ExpressionMappingParser parser = new ExpressionMappingParser(typeClasses);
        this.expressionPattern = parser.createExpressionPattern(expressionPattern);
        this.rewritePattern = Objects.requireNonNull(rewritePattern, "rewritePattern is null");
    }

    public boolean isEnabled(ConnectorSession session) {
        return this.condition.test(session);
    }

    public Pattern<ConnectorExpression> getPattern() {
        return this.expressionPattern.getPattern();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<ParameterizedExpression> rewrite(ConnectorExpression expression, Captures captures, ConnectorExpressionRule.RewriteContext<ParameterizedExpression> context) {
        MatchContext matchContext = new MatchContext();
        this.expressionPattern.resolve(captures, matchContext);
        StringBuilder result = new StringBuilder();
        ImmutableList.Builder parameters = ImmutableList.builder();
        Matcher matcher = REWRITE_TOKENS.matcher(this.rewritePattern);
        while (matcher.find()) {
            String replacement;
            String identifier = matcher.group(0);
            Optional<Object> capture = matchContext.getIfPresent(identifier);
            if (capture.isPresent()) {
                Object value = capture.get();
                if (value instanceof Long) {
                    Long longValue = (Long)value;
                    replacement = Long.toString(longValue);
                } else {
                    if (!(value instanceof ConnectorExpression)) throw new UnsupportedOperationException(String.format("Unsupported value: %s (%s)", value, value.getClass()));
                    ConnectorExpression connectorExpression = (ConnectorExpression)value;
                    Optional rewritten = context.defaultRewrite(connectorExpression);
                    if (rewritten.isEmpty()) {
                        return Optional.empty();
                    }
                    replacement = String.format("(%s)", ((ParameterizedExpression)rewritten.get()).expression());
                    parameters.addAll(((ParameterizedExpression)rewritten.get()).parameters());
                }
            } else {
                replacement = identifier;
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return Optional.of(new ParameterizedExpression(result.toString(), (List<QueryParameter>)parameters.build()));
    }

    public String toString() {
        return String.format("%s(%s -> %s)", GenericRewrite.class.getSimpleName(), this.expressionPattern, this.rewritePattern);
    }
}

