/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.containers;

import com.sun.jna.Platform;
import io.trino.testing.containers.TestContainers;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.ImageNameSubstitutor;

public class PlatformChecks
extends ImageNameSubstitutor {
    private static final boolean TESTCONTAINERS_SKIP_ARCH_CHECK = "true".equalsIgnoreCase(System.getenv("TESTCONTAINERS_SKIP_ARCHITECTURE_CHECK"));

    public DockerImageName apply(DockerImageName dockerImageName) {
        boolean isImageArmBased;
        boolean hasIncompatibleRuntime;
        if (TESTCONTAINERS_SKIP_ARCH_CHECK) {
            return dockerImageName;
        }
        TestContainers.DockerArchitectureInfo architecture = TestContainers.getDockerArchitectureInfo(dockerImageName);
        boolean isJavaOnArm = Platform.isARM();
        boolean bl = hasIncompatibleRuntime = isJavaOnArm != (isImageArmBased = architecture.imageArch().equals((Object)TestContainers.DockerArchitecture.ARM64));
        if (hasIncompatibleRuntime) {
            System.err.println("\n!!! ERROR !!!\nDetected incompatible Docker image and host architectures. The performance of running docker images in such scenarios can vary or not work at all.\nHost: %s (%s).\nDocker architecture: %s.\nDocker image architecture: %s.\n\nSet environment variable TESTCONTAINERS_SKIP_ARCHITECTURE_CHECK=true to skip this check.\n!!! ERROR !!!\n".formatted(new Object[]{System.getProperty("os.name"), System.getProperty("os.arch"), architecture.hostArch(), architecture.imageArch()}));
            System.exit(99);
        }
        return dockerImageName;
    }

    protected String getDescription() {
        return "Image substitutor that checks whether the image platform matches host platform";
    }
}

