/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.minio;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.io.ByteSource;
import com.google.common.reflect.ClassPath;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.minio.BucketExistsArgs;
import io.minio.CloseableIterator;
import io.minio.CopyObjectArgs;
import io.minio.CopySource;
import io.minio.ListObjectsArgs;
import io.minio.ListenBucketNotificationArgs;
import io.minio.MakeBucketArgs;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.http.HttpUtils;
import io.minio.messages.Event;
import io.minio.messages.EventType;
import io.minio.messages.Item;
import io.minio.messages.NotificationRecords;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.OkHttpClient;

public class MinioClient
implements AutoCloseable {
    private final Logger logger = Logger.get(MinioClient.class);
    public static final String DEFAULT_MINIO_ENDPOINT = "http://minio:9080";
    public static final String DEFAULT_MINIO_ACCESS_KEY = "minio-access-key";
    public static final String DEFAULT_MINIO_SECRET_KEY = "minio-secret-key";
    private static final Set<String> createdBuckets = Sets.newConcurrentHashSet();
    private final OkHttpClient httpClient;
    private final io.minio.MinioClient client;
    private final ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(32, Threads.daemonThreadsNamed((String)"minio-client-%s")));
    private static final String[] ALL_MINIO_EVENTS = new String[]{EventType.OBJECT_CREATED_ANY.toString(), EventType.OBJECT_REMOVED_ANY.toString(), EventType.OBJECT_ACCESSED_ANY.toString()};

    public MinioClient() {
        this(DEFAULT_MINIO_ENDPOINT, DEFAULT_MINIO_ACCESS_KEY, DEFAULT_MINIO_SECRET_KEY);
    }

    public MinioClient(String endpoint, String accessKey, String secretKey) {
        long fiveMinutes = TimeUnit.MINUTES.toMillis(5L);
        this.httpClient = HttpUtils.newDefaultHttpClient((long)fiveMinutes, (long)fiveMinutes, (long)fiveMinutes);
        this.client = io.minio.MinioClient.builder().httpClient(this.httpClient).endpoint(endpoint).credentials(accessKey, secretKey).build();
    }

    public void copyResourcePath(String bucket, String resourcePath, String target) {
        this.ensureBucketExists(bucket);
        try {
            ClassPath.from((ClassLoader)this.getClass().getClassLoader()).getResources().stream().filter(resourceInfo -> resourceInfo.getResourceName().startsWith(resourcePath)).forEach(resourceInfo -> {
                String fileName = resourceInfo.getResourceName().replaceFirst("^" + Pattern.quote(resourcePath), Matcher.quoteReplacement(target));
                this.putObject(bucket, resourceInfo.asByteSource(), fileName);
            });
        }
        catch (IOException e) {
            this.logger.warn((Throwable)e, "Could not copy resources from classpath");
            throw new UncheckedIOException(e);
        }
    }

    public void putObject(String bucket, byte[] contents, String targetPath) {
        this.ensureBucketExists(bucket);
        this.putObject(bucket, ByteSource.wrap((byte[])contents), targetPath);
    }

    public void captureBucketNotifications(final String bucket, Consumer<Event> consumer) {
        this.ensureBucketExists(bucket);
        ListenableFuture future = this.executor.submit((Runnable)new NotificationListener(this.client, bucket, consumer));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                MinioClient.this.logger.info("Completed notification listener for bucket %s", new Object[]{bucket});
            }

            public void onFailure(Throwable t) {
                MinioClient.this.logger.warn(t, "Notification listener for bucket %s threw exception", new Object[]{bucket});
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public List<String> listObjects(String bucket, String path) {
        try {
            return (List)Streams.stream((Iterable)this.client.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucket)).prefix(path).recursive(true).useUrlEncodingType(false).build())).map(result -> {
                try {
                    return ((Item)result.get()).objectName();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).collect(ImmutableList.toImmutableList());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void makeBucket(String bucketName) {
        if (!createdBuckets.add(bucketName)) {
            throw new IllegalArgumentException("Bucket " + bucketName + " already created in this classloader");
        }
        try {
            this.client.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            createdBuckets.remove(bucketName);
            throw new RuntimeException(e);
        }
    }

    public void ensureBucketExists(String bucketName) {
        try {
            if (!this.client.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build())) {
                this.makeBucket(bucketName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void putObject(String bucket, ByteSource byteSource, String targetPath) {
        try (InputStream inputStream = byteSource.openStream();){
            this.client.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(targetPath)).stream(inputStream, byteSource.size(), -1L).build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void copyObject(String sourceBucket, String sourceKey, String targetBucket, String targetKey) {
        try {
            this.client.copyObject((CopyObjectArgs)((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)CopyObjectArgs.builder().source((CopySource)((CopySource.Builder)((CopySource.Builder)CopySource.builder().bucket(sourceBucket)).object(sourceKey)).build()).bucket(targetBucket)).object(targetKey)).build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeObject(String bucket, String key) {
        try {
            this.client.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucket)).object(key)).build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
        this.executor.shutdownNow();
    }

    private static class NotificationListener
    implements Runnable {
        private final io.minio.MinioClient client;
        private final String bucket;
        private final Consumer<Event> consumer;

        private NotificationListener(io.minio.MinioClient client, String bucket, Consumer<Event> consumer) {
            this.client = Objects.requireNonNull(client, "client is null");
            this.bucket = Objects.requireNonNull(bucket, "bucket is null");
            this.consumer = Objects.requireNonNull(consumer, "consumer is null");
        }

        @Override
        public void run() {
            try (CloseableIterator iterator = this.client.listenBucketNotification((ListenBucketNotificationArgs)((ListenBucketNotificationArgs.Builder)ListenBucketNotificationArgs.builder().bucket(this.bucket)).prefix("*").suffix("*").events(ALL_MINIO_EVENTS).build());){
                while (iterator.hasNext()) {
                    NotificationRecords records = (NotificationRecords)((Result)iterator.next()).get();
                    records.events().forEach(this.consumer);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

