/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.containers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import io.airlift.log.Logger;
import io.trino.testing.containers.BaseTestContainer;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.OutputFrame;

public class MitmProxy
extends BaseTestContainer {
    private static final Logger log = Logger.get(MitmProxy.class);
    public static final String DEFAULT_IMAGE = "mitmproxy/mitmproxy:9.0.1";
    public static final String DEFAULT_HOST_NAME = "mitmproxy";
    public static final int MITMPROXY_PORT = 6660;

    public static Builder builder() {
        return new Builder();
    }

    private MitmProxy(String image, String hostName, Set<Integer> exposePorts, Map<String, String> filesToMount, Map<String, String> envVars, Optional<Network> network, int retryLimit) {
        super(image, hostName, exposePorts, filesToMount, envVars, network, retryLimit);
    }

    @Override
    protected void setupContainer() {
        super.setupContainer();
        this.withRunCommand((List<String>)ImmutableList.of((Object)"mitmdump", (Object)"--listen-port", (Object)Integer.toString(6660), (Object)"--certs", (Object)"/tmp/cert.pem", (Object)"--set", (Object)"proxy_debug=true", (Object)"--set", (Object)"stream_large_bodies=0"));
        this.withLogConsumer(MitmProxy::printProxiedRequest);
    }

    private static void printProxiedRequest(OutputFrame outputFrame) {
        String line = outputFrame.getUtf8String().trim();
        if (!line.startsWith("<<")) {
            log.info("Proxied %s,", new Object[]{line});
        }
    }

    @Override
    public void start() {
        super.start();
        log.info("Mitm proxy container started with address: %s", new Object[]{this.getProxyEndpoint()});
    }

    public HostAndPort getProxyHostAndPort() {
        return this.getMappedHostAndPortForExposedPort(6660);
    }

    public String getProxyEndpoint() {
        return "https://" + String.valueOf(this.getProxyHostAndPort());
    }

    public static class Builder
    extends BaseTestContainer.Builder<Builder, MitmProxy> {
        private Builder() {
            this.image = MitmProxy.DEFAULT_IMAGE;
            this.hostName = MitmProxy.DEFAULT_HOST_NAME;
            this.exposePorts = ImmutableSet.of((Object)6660);
            this.envVars = ImmutableMap.of();
        }

        public Builder withSSLCertificate(Path filename) {
            return (Builder)this.withFilesToMount((Map)Map.of("/tmp/cert.pem", filename.toString()));
        }

        @Override
        public MitmProxy build() {
            return new MitmProxy(this.image, this.hostName, this.exposePorts, this.filesToMount, this.envVars, this.network, this.startupRetryLimit);
        }
    }
}

