/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.containers;

import com.google.common.net.UrlEscapers;
import io.airlift.units.DataSize;
import io.trino.testing.containers.BaseTestContainer;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class OpenTracingCollector
extends BaseTestContainer {
    private static final int COLLECTOR_PORT = 4318;
    private static final int HTTP_PORT = 16686;
    private final Path storageDirectory;

    public OpenTracingCollector() {
        super("jaegertracing/all-in-one:latest", "opentracing-collector", Set.of(Integer.valueOf(4318), Integer.valueOf(16686)), Map.of(), Map.of("COLLECTOR_OTLP_ENABLED", "true", "SPAN_STORAGE_TYPE", "badger", "GOMAXPROCS", "2"), Optional.empty(), 1);
        this.withRunCommand(List.of("--badger.ephemeral=false", "--badger.span-store-ttl=15m", "--badger.directory-key=/badger/data", "--badger.directory-value=/badger/data", "--badger.maintenance-interval=30s"));
        this.withCreateContainerModifier(command -> command.getHostConfig().withMemory(Long.valueOf(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE).toBytes())));
        try {
            this.storageDirectory = Files.createTempDirectory("tracing-collector", new FileAttribute[0]);
            this.mountDirectory(this.storageDirectory.toString(), "/badger");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
        super.close();
        try (Stream<File> files = Files.walk(this.storageDirectory, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile);){
            files.forEach(File::delete);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public URI getExporterEndpoint() {
        return URI.create("http://" + String.valueOf(this.getMappedHostAndPortForExposedPort(4318)) + "/v1/traces");
    }

    public URI searchForQueryId(String queryId) {
        String query = "{\"trino.query_id\": \"%s\"}".formatted(queryId);
        return URI.create("http://%s/search?operation=query&service=trino&tags=%s".formatted(this.getMappedHostAndPortForExposedPort(16686), UrlEscapers.urlFragmentEscaper().escape(query)));
    }
}

