/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testng.services;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.trino.testng.services.Listeners;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.testng.IClassListener;
import org.testng.ITestClass;
import org.testng.annotations.Test;

public class ReportBadTestAnnotations
implements IClassListener {
    public void onBeforeClass(ITestClass testClass) {
        try {
            this.reportBadTestAnnotations(testClass);
        }
        catch (Error | RuntimeException e) {
            Listeners.reportListenerFailure(ReportBadTestAnnotations.class, "Failed to process %s: \n%s", testClass, Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private void reportBadTestAnnotations(ITestClass testClass) {
        Optional<Class<?>> clazz;
        Class realClass = testClass.getRealClass();
        if (realClass.getSuperclass() != null && "io.trino.tempto.internal.convention.ConventionBasedTestProxyGenerator$ConventionBasedTestProxy".equals(realClass.getSuperclass().getName())) {
            return;
        }
        List<Method> unannotatedTestMethods = ReportBadTestAnnotations.findUnannotatedTestMethods(realClass);
        if (!unannotatedTestMethods.isEmpty()) {
            Listeners.reportListenerFailure(ReportBadTestAnnotations.class, "Test class %s has methods which are public but not explicitly annotated. Are they missing @Test?%s", realClass.getName(), unannotatedTestMethods.stream().map(Method::toString).collect(Collectors.joining("\n\t\t", "\n\t\t", "")));
        }
        if (!realClass.isAnnotationPresent(Suppress.class) && (clazz = ReportBadTestAnnotations.classWithMeaninglessTestAnnotation(realClass)).isPresent()) {
            Listeners.reportListenerFailure(ReportBadTestAnnotations.class, "Test class %s (%s) has meaningless class-level @Test annotation. We require each test method be explicitly annotated, deliberately not leveraging https://testng.org/doc/documentation-main.html#class-level.", clazz.get().getName(), realClass.getName());
        }
    }

    @VisibleForTesting
    static Optional<Class<?>> classWithMeaninglessTestAnnotation(Class<?> realClass) {
        for (Class<?> clazz = realClass; clazz != null; clazz = clazz.getSuperclass()) {
            Test testAnnotation = clazz.getAnnotation(Test.class);
            if (testAnnotation == null || !ReportBadTestAnnotations.isAllDefaults(testAnnotation)) continue;
            return Optional.of(clazz);
        }
        return Optional.empty();
    }

    private static boolean isAllDefaults(Test annotationInstance) {
        try {
            for (Method method : Test.class.getDeclaredMethods()) {
                Object defaultValue;
                Object value;
                if (Modifier.isStatic(method.getModifiers()) || Objects.deepEquals(value = method.invoke((Object)annotationInstance, new Object[0]), defaultValue = method.getDefaultValue())) continue;
                return false;
            }
            return true;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    static List<Method> findUnannotatedTestMethods(Class<?> realClass) {
        return (List)Arrays.stream(realClass.getMethods()).filter(method -> method.getDeclaringClass() != Object.class).filter(method -> !Modifier.isStatic(method.getModifiers())).filter(method -> !method.isBridge()).filter(method -> !ReportBadTestAnnotations.isAllowedPublicMethodInTest(method)).collect(ImmutableList.toImmutableList());
    }

    public void onAfterClass(ITestClass testClass) {
    }

    private static boolean isAllowedPublicMethodInTest(Method method) {
        if (ReportBadTestAnnotations.isTestAnnotated(method)) {
            return true;
        }
        if (method.getDeclaringClass() == Object.class) {
            return true;
        }
        if (method.getDeclaringClass().isInterface()) {
            return ReportBadTestAnnotations.isTemptoClass(method.getDeclaringClass());
        }
        for (Class<?> interfaceClass : method.getDeclaringClass().getInterfaces()) {
            Optional<Method> overridden = ReportBadTestAnnotations.getOverridden(method, interfaceClass);
            if (!overridden.isPresent() || !ReportBadTestAnnotations.isTemptoClass(interfaceClass)) continue;
            return true;
        }
        return ReportBadTestAnnotations.getOverridden(method, method.getDeclaringClass().getSuperclass()).map(ReportBadTestAnnotations::isAllowedPublicMethodInTest).orElse(false);
    }

    private static Optional<Method> getOverridden(Method method, Class<?> base) {
        try {
            return Optional.of(base.getMethod(method.getName(), method.getParameterTypes()));
        }
        catch (NoSuchMethodException ignored) {
            return Optional.empty();
        }
    }

    private static boolean isTestAnnotated(Method method) {
        return Arrays.stream(method.getAnnotations()).map(Annotation::annotationType).anyMatch(annotationClass -> {
            if (Suppress.class.equals(annotationClass)) {
                return true;
            }
            if ("org.openjdk.jmh.annotations.Benchmark".equals(annotationClass.getName())) {
                return true;
            }
            if (Test.class.getPackage().equals(annotationClass.getPackage())) {
                return true;
            }
            if (ReportBadTestAnnotations.isJUnitAnnotation(annotationClass)) {
                return true;
            }
            return ReportBadTestAnnotations.isTemptoClass(annotationClass);
        });
    }

    private static boolean isJUnitAnnotation(Class<? extends Annotation> clazz) {
        return clazz.getPackage().getName().startsWith("org.junit.jupiter.");
    }

    @VisibleForTesting
    static boolean isTemptoClass(Class<?> aClass) {
        String temptoPackage = "io.trino.tempto";
        String aPackage = aClass.getPackage().getName();
        return aPackage.equals(temptoPackage) || aPackage.startsWith(temptoPackage + ".");
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface Suppress {
    }
}

