/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

@ThreadSafe
public class SharedResource<T extends AutoCloseable> {
    private final Callable<T> factory;
    @GuardedBy(value="this")
    private long counter;
    @Nullable
    @GuardedBy(value="this")
    private T instance;

    public SharedResource(Callable<T> factory) {
        this.factory = Objects.requireNonNull(factory, "factory is null");
    }

    public synchronized Lease<T> getInstanceLease() throws Exception {
        if (this.instance == null) {
            Preconditions.checkState((this.counter == 0L ? 1 : 0) != 0, (String)"Expected counter to be 0, but was: %s", (long)this.counter);
            this.instance = Objects.requireNonNull((AutoCloseable)this.factory.call(), "factory.call() is null");
        }
        ++this.counter;
        return new Lease<T>(this.instance, this::returnLease);
    }

    private synchronized Void returnLease() throws Exception {
        --this.counter;
        Preconditions.checkState((this.counter >= 0L ? 1 : 0) != 0, (Object)"Counter got negative");
        if (this.counter == 0L) {
            ((AutoCloseable)Objects.requireNonNull(this.instance, "instance is null")).close();
            this.instance = null;
        }
        return null;
    }

    public static class Lease<T>
    implements AutoCloseable,
    Supplier<T> {
        private final T instance;
        private final Callable<Void> onClose;

        public Lease(T instance, Callable<Void> onClose) {
            this.instance = Objects.requireNonNull(instance, "instance is null");
            this.onClose = Objects.requireNonNull(onClose, "onClose is null");
        }

        @Override
        public T get() {
            return this.instance;
        }

        @Override
        public void close() throws Exception {
            this.onClose.call();
        }
    }
}

