/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testng.services;

import com.google.common.base.Throwables;
import io.trino.testng.services.Listeners;
import io.trino.testng.services.ReportBadTestAnnotations;
import org.testng.IClassListener;
import org.testng.ITestClass;

public class ReportIllNamedTest
implements IClassListener {
    public void onBeforeClass(ITestClass testClass) {
        try {
            this.reportIllNamedTest(testClass);
        }
        catch (Error | RuntimeException e) {
            Listeners.reportListenerFailure(ReportIllNamedTest.class, "Failed to process %s: \n%s", testClass, Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private void reportIllNamedTest(ITestClass testClass) {
        Class realClass = testClass.getRealClass();
        String testClassName = realClass.getSimpleName();
        if (testClassName.startsWith("Test") || testClassName.startsWith("Benchmark")) {
            return;
        }
        if (testClassName.endsWith("IT")) {
            return;
        }
        if (ReportBadTestAnnotations.isTemptoClass(realClass)) {
            return;
        }
        Listeners.reportListenerFailure(ReportIllNamedTest.class, "Test class %s's name should start with Test", realClass.getName());
    }

    public void onAfterClass(ITestClass iTestClass) {
    }
}

