/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.client.StageStats;
import io.trino.client.StatementStats;
import io.trino.execution.FailureInjector;
import io.trino.spi.ErrorType;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.sql.TestTable;
import io.trino.tpch.TpchTable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractTestFailureRecovery
extends AbstractTestQueryFramework {
    protected static final int INVOCATION_COUNT = 3;
    private static final Duration MAX_ERROR_DURATION = new Duration(10.0, TimeUnit.SECONDS);
    private static final Duration REQUEST_TIMEOUT = new Duration(10.0, TimeUnit.SECONDS);

    @Override
    protected final QueryRunner createQueryRunner() throws Exception {
        return this.createQueryRunner((List<TpchTable<?>>)ImmutableList.of((Object)TpchTable.NATION, (Object)TpchTable.ORDERS, (Object)TpchTable.CUSTOMER), (Map<String, String>)ImmutableMap.builder().put((Object)"query.remote-task.max-error-duration", (Object)MAX_ERROR_DURATION.toString()).put((Object)"exchange.max-error-duration", (Object)MAX_ERROR_DURATION.toString()).put((Object)"retry-policy", (Object)"QUERY").put((Object)"retry-initial-delay", (Object)"0s").put((Object)"retry-attempts", (Object)"1").put((Object)"failure-injection.request-timeout", (Object)new Duration((double)(REQUEST_TIMEOUT.toMillis() * 2L), TimeUnit.MILLISECONDS).toString()).put((Object)"exchange.http-client.idle-timeout", (Object)REQUEST_TIMEOUT.toString()).put((Object)"enable-dynamic-filtering", (Object)"false").put((Object)"distributed-sort", (Object)"false").build(), (Map<String, String>)ImmutableMap.builder().put((Object)"scheduler.http-client.idle-timeout", (Object)REQUEST_TIMEOUT.toString()).build());
    }

    protected abstract QueryRunner createQueryRunner(List<TpchTable<?>> var1, Map<String, String> var2, Map<String, String> var3) throws Exception;

    @Test(invocationCount=3)
    public void testSimpleSelect() {
        this.testSelect("SELECT * FROM nation");
    }

    @Test(invocationCount=3)
    public void testAggregation() {
        this.testSelect("SELECT orderStatus, count(*) FROM orders GROUP BY orderStatus");
    }

    @Test(invocationCount=3)
    public void testJoin() {
        this.testSelect("SELECT * FROM orders o, customer c WHERE o.custkey = c.custkey AND c.nationKey = 1");
    }

    protected void testSelect(String query) {
        this.assertThatQuery(query).experiencing(FailureInjector.InjectedFailureType.TASK_MANAGEMENT_REQUEST_FAILURE).at(AbstractTestFailureRecovery.leafStage()).finishesSuccessfully();
        this.assertThatQuery(query).experiencing(FailureInjector.InjectedFailureType.TASK_GET_RESULTS_REQUEST_FAILURE).at(AbstractTestFailureRecovery.boundaryDistributedStage()).finishesSuccessfully();
        this.assertThatQuery(query).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(AbstractTestFailureRecovery.leafStage()).finishesSuccessfully();
        this.assertThatQuery(query).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.EXTERNAL)).at(AbstractTestFailureRecovery.intermediateDistributedStage()).finishesSuccessfully();
    }

    @Test(invocationCount=3)
    public void testUserFailure() {
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("SELECT * FROM nation WHERE regionKey / nationKey - 1 = 0")).hasMessageContaining("Division by zero");
        this.assertThatQuery("SELECT * FROM nation").experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.USER_ERROR)).at(AbstractTestFailureRecovery.leafStage()).failsWithErrorThat().hasMessageContaining("This error is injected by the failure injection service");
    }

    @Test(invocationCount=3)
    public void testCreateTable() {
        this.testTableModification(Optional.empty(), "CREATE TABLE <table> AS SELECT * FROM orders", Optional.of("DROP TABLE <table>"));
    }

    @Test(invocationCount=3)
    public void testInsert() {
        this.testTableModification(Optional.of("CREATE TABLE <table> AS SELECT * FROM orders WITH NO DATA"), "INSERT INTO <table> SELECT * FROM orders", Optional.of("DROP TABLE <table>"));
    }

    @Test(invocationCount=3)
    public void testDelete() {
        this.testTableModification(Optional.of("CREATE TABLE <table> AS SELECT * FROM orders"), "DELETE FROM orders WHERE orderkey = 1", Optional.of("DROP TABLE <table>"));
    }

    @Test(invocationCount=3)
    public void testDeleteWithSubquery() {
        this.testTableModification(Optional.of("CREATE TABLE <table> AS SELECT * FROM orders"), "DELETE FROM orders WHERE custkey IN (SELECT custkey FROM customer WHERE nationkey = 1)", Optional.of("DROP TABLE <table>"));
    }

    @Test(invocationCount=3)
    public void testUpdate() {
        this.testTableModification(Optional.of("CREATE TABLE <table> AS SELECT * FROM orders"), "UPDATE orders SET shippriority = 101 WHERE custkey = 1", Optional.of("DROP TABLE <table>"));
    }

    @Test(invocationCount=3)
    public void testUpdateWithSubquery() {
        this.testTableModification(Optional.of("CREATE TABLE <table> AS SELECT * FROM orders"), "UPDATE orders SET shippriority = 101 WHERE custkey = (SELECT min(custkey) FROM customer)", Optional.of("DROP TABLE <table>"));
    }

    @Test(invocationCount=3)
    public void testAnalyzeStatistics() {
        this.testTableModification(Optional.of("CREATE TABLE <table> AS SELECT * FROM orders"), "ANALYZE <table>", Optional.of("DROP TABLE <table>"));
    }

    @Test(invocationCount=3)
    public void testRefreshMaterializedView() {
        this.testTableModification(Optional.of("CREATE MATERIALIZED VIEW <table> AS SELECT * FROM orders"), "REFRESH MATERIALIZED VIEW <table>", Optional.of("DROP MATERIALIZED VIEW <table>"));
    }

    @Test(invocationCount=3)
    public void testExplainAnalyze() {
        this.testSelect("EXPLAIN ANALYZE SELECT orderStatus, count(*) FROM orders GROUP BY orderStatus");
        this.testTableModification(Optional.of("CREATE TABLE <table> AS SELECT * FROM orders WITH NO DATA"), "EXPLAIN ANALYZE INSERT INTO <table> SELECT * FROM orders", Optional.of("DROP TABLE <table>"));
    }

    @Test(invocationCount=3)
    public void testRequestTimeouts() {
        this.assertThatQuery("SELECT orderStatus, count(*) FROM orders GROUP BY orderStatus").experiencing(FailureInjector.InjectedFailureType.TASK_MANAGEMENT_REQUEST_TIMEOUT).at(AbstractTestFailureRecovery.intermediateDistributedStage()).finishesSuccessfully();
        this.assertThatQuery("SELECT * FROM nation").experiencing(FailureInjector.InjectedFailureType.TASK_MANAGEMENT_REQUEST_TIMEOUT).at(AbstractTestFailureRecovery.boundaryDistributedStage()).finishesSuccessfully();
        this.assertThatQuery("SELECT * FROM orders o, customer c WHERE o.custkey = c.custkey AND c.nationKey = 1").experiencing(FailureInjector.InjectedFailureType.TASK_GET_RESULTS_REQUEST_TIMEOUT).at(AbstractTestFailureRecovery.boundaryDistributedStage()).finishesSuccessfully();
        this.assertThatQuery("INSERT INTO <table> SELECT * FROM orders").withSetupQuery(Optional.of("CREATE TABLE <table> AS SELECT * FROM orders WITH NO DATA")).withCleanupQuery(Optional.of("DROP TABLE <table>")).experiencing(FailureInjector.InjectedFailureType.TASK_MANAGEMENT_REQUEST_TIMEOUT).at(AbstractTestFailureRecovery.boundaryDistributedStage()).finishesSuccessfully();
        this.assertThatQuery("INSERT INTO <table> SELECT * FROM orders").withSetupQuery(Optional.of("CREATE TABLE <table> AS SELECT * FROM orders WITH NO DATA")).withCleanupQuery(Optional.of("DROP TABLE <table>")).experiencing(FailureInjector.InjectedFailureType.TASK_GET_RESULTS_REQUEST_TIMEOUT).at(AbstractTestFailureRecovery.boundaryDistributedStage()).finishesSuccessfully();
    }

    protected void testTableModification(Optional<String> setupQuery, String query, Optional<String> cleanupQuery) {
        this.testTableModification(Optional.empty(), setupQuery, query, cleanupQuery);
    }

    protected void testTableModification(Optional<Session> session, Optional<String> setupQuery, String query, Optional<String> cleanupQuery) {
        this.assertThatQuery(query).withSession(session).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(AbstractTestFailureRecovery.boundaryCoordinatorStage()).failsWithErrorThat().hasMessageContaining("This error is injected by the failure injection service");
        this.assertThatQuery(query).withSession(session).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(AbstractTestFailureRecovery.rootStage()).failsWithErrorThat().hasMessageContaining("This error is injected by the failure injection service");
        this.assertThatQuery(query).withSession(session).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(AbstractTestFailureRecovery.leafStage()).finishesSuccessfully();
        this.assertThatQuery(query).withSession(session).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(AbstractTestFailureRecovery.boundaryDistributedStage()).finishesSuccessfully();
        this.assertThatQuery(query).withSession(session).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_FAILURE, Optional.of(ErrorType.INTERNAL_ERROR)).at(AbstractTestFailureRecovery.intermediateDistributedStage()).finishesSuccessfully();
        this.assertThatQuery(query).withSession(session).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_MANAGEMENT_REQUEST_FAILURE).at(AbstractTestFailureRecovery.boundaryDistributedStage()).finishesSuccessfully();
        this.assertThatQuery(query).withSession(session).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).experiencing(FailureInjector.InjectedFailureType.TASK_GET_RESULTS_REQUEST_FAILURE).at(AbstractTestFailureRecovery.boundaryDistributedStage()).finishesSuccessfully();
    }

    private FailureRecoveryAssert assertThatQuery(String query) {
        return new FailureRecoveryAssert(query);
    }

    protected static Function<MaterializedResult, Integer> rootStage() {
        return result -> Integer.parseInt(AbstractTestFailureRecovery.getRootStage(result).getStageId());
    }

    protected static Function<MaterializedResult, Integer> boundaryCoordinatorStage() {
        return result -> AbstractTestFailureRecovery.findStageId(result, stage -> stage.isCoordinatorOnly() && stage.getSubStages().stream().noneMatch(StageStats::isCoordinatorOnly));
    }

    protected static Function<MaterializedResult, Integer> boundaryDistributedStage() {
        return result -> {
            StageStats rootStage = AbstractTestFailureRecovery.getRootStage(result);
            if (!rootStage.isCoordinatorOnly()) {
                return Integer.parseInt(rootStage.getStageId());
            }
            StageStats boundaryCoordinatorStage = AbstractTestFailureRecovery.findStage(result, stage -> stage.isCoordinatorOnly() && stage.getSubStages().stream().noneMatch(StageStats::isCoordinatorOnly));
            StageStats boundaryDistributedStage = (StageStats)boundaryCoordinatorStage.getSubStages().get(ThreadLocalRandom.current().nextInt(boundaryCoordinatorStage.getSubStages().size()));
            return Integer.parseInt(boundaryDistributedStage.getStageId());
        };
    }

    protected static Function<MaterializedResult, Integer> intermediateDistributedStage() {
        return result -> AbstractTestFailureRecovery.findStageId(result, stage -> !stage.isCoordinatorOnly() && !stage.getSubStages().isEmpty());
    }

    protected static Function<MaterializedResult, Integer> leafStage() {
        return result -> AbstractTestFailureRecovery.findStageId(result, stage -> stage.getSubStages().isEmpty());
    }

    private static int findStageId(MaterializedResult result, Predicate<StageStats> predicate) {
        return Integer.parseInt(AbstractTestFailureRecovery.findStage(result, predicate).getStageId());
    }

    private static StageStats findStage(MaterializedResult result, Predicate<StageStats> predicate) {
        List stages = (List)Streams.stream((Iterable)Traverser.forTree(StageStats::getSubStages).breadthFirst((Object)AbstractTestFailureRecovery.getRootStage(result))).filter(predicate).collect(ImmutableList.toImmutableList());
        if (stages.isEmpty()) {
            throw new IllegalArgumentException("stage not found");
        }
        return (StageStats)stages.get(ThreadLocalRandom.current().nextInt(stages.size()));
    }

    private static StageStats getStageStats(MaterializedResult result, int stageId) {
        return Streams.stream((Iterable)Traverser.forTree(StageStats::getSubStages).breadthFirst((Object)AbstractTestFailureRecovery.getRootStage(result))).filter(stageStats -> Integer.parseInt(stageStats.getStageId()) == stageId).findFirst().orElseThrow(() -> new IllegalArgumentException("stage stats not found: " + stageId));
    }

    private static StageStats getRootStage(MaterializedResult result) {
        StatementStats statementStats = (StatementStats)result.getStatementStats().orElseThrow(() -> new IllegalArgumentException("statement stats is not present"));
        return Objects.requireNonNull(statementStats.getRootStage(), "root stage is null");
    }

    private static class ExecutionResult {
        private final MaterializedResult queryResult;
        private final Optional<MaterializedResult> updatedTableContent;
        private final Optional<MaterializedResult> updatedTableStatistics;

        private ExecutionResult(MaterializedResult queryResult, Optional<MaterializedResult> updatedTableContent, Optional<MaterializedResult> updatedTableStatistics) {
            this.queryResult = Objects.requireNonNull(queryResult, "queryResult is null");
            this.updatedTableContent = Objects.requireNonNull(updatedTableContent, "updatedTableContent is null");
            this.updatedTableStatistics = Objects.requireNonNull(updatedTableStatistics, "updatedTableStatistics is null");
        }

        public MaterializedResult getQueryResult() {
            return this.queryResult;
        }

        public Optional<MaterializedResult> getUpdatedTableContent() {
            return this.updatedTableContent;
        }

        public Optional<MaterializedResult> getUpdatedTableStatistics() {
            return this.updatedTableStatistics;
        }
    }

    protected class FailureRecoveryAssert {
        private final String query;
        private Session session;
        private Function<MaterializedResult, Integer> stageSelector;
        private Optional<FailureInjector.InjectedFailureType> failureType;
        private Optional<ErrorType> errorType;
        private Optional<String> setup;
        private Optional<String> cleanup;

        public FailureRecoveryAssert(String query) {
            this.session = AbstractTestFailureRecovery.this.getQueryRunner().getDefaultSession();
            this.failureType = Optional.empty();
            this.errorType = Optional.empty();
            this.setup = Optional.empty();
            this.cleanup = Optional.empty();
            this.query = Objects.requireNonNull(query, "query is null");
        }

        public FailureRecoveryAssert withSession(Optional<Session> session) {
            Objects.requireNonNull(session, "session is null");
            session.ifPresent(value -> {
                this.session = value;
            });
            return this;
        }

        public FailureRecoveryAssert withSetupQuery(Optional<String> query) {
            this.setup = Objects.requireNonNull(query, "query is null");
            return this;
        }

        public FailureRecoveryAssert withCleanupQuery(Optional<String> query) {
            this.cleanup = Objects.requireNonNull(query, "query is null");
            return this;
        }

        public FailureRecoveryAssert experiencing(FailureInjector.InjectedFailureType failureType) {
            return this.experiencing(failureType, Optional.empty());
        }

        public FailureRecoveryAssert experiencing(FailureInjector.InjectedFailureType failureType, Optional<ErrorType> errorType) {
            this.failureType = Optional.of(Objects.requireNonNull(failureType, "failureType is null"));
            this.errorType = Objects.requireNonNull(errorType, "errorType is null");
            if (failureType == FailureInjector.InjectedFailureType.TASK_FAILURE) {
                Preconditions.checkArgument((boolean)errorType.isPresent(), (Object)"error type must be present when injection type is task failure");
            } else {
                Preconditions.checkArgument((boolean)errorType.isEmpty(), (Object)"error type must not be present when injection type is not task failure");
            }
            return this;
        }

        public FailureRecoveryAssert at(Function<MaterializedResult, Integer> stageSelector) {
            this.stageSelector = Objects.requireNonNull(stageSelector, "stageSelector is null");
            return this;
        }

        private ExecutionResult executeExpected() {
            return this.execute(this.query, Optional.empty());
        }

        private ExecutionResult executeActual(MaterializedResult expected) {
            Objects.requireNonNull(this.stageSelector, "stageSelector must be set");
            int stageId = this.stageSelector.apply(expected);
            String token = UUID.randomUUID().toString();
            this.failureType.ifPresent(failure -> AbstractTestFailureRecovery.this.getQueryRunner().injectTaskFailure(token, stageId, 0, 0, failure, this.errorType));
            ExecutionResult actual = this.execute(this.query, Optional.of(token));
            Assert.assertEquals((int)AbstractTestFailureRecovery.getStageStats(actual.getQueryResult(), stageId).getFailedTasks(), (int)(this.failureType.isPresent() ? 1 : 0));
            return actual;
        }

        private ExecutionResult execute(String query, Optional<String> traceToken) {
            Optional<MaterializedResult> updatedTableStatistics;
            Optional<MaterializedResult> updatedTableContent;
            RuntimeException failure;
            MaterializedResult result;
            block8: {
                String tableName = "table_" + TestTable.randomTableSuffix();
                this.setup.ifPresent(sql -> AbstractTestFailureRecovery.this.getQueryRunner().execute(this.session, this.resolveTableName((String)sql, tableName)));
                result = null;
                failure = null;
                try {
                    Session sessionWithToken = Session.builder((Session)this.session).setTraceToken(traceToken).build();
                    result = AbstractTestFailureRecovery.this.getQueryRunner().execute(sessionWithToken, this.resolveTableName(query, tableName));
                }
                catch (RuntimeException e) {
                    failure = e;
                }
                updatedTableContent = Optional.empty();
                if (result != null && result.getUpdateCount().isPresent()) {
                    updatedTableContent = Optional.of(AbstractTestFailureRecovery.this.getQueryRunner().execute(this.session, "SELECT * FROM " + tableName));
                }
                updatedTableStatistics = Optional.empty();
                if (result != null && result.getUpdateType().isPresent() && ((String)result.getUpdateType().get()).equals("ANALYZE")) {
                    updatedTableStatistics = Optional.of(AbstractTestFailureRecovery.this.getQueryRunner().execute(this.session, "SHOW STATS FOR " + tableName));
                }
                try {
                    this.cleanup.ifPresent(sql -> AbstractTestFailureRecovery.this.getQueryRunner().execute(this.session, this.resolveTableName((String)sql, tableName)));
                }
                catch (RuntimeException e) {
                    if (failure == null) {
                        failure = e;
                    }
                    if (failure == e) break block8;
                    failure.addSuppressed(e);
                }
            }
            if (failure != null) {
                throw failure;
            }
            return new ExecutionResult(result, updatedTableContent, updatedTableStatistics);
        }

        public void finishesSuccessfully() {
            ExecutionResult expected = this.executeExpected();
            MaterializedResult expectedQueryResult = expected.getQueryResult();
            ExecutionResult actual = this.executeActual(expectedQueryResult);
            MaterializedResult actualQueryResult = actual.getQueryResult();
            boolean isAnalyze = expectedQueryResult.getUpdateType().isPresent() && ((String)expectedQueryResult.getUpdateType().get()).equals("ANALYZE");
            boolean isUpdate = expectedQueryResult.getUpdateCount().isPresent();
            boolean isExplain = this.query.trim().toUpperCase(Locale.ENGLISH).startsWith("EXPLAIN");
            if (isAnalyze) {
                Assert.assertEquals((Object)actualQueryResult.getUpdateCount(), (Object)expectedQueryResult.getUpdateCount());
                Assertions.assertThat(expected.getUpdatedTableStatistics()).isPresent();
                Assertions.assertThat(actual.getUpdatedTableStatistics()).isPresent();
                MaterializedResult expectedUpdatedTableStatistics = expected.getUpdatedTableStatistics().get();
                MaterializedResult actualUpdatedTableStatistics = actual.getUpdatedTableStatistics().get();
                QueryAssertions.assertEqualsIgnoreOrder(actualUpdatedTableStatistics, expectedUpdatedTableStatistics, "For query: \n " + this.query);
            } else if (isUpdate) {
                Assert.assertEquals((Object)actualQueryResult.getUpdateCount(), (Object)expectedQueryResult.getUpdateCount());
                Assertions.assertThat(expected.getUpdatedTableContent()).isPresent();
                Assertions.assertThat(actual.getUpdatedTableContent()).isPresent();
                MaterializedResult expectedUpdatedTableContent = expected.getUpdatedTableContent().get();
                MaterializedResult actualUpdatedTableContent = actual.getUpdatedTableContent().get();
                QueryAssertions.assertEqualsIgnoreOrder(actualUpdatedTableContent, expectedUpdatedTableContent, "For query: \n " + this.query);
            } else if (isExplain) {
                Assert.assertEquals((int)actualQueryResult.getRowCount(), (int)expectedQueryResult.getRowCount());
            } else {
                QueryAssertions.assertEqualsIgnoreOrder(actualQueryResult, expectedQueryResult, "For query: \n " + this.query);
            }
        }

        public AbstractThrowableAssert<?, ? extends Throwable> failsWithErrorThat() {
            ExecutionResult expected = this.executeExpected();
            return Assertions.assertThatThrownBy(() -> this.executeActual(expected.getQueryResult()));
        }

        private String resolveTableName(String query, String tableName) {
            return query.replaceAll("<table>", tableName);
        }
    }
}

