/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.server.SessionContext;
import io.trino.spi.security.SelectedRole;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class TestingSessionContext {
    private TestingSessionContext() {
    }

    public static SessionContext fromSession(Session session) {
        Objects.requireNonNull(session, "session is null");
        Set enabledRoles = session.getIdentity().getEnabledRoles();
        SelectedRole selectedRole = enabledRoles.isEmpty() ? new SelectedRole(SelectedRole.Type.NONE, Optional.empty()) : (enabledRoles.size() == 1 ? new SelectedRole(SelectedRole.Type.ROLE, Optional.of((String)enabledRoles.iterator().next())) : new SelectedRole(SelectedRole.Type.ALL, Optional.empty()));
        return new SessionContext(session.getProtocolHeaders(), session.getCatalog(), session.getSchema(), session.getPath().getRawPath(), Optional.empty(), session.getIdentity(), selectedRole, session.getSource(), session.getTraceToken(), session.getUserAgent(), session.getRemoteUserAddress(), Optional.of(session.getTimeZoneKey().getId()), Optional.of(session.getLocale().getLanguage()), session.getClientTags(), session.getClientCapabilities(), session.getResourceEstimates(), session.getSystemProperties(), (Map)session.getConnectorProperties().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((CatalogName)entry.getKey()).getCatalogName(), Map.Entry::getValue)), session.getPreparedStatements(), session.getTransactionId(), session.isClientTransactionSupport(), session.getClientInfo());
    }
}

