/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.QualifiedObjectName;
import io.trino.spi.QueryId;
import io.trino.spi.TrinoException;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.planner.Plan;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.H2QueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedResultWithQueryId;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryFailedException;
import io.trino.testing.QueryRunner;
import io.trino.testing.assertions.Assert;
import io.trino.tpch.TpchTable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.intellij.lang.annotations.Language;

public final class QueryAssertions {
    private static final Logger log = Logger.get(QueryAssertions.class);

    private QueryAssertions() {
    }

    public static void assertUpdate(QueryRunner queryRunner, Session session, @Language(value="SQL") String sql, OptionalLong count, Optional<Consumer<Plan>> planAssertion) {
        MaterializedResult results;
        Plan queryPlan;
        if (queryRunner instanceof DistributedQueryRunner) {
            DistributedQueryRunner distributedQueryRunner = (DistributedQueryRunner)queryRunner;
            QueryAssertions.assertDistributedUpdate(distributedQueryRunner, session, sql, count, planAssertion);
            return;
        }
        long start = System.nanoTime();
        if (planAssertion.isPresent()) {
            QueryRunner.MaterializedResultWithPlan resultWithPlan = queryRunner.executeWithPlan(session, sql, WarningCollector.NOOP);
            queryPlan = resultWithPlan.getQueryPlan();
            results = resultWithPlan.getMaterializedResult().toTestTypes();
        } else {
            queryPlan = null;
            results = queryRunner.execute(session, sql);
        }
        Duration queryTime = Duration.nanosSince((long)start);
        if (queryTime.compareTo(Duration.succinctDuration((double)1.0, (TimeUnit)TimeUnit.SECONDS)) > 0) {
            log.info("FINISHED in Trino: %s", new Object[]{queryTime});
        }
        if (planAssertion.isPresent()) {
            planAssertion.get().accept(queryPlan);
        }
        if (results.getUpdateType().isEmpty()) {
            org.testng.Assert.fail((String)"update type is not set");
        }
        if (results.getUpdateCount().isPresent()) {
            if (count.isEmpty()) {
                org.testng.Assert.fail((String)("expected no update count, but got " + results.getUpdateCount().getAsLong()));
            }
            org.testng.Assert.assertEquals((long)results.getUpdateCount().getAsLong(), (long)count.getAsLong(), (String)"update count");
        } else if (count.isPresent()) {
            org.testng.Assert.fail((String)"update count is not present");
        }
    }

    private static void assertDistributedUpdate(DistributedQueryRunner distributedQueryRunner, Session session, @Language(value="SQL") String sql, OptionalLong count, Optional<Consumer<Plan>> planAssertion) {
        Duration queryTime;
        long start = System.nanoTime();
        Plan queryPlan = null;
        MaterializedResultWithQueryId resultWithQueryId = distributedQueryRunner.executeWithQueryId(session, sql);
        QueryId queryId = resultWithQueryId.getQueryId();
        MaterializedResult results = resultWithQueryId.getResult().toTestTypes();
        if (planAssertion.isPresent()) {
            try {
                queryPlan = distributedQueryRunner.getQueryPlan(queryId);
            }
            catch (RuntimeException e) {
                org.testng.Assert.fail((String)("Failed to get query plan for query " + queryId), (Throwable)e);
            }
        }
        if ((queryTime = Duration.nanosSince((long)start)).compareTo(Duration.succinctDuration((double)1.0, (TimeUnit)TimeUnit.SECONDS)) > 0) {
            log.info("FINISHED query %s in Trino: %s", new Object[]{queryId, queryTime});
        }
        if (planAssertion.isPresent()) {
            try {
                planAssertion.get().accept(queryPlan);
            }
            catch (Exception e) {
                org.testng.Assert.fail((String)("Plan assertion failed for query " + queryId), (Throwable)e);
            }
        }
        if (results.getUpdateType().isEmpty()) {
            org.testng.Assert.fail((String)("update type is not set for query " + queryId));
        }
        if (results.getUpdateCount().isPresent()) {
            if (count.isEmpty()) {
                org.testng.Assert.fail((String)("expected no update count, but got " + results.getUpdateCount().getAsLong() + " for query " + queryId));
            }
            org.testng.Assert.assertEquals((long)results.getUpdateCount().getAsLong(), (long)count.getAsLong(), (String)("update count for query " + queryId));
        } else if (count.isPresent()) {
            org.testng.Assert.fail((String)("update count is not present for query " + queryId));
        }
    }

    public static void assertQuery(QueryRunner actualQueryRunner, Session session, @Language(value="SQL") String actual, H2QueryRunner h2QueryRunner, @Language(value="SQL") String expected, boolean ensureOrdering, boolean compareUpdate) {
        QueryAssertions.assertQuery(actualQueryRunner, session, actual, h2QueryRunner, expected, ensureOrdering, compareUpdate, Optional.empty());
    }

    public static void assertQuery(QueryRunner actualQueryRunner, Session session, @Language(value="SQL") String actual, H2QueryRunner h2QueryRunner, @Language(value="SQL") String expected, boolean ensureOrdering, boolean compareUpdate, Consumer<Plan> planAssertion) {
        QueryAssertions.assertQuery(actualQueryRunner, session, actual, h2QueryRunner, expected, ensureOrdering, compareUpdate, Optional.of(planAssertion));
    }

    private static void assertQuery(QueryRunner actualQueryRunner, Session session, @Language(value="SQL") String actual, H2QueryRunner h2QueryRunner, @Language(value="SQL") String expected, boolean ensureOrdering, boolean compareUpdate, Optional<Consumer<Plan>> planAssertion) {
        if (actualQueryRunner instanceof DistributedQueryRunner) {
            DistributedQueryRunner distributedQueryRunner = (DistributedQueryRunner)actualQueryRunner;
            QueryAssertions.assertDistributedQuery(distributedQueryRunner, session, actual, h2QueryRunner, expected, ensureOrdering, compareUpdate, planAssertion);
            return;
        }
        long start = System.nanoTime();
        MaterializedResult actualResults = null;
        Plan queryPlan = null;
        if (planAssertion.isPresent()) {
            try {
                QueryRunner.MaterializedResultWithPlan resultWithPlan = actualQueryRunner.executeWithPlan(session, actual, WarningCollector.NOOP);
                queryPlan = resultWithPlan.getQueryPlan();
                actualResults = resultWithPlan.getMaterializedResult().toTestTypes();
            }
            catch (RuntimeException ex) {
                org.testng.Assert.fail((String)("Execution of 'actual' query failed: " + actual), (Throwable)ex);
            }
        } else {
            try {
                actualResults = actualQueryRunner.execute(session, actual).toTestTypes();
            }
            catch (RuntimeException ex) {
                org.testng.Assert.fail((String)("Execution of 'actual' query failed: " + actual), (Throwable)ex);
            }
        }
        if (planAssertion.isPresent()) {
            planAssertion.get().accept(queryPlan);
        }
        Duration actualTime = Duration.nanosSince((long)start);
        long expectedStart = System.nanoTime();
        MaterializedResult expectedResults = null;
        try {
            expectedResults = h2QueryRunner.execute(session, expected, actualResults.getTypes());
        }
        catch (RuntimeException ex) {
            org.testng.Assert.fail((String)("Execution of 'expected' query failed: " + expected), (Throwable)ex);
        }
        Duration totalTime = Duration.nanosSince((long)start);
        if (totalTime.compareTo(Duration.succinctDuration((double)1.0, (TimeUnit)TimeUnit.SECONDS)) > 0) {
            log.info("FINISHED in Trino: %s, H2: %s, total: %s", new Object[]{actualTime, Duration.nanosSince((long)expectedStart), totalTime});
        }
        if (actualResults.getUpdateType().isPresent() || actualResults.getUpdateCount().isPresent()) {
            if (actualResults.getUpdateType().isEmpty()) {
                org.testng.Assert.fail((String)("update count present without update type for query: \n" + actual));
            }
            if (!compareUpdate) {
                org.testng.Assert.fail((String)("update type should not be present (use assertUpdate) for query: \n" + actual));
            }
        }
        List actualRows = actualResults.getMaterializedRows();
        List expectedRows = expectedResults.getMaterializedRows();
        if (compareUpdate) {
            if (actualResults.getUpdateType().isEmpty()) {
                org.testng.Assert.fail((String)("update type not present for query: \n" + actual));
            }
            if (actualResults.getUpdateCount().isEmpty()) {
                org.testng.Assert.fail((String)("update count not present for query: \n" + actual));
            }
            org.testng.Assert.assertEquals((int)actualRows.size(), (int)1, (String)("For query: \n " + actual + "\n:"));
            org.testng.Assert.assertEquals((int)expectedRows.size(), (int)1, (String)("For query: \n " + actual + "\n:"));
            MaterializedRow row = (MaterializedRow)expectedRows.get(0);
            org.testng.Assert.assertEquals((int)row.getFieldCount(), (int)1, (String)("For query: \n " + actual + "\n:"));
            org.testng.Assert.assertEquals((Object)row.getField(0), (Object)actualResults.getUpdateCount().getAsLong(), (String)("For query: \n " + actual + "\n:"));
        }
        if (ensureOrdering) {
            if (!actualRows.equals(expectedRows)) {
                org.testng.Assert.assertEquals((Collection)actualRows, (Collection)expectedRows, (String)("For query: \n " + actual + "\n:"));
            }
        } else {
            QueryAssertions.assertEqualsIgnoreOrder(actualRows, expectedRows, "For query: \n " + actual);
        }
    }

    private static void assertDistributedQuery(DistributedQueryRunner distributedQueryRunner, Session session, @Language(value="SQL") String actual, H2QueryRunner h2QueryRunner, @Language(value="SQL") String expected, boolean ensureOrdering, boolean compareUpdate, Optional<Consumer<Plan>> planAssertion) {
        long start = System.nanoTime();
        QueryId queryId = null;
        MaterializedResult actualResults = null;
        try {
            MaterializedResultWithQueryId resultWithQueryId = distributedQueryRunner.executeWithQueryId(session, actual);
            queryId = resultWithQueryId.getQueryId();
            actualResults = resultWithQueryId.getResult().toTestTypes();
        }
        catch (RuntimeException ex) {
            org.testng.Assert.fail((String)("Execution of 'actual' query failed: " + actual), (Throwable)ex);
        }
        if (planAssertion.isPresent()) {
            try {
                planAssertion.get().accept(distributedQueryRunner.getQueryPlan(queryId));
            }
            catch (Throwable t) {
                t.addSuppressed(new Exception(String.format("SQL: %s [QueryId: %s]", actual, queryId)));
                throw t;
            }
        }
        Duration actualTime = Duration.nanosSince((long)start);
        long expectedStart = System.nanoTime();
        MaterializedResult expectedResults = null;
        try {
            expectedResults = h2QueryRunner.execute(session, expected, actualResults.getTypes());
        }
        catch (RuntimeException ex) {
            org.testng.Assert.fail((String)("Execution of 'expected' query failed: " + expected), (Throwable)ex);
        }
        Duration totalTime = Duration.nanosSince((long)start);
        if (totalTime.compareTo(Duration.succinctDuration((double)1.0, (TimeUnit)TimeUnit.SECONDS)) > 0) {
            log.info("FINISHED in Trino: %s, H2: %s, total: %s", new Object[]{actualTime, Duration.nanosSince((long)expectedStart), totalTime});
        }
        if (actualResults.getUpdateType().isPresent() || actualResults.getUpdateCount().isPresent()) {
            if (actualResults.getUpdateType().isEmpty()) {
                org.testng.Assert.fail((String)("update count present without update type for query " + queryId + ": \n" + actual));
            }
            if (!compareUpdate) {
                org.testng.Assert.fail((String)("update type should not be present (use assertUpdate) for query " + queryId + ": \n" + actual));
            }
        }
        List actualRows = actualResults.getMaterializedRows();
        List expectedRows = expectedResults.getMaterializedRows();
        if (compareUpdate) {
            if (actualResults.getUpdateType().isEmpty()) {
                org.testng.Assert.fail((String)("update type not present for query " + queryId + ": \n" + actual));
            }
            if (actualResults.getUpdateCount().isEmpty()) {
                org.testng.Assert.fail((String)("update count not present for query " + queryId + ": \n" + actual));
            }
            org.testng.Assert.assertEquals((int)actualRows.size(), (int)1, (String)("For query " + queryId + ": \n " + actual + "\n:"));
            org.testng.Assert.assertEquals((int)expectedRows.size(), (int)1, (String)("For query " + queryId + ": \n " + actual + "\n:"));
            MaterializedRow row = (MaterializedRow)expectedRows.get(0);
            org.testng.Assert.assertEquals((int)row.getFieldCount(), (int)1, (String)("For query " + queryId + ": \n " + actual + "\n:"));
            org.testng.Assert.assertEquals((Object)row.getField(0), (Object)actualResults.getUpdateCount().getAsLong(), (String)("For query " + queryId + ": \n " + actual + "\n:"));
        }
        if (ensureOrdering) {
            if (!actualRows.equals(expectedRows)) {
                org.testng.Assert.assertEquals((Collection)actualRows, (Collection)expectedRows, (String)("For query " + queryId + ": \n " + actual + "\n:"));
            }
        } else {
            QueryAssertions.assertEqualsIgnoreOrder(actualRows, expectedRows, "For query " + queryId + ": \n " + actual);
        }
    }

    public static void assertQueryEventually(QueryRunner actualQueryRunner, Session session, @Language(value="SQL") String actual, H2QueryRunner h2QueryRunner, @Language(value="SQL") String expected, boolean ensureOrdering, boolean compareUpdate, Optional<Consumer<Plan>> planAssertion, Duration timeout) {
        Assert.assertEventually((Duration)timeout, () -> QueryAssertions.assertQuery(actualQueryRunner, session, actual, h2QueryRunner, expected, ensureOrdering, compareUpdate, planAssertion));
    }

    public static void assertEqualsIgnoreOrder(Iterable<?> actual, Iterable<?> expected) {
        QueryAssertions.assertEqualsIgnoreOrder(actual, expected, null);
    }

    public static void assertEqualsIgnoreOrder(Iterable<?> actual, Iterable<?> expected, String message) {
        org.testng.Assert.assertNotNull(actual, (String)"actual is null");
        org.testng.Assert.assertNotNull(expected, (String)"expected is null");
        ImmutableMultiset actualSet = ImmutableMultiset.copyOf(actual);
        ImmutableMultiset expectedSet = ImmutableMultiset.copyOf(expected);
        if (!actualSet.equals((Object)expectedSet)) {
            Multiset unexpectedRows = Multisets.difference((Multiset)actualSet, (Multiset)expectedSet);
            Multiset missingRows = Multisets.difference((Multiset)expectedSet, (Multiset)actualSet);
            int limit = 100;
            org.testng.Assert.fail((String)String.format("%snot equal\nActual rows (up to %s of %s extra rows shown, %s rows in total):\n    %s\nExpected rows (up to %s of %s missing rows shown, %s rows in total):\n    %s\n", message == null ? "" : message + "\n", limit, unexpectedRows.size(), actualSet.size(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)unexpectedRows, (int)limit)), limit, missingRows.size(), expectedSet.size(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)missingRows, (int)limit))));
        }
    }

    public static void assertContainsEventually(Supplier<MaterializedResult> all, MaterializedResult expectedSubset, Duration timeout) {
        Assert.assertEventually((Duration)timeout, () -> QueryAssertions.assertContains((MaterializedResult)all.get(), expectedSubset));
    }

    public static void assertContains(MaterializedResult all, MaterializedResult expectedSubset) {
        for (MaterializedRow row : expectedSubset.getMaterializedRows()) {
            if (all.getMaterializedRows().contains(row)) continue;
            org.testng.Assert.fail((String)String.format("expected row missing: %s\nAll %s rows:\n    %s\nExpected subset %s rows:\n    %s\n", row, all.getMaterializedRows().size(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)all, (int)100)), expectedSubset.getMaterializedRows().size(), Joiner.on((String)"\n    ").join(Iterables.limit((Iterable)expectedSubset, (int)100))));
        }
    }

    protected static void assertQuerySucceeds(QueryRunner queryRunner, Session session, @Language(value="SQL") String sql) {
        try {
            queryRunner.execute(session, sql);
        }
        catch (QueryFailedException e) {
            org.testng.Assert.fail((String)String.format("Expected query %s to succeed: %s", e.getQueryId(), sql), (Throwable)e);
        }
        catch (RuntimeException e) {
            org.testng.Assert.fail((String)String.format("Expected query to succeed: %s", sql), (Throwable)e);
        }
    }

    protected static void assertQueryFailsEventually(QueryRunner queryRunner, Session session, @Language(value="SQL") String sql, @Language(value="RegExp") String expectedMessageRegExp, Duration timeout) {
        Assert.assertEventually((Duration)timeout, () -> QueryAssertions.assertQueryFails(queryRunner, session, sql, expectedMessageRegExp));
    }

    protected static void assertQueryFails(QueryRunner queryRunner, Session session, @Language(value="SQL") String sql, @Language(value="RegExp") String expectedMessageRegExp) {
        try {
            if (queryRunner instanceof DistributedQueryRunner) {
                DistributedQueryRunner distributedQueryRunner = (DistributedQueryRunner)queryRunner;
                MaterializedResultWithQueryId resultWithQueryId = distributedQueryRunner.executeWithQueryId(session, sql);
                org.testng.Assert.fail((String)String.format("Expected query to fail: %s [QueryId: %s]", sql, resultWithQueryId.getQueryId()));
            } else {
                queryRunner.execute(session, sql);
                org.testng.Assert.fail((String)String.format("Expected query to fail: %s", sql));
            }
        }
        catch (RuntimeException exception) {
            exception.addSuppressed(new Exception("Query: " + sql));
            Assertions.assertThat((Throwable)exception).hasMessageMatching(expectedMessageRegExp).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Throwable)QueryAssertions.getTrinoExceptionCause(e)).hasMessageMatching(expectedMessageRegExp)});
        }
    }

    protected static void assertQueryReturnsEmptyResult(QueryRunner queryRunner, Session session, @Language(value="SQL") String sql) {
        QueryId queryId = null;
        try {
            MaterializedResult results;
            if (queryRunner instanceof DistributedQueryRunner) {
                DistributedQueryRunner distributedQueryRunner = (DistributedQueryRunner)queryRunner;
                MaterializedResultWithQueryId resultWithQueryId = distributedQueryRunner.executeWithQueryId(session, sql);
                queryId = resultWithQueryId.getQueryId();
                results = resultWithQueryId.getResult().toTestTypes();
            } else {
                results = queryRunner.execute(session, sql).toTestTypes();
            }
            org.testng.Assert.assertNotNull((Object)results);
            org.testng.Assert.assertEquals((int)results.getRowCount(), (int)0);
        }
        catch (RuntimeException ex) {
            if (queryId == null) {
                org.testng.Assert.fail((String)("Execution of query failed: " + sql), (Throwable)ex);
            }
            org.testng.Assert.fail((String)String.format("Execution of query failed: %s [QueryId: %s]", sql, queryId), (Throwable)ex);
        }
    }

    public static void copyTpchTables(QueryRunner queryRunner, String sourceCatalog, String sourceSchema, Session session, Iterable<TpchTable<?>> tables) {
        log.info("Loading data from %s.%s...", new Object[]{sourceCatalog, sourceSchema});
        long startTime = System.nanoTime();
        for (TpchTable<?> table : tables) {
            QueryAssertions.copyTable(queryRunner, sourceCatalog, sourceSchema, table.getTableName().toLowerCase(Locale.ENGLISH), session);
        }
        log.info("Loading from %s.%s complete in %s", new Object[]{sourceCatalog, sourceSchema, Duration.nanosSince((long)startTime).toString(TimeUnit.SECONDS)});
    }

    public static void copyTable(QueryRunner queryRunner, String sourceCatalog, String sourceSchema, String sourceTable, Session session) {
        QualifiedObjectName table = new QualifiedObjectName(sourceCatalog, sourceSchema, sourceTable);
        QueryAssertions.copyTable(queryRunner, table, session);
    }

    public static void copyTable(QueryRunner queryRunner, QualifiedObjectName table, Session session) {
        long start = System.nanoTime();
        log.info("Running import for %s", new Object[]{table.getObjectName()});
        String sql = String.format("CREATE TABLE IF NOT EXISTS %s AS SELECT * FROM %s", table.getObjectName(), table);
        long rows = (Long)((MaterializedRow)queryRunner.execute(session, sql).getMaterializedRows().get(0)).getField(0);
        log.info("Imported %s rows for %s in %s", new Object[]{rows, table.getObjectName(), Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
        ((ObjectAssert)Assertions.assertThat((Object)queryRunner.execute(session, "SELECT count(*) FROM " + table).getOnlyValue()).as("Table is not loaded properly: %s", new Object[]{table})).isEqualTo(queryRunner.execute(session, "SELECT count(*) FROM " + table.getObjectName()).getOnlyValue());
    }

    public static RuntimeException getTrinoExceptionCause(Throwable e) {
        return Throwables.getCausalChain((Throwable)e).stream().filter(QueryAssertions::isTrinoException).findFirst().map(RuntimeException.class::cast).orElseThrow(() -> new IllegalArgumentException("Exception does not have TrinoException cause", e));
    }

    private static boolean isTrinoException(Throwable exception) {
        Objects.requireNonNull(exception, "exception is null");
        if (exception instanceof TrinoException || exception instanceof ParsingException) {
            return true;
        }
        if (exception.getClass().getName().equals("io.trino.client.FailureInfo$FailureException")) {
            try {
                String originalClassName = exception.toString().split(":", 2)[0];
                Class<Throwable> originalClass = Class.forName(originalClassName).asSubclass(Throwable.class);
                return TrinoException.class.isAssignableFrom(originalClass) || ParsingException.class.isAssignableFrom(originalClass);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return false;
    }
}

