/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.cost.StatsAndCosts;
import io.trino.dispatcher.DispatchManager;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryManager;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.server.BasicQueryInfo;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.Plugin;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.security.Identity;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueries;
import io.trino.testing.DataProviders;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedResultWithQueryId;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.TestingNames;
import io.trino.testing.assertions.Assert;
import io.trino.testing.assertions.TestUtil;
import io.trino.testing.sql.TestTable;
import io.trino.testing.sql.TestView;
import io.trino.transaction.TransactionBuilder;
import io.trino.transaction.TransactionManager;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractZonedDateTimeAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ThrowingConsumer;
import org.intellij.lang.annotations.Language;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class BaseConnectorTest
extends AbstractTestQueries {
    private static final Logger log = Logger.get(BaseConnectorTest.class);
    private final ConcurrentMap<String, Function<ConnectorSession, List<String>>> mockTableListings = new ConcurrentHashMap<String, Function<ConnectorSession, List<String>>>();

    @BeforeClass
    public void initMockCatalog() {
        QueryRunner queryRunner = this.getQueryRunner();
        queryRunner.installPlugin((Plugin)this.buildMockConnectorPlugin());
        queryRunner.createCatalog("mock_dynamic_listing", "mock", Map.of());
    }

    protected MockConnectorPlugin buildMockConnectorPlugin() {
        MockConnectorFactory connectorFactory = MockConnectorFactory.builder().withListSchemaNames(session -> ImmutableList.copyOf(this.mockTableListings.keySet())).withListTables((session, schemaName) -> (List)((Function)Verify.verifyNotNull((Object)((Function)this.mockTableListings.get(schemaName)), (String)"No listing function registered for [%s]", (Object[])new Object[]{schemaName})).apply(session)).build();
        return new MockConnectorPlugin((ConnectorFactory)connectorFactory);
    }

    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return connectorBehavior.hasBehaviorByDefault(this::hasBehavior);
    }

    @Override
    @Test
    public void ensureTestNamingConvention() {
        Assertions.assertThat((String)this.getClass().getName()).endsWith((CharSequence)"ConnectorTest");
    }

    @Test
    public void ensureDistributedQueryRunner() {
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.getQueryRunner().getNodeCount()).as("query runner node count", new Object[0])).isGreaterThanOrEqualTo(3);
    }

    @Test
    public void testShowCreateSchema() {
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE SCHEMA " + schemaName))).isEqualTo(String.format("CREATE SCHEMA %s.%s", this.getSession().getCatalog().orElseThrow(), schemaName));
    }

    @Test
    public void testCreateSchema() {
        String schemaName = "test_schema_create_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            this.assertQueryFails(this.createSchemaSql(schemaName), "This connector does not support creating schemas");
            return;
        }
        Assertions.assertThat((Collection)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).doesNotContain(new Object[]{schemaName});
        this.assertUpdate(this.createSchemaSql(schemaName));
        Assertions.assertThat((Collection)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).contains(new Object[]{schemaName});
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE SCHEMA " + schemaName))).startsWith((CharSequence)String.format("CREATE SCHEMA %s.%s", this.getSession().getCatalog().orElseThrow(), schemaName));
        this.assertQueryFails(this.createSchemaSql(schemaName), String.format("line 1:1: Schema '.*\\.%s' already exists", schemaName));
        this.assertUpdate("DROP SCHEMA " + schemaName);
        this.assertQueryFails("DROP SCHEMA " + schemaName, String.format("line 1:1: Schema '.*\\.%s' does not exist", schemaName));
    }

    @Test
    public void testDropNonEmptySchemaWithTable() {
        String schemaName = "test_drop_non_empty_schema_table_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            return;
        }
        try {
            this.assertUpdate(this.createSchemaSql(schemaName));
            this.assertUpdate("CREATE TABLE " + schemaName + ".t(x int)");
            this.assertQueryFails("DROP SCHEMA " + schemaName, ".*Cannot drop non-empty schema '\\Q" + schemaName + "\\E'");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + schemaName + ".t");
            this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName);
        }
    }

    @Test
    public void testDropNonEmptySchemaWithView() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            return;
        }
        String schemaName = "test_drop_non_empty_schema_view_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate(this.createSchemaSql(schemaName));
            this.assertUpdate("CREATE VIEW " + schemaName + ".v_t  AS SELECT 123 x");
            this.assertQueryFails("DROP SCHEMA " + schemaName, ".*Cannot drop non-empty schema '\\Q" + schemaName + "\\E'");
        }
        finally {
            this.assertUpdate("DROP VIEW IF EXISTS " + schemaName + ".v_t");
            this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName);
        }
    }

    @Test
    public void testDropNonEmptySchemaWithMaterializedView() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            return;
        }
        String schemaName = "test_drop_non_empty_schema_mv_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate(this.createSchemaSql(schemaName));
            this.assertUpdate("CREATE MATERIALIZED VIEW " + schemaName + ".mv_t  AS SELECT 123 x");
            this.assertQueryFails("DROP SCHEMA " + schemaName, ".*Cannot drop non-empty schema '\\Q" + schemaName + "\\E'");
        }
        finally {
            this.assertUpdate("DROP MATERIALIZED VIEW IF EXISTS " + schemaName + ".mv_t");
            this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName);
        }
    }

    @Test
    public void testColumnsInReverseOrder() {
        this.assertQuery("SELECT shippriority, clerk, totalprice FROM orders");
    }

    @Test
    public void testCharVarcharComparison() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_char_varchar", "(k, v) AS VALUES   (-1, CAST(NULL AS char(3))),    (3, CAST('   ' AS char(3))),   (6, CAST('x  ' AS char(3)))");){
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('  ' AS varchar(2))", "VALUES (3, '   ')");
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('  ' AS varchar(4))", "VALUES (3, '   ')");
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('x ' AS varchar(2))", "VALUES (6, 'x  ')");
        }
    }

    @Test
    public void testVarcharCharComparison() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_varchar_char", "(k, v) AS VALUES   (-1, CAST(NULL AS varchar(3))),    (0, CAST('' AS varchar(3))),   (1, CAST(' ' AS varchar(3))),    (2, CAST('  ' AS varchar(3))),    (3, CAST('   ' AS varchar(3))),   (4, CAST('x' AS varchar(3))),   (5, CAST('x ' AS varchar(3))),   (6, CAST('x  ' AS varchar(3)))");){
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('  ' AS char(2))", "VALUES (0, ''), (1, ' '), (2, '  '), (3, '   ')");
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('x ' AS char(2))", "VALUES (4, 'x'), (5, 'x '), (6, 'x  ')");
        }
    }

    @Test
    public void testAggregation() {
        this.assertQuery("SELECT sum(orderkey) FROM orders");
        this.assertQuery("SELECT sum(totalprice) FROM orders");
        this.assertQuery("SELECT max(comment) FROM nation");
        this.assertQuery("SELECT count(*) FROM orders");
        this.assertQuery("SELECT count(*) FROM orders WHERE orderkey > 10");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders LIMIT 10)");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM orders WHERE orderkey > 10 LIMIT 10)");
        this.assertQuery("SELECT DISTINCT regionkey FROM nation");
        this.assertQuery("SELECT regionkey FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT regionkey, nationkey FROM nation GROUP BY GROUPING SETS ((regionkey), (nationkey))", "SELECT NULL, nationkey FROM nation UNION ALL SELECT DISTINCT regionkey, NULL FROM nation");
        this.assertQuery("SELECT regionkey, nationkey, count(*) FROM nation GROUP BY GROUPING SETS ((), (regionkey), (nationkey), (regionkey, nationkey))", "SELECT NULL, NULL, count(*) FROM nation UNION ALL SELECT NULL, nationkey, 1 FROM nation UNION ALL SELECT regionkey, NULL, count(*) FROM nation GROUP BY regionkey UNION ALL SELECT regionkey, nationkey, 1 FROM nation");
        this.assertQuery("SELECT count(regionkey) FROM nation");
        this.assertQuery("SELECT count(DISTINCT regionkey) FROM nation");
        this.assertQuery("SELECT regionkey, count(*) FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT min(regionkey), max(regionkey) FROM nation");
        this.assertQuery("SELECT min(DISTINCT regionkey), max(DISTINCT regionkey) FROM nation");
        this.assertQuery("SELECT regionkey, min(regionkey), min(name), max(regionkey), max(name) FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT sum(regionkey) FROM nation");
        this.assertQuery("SELECT sum(DISTINCT regionkey) FROM nation");
        this.assertQuery("SELECT regionkey, sum(regionkey) FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT avg(nationkey) FROM nation", "SELECT avg(CAST(nationkey AS double)) FROM nation");
        this.assertQuery("SELECT avg(DISTINCT nationkey) FROM nation", "SELECT avg(DISTINCT CAST(nationkey AS double)) FROM nation");
        this.assertQuery("SELECT regionkey, avg(nationkey) FROM nation GROUP BY regionkey", "SELECT regionkey, avg(CAST(nationkey AS double)) FROM nation GROUP BY regionkey");
        this.assertQuery("SELECT -13 FROM (SELECT count(*) FROM nation)", "VALUES -13");
        this.assertQuery("SELECT count(*) FROM (SELECT count(*) FROM nation UNION ALL SELECT count(*) FROM region)", "VALUES 2");
    }

    @Test
    public void testExactPredicate() {
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey = 10");
        this.assertQuery("SELECT custkey, orderkey FROM orders WHERE orderkey = 32", "VALUES (1301, 32)");
        this.assertQuery("SELECT custkey FROM orders WHERE orderkey = 32", "VALUES (1301)");
    }

    @Test
    public void testInListPredicate() {
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey IN (10, 11, 20, 21)");
        this.assertQuery("SELECT custkey, orderkey FROM orders WHERE orderkey IN (7, 10, 32, 33)", "VALUES (392, 7), (1301, 32), (670, 33)");
        this.assertQuery("SELECT custkey FROM orders WHERE orderkey IN (7, 10, 32, 33)", "VALUES (392), (1301), (670)");
    }

    @Test
    public void testIsNullPredicate() {
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey IS NULL");
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderkey = 10 OR orderkey IS NULL");
        this.assertQuery("SELECT custkey, orderkey FROM orders WHERE orderkey = 32 OR orderkey IS NULL", "VALUES (1301, 32)");
        this.assertQuery("SELECT custkey FROM orders WHERE orderkey = 32 OR orderkey IS NULL", "VALUES (1301)");
    }

    @Test
    public void testLikePredicate() {
        this.assertQuery("SELECT orderkey FROM orders WHERE orderpriority LIKE '5-L%'");
        this.assertQuery("SELECT orderkey, orderpriority FROM orders WHERE orderpriority LIKE '5-L%'");
        this.assertQuery("SELECT orderkey FROM orders WHERE orderpriority LIKE '5-L__'");
        this.assertQuery("SELECT orderkey, orderpriority FROM orders WHERE orderpriority LIKE '5-L__'");
    }

    @Test
    public void testMultipleRangesPredicate() {
        this.assertQuery("SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders WHERE orderkey BETWEEN 10 AND 50");
    }

    @Test
    public void testRangePredicate() {
        this.assertQuery("SELECT orderkey, custkey, orderstatus, totalprice, orderdate, orderpriority, clerk, shippriority, comment FROM orders WHERE orderkey BETWEEN 10 AND 50");
    }

    @Test
    public void testDateYearOfEraPredicate() {
        this.assertQuery("SELECT orderdate FROM orders WHERE orderdate = DATE '1997-09-14'", "VALUES DATE '1997-09-14'");
        this.assertQueryReturnsEmptyResult("SELECT * FROM orders WHERE orderdate = DATE '-1996-09-14'");
    }

    @Test
    public void testPredicateReflectedInExplain() {
        this.assertExplain("EXPLAIN SELECT name FROM nation WHERE nationkey = 42", "(predicate|filterPredicate|constraint).{0,10}(nationkey|NATIONKEY)");
    }

    @Test
    public void testSortItemsReflectedInExplain() {
        String expectedPattern = this.hasBehavior(TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN) ? "sortOrder=\\[(?i:nationkey):.* DESC NULLS LAST] limit=5" : "\\[count = 5, orderBy = \\[(?i:nationkey) DESC NULLS LAST]]";
        this.assertExplain("EXPLAIN SELECT name FROM nation ORDER BY nationkey DESC NULLS LAST LIMIT 5", expectedPattern);
    }

    @Test
    public void testVarcharCastToDateInPredicate() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "varchar_as_date_pred", "(a varchar)", List.of("'999-09-09'", "'1005-09-09'", "'2005-06-06'", "'2005-06-6'", "'2005-6-06'", "'2005-6-6'", "' 2005-06-06'", "'2005-06-06 '", "' +2005-06-06'", "'02005-06-06'", "'2005-09-06'", "'2005-09-6'", "'2005-9-06'", "'2005-9-6'", "' 2005-09-06'", "'2005-09-06 '", "' +2005-09-06'", "'02005-09-06'", "'2005-09-09'", "'2005-09-9'", "'2005-9-09'", "'2005-9-9'", "' 2005-09-09'", "'2005-09-09 '", "' +2005-09-09'", "'02005-09-09'", "'2005-09-10'", "'2005-9-10'", "' 2005-09-10'", "'2005-09-10 '", "' +2005-09-10'", "'02005-09-10'", "'2005-09-20'", "'2005-9-20'", "' 2005-09-20'", "'2005-09-20 '", "' +2005-09-20'", "'02005-09-20'", "'9999-09-09'", "'99999-09-09'"));){
            for (String date : List.of("2005-09-06", "2005-09-09", "2005-09-10")) {
                for (String operator : List.of("=", "<=", "<", ">", ">=", "!=", "IS DISTINCT FROM", "IS NOT DISTINCT FROM")) {
                    ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT a FROM %s WHERE CAST(a AS date) %s DATE '%s'".formatted(table.getName(), operator, date)))).hasCorrectResultsRegardlessOfPushdown();
                }
            }
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "varchar_as_date_pred", "(a varchar)", List.of("'2005-06-bad-date'", "'2005-09-10'"));
        try {
            Assertions.assertThatThrownBy(() -> this.query("SELECT a FROM %s WHERE CAST(a AS date) < DATE '2005-09-10'".formatted(table.getName()))).hasMessage("Value cannot be cast to date: 2005-06-bad-date");
            TestUtil.verifyResultOrFailure(() -> this.query("SELECT a FROM %s WHERE CAST(a AS date) = DATE '2005-09-10'".formatted(table.getName())), queryAssert -> ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)queryAssert)).skippingTypesCheck().matches("VALUES '2005-09-10'"), failure -> Assertions.assertThat((Throwable)failure).hasMessage("Value cannot be cast to date: 2005-06-bad-date"));
            TestUtil.verifyResultOrFailure(() -> this.query("SELECT a FROM %s WHERE CAST(a AS date) != DATE '2005-9-1'".formatted(table.getName())), queryAssert -> ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)queryAssert)).skippingTypesCheck().matches("VALUES '2005-09-10'"), failure -> Assertions.assertThat((Throwable)failure).hasMessage("Value cannot be cast to date: 2005-06-bad-date"));
            TestUtil.verifyResultOrFailure(() -> this.query("SELECT a FROM %s WHERE CAST(a AS date) > DATE '2022-08-10'".formatted(table.getName())), queryAssert -> ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)queryAssert)).skippingTypesCheck().returnsEmptyResult(), failure -> Assertions.assertThat((Throwable)failure).hasMessage("Value cannot be cast to date: 2005-06-bad-date"));
        }
        finally {
            table.close();
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "varchar_as_date_pred", "(a varchar)", List.of("'2005-09-10'"));
        try {
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT a FROM %s WHERE CAST(a AS date) != DATE '2005-09-01'".formatted(table.getName())))).skippingTypesCheck().matches("VALUES '2005-09-10'");
        }
        finally {
            table.close();
        }
    }

    @Test
    public void testConcurrentScans() {
        String unionMultipleTimes = String.join((CharSequence)" UNION ALL ", Collections.nCopies(25, "SELECT * FROM orders"));
        this.assertQuery("SELECT sum(if(rand() >= 0, orderkey)) FROM (" + unionMultipleTimes + ")", "VALUES 11246812500");
    }

    @Test
    public void testSelectAll() {
        this.assertQuery("SELECT * FROM orders");
    }

    @Test
    public void testSelectInTransaction() {
        this.inTransaction(session -> {
            this.assertQuery((Session)session, "SELECT nationkey, name, regionkey FROM nation");
            this.assertQuery((Session)session, "SELECT regionkey, name FROM region");
            this.assertQuery((Session)session, "SELECT nationkey, name, regionkey FROM nation");
        });
    }

    @Test
    public void testSelectVersionOfNonExistentTable() {
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        String schema = (String)this.getSession().getSchema().orElseThrow();
        String tableName = "foo_" + TestingNames.randomNameSuffix();
        Assertions.assertThatThrownBy(() -> this.query("SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '2021-03-01 00:00:01'")).hasMessage(String.format("line 1:15: Table '%s.%s.%s' does not exist", catalog, schema, tableName));
        Assertions.assertThatThrownBy(() -> this.query("SELECT * FROM " + tableName + " FOR VERSION AS OF 'version1'")).hasMessage(String.format("line 1:15: Table '%s.%s.%s' does not exist", catalog, schema, tableName));
    }

    @Test
    public void testTrySelectTableVersion() {
        this.testTrySelectTableVersion("SELECT * FROM nation FOR TIMESTAMP AS OF DATE '2005-09-10'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR TIMESTAMP AS OF TIMESTAMP '2005-09-10 13:00:00'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR TIMESTAMP AS OF TIMESTAMP '2005-09-10 13:00:00 Europe/Warsaw'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF TINYINT '123'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF SMALLINT '123'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF 123");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF BIGINT '123'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF REAL '123.123'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF DOUBLE '123.123'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF DECIMAL '123.123'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF CHAR 'abc'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF '123'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF CAST('abc' AS varchar(5))");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF CAST('abc' AS varchar)");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF DATE '2005-09-10'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF TIME '13:00:00'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF TIMESTAMP '2005-09-10 13:00:00'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF TIMESTAMP '2005-09-10 13:00:00 Europe/Warsaw'");
        this.testTrySelectTableVersion("SELECT * FROM nation FOR VERSION AS OF JSON '{}'");
    }

    private void testTrySelectTableVersion(@Language(value="SQL") String query) {
        try {
            this.computeActual(query);
        }
        catch (Exception somewhatExpected) {
            this.verifyVersionedQueryFailurePermissible(QueryAssertions.getTrinoExceptionCause(somewhatExpected));
        }
    }

    protected void verifyVersionedQueryFailurePermissible(Exception e) {
        Assertions.assertThat((Throwable)e).hasMessageContaining("This connector does not support versioned tables");
    }

    @Test(dataProvider="joinDistributionTypes")
    public void testJoinWithEmptySides(OptimizerConfig.JoinDistributionType joinDistributionType) {
        Session session = this.noJoinReordering(joinDistributionType);
        this.assertQuery(session, "SELECT count(*) FROM nation JOIN region ON nation.regionkey = region.regionkey AND region.name = ''", "VALUES 0");
        this.assertQuery(session, "SELECT count(*) FROM nation JOIN region ON nation.regionkey = region.regionkey AND region.regionkey < 0", "VALUES 0");
        this.assertQuery(session, "SELECT count(*) FROM region JOIN nation ON nation.regionkey = region.regionkey AND region.name = ''", "VALUES 0");
        this.assertQuery(session, "SELECT count(*) FROM nation JOIN region ON nation.regionkey = region.regionkey AND region.regionkey < 0", "VALUES 0");
    }

    @DataProvider
    public Object[][] joinDistributionTypes() {
        return (Object[][])Stream.of(OptimizerConfig.JoinDistributionType.values()).collect(DataProviders.toDataProvider());
    }

    @Test
    public void testJoin() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("ignore_stats_calculator_failures", "false").build();
        this.assertQuery(session, "SELECT c.name, n.name, r.name FROM nation n JOIN customer c ON c.nationkey = n.nationkey JOIN region r ON n.regionkey = r.regionkey");
        this.assertQuery(session, "SELECT c.name, n.name, r.name FROM nation n JOIN customer c ON c.nationkey = n.nationkey JOIN region r ON n.regionkey = r.regionkey WHERE n.name = 'ARGENTINA'");
        this.assertQuery(session, "SELECT c.name, n.name, n.count, r.name FROM (SELECT name, regionkey, nationkey, count(*) count FROM nation GROUP BY name, regionkey, nationkey) n JOIN customer c ON c.nationkey = n.nationkey JOIN region r ON n.regionkey = r.regionkey");
    }

    @Test
    public void testDescribeTable() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("DESCRIBE orders"))).matches(this.getDescribeOrdersResult());
    }

    protected MaterializedResult getDescribeOrdersResult() {
        return MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar(1)", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "date", "", ""}).row(new Object[]{"orderpriority", "varchar(15)", "", ""}).row(new Object[]{"clerk", "varchar(15)", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar(79)", "", ""}).build();
    }

    @Test
    public void testShowInformationSchemaTables() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW TABLES FROM information_schema"))).skippingTypesCheck().containsAll("VALUES 'applicable_roles', 'columns', 'enabled_roles', 'roles', 'schemata', 'table_privileges', 'tables', 'views'");
    }

    @Test
    public void testView() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW)) {
            this.assertQueryFails("CREATE VIEW nation_v AS SELECT * FROM nation", "This connector does not support creating views");
            return;
        }
        String query = "SELECT orderkey, orderstatus, (totalprice / 2) half FROM orders";
        String catalogName = (String)this.getSession().getCatalog().orElseThrow();
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        String testView = "test_view_" + TestingNames.randomNameSuffix();
        String testViewWithComment = "test_view_with_comment_" + TestingNames.randomNameSuffix();
        Assertions.assertThat((Collection)this.computeActual("SHOW TABLES").getOnlyColumnAsSet()).doesNotContain(new Object[]{testView});
        this.assertUpdate("CREATE VIEW " + testView + " AS SELECT 123 x");
        Assertions.assertThat((Collection)this.computeActual("SHOW TABLES").getOnlyColumnAsSet()).contains(new Object[]{testView});
        this.assertUpdate("CREATE OR REPLACE VIEW " + testView + " AS " + query);
        this.assertUpdate("CREATE VIEW " + testViewWithComment + " COMMENT 'orders' AS SELECT 123 x");
        this.assertUpdate("CREATE OR REPLACE VIEW " + testViewWithComment + " COMMENT 'orders' AS " + query);
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE VIEW " + testViewWithComment))).contains(new CharSequence[]{"COMMENT 'orders'"});
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, comment FROM system.metadata.table_comments WHERE catalog_name = '" + catalogName + "' AND schema_name = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES ('" + testView + "', null), ('" + testViewWithComment + "', 'orders')");
        this.assertQuery("SELECT * FROM " + testView, query);
        this.assertQuery("SELECT * FROM " + testViewWithComment, query);
        this.assertQuery("SELECT * FROM " + testView + " a JOIN " + testView + " b on a.orderkey = b.orderkey", String.format("SELECT * FROM (%s) a JOIN (%s) b ON a.orderkey = b.orderkey", query, query));
        this.assertQuery("WITH orders AS (SELECT * FROM orders LIMIT 0) SELECT * FROM " + testView, query);
        String name = String.format("%s.%s." + testView, catalogName, schemaName);
        this.assertQuery("SELECT * FROM " + name, query);
        this.assertUpdate("DROP VIEW " + testViewWithComment);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, regexp_replace(view_definition, '\\s', '') FROM information_schema.views WHERE table_schema = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES ('" + testView + "', '" + query.replaceAll("\\s", "") + "')");
        this.assertQuery("SELECT table_name, regexp_replace(view_definition, '\\s', '') FROM information_schema.views WHERE table_schema = '" + schemaName + "' and table_name = '" + testView + "'", "VALUES ('" + testView + "', '" + query.replaceAll("\\s", "") + "')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW TABLES"))).skippingTypesCheck().containsAll("VALUES '" + testView + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES ('" + testView + "', 'VIEW')");
        this.assertQuery("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '" + schemaName + "' and table_name = '" + testView + "'", "VALUES ('" + testView + "', 'VIEW')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, table_type FROM system.jdbc.tables"))).skippingTypesCheck().containsAll("VALUES ('" + schemaName + "', '" + testView + "', 'VIEW')");
        this.assertQuery("SELECT table_schem, table_name, table_type FROM system.jdbc.tables WHERE table_cat = '" + catalogName + "' AND table_schem = '" + schemaName + "' AND table_name = '" + testView + "'", "VALUES ('" + schemaName + "', '" + testView + "', 'VIEW')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW COLUMNS FROM " + testView))).projected(new String[]{"Column"}).skippingTypesCheck().matches("VALUES 'orderkey', 'orderstatus', 'half'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("DESCRIBE " + testView))).projected(new String[]{"Column"}).skippingTypesCheck().matches("VALUES 'orderkey', 'orderstatus', 'half'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schemaName + "'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES '" + testView + "') CROSS JOIN UNNEST(ARRAY['orderkey', 'orderstatus', 'half'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schemaName + "' and table_name = '" + testView + "'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES '" + testView + "') CROSS JOIN UNNEST(ARRAY['orderkey', 'orderstatus', 'half'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name FROM information_schema.views WHERE table_schema = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES '" + testView + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES ('" + schemaName + "', '" + testView + "')) CROSS JOIN UNNEST(ARRAY['orderkey', 'orderstatus', 'half'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_schem LIKE '%" + schemaName + "%'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES ('" + schemaName + "', '" + testView + "')) CROSS JOIN UNNEST(ARRAY['orderkey', 'orderstatus', 'half'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_name LIKE '%" + testView + "%'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES ('" + schemaName + "', '" + testView + "')) CROSS JOIN UNNEST(ARRAY['orderkey', 'orderstatus', 'half'])");
        this.assertUpdate("DROP VIEW " + testView);
        Assertions.assertThat((Collection)this.computeActual("SHOW TABLES").getOnlyColumnAsSet()).doesNotContain(new Object[]{testView});
    }

    @Test
    public void testCreateViewSchemaNotFound() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW));
        String schemaName = "test_schema_" + TestingNames.randomNameSuffix();
        String viewName = "test_view_create_no_schema_" + TestingNames.randomNameSuffix();
        try {
            this.assertQueryFails(String.format("CREATE VIEW %s.%s AS SELECT 1 AS c1", schemaName, viewName), String.format("Schema %s not found", schemaName));
            this.assertQueryFails(String.format("CREATE OR REPLACE VIEW %s.%s AS SELECT 1 AS c1", schemaName, viewName), String.format("Schema %s not found", schemaName));
        }
        catch (Throwable throwable) {
            this.assertUpdate(String.format("DROP VIEW IF EXISTS %s.%s", schemaName, viewName));
            throw throwable;
        }
        this.assertUpdate(String.format("DROP VIEW IF EXISTS %s.%s", schemaName, viewName));
    }

    @Test
    public void testViewCaseSensitivity() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW));
        String upperCaseView = "test_view_uppercase_" + TestingNames.randomNameSuffix();
        String mixedCaseView = "test_view_mixedcase_" + TestingNames.randomNameSuffix();
        this.computeActual("CREATE VIEW " + upperCaseView + " AS SELECT X FROM (SELECT 123 X)");
        this.computeActual("CREATE VIEW " + mixedCaseView + " AS SELECT XyZ FROM (SELECT 456 XyZ)");
        this.assertQuery("SELECT * FROM " + upperCaseView, "SELECT X FROM (SELECT 123 X)");
        this.assertQuery("SELECT * FROM " + mixedCaseView, "SELECT XyZ FROM (SELECT 456 XyZ)");
        this.assertUpdate("DROP VIEW " + upperCaseView);
        this.assertUpdate("DROP VIEW " + mixedCaseView);
    }

    @Test
    public void testMaterializedView() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW)) {
            this.assertQueryFails("CREATE MATERIALIZED VIEW nation_mv AS SELECT * FROM nation", "This connector does not support creating materialized views");
            return;
        }
        String otherSchema = "other_schema" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createSchemaSql(otherSchema));
        QualifiedObjectName view = new QualifiedObjectName((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), "test_materialized_view_" + TestingNames.randomNameSuffix());
        QualifiedObjectName otherView = new QualifiedObjectName((String)this.getSession().getCatalog().orElseThrow(), otherSchema, "test_materialized_view_" + TestingNames.randomNameSuffix());
        QualifiedObjectName viewWithComment = new QualifiedObjectName((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), "test_materialized_view_with_comment_" + TestingNames.randomNameSuffix());
        this.createTestingMaterializedView(view, Optional.empty());
        this.createTestingMaterializedView(otherView, Optional.of("sarcastic comment"));
        this.createTestingMaterializedView(viewWithComment, Optional.of("mv_comment"));
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE MATERIALIZED VIEW " + viewWithComment))).contains(new CharSequence[]{"COMMENT 'mv_comment'"});
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, comment FROM system.metadata.table_comments WHERE catalog_name = '" + view.getCatalogName() + "' AND schema_name = '" + view.getSchemaName() + "'"))).skippingTypesCheck().containsAll("VALUES ('" + view.getObjectName() + "', null), ('" + viewWithComment.getObjectName() + "', 'mv_comment')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + view))).skippingTypesCheck().matches("SELECT * FROM nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + viewWithComment))).skippingTypesCheck().matches("SELECT * FROM nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW TABLES"))).skippingTypesCheck().containsAll("VALUES '" + view.getObjectName() + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '" + view.getSchemaName() + "'"))).skippingTypesCheck().containsAll("VALUES ('" + view.getObjectName() + "', 'BASE TABLE')");
        this.assertQuery("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '" + view.getSchemaName() + "' and table_name = '" + view.getObjectName() + "'", "VALUES ('" + view.getObjectName() + "', 'BASE TABLE')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, table_type FROM system.jdbc.tables"))).skippingTypesCheck().containsAll("VALUES ('" + view.getSchemaName() + "', '" + view.getObjectName() + "', 'TABLE')");
        this.assertQuery("SELECT table_schem, table_name, table_type FROM system.jdbc.tables WHERE table_cat = '" + view.getCatalogName() + "' AND table_schem = '" + view.getSchemaName() + "' AND table_name = '" + view.getObjectName() + "'", "VALUES ('" + view.getSchemaName() + "', '" + view.getObjectName() + "', 'TABLE')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW COLUMNS FROM " + view.getObjectName()))).projected(new String[]{"Column"}).skippingTypesCheck().matches("VALUES 'nationkey', 'name', 'regionkey', 'comment'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("DESCRIBE " + view.getObjectName()))).projected(new String[]{"Column"}).skippingTypesCheck().matches("VALUES 'nationkey', 'name', 'regionkey', 'comment'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + view.getSchemaName() + "'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES '" + view.getObjectName() + "') CROSS JOIN UNNEST(ARRAY['nationkey', 'name', 'regionkey', 'comment'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + view.getSchemaName() + "' and table_name = '" + view.getObjectName() + "'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES '" + view.getObjectName() + "') CROSS JOIN UNNEST(ARRAY['nationkey', 'name', 'regionkey', 'comment'])");
        this.checkInformationSchemaViewsForMaterializedView(view.getSchemaName(), view.getObjectName());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES ('" + view.getSchemaName() + "', '" + view.getObjectName() + "')) CROSS JOIN UNNEST(ARRAY['nationkey', 'name', 'regionkey', 'comment'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_schem LIKE '%" + view.getSchemaName() + "%'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES ('" + view.getSchemaName() + "', '" + view.getObjectName() + "')) CROSS JOIN UNNEST(ARRAY['nationkey', 'name', 'regionkey', 'comment'])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_name LIKE '%" + view.getObjectName() + "%'"))).skippingTypesCheck().containsAll("SELECT * FROM (VALUES ('" + view.getSchemaName() + "', '" + view.getObjectName() + "')) CROSS JOIN UNNEST(ARRAY['nationkey', 'name', 'regionkey', 'comment'])");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE MATERIALIZED VIEW " + view.getObjectName()))).matches((CharSequence)("(?s)CREATE MATERIALIZED VIEW \\Q" + view + "\\E.* AS\nSELECT \\*\nFROM\n  nation"));
        this.assertUpdate("DROP MATERIALIZED VIEW " + viewWithComment);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(this.listMaterializedViewsSql("catalog_name = '" + view.getCatalogName() + "'")))).skippingTypesCheck().containsAll(this.getTestingMaterializedViewsResultRows(view, otherView));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(this.listMaterializedViewsSql("catalog_name = '" + otherView.getCatalogName() + "'", "schema_name = '" + otherView.getSchemaName() + "'")))).skippingTypesCheck().containsAll(this.getTestingMaterializedViewsResultRow(otherView, "sarcastic comment"));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(this.listMaterializedViewsSql("catalog_name = '" + view.getCatalogName() + "'", "schema_name = '" + view.getSchemaName() + "'", "name = '" + view.getObjectName() + "'")))).skippingTypesCheck().containsAll(this.getTestingMaterializedViewsResultRow(view, ""));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(this.listMaterializedViewsSql("schema_name LIKE '%" + view.getSchemaName() + "%'")))).skippingTypesCheck().containsAll(this.getTestingMaterializedViewsResultRow(view, ""));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(this.listMaterializedViewsSql("name LIKE '%" + view.getObjectName() + "%'")))).skippingTypesCheck().containsAll(this.getTestingMaterializedViewsResultRow(view, ""));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MULTI_STATEMENT_WRITES)) {
            Assertions.assertThatThrownBy(() -> this.inTransaction(session -> this.computeActual((Session)session, "REFRESH MATERIALIZED VIEW " + view))).hasMessageMatching("Catalog only supports writes using autocommit: \\w+");
        }
        this.assertUpdate("DROP MATERIALIZED VIEW " + view);
        this.assertUpdate("DROP MATERIALIZED VIEW " + otherView);
        this.assertQueryReturnsEmptyResult(this.listMaterializedViewsSql("name = '" + view.getObjectName() + "'"));
        this.assertQueryReturnsEmptyResult(this.listMaterializedViewsSql("name = '" + otherView.getObjectName() + "'"));
        this.assertQueryReturnsEmptyResult(this.listMaterializedViewsSql("name = '" + viewWithComment.getObjectName() + "'"));
        this.assertUpdate("DROP SCHEMA " + otherSchema);
    }

    @Test
    public void testMaterializedViewAllTypes() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW));
        String viewName = "test_mv_all_types_" + TestingNames.randomNameSuffix();
        String values = "SELECT\n    true a_boolean,\n    TINYINT '67' a_tinyint,\n    SMALLINT '35' a_smallint,\n    INTEGER '-1546831166' an_integer,\n    1544323431676534245 a_bigint,\n    REAL '12345.67' a_real,\n    DOUBLE '12345.678901234' a_double,\n    CAST('1234567.8901' AS decimal(11, 4)) a_short_decimal,\n    CAST('1234567890123456789.0123456' AS decimal(26, 7)) a_long_decimal,\n    CHAR 'few chars  ' a_char,\n    CAST('some string' AS varchar(33)) a_bounded_varchar,\n    CAST('some longer string' AS varchar) an_unbounded_varchar,\n    X'65683F' a_varbinary,\n    DATE '2005-09-10' a_date,\n    TIME '13:00:00' a_time_seconds,\n    TIME '13:00:00.123' a_time_millis,\n    TIME '13:00:00.123456' a_time_micros,\n    TIME '13:00:00.123456789' a_time_nanos,\n    TIME '13:00:00 +02:00' a_time_tz__seconds,\n    TIME '13:00:00.123 +02:00' a_time_tz__millis,\n    TIME '13:00:00.123456 +02:00' a_time_tz__micros,\n    TIME '13:00:00.123456789 +02:00' a_time_tz__nanos,\n    TIMESTAMP '2005-09-10 13:00:00' a_timestamp_seconds,\n    TIMESTAMP '2005-09-10 13:00:00.123' a_timestamp_millis,\n    TIMESTAMP '2005-09-10 13:00:00.123456' a_timestamp_micros,\n    TIMESTAMP '2005-09-10 13:00:00.123456789' a_timestamp_nanos,\n    TIMESTAMP '2005-09-10 13:00:00 Europe/Warsaw' a_timestamp_tz_seconds,\n    TIMESTAMP '2005-09-10 13:00:00.123 Europe/Warsaw' a_timestamp_tz_millis,\n    TIMESTAMP '2005-09-10 13:00:00.123456 Europe/Warsaw' a_timestamp_tz_micros,\n    TIMESTAMP '2005-09-10 13:00:00.123456789 Europe/Warsaw' a_timestamp_tz_nanos,\n    UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59' a_uuid,\n    ARRAY[TIMESTAMP '2005-09-10 13:00:00.123456789'] an_array_of_timestamp_nanos,\n    map(ARRAY['key'], ARRAY[TIMESTAMP '2005-09-10 13:00:00.123456789']) a_map_with_timestamp_nanos,\n    CAST(ROW(TIMESTAMP '2005-09-10 13:00:00.123456789') AS ROW(key timestamp(9))) a_row_with_timestamp_nanos,\n  'a dummy' a_dummy";
        this.assertUpdate("CREATE MATERIALIZED VIEW %s AS %s".formatted(viewName, values));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("TABLE " + viewName))).matches(values);
        this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("TABLE " + viewName))).matches(values);
        this.assertUpdate("DROP MATERIALIZED VIEW " + viewName);
    }

    @Test
    public void testMaterializedViewGracePeriod() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW));
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        String viewName = "test_mv_grace_period_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW_GRACE_PERIOD)) {
            this.assertQueryFails("CREATE MATERIALIZED VIEW " + viewName + " GRACE PERIOD INTERVAL '1' HOUR AS SELECT * FROM nation", "line 1:1: Catalog '%s' does support not GRACE PERIOD".formatted(catalog));
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_base_table", "AS TABLE region");){
            Session defaultSession = this.getSession();
            Session legacySession = Session.builder((Session)defaultSession).setSystemProperty("legacy_materialized_view_grace_period", "true").build();
            Session futureSession = Session.builder((Session)defaultSession).setSystemProperty("testing_session_time", Instant.now().plus(1L, ChronoUnit.DAYS).toString()).build();
            PlanMatchPattern readFromBaseTables = PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)table.getName())})})})})});
            PlanMatchPattern readFromStorageTable = PlanMatchPattern.node(OutputNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])});
            this.assertUpdate("CREATE MATERIALIZED VIEW " + viewName + " GRACE PERIOD INTERVAL '1' HOUR AS SELECT DISTINCT regionkey, CAST(name AS varchar) name FROM " + table.getName());
            String initialResults = "SELECT DISTINCT regionkey, CAST(name AS varchar) FROM region";
            Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.STALE);
            Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).isEmpty();
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(legacySession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(initialResults);
            ZonedDateTime beforeRefresh = ZonedDateTime.now();
            this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 5L);
            ZonedDateTime afterRefresh = ZonedDateTime.now();
            boolean supportsFresh = this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MATERIALIZED_VIEW_FRESHNESS_FROM_BASE_TABLES);
            if (supportsFresh) {
                Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.FRESH);
                Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).isEmpty();
            } else {
                Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.UNKNOWN);
                ((AbstractZonedDateTimeAssert)Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).get(InstanceOfAssertFactories.ZONED_DATE_TIME)).isBetween(beforeRefresh, afterRefresh);
            }
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(legacySession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(supportsFresh ? readFromStorageTable : readFromBaseTables).matches(initialResults);
            ZonedDateTime beforeModification = ZonedDateTime.now();
            this.assertUpdate("INSERT INTO " + table.getName() + " (regionkey, name) VALUES (42, 'foo new region')", 1L);
            ZonedDateTime afterModification = ZonedDateTime.now();
            String updatedResults = initialResults + " UNION ALL VALUES (42, 'foo new region')";
            Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)(supportsFresh ? MaterializedViewFreshness.Freshness.STALE : MaterializedViewFreshness.Freshness.UNKNOWN));
            ((AbstractZonedDateTimeAssert)Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).get(InstanceOfAssertFactories.ZONED_DATE_TIME)).isBetween(supportsFresh ? beforeModification : beforeRefresh, supportsFresh ? afterModification : afterRefresh);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(legacySession, "TABLE " + viewName))).hasPlan(supportsFresh ? readFromBaseTables : readFromStorageTable).matches((String)(supportsFresh ? updatedResults : initialResults));
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(updatedResults);
            this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 6L);
            if (supportsFresh) {
                Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.FRESH);
                Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).isEmpty();
            } else {
                Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.UNKNOWN);
            }
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(updatedResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(legacySession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(updatedResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(supportsFresh ? readFromStorageTable : readFromBaseTables).matches(updatedResults);
            this.assertUpdate("DROP MATERIALIZED VIEW " + viewName);
        }
    }

    @Test
    public void testFederatedMaterializedView() {
        String viewName = "test_federated_mv_" + TestingNames.randomNameSuffix();
        String mockSchemaForListing = "mock_schema_for_listing_" + TestingNames.randomNameSuffix();
        String query = "SELECT table_name, count(*) AS c FROM mock_dynamic_listing.information_schema.tables WHERE table_schema = '" + mockSchemaForListing + "' GROUP BY table_name";
        String create = "CREATE MATERIALIZED VIEW " + viewName + " AS " + query;
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_FEDERATED_MATERIALIZED_VIEW)) {
            this.assertQueryFails(create, "This connector does not support creating materialized views");
            return;
        }
        Session defaultSession = this.getSession();
        Session legacySession = Session.builder((Session)defaultSession).setSystemProperty("legacy_materialized_view_grace_period", "true").build();
        Session futureSession = Session.builder((Session)defaultSession).setSystemProperty("testing_session_time", Instant.now().plus(1L, ChronoUnit.DAYS).toString()).build();
        PlanMatchPattern readFromBaseTables = PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"tables")})})})})});
        PlanMatchPattern readFromStorageTable = PlanMatchPattern.node(OutputNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])});
        AtomicReference<List<String>> mockListing = new AtomicReference<List<String>>(List.of("first_table"));
        String initialResults = "VALUES (VARCHAR 'first_table', BIGINT '1')";
        this.withMockTableListing(mockSchemaForListing, connectorSession -> List.copyOf((Collection)mockListing.get()), () -> {
            this.assertUpdate(create);
            Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.STALE);
            Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).isEmpty();
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(legacySession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(initialResults);
            ZonedDateTime beforeRefresh = ZonedDateTime.now();
            this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 1L);
            ZonedDateTime afterRefresh = ZonedDateTime.now();
            Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.UNKNOWN);
            ((AbstractZonedDateTimeAssert)Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).get(InstanceOfAssertFactories.ZONED_DATE_TIME)).isBetween(beforeRefresh, afterRefresh);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(legacySession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(initialResults);
            mockListing.set(List.of("first_table", "second_table"));
            String updatedResults = "VALUES (VARCHAR 'first_table', BIGINT '1'), ('second_table', 1)";
            Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.UNKNOWN);
            ((AbstractZonedDateTimeAssert)Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).get(InstanceOfAssertFactories.ZONED_DATE_TIME)).isBetween(beforeRefresh, afterRefresh);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(legacySession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(initialResults);
            ZonedDateTime beforeSecondRefresh = ZonedDateTime.now();
            this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 2L);
            ZonedDateTime afterSecondRefresh = ZonedDateTime.now();
            Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.UNKNOWN);
            ((AbstractZonedDateTimeAssert)Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).get(InstanceOfAssertFactories.ZONED_DATE_TIME)).isBetween(beforeSecondRefresh, afterSecondRefresh);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(updatedResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(legacySession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(updatedResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(updatedResults);
            this.assertUpdate("DROP MATERIALIZED VIEW " + viewName);
        });
    }

    @Test
    public void testFederatedMaterializedViewWithGracePeriod() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_FEDERATED_MATERIALIZED_VIEW));
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW));
        String viewName = "test_federated_mv_grace_period_" + TestingNames.randomNameSuffix();
        String mockSchemaForListing = "mock_schema_for_listing_" + TestingNames.randomNameSuffix();
        String query = "SELECT table_name, count(*) AS c FROM mock_dynamic_listing.information_schema.tables WHERE table_schema = '" + mockSchemaForListing + "' GROUP BY table_name";
        Session defaultSession = this.getSession();
        Session legacySession = Session.builder((Session)defaultSession).setSystemProperty("legacy_materialized_view_grace_period", "true").build();
        Session futureSession = Session.builder((Session)defaultSession).setSystemProperty("testing_session_time", Instant.now().plus(1L, ChronoUnit.DAYS).toString()).build();
        PlanMatchPattern readFromBaseTables = PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(AggregationNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)"tables")})})})})});
        PlanMatchPattern readFromStorageTable = PlanMatchPattern.node(OutputNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])});
        AtomicReference<List<String>> mockListing = new AtomicReference<List<String>>(List.of("first_table"));
        String initialResults = "VALUES (VARCHAR 'first_table', BIGINT '1')";
        this.withMockTableListing(mockSchemaForListing, connectorSession -> List.copyOf((Collection)mockListing.get()), () -> {
            this.assertUpdate("CREATE MATERIALIZED VIEW " + viewName + " GRACE PERIOD INTERVAL '1' HOUR  AS " + query);
            Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.STALE);
            Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).isEmpty();
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(legacySession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(initialResults);
            ZonedDateTime beforeRefresh = ZonedDateTime.now();
            this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 1L);
            ZonedDateTime afterRefresh = ZonedDateTime.now();
            Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.UNKNOWN);
            ((AbstractZonedDateTimeAssert)Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).get(InstanceOfAssertFactories.ZONED_DATE_TIME)).isBetween(beforeRefresh, afterRefresh);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(legacySession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(initialResults);
            mockListing.set(List.of("first_table", "second_table"));
            String updatedResults = "VALUES (VARCHAR 'first_table', BIGINT '1'), ('second_table', 1)";
            Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.UNKNOWN);
            ((AbstractZonedDateTimeAssert)Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).get(InstanceOfAssertFactories.ZONED_DATE_TIME)).isBetween(beforeRefresh, afterRefresh);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(legacySession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(initialResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(updatedResults);
            ZonedDateTime beforeSecondRefresh = ZonedDateTime.now();
            this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 2L);
            ZonedDateTime afterSecondRefresh = ZonedDateTime.now();
            Assertions.assertThat((Comparable)this.getMaterializedViewFreshness(viewName)).isEqualTo((Object)MaterializedViewFreshness.Freshness.UNKNOWN);
            ((AbstractZonedDateTimeAssert)Assertions.assertThat(this.getMaterializedViewLastFreshTime(viewName)).get(InstanceOfAssertFactories.ZONED_DATE_TIME)).isBetween(beforeSecondRefresh, afterSecondRefresh);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(defaultSession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(updatedResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(legacySession, "TABLE " + viewName))).hasPlan(readFromStorageTable).matches(updatedResults);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(futureSession, "TABLE " + viewName))).hasPlan(readFromBaseTables).matches(updatedResults);
            this.assertUpdate("DROP MATERIALIZED VIEW " + viewName);
        });
    }

    @Test(dataProviderClass=DataProviders.class, dataProvider="trueFalse")
    public void testMaterializedViewBaseTableGone(boolean initialized) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW));
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        String schema = (String)this.getSession().getSchema().orElseThrow();
        String viewName = "mv_base_table_missing_" + TestingNames.randomNameSuffix();
        String baseTable = "mv_base_table_missing_the_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + baseTable + " AS SELECT 1 a", 1L);
        this.assertUpdate("CREATE MATERIALIZED VIEW " + viewName + " AS SELECT * FROM " + baseTable);
        if (initialized) {
            this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 1L);
        }
        this.assertUpdate("DROP TABLE " + baseTable);
        this.assertQueryFails("TABLE " + viewName, "line 1:1: Failed analyzing stored view '%1$s\\.%2$s\\.%3$s': line 3:3: Table '%1$s\\.%2$s\\.%4$s' does not exist".formatted(catalog, schema, viewName, baseTable));
        this.assertUpdate("DROP MATERIALIZED VIEW " + viewName);
    }

    private MaterializedViewFreshness.Freshness getMaterializedViewFreshness(String materializedViewName) {
        String freshness = (String)this.computeScalar("SELECT freshness FROM system.metadata.materialized_views WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA AND name = '" + materializedViewName + "'");
        return MaterializedViewFreshness.Freshness.valueOf((String)freshness);
    }

    private Optional<ZonedDateTime> getMaterializedViewLastFreshTime(String materializedViewName) {
        ZonedDateTime lastFreshTime = (ZonedDateTime)this.computeScalar("SELECT last_fresh_time FROM system.metadata.materialized_views WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA AND name = '" + materializedViewName + "'");
        return Optional.ofNullable(lastFreshTime);
    }

    @Test
    public void testCompatibleTypeChangeForView() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW));
        String tableName = "test_table_" + TestingNames.randomNameSuffix();
        String viewName = "test_view_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 'abcdefg' a", 1L);
        this.assertUpdate("CREATE VIEW " + viewName + " AS SELECT a FROM " + tableName);
        this.assertQuery("SELECT * FROM " + viewName, "VALUES 'abcdefg'");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 'abc' a", 1L);
        this.assertQuery("SELECT * FROM " + viewName, "VALUES 'abc'");
        this.assertUpdate("DROP VIEW " + viewName);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCompatibleTypeChangeForView2() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW));
        String tableName = "test_table_" + TestingNames.randomNameSuffix();
        String viewName = "test_view_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT BIGINT '1' v", 1L);
        this.assertUpdate("CREATE VIEW " + viewName + " AS SELECT * FROM " + tableName);
        this.assertQuery("SELECT * FROM " + viewName, "VALUES 1");
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT INTEGER '1' v", 1L);
        this.assertQuery("SELECT * FROM " + viewName + " WHERE v = 1", "VALUES 1");
        this.assertUpdate("DROP VIEW " + viewName);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test(dataProvider="testViewMetadataDataProvider")
    public void testViewMetadata(String securityClauseInCreate, String securityClauseInShowCreate) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW));
        String viewName = "meta_test_view_" + TestingNames.randomNameSuffix();
        String query = "SELECT BIGINT '123' x, 'foo' y";
        this.assertUpdate("CREATE VIEW " + viewName + securityClauseInCreate + " AS " + query);
        MaterializedResult actual = this.computeActual(String.format("SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = '%s'", this.getSession().getSchema().get()));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"customer", "BASE TABLE"}).row(new Object[]{viewName, "VIEW"}).row(new Object[]{"nation", "BASE TABLE"}).row(new Object[]{"orders", "BASE TABLE"}).row(new Object[]{"region", "BASE TABLE"}).build();
        QueryAssertions.assertContains(actual, expected);
        actual = this.computeActual("SHOW TABLES");
        MaterializedResult.Builder builder = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes());
        for (MaterializedRow row : expected.getMaterializedRows()) {
            builder.row(new Object[]{row.getField(0)});
        }
        expected = builder.build();
        QueryAssertions.assertContains(actual, expected);
        actual = this.computeActual(String.format("SELECT table_name, view_definition FROM information_schema.views WHERE table_schema = '%s'", this.getSession().getSchema().get()));
        expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{viewName, this.formatSqlText(query)}).build();
        QueryAssertions.assertContains(actual, expected);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW COLUMNS FROM " + viewName))).matches(MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"x", "bigint", "", ""}).row(new Object[]{"y", "varchar(3)", "", ""}).build());
        String expectedSql = this.formatSqlText(String.format("CREATE VIEW %s.%s.%s SECURITY %s AS %s", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), viewName, securityClauseInShowCreate, query)).trim();
        actual = this.computeActual("SHOW CREATE VIEW " + viewName);
        org.testng.Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)actual.getOnlyColumnAsSet()), (Object)expectedSql);
        actual = this.computeActual(String.format("SHOW CREATE VIEW %s.%s.%s", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), viewName));
        org.testng.Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)actual.getOnlyColumnAsSet()), (Object)expectedSql);
        this.assertUpdate("DROP VIEW " + viewName);
    }

    @DataProvider
    public static Object[][] testViewMetadataDataProvider() {
        return new Object[][]{{"", "DEFINER"}, {" SECURITY DEFINER", "DEFINER"}, {" SECURITY INVOKER", "INVOKER"}};
    }

    @Test
    public void testShowCreateView() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW));
        Preconditions.checkState((boolean)this.getSession().getCatalog().isPresent(), (Object)"catalog is not set");
        Preconditions.checkState((boolean)this.getSession().getSchema().isPresent(), (Object)"schema is not set");
        String viewName = "test_show_create_view" + TestingNames.randomNameSuffix();
        this.assertUpdate("DROP VIEW IF EXISTS " + viewName);
        String ddl = String.format("CREATE VIEW %s.%s.%s SECURITY DEFINER AS\nSELECT *\nFROM\n  (\n VALUES \n     ROW (1, 'one')\n   , ROW (2, 't')\n)  t (col1, col2)", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), viewName);
        this.assertUpdate(ddl);
        org.testng.Assert.assertEquals((Object)this.computeScalar("SHOW CREATE VIEW " + viewName), (Object)ddl);
        this.assertUpdate("DROP VIEW " + viewName);
    }

    @Test
    public void testRenameMaterializedView() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW));
        String schema = "rename_mv_test_" + TestingNames.randomNameSuffix();
        Session session = Session.builder((Session)this.getSession()).setSchema(schema).build();
        this.assertUpdate(this.createSchemaSql(schema));
        QualifiedObjectName originalMaterializedView = new QualifiedObjectName((String)session.getCatalog().orElseThrow(), (String)session.getSchema().orElseThrow(), "test_materialized_view_rename_" + TestingNames.randomNameSuffix());
        this.createTestingMaterializedView(originalMaterializedView, Optional.empty());
        String renamedMaterializedView = "test_materialized_view_rename_new_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_MATERIALIZED_VIEW)) {
            this.assertQueryFails(session, "ALTER MATERIALIZED VIEW " + originalMaterializedView + " RENAME TO " + renamedMaterializedView, "This connector does not support renaming materialized views");
            this.assertUpdate(session, "DROP MATERIALIZED VIEW " + originalMaterializedView);
            return;
        }
        this.assertUpdate(session, "ALTER MATERIALIZED VIEW " + originalMaterializedView + " RENAME TO " + renamedMaterializedView);
        this.assertTestingMaterializedViewQuery(schema, renamedMaterializedView);
        this.assertQuery(session, "SELECT catalog_name, schema_name FROM system.metadata.materialized_views WHERE name = '" + renamedMaterializedView + "'", String.format("VALUES ('%s', '%s')", originalMaterializedView.getCatalogName(), originalMaterializedView.getSchemaName()));
        this.assertQueryReturnsEmptyResult(session, this.listMaterializedViewsSql("name = '" + originalMaterializedView.getObjectName() + "'"));
        String testExistsMaterializedViewName = "test_materialized_view_rename_exists_" + TestingNames.randomNameSuffix();
        this.assertUpdate(session, "ALTER MATERIALIZED VIEW IF EXISTS " + renamedMaterializedView + " RENAME TO " + testExistsMaterializedViewName);
        this.assertTestingMaterializedViewQuery(schema, testExistsMaterializedViewName);
        String uppercaseName = "TEST_MATERIALIZED_VIEW_RENAME_UPPERCASE_" + TestingNames.randomNameSuffix();
        this.assertUpdate(session, "ALTER MATERIALIZED VIEW " + testExistsMaterializedViewName + " RENAME TO " + uppercaseName);
        this.assertTestingMaterializedViewQuery(schema, uppercaseName.toLowerCase(Locale.ENGLISH));
        String otherSchema = "rename_mv_other_schema_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createSchemaSql(otherSchema));
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_MATERIALIZED_VIEW_ACROSS_SCHEMAS)) {
            this.assertUpdate(session, "ALTER MATERIALIZED VIEW " + uppercaseName + " RENAME TO " + otherSchema + "." + originalMaterializedView.getObjectName());
            this.assertTestingMaterializedViewQuery(otherSchema, originalMaterializedView.getObjectName());
            this.assertUpdate(session, "DROP MATERIALIZED VIEW " + otherSchema + "." + originalMaterializedView.getObjectName());
        } else {
            this.assertQueryFails(session, "ALTER MATERIALIZED VIEW " + uppercaseName + " RENAME TO " + otherSchema + "." + originalMaterializedView.getObjectName(), "Materialized View rename across schemas is not supported");
            this.assertUpdate(session, "DROP MATERIALIZED VIEW " + uppercaseName);
        }
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, originalMaterializedView.toString()));
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, renamedMaterializedView));
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, testExistsMaterializedViewName));
        this.assertUpdate(session, "ALTER TABLE IF EXISTS " + originalMaterializedView + " RENAME TO " + renamedMaterializedView);
        this.assertQueryReturnsEmptyResult(session, this.listMaterializedViewsSql("name = '" + originalMaterializedView.getObjectName() + "'"));
        this.assertQueryReturnsEmptyResult(session, this.listMaterializedViewsSql("name = '" + renamedMaterializedView + "'"));
    }

    private void assertTestingMaterializedViewQuery(String schema, String materializedViewName) {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + schema + "." + materializedViewName))).skippingTypesCheck().matches("SELECT * FROM nation");
    }

    private void createTestingMaterializedView(QualifiedObjectName view, Optional<String> comment) {
        this.assertUpdate(String.format("CREATE MATERIALIZED VIEW %s %s AS SELECT * FROM nation", view, comment.map(c -> String.format("COMMENT '%s'", c)).orElse("")));
    }

    private String getTestingMaterializedViewsResultRow(QualifiedObjectName materializedView, String comment) {
        return String.format("VALUES ('%s', '%s', '%s', '%s', 'SELECT *\nFROM\n  nation\n')", materializedView.getCatalogName(), materializedView.getSchemaName(), materializedView.getObjectName(), comment);
    }

    private String getTestingMaterializedViewsResultRows(QualifiedObjectName materializedView, QualifiedObjectName otherMaterializedView) {
        String viewDefinitionSql = "SELECT *\nFROM\n  nation\n";
        return String.format("VALUES ('%s', '%s', '%s', '', '%s'),('%s', '%s', '%s', 'sarcastic comment', '%s')", materializedView.getCatalogName(), materializedView.getSchemaName(), materializedView.getObjectName(), viewDefinitionSql, otherMaterializedView.getCatalogName(), otherMaterializedView.getSchemaName(), otherMaterializedView.getObjectName(), viewDefinitionSql);
    }

    private String listMaterializedViewsSql(String ... filterClauses) {
        StringBuilder sql = new StringBuilder("SELECT   catalog_name,   schema_name,   name,   comment,   definition FROM system.metadata.materialized_views WHERE true");
        for (String filterClause : filterClauses) {
            sql.append(" AND ").append(filterClause);
        }
        return sql.toString();
    }

    @Test
    public void testViewAndMaterializedViewTogether() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW) || !this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW)) {
            return;
        }
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        String regularViewName = "test_views_together_normal_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE VIEW " + regularViewName + " AS SELECT * FROM region");
        String materializedViewName = "test_views_together_materialized_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE MATERIALIZED VIEW " + materializedViewName + " AS SELECT * FROM nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name FROM information_schema.views WHERE table_schema = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES '" + regularViewName + "'");
        this.checkInformationSchemaViewsForMaterializedView(schemaName, materializedViewName);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + regularViewName))).containsAll("SELECT * FROM region");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + materializedViewName))).containsAll("SELECT * FROM nation");
        this.assertUpdate("DROP VIEW " + regularViewName);
        this.assertUpdate("DROP MATERIALIZED VIEW " + materializedViewName);
    }

    protected void checkInformationSchemaViewsForMaterializedView(String schemaName, String viewName) {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name FROM information_schema.views WHERE table_schema = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES '" + viewName + "'");
    }

    @Test(timeOut=180000L)
    public void testReadMetadataWithRelationsConcurrentModifications() throws Exception {
        if (!(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) || this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW) || this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW))) {
            throw new SkipException("Cannot test");
        }
        int readIterations = 5;
        int testTimeoutSeconds = 150;
        this.testReadMetadataWithRelationsConcurrentModifications(readIterations, testTimeoutSeconds);
    }

    protected void testReadMetadataWithRelationsConcurrentModifications(int readIterations, int testTimeoutSeconds) throws Exception {
        Stopwatch testWatch = Stopwatch.createStarted();
        int readerTasksCount = 6 + (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW) ? 1 : 0) + (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW) ? 1 : 0);
        AtomicInteger incompleteReadTasks = new AtomicInteger(readerTasksCount);
        ArrayList readerTasks = new ArrayList();
        readerTasks.add(this.queryRepeatedly(readIterations, incompleteReadTasks, "SHOW TABLES"));
        readerTasks.add(this.queryRepeatedly(readIterations, incompleteReadTasks, "SELECT * FROM information_schema.tables WHERE table_schema = CURRENT_SCHEMA"));
        readerTasks.add(this.queryRepeatedly(readIterations, incompleteReadTasks, "SELECT * FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA"));
        readerTasks.add(this.queryRepeatedly(readIterations, incompleteReadTasks, "SELECT * FROM system.jdbc.tables WHERE table_cat = CURRENT_CATALOG AND table_schem = CURRENT_SCHEMA"));
        readerTasks.add(this.queryRepeatedly(readIterations, incompleteReadTasks, "SELECT * FROM system.jdbc.columns WHERE table_cat = CURRENT_CATALOG AND table_schem = CURRENT_SCHEMA"));
        readerTasks.add(this.queryRepeatedly(readIterations, incompleteReadTasks, "SELECT * FROM system.metadata.table_comments WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA"));
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW)) {
            readerTasks.add(this.queryRepeatedly(readIterations, incompleteReadTasks, "SELECT * FROM information_schema.views WHERE table_schema = CURRENT_SCHEMA"));
        }
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW)) {
            readerTasks.add(this.queryRepeatedly(readIterations, incompleteReadTasks, "SELECT * FROM system.metadata.materialized_views WHERE catalog_name = CURRENT_CATALOG AND schema_name = CURRENT_SCHEMA"));
        }
        org.testng.Assert.assertEquals((int)readerTasks.size(), (int)readerTasksCount);
        int writeTasksCount = 1 + (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW) ? 1 : 0) + (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW) ? 1 : 0);
        writeTasksCount = 2 * writeTasksCount;
        CountDownLatch writeTasksInitialized = new CountDownLatch(writeTasksCount);
        Runnable writeInitialized = writeTasksInitialized::countDown;
        AtomicBoolean aborted = new AtomicBoolean();
        Supplier<Boolean> done = () -> aborted.get() || incompleteReadTasks.get() == 0;
        ArrayList writeTasks = new ArrayList();
        writeTasks.add(this.createDropRepeatedly(writeInitialized, done, "concur_table", this.createTableSqlTemplateForConcurrentModifications(), "DROP TABLE %s"));
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW)) {
            writeTasks.add(this.createDropRepeatedly(writeInitialized, done, "concur_view", "CREATE VIEW %s AS SELECT 1 a", "DROP VIEW %s"));
        }
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW)) {
            writeTasks.add(this.createDropRepeatedly(writeInitialized, done, "concur_mview", "CREATE MATERIALIZED VIEW %s AS SELECT 1 a", "DROP MATERIALIZED VIEW %s"));
        }
        org.testng.Assert.assertEquals((int)(writeTasks.size() * 2), (int)writeTasksCount);
        ExecutorService executor = Executors.newFixedThreadPool(readerTasksCount + writeTasksCount);
        try {
            ExecutorCompletionService completionService = new ExecutorCompletionService(executor);
            this.submitTasks(writeTasks, completionService);
            this.submitTasks(writeTasks, completionService);
            if (!writeTasksInitialized.await(testTimeoutSeconds, TimeUnit.SECONDS)) {
                Future someFailure = completionService.poll();
                if (someFailure != null) {
                    someFailure.get();
                }
                org.testng.Assert.fail((String)"Setup failed");
            }
            this.submitTasks(readerTasks, completionService);
            for (int i = 0; i < readerTasksCount + writeTasksCount; ++i) {
                long remainingTimeSeconds = (long)testTimeoutSeconds - testWatch.elapsed(TimeUnit.SECONDS);
                Future future = completionService.poll(remainingTimeSeconds, TimeUnit.SECONDS);
                Verify.verifyNotNull(future, (String)"Task did not completed before timeout; completed tasks: %s, current poll timeout: %s s", (Object[])new Object[]{i, remainingTimeSeconds});
                future.get();
            }
        }
        catch (Throwable failure) {
            aborted.set(true);
            executor.shutdownNow();
            if (!executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                throw new AssertionError("Test threads did not complete. Leaving test threads behind may violate AbstractTestQueryFramework.checkQueryInfosFinal", failure);
            }
            throw failure;
        }
        finally {
            executor.shutdownNow();
        }
        org.testng.Assert.assertTrue((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS));
    }

    @Language(value="SQL")
    protected String createTableSqlTemplateForConcurrentModifications() {
        return "CREATE TABLE %s(a integer)";
    }

    protected Callable<Void> queryRepeatedly(final int minIterations, final AtomicInteger incompleteReadTasks, final @Language(value="SQL") String sql) {
        return new Callable<Void>(){

            @Override
            public Void call() {
                boolean alwaysEmpty = true;
                for (int i = 0; i < minIterations; ++i) {
                    MaterializedResult result = BaseConnectorTest.this.computeActual(sql);
                    alwaysEmpty &= result.getRowCount() == 0;
                }
                if (alwaysEmpty) {
                    org.testng.Assert.fail((String)String.format("The results of [%s] are always empty after %s iterations, this may indicate test misconfiguration or broken connector behavior", sql, minIterations));
                }
                ((AbstractIntegerAssert)Assertions.assertThat((int)incompleteReadTasks.decrementAndGet()).as("incompleteReadTasks", new Object[0])).isGreaterThanOrEqualTo(0);
                while (incompleteReadTasks.get() != 0) {
                    BaseConnectorTest.this.computeActual(sql);
                }
                return null;
            }

            public String toString() {
                return String.format("Query(%s)", sql);
            }
        };
    }

    protected Callable<Void> createDropRepeatedly(final Runnable initReady, final Supplier<Boolean> done, final String namePrefix, final String createTemplate, final String dropTemplate) {
        return new Callable<Void>(){

            @Override
            public Void call() {
                int objectsToKeep = 3;
                ArrayDeque<CallSite> liveObjects = new ArrayDeque<CallSite>(objectsToKeep);
                for (int i = 0; i < objectsToKeep; ++i) {
                    String name = namePrefix + "_" + TestingNames.randomNameSuffix();
                    BaseConnectorTest.this.assertUpdate(String.format(createTemplate, name));
                    liveObjects.addLast((CallSite)((Object)name));
                }
                initReady.run();
                while (!((Boolean)done.get()).booleanValue()) {
                    BaseConnectorTest.this.assertUpdate(String.format(dropTemplate, liveObjects.removeFirst()));
                    String name = namePrefix + "_" + TestingNames.randomNameSuffix();
                    BaseConnectorTest.this.assertUpdate(String.format(createTemplate, name));
                    liveObjects.addLast((CallSite)((Object)name));
                }
                while (!liveObjects.isEmpty()) {
                    BaseConnectorTest.this.assertUpdate(String.format(dropTemplate, liveObjects.removeFirst()));
                }
                return null;
            }

            public String toString() {
                return String.format("Repeat (%s) and (%s)", createTemplate, dropTemplate);
            }
        };
    }

    protected <T> void submitTasks(List<Callable<T>> callables, CompletionService<T> completionService) {
        for (final Callable<T> callable : callables) {
            final String taskDescription = callable.toString();
            completionService.submit(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    try {
                        return callable.call();
                    }
                    catch (Throwable e) {
                        e.addSuppressed(new Exception("Task: " + taskDescription));
                        throw e;
                    }
                }
            });
        }
    }

    @Test
    public void testExplainAnalyze() {
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT * FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT count(*), clerk FROM orders GROUP BY clerk", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT x + y FROM (   SELECT orderdate, COUNT(*) x FROM orders GROUP BY orderdate) a JOIN (   SELECT orderdate, COUNT(*) y FROM orders GROUP BY orderdate) b ON a.orderdate = b.orderdate", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT count(*), clerk FROM orders GROUP BY clerk UNION ALL SELECT sum(orderkey), clerk FROM orders GROUP BY clerk", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW COLUMNS FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE EXPLAIN SELECT count(*) FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE EXPLAIN ANALYZE SELECT count(*) FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW FUNCTIONS", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW TABLES", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW SCHEMAS", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW CATALOGS", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE SHOW SESSION", new String[0]);
    }

    @Test
    public void testExplainAnalyzeVerbose() {
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT * FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT rank() OVER (PARTITION BY orderkey ORDER BY clerk DESC) FROM orders", new String[0]);
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT rank() OVER (PARTITION BY orderkey ORDER BY clerk DESC) FROM orders WHERE orderkey < 0", new String[0]);
    }

    @Test
    public void testTableSampleSystem() {
        MaterializedResult fullSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (100)");
        MaterializedResult emptySample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (0)");
        MaterializedResult randomSample = this.computeActual("SELECT orderkey FROM orders TABLESAMPLE SYSTEM (50)");
        MaterializedResult all = this.computeActual("SELECT orderkey FROM orders");
        QueryAssertions.assertContains(all, fullSample);
        org.testng.Assert.assertEquals((int)emptySample.getMaterializedRows().size(), (int)0);
        org.testng.Assert.assertTrue((all.getMaterializedRows().size() >= randomSample.getMaterializedRows().size() ? 1 : 0) != 0);
    }

    @Test
    public void testTableSampleWithFiltering() {
        MaterializedResult emptySample = this.computeActual("SELECT DISTINCT orderkey, orderdate FROM orders TABLESAMPLE SYSTEM (99) WHERE orderkey BETWEEN 0 AND 0");
        MaterializedResult halfSample = this.computeActual("SELECT DISTINCT orderkey, orderdate FROM orders TABLESAMPLE SYSTEM (50) WHERE orderkey BETWEEN 0 AND 9999999999");
        MaterializedResult all = this.computeActual("SELECT orderkey, orderdate FROM orders");
        org.testng.Assert.assertEquals((int)emptySample.getMaterializedRows().size(), (int)0);
        org.testng.Assert.assertTrue((all.getMaterializedRows().size() >= halfSample.getMaterializedRows().size() ? 1 : 0) != 0);
    }

    @Test
    public void testShowCreateTable() {
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        String schema = (String)this.getSession().getSchema().orElseThrow();
        Assertions.assertThat((Object)this.computeScalar("SHOW CREATE TABLE orders")).isEqualTo((Object)String.format("CREATE TABLE %s.%s.orders (\n   orderkey bigint,\n   custkey bigint,\n   orderstatus varchar(1),\n   totalprice double,\n   orderdate date,\n   orderpriority varchar(15),\n   clerk varchar(15),\n   shippriority integer,\n   comment varchar(79)\n)", catalog, schema));
    }

    @Test
    public void testSelectInformationSchemaTables() {
        String catalog = (String)this.getSession().getCatalog().get();
        String schema = (String)this.getSession().getSchema().get();
        String schemaPattern = schema.replaceAll("^.", "_");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema = '" + schema + "' AND table_name = 'orders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema LIKE '" + schema + "' AND table_name LIKE '%rders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema LIKE '" + schemaPattern + "' AND table_name LIKE '%rders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_catalog = '" + catalog + "' AND table_schema LIKE '" + schema + "' AND table_name LIKE '%orders'", "VALUES 'orders'");
        this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_catalog = 'something_else'", "SELECT '' WHERE false");
        this.assertQuery("SELECT DISTINCT table_name FROM information_schema.tables WHERE table_schema = 'information_schema' OR rand() = 42 ORDER BY 1", "VALUES ('applicable_roles'), ('columns'), ('enabled_roles'), ('roles'), ('schemata'), ('table_privileges'), ('tables'), ('views')");
    }

    @Test
    public void testSelectInformationSchemaColumns() {
        String catalog = (String)this.getSession().getCatalog().get();
        String schema = (String)this.getSession().getSchema().get();
        String schemaPattern = schema.replaceAll(".$", "_");
        String ordersTableWithColumns = "VALUES ('orders', 'orderkey'), ('orders', 'custkey'), ('orders', 'orderstatus'), ('orders', 'totalprice'), ('orders', 'orderdate'), ('orders', 'orderpriority'), ('orders', 'clerk'), ('orders', 'shippriority'), ('orders', 'comment')";
        this.assertQuery("SELECT table_schema FROM information_schema.columns WHERE table_schema = '" + schema + "' GROUP BY table_schema", "VALUES '" + schema + "'");
        this.assertQuery("SELECT table_name FROM information_schema.columns WHERE table_name = 'orders' GROUP BY table_name", "VALUES 'orders'");
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schema + "' AND table_name = 'orders'", ordersTableWithColumns);
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = '" + schema + "' AND table_name LIKE '%rders'", ordersTableWithColumns);
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema LIKE '" + schemaPattern + "' AND table_name LIKE '_rder_'", ordersTableWithColumns);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, column_name FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_schema = '" + schema + "' AND table_name LIKE '%orders%'"))).skippingTypesCheck().containsAll(ordersTableWithColumns);
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns");
        this.assertQuery("SELECT DISTINCT table_name, column_name FROM information_schema.columns WHERE table_name LIKE '_rders'", ordersTableWithColumns);
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns WHERE table_catalog = '" + catalog + "'");
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_schema = '" + schema + "'");
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_schema = '" + schema + "' AND table_name LIKE '_rders'", ordersTableWithColumns);
        this.assertQuerySucceeds("SELECT * FROM information_schema.columns WHERE table_catalog = '" + catalog + "' AND table_name LIKE '%'");
        this.assertQuery("SELECT column_name FROM information_schema.columns WHERE table_catalog = 'something_else'", "SELECT '' WHERE false");
        this.assertQuery("SELECT DISTINCT table_name FROM information_schema.columns WHERE table_schema = 'information_schema' OR rand() = 42 ORDER BY 1", "VALUES ('applicable_roles'), ('columns'), ('enabled_roles'), ('roles'), ('schemata'), ('table_privileges'), ('tables'), ('views')");
    }

    @Test
    public void testShowCreateInformationSchema() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SHOW CREATE SCHEMA information_schema"))).skippingTypesCheck().matches(String.format("VALUES 'CREATE SCHEMA %s.information_schema'", this.getSession().getCatalog().orElseThrow()));
    }

    @Test
    public void testShowCreateInformationSchemaTable() {
        this.assertQueryFails("SHOW CREATE VIEW information_schema.schemata", "line 1:1: Relation '\\w+.information_schema.schemata' is a table, not a view");
        this.assertQueryFails("SHOW CREATE MATERIALIZED VIEW information_schema.schemata", "line 1:1: Relation '\\w+.information_schema.schemata' is a table, not a materialized view");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE information_schema.schemata"))).isEqualTo("CREATE TABLE " + (String)this.getSession().getCatalog().orElseThrow() + ".information_schema.schemata (\n   catalog_name varchar,\n   schema_name varchar\n)");
    }

    @Test
    public void testRollback() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MULTI_STATEMENT_WRITES));
        String table = "test_rollback_" + TestingNames.randomNameSuffix();
        this.computeActual(String.format("CREATE TABLE %s (x int)", table));
        Assertions.assertThatThrownBy(() -> this.inTransaction(session -> {
            this.assertUpdate((Session)session, String.format("INSERT INTO %s VALUES (42)", table), 1L);
            throw new RollbackException();
        })).isInstanceOf(RollbackException.class);
        this.assertQuery(String.format("SELECT count(*) FROM %s", table), "SELECT 0");
    }

    @Test
    public void testWriteNotAllowedInTransaction() {
        BaseConnectorTest.skipTestUnless(!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MULTI_STATEMENT_WRITES));
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA, "CREATE SCHEMA write_not_allowed");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE, "CREATE TABLE write_not_allowed (x int)");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE, "DROP TABLE region");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA, "CREATE TABLE write_not_allowed AS SELECT * FROM region");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW, "CREATE VIEW write_not_allowed AS SELECT * FROM region");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW, "CREATE MATERIALIZED VIEW write_not_allowed AS SELECT * FROM region");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE, "ALTER TABLE region RENAME TO region_name");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_INSERT, "INSERT INTO region (regionkey) VALUES (123)");
        this.assertWriteNotAllowedInTransaction(TestingConnectorBehavior.SUPPORTS_DELETE, "DELETE FROM region WHERE regionkey = 123");
    }

    protected void assertWriteNotAllowedInTransaction(TestingConnectorBehavior behavior, @Language(value="SQL") String sql) {
        if (this.hasBehavior(behavior)) {
            Assertions.assertThatThrownBy(() -> this.inTransaction(session -> this.computeActual((Session)session, sql))).hasMessageMatching("Catalog only supports writes using autocommit: \\w+");
        }
    }

    @Test
    public void testRenameSchema() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_SCHEMA)) {
            String schemaName = (String)this.getSession().getSchema().orElseThrow();
            this.assertQueryFails(String.format("ALTER SCHEMA %s RENAME TO %s", schemaName, schemaName + TestingNames.randomNameSuffix()), "This connector does not support renaming schemas");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            throw new SkipException("Skipping as connector does not support CREATE SCHEMA");
        }
        String schemaName = "test_rename_schema_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate(this.createSchemaSql(schemaName));
            this.assertUpdate("ALTER SCHEMA " + schemaName + " RENAME TO " + schemaName + "_renamed");
            Assertions.assertThat((Collection)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).contains(new Object[]{schemaName + "_renamed"});
        }
        finally {
            this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName);
            this.assertUpdate("DROP SCHEMA IF EXISTS " + schemaName + "_renamed");
        }
    }

    @Test
    public void testAddColumn() {
        String tableName;
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN)) {
            this.assertQueryFails("ALTER TABLE nation ADD COLUMN test_add_column bigint", "This connector does not support adding columns");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_add_column_", this.tableDefinitionForAddColumn());){
            tableName = table.getName();
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'first'", 1L);
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN x bigint", ".* Column 'x' already exists");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN X bigint", ".* Column 'X' already exists");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN q bad_type", ".* Unknown type 'bad_type' for column 'q'");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN a varchar(50)");
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES ('first', NULL)");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'second', 'xxx'", 1L);
            this.assertQuery("SELECT x, a FROM " + table.getName(), "VALUES ('first', NULL), ('second', 'xxx')");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN b double");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'third', 'yyy', 33.3E0", 1L);
            this.assertQuery("SELECT x, a, b FROM " + table.getName(), "VALUES ('first', NULL, NULL), ('second', 'xxx', NULL), ('third', 'yyy', 33.3)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN IF NOT EXISTS c varchar(50)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN IF NOT EXISTS c varchar(50)");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'fourth', 'zzz', 55.3E0, 'newColumn'", 1L);
            this.assertQuery("SELECT x, a, b, c FROM " + table.getName(), "VALUES ('first', NULL, NULL, NULL), ('second', 'xxx', NULL, NULL), ('third', 'yyy', 33.3, NULL), ('fourth', 'zzz', 55.3, 'newColumn')");
        }
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " ADD COLUMN x bigint");
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " ADD COLUMN IF NOT EXISTS x bigint");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    protected String tableDefinitionForAddColumn() {
        return "(x VARCHAR)";
    }

    @Test
    public void testAddColumnWithComment() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN)) {
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN_WITH_COMMENT)) {
            this.assertQueryFails("ALTER TABLE nation ADD COLUMN test_add_col_desc bigint COMMENT 'test column comment'", "This connector does not support adding columns with comments");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_add_col_desc_", "(a_varchar varchar)");){
            String tableName = table.getName();
            this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN b_varchar varchar COMMENT 'test new column comment'");
            Assertions.assertThat((String)this.getColumnComment(tableName, "b_varchar")).isEqualTo("test new column comment");
            this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN empty_comment varchar COMMENT ''");
            org.testng.Assert.assertEquals((String)this.getColumnComment(tableName, "empty_comment"), (String)"");
        }
    }

    @Test
    public void testAddNotNullColumnToEmptyTable() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_add_nn_to_empty", "(a_varchar varchar)");){
            String tableName = table.getName();
            String addNonNullColumn = "ALTER TABLE " + tableName + " ADD COLUMN b_varchar varchar NOT NULL";
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN_NOT_NULL_CONSTRAINT)) {
                this.assertQueryFails(addNonNullColumn, this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NOT_NULL_CONSTRAINT) ? "This connector does not support adding not null columns" : ".* Catalog '.*' does not support NOT NULL for column '.*'");
                return;
            }
            this.assertUpdate(addNonNullColumn);
            org.testng.Assert.assertFalse((boolean)this.columnIsNullable(tableName, "b_varchar"));
            this.assertUpdate("INSERT INTO " + tableName + " VALUES ('a', 'b')", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("TABLE " + tableName))).skippingTypesCheck().matches("VALUES ('a', 'b')");
        }
    }

    @Test
    public void testAddNotNullColumn() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN_NOT_NULL_CONSTRAINT));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_add_nn_col", "(a_varchar varchar)");){
            String tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES ('a')", 1L);
            boolean success = false;
            try {
                this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN b_varchar varchar NOT NULL");
                success = true;
            }
            catch (Throwable e) {
                this.verifyAddNotNullColumnToNonEmptyTableFailurePermissible(e);
            }
            if (success) {
                throw new AssertionError((Object)"Should fail to add not null column without a default value to a non-empty table");
            }
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("TABLE " + tableName))).skippingTypesCheck().matches("VALUES 'a'");
        }
    }

    protected boolean columnIsNullable(String tableName, String columnName) {
        String isNullable = (String)this.computeScalar("SELECT is_nullable FROM information_schema.columns WHERE table_schema = '" + (String)this.getSession().getSchema().orElseThrow() + "' AND table_name = '" + tableName + "' AND column_name = '" + columnName + "'");
        return switch (Objects.requireNonNull(isNullable, "isNullable is null")) {
            case "YES" -> true;
            case "NO" -> false;
            default -> throw new IllegalStateException("Unrecognized is_nullable value: " + isNullable);
        };
    }

    protected void verifyAddNotNullColumnToNonEmptyTableFailurePermissible(Throwable e) {
        throw new AssertionError("Unexpected failure when adding not null column", e);
    }

    @Test
    public void testDropColumn() {
        String tableName;
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_COLUMN)) {
            this.assertQueryFails("ALTER TABLE nation DROP COLUMN nationkey", "This connector does not support dropping columns");
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_column_", "AS SELECT 123 x, 456 y, 111 a");){
            tableName = table.getName();
            this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN x");
            this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN IF EXISTS y");
            this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN IF EXISTS notExistColumn");
            this.assertQueryFails("SELECT x FROM " + tableName, ".* Column 'x' cannot be resolved");
            this.assertQueryFails("SELECT y FROM " + tableName, ".* Column 'y' cannot be resolved");
            this.assertQueryFails("ALTER TABLE " + tableName + " DROP COLUMN a", ".* Cannot drop the only column in a table");
        }
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " DROP COLUMN notExistColumn");
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " DROP COLUMN IF EXISTS notExistColumn");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testDropRowField() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_FIELD)) {
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_COLUMN) || !this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_TYPE)) {
                return;
            }
            try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_field_", "AS SELECT CAST(row(1, 2) AS row(x integer, y integer)) AS col");){
                this.assertQueryFails("ALTER TABLE " + table.getName() + " DROP COLUMN col.x", "This connector does not support dropping fields");
            }
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_field_", "AS SELECT CAST(row(1, 2, row(10, 20)) AS row(a integer, b integer, c row(x integer, y integer))) AS col");){
            org.testng.Assert.assertEquals((String)this.getColumnType(table.getName(), "col"), (String)"row(a integer, b integer, c row(x integer, y integer))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.b");
            org.testng.Assert.assertEquals((String)this.getColumnType(table.getName(), "col"), (String)"row(a integer, c row(x integer, y integer))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(row(1, row(10, 20)) AS row(a integer, c row(x integer, y integer)))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.c.y");
            org.testng.Assert.assertEquals((String)this.getColumnType(table.getName(), "col"), (String)"row(a integer, c row(x integer))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(row(1, row(10)) AS row(a integer, c row(x integer)))");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " DROP COLUMN col.c.x", ".* Cannot drop the only field in a row type");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " DROP COLUMN col.c.non_existing", "\\Qline 1:1: Cannot resolve field 'non_existing' within row(x integer) type when dropping [c, non_existing] in row(a integer, c row(x integer))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.c");
            org.testng.Assert.assertEquals((String)this.getColumnType(table.getName(), "col"), (String)"row(a integer)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(row(1) AS row(a integer))");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN IF EXISTS non_existing.a");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN IF EXISTS col.non_existing");
            org.testng.Assert.assertEquals((String)this.getColumnType(table.getName(), "col"), (String)"row(a integer)");
        }
    }

    @Test
    public void testDropRowFieldWhenDuplicates() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_FIELD));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_duplicated_field_", "AS SELECT CAST(row(1, 2, 3) AS row(a integer, a integer, b integer)) AS col");){
            org.testng.Assert.assertEquals((String)this.getColumnType(table.getName(), "col"), (String)"row(a integer, a integer, b integer)");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " DROP COLUMN col.a", "\\QField path [a] within row(a integer, a integer, b integer) is ambiguous");
            org.testng.Assert.assertEquals((String)this.getColumnType(table.getName(), "col"), (String)"row(a integer, a integer, b integer)");
        }
    }

    @Test
    public void testDropRowFieldCaseSensitivity() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_FIELD));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_row_field_case_sensitivity_", "AS SELECT CAST(row(1, 2) AS row(lower integer, \"UPPER\" integer)) AS col");){
            org.testng.Assert.assertEquals((String)this.getColumnType(table.getName(), "col"), (String)"row(lower integer, UPPER integer)");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " DROP COLUMN col.LOWER", "\\Qline 1:1: Cannot resolve field 'LOWER' within row(lower integer, UPPER integer) type when dropping [LOWER] in row(lower integer, UPPER integer)");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " DROP COLUMN col.upper", "\\Qline 1:1: Cannot resolve field 'upper' within row(lower integer, UPPER integer) type when dropping [upper] in row(lower integer, UPPER integer)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.\"UPPER\"");
            org.testng.Assert.assertEquals((String)this.getColumnType(table.getName(), "col"), (String)"row(lower integer)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(row(1) AS row(lower integer))");
        }
    }

    @Test
    public void testDropAmbiguousRowFieldCaseSensitivity() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_FIELD));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_row_field_case_sensitivity_", "AS SELECT CAST(row(1, 2, 3, 4, 5) AS\nrow(\"sOME_FIELd\" integer, \"some_field\" integer, \"SomE_Field\" integer, \"SOME_FIELD\" integer, \"sOME_FieLd\" integer)) AS col\n");){
            org.testng.Assert.assertEquals((String)this.getColumnType(table.getName(), "col"), (String)"row(sOME_FIELd integer, some_field integer, SomE_Field integer, SOME_FIELD integer, sOME_FieLd integer)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.some_field");
            org.testng.Assert.assertEquals((String)this.getColumnType(table.getName(), "col"), (String)"row(sOME_FIELd integer, SomE_Field integer, SOME_FIELD integer, sOME_FieLd integer)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.\"SomE_Field\"");
            org.testng.Assert.assertEquals((String)this.getColumnType(table.getName(), "col"), (String)"row(sOME_FIELd integer, SOME_FIELD integer, sOME_FieLd integer)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN col.\"SOME_FIELD\"");
            org.testng.Assert.assertEquals((String)this.getColumnType(table.getName(), "col"), (String)"row(sOME_FIELd integer, sOME_FieLd integer)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).matches("SELECT CAST(row(1, 5) AS row(\"sOME_FIELd\" integer, \"sOME_FieLd\" integer))");
        }
    }

    @Test
    public void testDropAndAddColumnWithSameName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_COLUMN) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_drop_add_column", "AS SELECT 1 x, 2 y, 3 z");){
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN y");
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (1, 3)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN y int");
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (1, 3, NULL)");
        }
    }

    @Test
    public void testRenameColumn() {
        String tableName;
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_COLUMN)) {
            this.assertQueryFails("ALTER TABLE nation RENAME COLUMN nationkey TO test_rename_column", "This connector does not support renaming columns");
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_rename_column_", "AS SELECT 'some value' x");){
            tableName = table.getName();
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN x TO before_y");
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN IF EXISTS before_y TO y");
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN IF EXISTS columnNotExists TO y");
            this.assertQuery("SELECT y FROM " + tableName, "VALUES 'some value'");
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN y TO Z");
            this.assertQuery("SELECT z FROM " + tableName, "VALUES 'some value'");
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN IF EXISTS z TO a");
            this.assertQuery("SELECT a FROM " + tableName, "VALUES 'some value'");
            this.assertQuery("SELECT * FROM " + tableName, "VALUES 'some value'");
        }
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " RENAME COLUMN columnNotExists TO y");
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " RENAME COLUMN IF EXISTS columnNotExists TO y");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testSetColumnType() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_COLUMN_TYPE)) {
            this.assertQueryFails("ALTER TABLE nation ALTER COLUMN nationkey SET DATA TYPE bigint", "This connector does not support setting column types");
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_column_type_", "AS SELECT CAST(123 AS integer) AS col");){
            this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col SET DATA TYPE bigint");
            org.testng.Assert.assertEquals((String)this.getColumnType(table.getName(), "col"), (String)"bigint");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).skippingTypesCheck().matches("VALUES bigint '123'");
        }
    }

    @Test(dataProvider="setColumnTypesDataProvider")
    public void testSetColumnTypes(SetColumnTypeSetup setup) {
        TestTable table;
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_COLUMN_TYPE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        try {
            table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_column_type_", " AS SELECT CAST(" + setup.sourceValueLiteral + " AS " + setup.sourceColumnType + ") AS col");
        }
        catch (Exception e) {
            this.verifyUnsupportedTypeException(e, setup.sourceColumnType);
            throw new SkipException("Unsupported column type: " + setup.sourceColumnType);
        }
        try (TestTable testTable = table;){
            Runnable setColumnType = () -> this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col SET DATA TYPE " + setup.newColumnType);
            if (setup.unsupportedType) {
                Assertions.assertThatThrownBy(setColumnType::run).satisfies(new ThrowingConsumer[]{this::verifySetColumnTypeFailurePermissible});
                return;
            }
            setColumnType.run();
            org.testng.Assert.assertEquals((String)this.getColumnType(table.getName(), "col"), (String)setup.newColumnType);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + table.getName()))).skippingTypesCheck().matches("SELECT " + setup.newValueLiteral);
        }
    }

    @DataProvider
    public Object[][] setColumnTypesDataProvider() {
        return (Object[][])this.setColumnTypeSetupData().stream().map(this::filterSetColumnTypesDataProvider).flatMap(Optional::stream).collect(DataProviders.toDataProvider());
    }

    protected Optional<SetColumnTypeSetup> filterSetColumnTypesDataProvider(SetColumnTypeSetup setup) {
        return Optional.of(setup);
    }

    private List<SetColumnTypeSetup> setColumnTypeSetupData() {
        return ImmutableList.builder().add((Object)new SetColumnTypeSetup("tinyint", "TINYINT '127'", "smallint")).add((Object)new SetColumnTypeSetup("smallint", "SMALLINT '32767'", "integer")).add((Object)new SetColumnTypeSetup("integer", "2147483647", "bigint")).add((Object)new SetColumnTypeSetup("bigint", "BIGINT '-2147483648'", "integer")).add((Object)new SetColumnTypeSetup("real", "REAL '10.3'", "double")).add((Object)new SetColumnTypeSetup("real", "REAL 'NaN'", "double")).add((Object)new SetColumnTypeSetup("decimal(5,3)", "12.345", "decimal(10,3)")).add((Object)new SetColumnTypeSetup("decimal(28,3)", "12.345", "decimal(38,3)")).add((Object)new SetColumnTypeSetup("decimal(5,3)", "12.345", "decimal(38,3)")).add((Object)new SetColumnTypeSetup("decimal(5,3)", "12.340", "decimal(5,2)")).add((Object)new SetColumnTypeSetup("decimal(5,3)", "12.349", "decimal(5,2)")).add((Object)new SetColumnTypeSetup("time(3)", "TIME '15:03:00.123'", "time(6)")).add((Object)new SetColumnTypeSetup("time(6)", "TIME '15:03:00.123000'", "time(3)")).add((Object)new SetColumnTypeSetup("time(6)", "TIME '15:03:00.123999'", "time(3)")).add((Object)new SetColumnTypeSetup("timestamp(3)", "TIMESTAMP '2020-02-12 15:03:00.123'", "timestamp(6)")).add((Object)new SetColumnTypeSetup("timestamp(6)", "TIMESTAMP '2020-02-12 15:03:00.123000'", "timestamp(3)")).add((Object)new SetColumnTypeSetup("timestamp(6)", "TIMESTAMP '2020-02-12 15:03:00.123999'", "timestamp(3)")).add((Object)new SetColumnTypeSetup("timestamp(3) with time zone", "TIMESTAMP '2020-02-12 15:03:00.123 +01:00'", "timestamp(6) with time zone")).add((Object)new SetColumnTypeSetup("varchar(100)", "'shorten-varchar'", "varchar(50)")).add((Object)new SetColumnTypeSetup("char(25)", "'shorten-char'", "char(20)")).add((Object)new SetColumnTypeSetup("char(20)", "'char-to-varchar'", "varchar")).add((Object)new SetColumnTypeSetup("varchar", "'varchar-to-char'", "char(20)")).add((Object)new SetColumnTypeSetup("array(integer)", "array[1]", "array(bigint)")).add((Object)new SetColumnTypeSetup("row(x integer)", "row(1)", "row(x bigint)")).add((Object)new SetColumnTypeSetup("row(x integer)", "row(1)", "row(y integer)", "cast(row(NULL) as row(x integer))")).add((Object)new SetColumnTypeSetup("row(x integer, y integer)", "row(1, 2)", "row(x integer, z integer)", "cast(row(1, NULL) as row(x integer, z integer))")).add((Object)new SetColumnTypeSetup("row(x integer)", "row(1)", "row(x integer, y integer)", "cast(row(1, NULL) as row(x integer, y integer))")).add((Object)new SetColumnTypeSetup("row(x integer, y integer)", "row(1, 2)", "row(x integer)", "cast(row(1) as row(x integer))")).add((Object)new SetColumnTypeSetup("row(x integer, y integer)", "row(1, 2)", "row(y integer, x integer)", "cast(row(2, 1) as row(y integer, x integer))")).add((Object)new SetColumnTypeSetup("row(x integer, y integer)", "row(1, 2)", "row(z integer, y integer, x integer)", "cast(row(null, 2, 1) as row(z integer, y integer, x integer))")).add((Object)new SetColumnTypeSetup("row(x row(nested integer))", "row(row(1))", "row(x row(nested bigint))", "cast(row(row(1)) as row(x row(nested bigint)))")).add((Object)new SetColumnTypeSetup("row(x row(a integer, b integer))", "row(row(1, 2))", "row(x row(b integer, a integer))", "cast(row(row(2, 1)) as row(x row(b integer, a integer)))")).build();
    }

    @Test
    public void testSetColumnTypeWithNotNull() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_COLUMN_TYPE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NOT_NULL_CONSTRAINT));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_column_type_null_", "(col int NOT NULL)");){
            org.testng.Assert.assertFalse((boolean)this.columnIsNullable(table.getName(), "col"));
            this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col SET DATA TYPE bigint");
            org.testng.Assert.assertFalse((boolean)this.columnIsNullable(table.getName(), "col"));
        }
    }

    @Test
    public void testSetColumnTypeWithComment() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_COLUMN_TYPE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_COLUMN_COMMENT));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_column_type_comment_", "(col int COMMENT 'test comment')");){
            org.testng.Assert.assertEquals((String)this.getColumnComment(table.getName(), "col"), (String)"test comment");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col SET DATA TYPE bigint");
            org.testng.Assert.assertEquals((String)this.getColumnComment(table.getName(), "col"), (String)"test comment");
        }
    }

    @Test
    public void testSetColumnTypeWithDefaultColumn() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_COLUMN_TYPE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        try (TestTable table = this.createTableWithDefaultColumns();){
            this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col_default SET DATA TYPE bigint");
            this.assertUpdate("INSERT INTO " + table.getName() + " (col_required, col_required2) VALUES (1, 10)", 1L);
            this.assertQuery("SELECT col_default FROM " + table.getName(), "VALUES 43");
        }
    }

    @Test
    public void testSetColumnIncompatibleType() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_COLUMN_TYPE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_invalid_column_type_", "AS SELECT 'test' AS col");){
            Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col SET DATA TYPE integer")).satisfies(new ThrowingConsumer[]{this::verifySetColumnTypeFailurePermissible});
        }
    }

    @Test
    public void testSetColumnOutOfRangeType() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_SET_COLUMN_TYPE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_set_column_type_invalid_range_", "AS SELECT CAST(9223372036854775807 AS bigint) AS col");){
            Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col SET DATA TYPE integer")).satisfies(new ThrowingConsumer[]{this::verifySetColumnTypeFailurePermissible});
        }
    }

    protected void verifySetColumnTypeFailurePermissible(Throwable e) {
        throw new AssertionError("Unexpected set column type failure", e);
    }

    private String getColumnType(String tableName, String columnName) {
        return (String)this.computeScalar(String.format("SELECT data_type FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA AND table_name = '%s' AND column_name = '%s'", tableName, columnName));
    }

    @Test
    public void testCreateTable() {
        String tableName = "test_create_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            this.assertQueryFails("CREATE TABLE " + tableName + " (a bigint, b double, c varchar(50))", "This connector does not support creating tables");
            return;
        }
        Assertions.assertThat((Collection)this.computeActual("SHOW TABLES").getOnlyColumnAsSet()).doesNotContain(new Object[]{tableName});
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint, b double, c varchar(50))");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        Assertions.assertThat((Collection)this.computeActual("SHOW TABLES").getOnlyColumnAsSet()).contains(new Object[]{tableName});
        this.assertTableColumnNames(tableName, "a", "b", "c");
        org.testng.Assert.assertNull((Object)this.getTableComment((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), tableName));
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        Assertions.assertThat((Collection)this.computeActual("SHOW TABLES").getOnlyColumnAsSet()).doesNotContain(new Object[]{tableName});
        this.assertQueryFails("CREATE TABLE " + tableName + " (a bad_type)", ".* Unknown type 'bad_type' for column 'a'");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        tableName = "test_cr_not_exists_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint, b varchar(50), c double)");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertTableColumnNames(tableName, "a", "b", "c");
        this.assertUpdate("CREATE TABLE IF NOT EXISTS " + tableName + " (d bigint, e varchar(50))");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertTableColumnNames(tableName, "a", "b", "c");
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        tableName = "test_create_orig_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint, b double, c varchar(50))");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertTableColumnNames(tableName, "a", "b", "c");
        String tableNameLike = "test_create_like_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableNameLike + " (LIKE " + tableName + ", d bigint, e varchar(50))");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableNameLike));
        this.assertTableColumnNames(tableNameLike, "a", "b", "c", "d", "e");
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertUpdate("DROP TABLE " + tableNameLike);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableNameLike));
    }

    @Test
    public void testCreateSchemaWithNonLowercaseOwnerName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA));
        Session newSession = Session.builder((Session)this.getSession()).setIdentity(Identity.ofUser((String)"ADMIN")).build();
        String schemaName = "test_schema_create_uppercase_owner_name_" + TestingNames.randomNameSuffix();
        this.assertUpdate(newSession, this.createSchemaSql(schemaName));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(newSession, "SHOW SCHEMAS"))).skippingTypesCheck().containsAll(String.format("VALUES '%s'", schemaName));
        this.assertUpdate(newSession, "DROP SCHEMA " + schemaName);
    }

    @Test
    public void testCreateSchemaWithLongName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA));
        String baseSchemaName = "test_create_" + TestingNames.randomNameSuffix();
        int maxLength = this.maxSchemaNameLength().orElse(65541);
        String validSchemaName = baseSchemaName + "z".repeat(maxLength - baseSchemaName.length());
        this.assertUpdate(this.createSchemaSql(validSchemaName));
        Assertions.assertThat((Collection)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).contains(new Object[]{validSchemaName});
        this.assertUpdate("DROP SCHEMA " + validSchemaName);
        if (this.maxSchemaNameLength().isEmpty()) {
            return;
        }
        String invalidSchemaName = validSchemaName + "z";
        Assertions.assertThatThrownBy(() -> this.assertUpdate(this.createSchemaSql(invalidSchemaName))).satisfies(new ThrowingConsumer[]{this::verifySchemaNameLengthFailurePermissible});
        Assertions.assertThat((Collection)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).doesNotContain(new Object[]{invalidSchemaName});
    }

    @Test
    public void testRenameSchemaToLongName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_SCHEMA));
        String sourceSchemaName = "test_rename_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createSchemaSql(sourceSchemaName));
        String baseSchemaName = "test_rename_target_" + TestingNames.randomNameSuffix();
        int maxLength = this.maxSchemaNameLength().orElse(65541);
        String validTargetSchemaName = baseSchemaName + "z".repeat(maxLength - baseSchemaName.length());
        this.assertUpdate("ALTER SCHEMA " + sourceSchemaName + " RENAME TO " + validTargetSchemaName);
        Assertions.assertThat((Collection)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).contains(new Object[]{validTargetSchemaName});
        this.assertUpdate("DROP SCHEMA " + validTargetSchemaName);
        if (this.maxSchemaNameLength().isEmpty()) {
            return;
        }
        this.assertUpdate(this.createSchemaSql(sourceSchemaName));
        String invalidTargetSchemaName = validTargetSchemaName + "z";
        Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER SCHEMA " + sourceSchemaName + " RENAME TO " + invalidTargetSchemaName)).satisfies(new ThrowingConsumer[]{this::verifySchemaNameLengthFailurePermissible});
        Assertions.assertThat((Collection)this.computeActual("SHOW SCHEMAS").getOnlyColumnAsSet()).doesNotContain(new Object[]{invalidTargetSchemaName});
    }

    protected OptionalInt maxSchemaNameLength() {
        return OptionalInt.empty();
    }

    protected void verifySchemaNameLengthFailurePermissible(Throwable e) {
        throw new AssertionError("Unexpected schema name length failure", e);
    }

    @Test
    public void testCreateTableWithLongTableName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String baseTableName = "test_create_" + TestingNames.randomNameSuffix();
        int maxLength = this.maxTableNameLength().orElse(65541);
        String validTableName = baseTableName + "z".repeat(maxLength - baseTableName.length());
        this.assertUpdate("CREATE TABLE " + validTableName + " (a bigint)");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), validTableName));
        this.assertUpdate("DROP TABLE " + validTableName);
        if (this.maxTableNameLength().isEmpty()) {
            return;
        }
        String invalidTableName = validTableName + "z";
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE " + invalidTableName + " (a bigint)")).satisfies(new ThrowingConsumer[]{this::verifyTableNameLengthFailurePermissible});
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), validTableName));
    }

    @Test
    public void testRenameTableToLongTableName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE));
        String sourceTableName = "test_rename_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + sourceTableName + " AS SELECT 123 x", 1L);
        String baseTableName = "test_rename_target_" + TestingNames.randomNameSuffix();
        int maxLength = this.maxTableRenameLength().orElse(65541);
        String validTargetTableName = baseTableName + "z".repeat(maxLength - baseTableName.length());
        this.assertUpdate("ALTER TABLE " + sourceTableName + " RENAME TO " + validTargetTableName);
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), validTargetTableName));
        this.assertQuery("SELECT x FROM " + validTargetTableName, "VALUES 123");
        this.assertUpdate("DROP TABLE " + validTargetTableName);
        if (this.maxTableRenameLength().isEmpty()) {
            return;
        }
        this.assertUpdate("CREATE TABLE " + sourceTableName + " AS SELECT 123 x", 1L);
        String invalidTargetTableName = validTargetTableName + "z";
        Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE " + sourceTableName + " RENAME TO " + invalidTargetTableName)).satisfies(new ThrowingConsumer[]{this::verifyTableNameLengthFailurePermissible});
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), invalidTargetTableName));
        this.assertUpdate("DROP TABLE " + sourceTableName);
    }

    protected OptionalInt maxTableNameLength() {
        return OptionalInt.empty();
    }

    protected OptionalInt maxTableRenameLength() {
        return this.maxTableNameLength();
    }

    protected void verifyTableNameLengthFailurePermissible(Throwable e) {
        throw new AssertionError("Unexpected table name length failure", e);
    }

    @Test
    public void testCreateTableWithLongColumnName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String tableName = "test_long_column" + TestingNames.randomNameSuffix();
        String baseColumnName = "col";
        int maxLength = this.maxColumnNameLength().orElse(65541);
        String validColumnName = baseColumnName + "z".repeat(maxLength - baseColumnName.length());
        this.assertUpdate("CREATE TABLE " + tableName + " (" + validColumnName + " bigint)");
        org.testng.Assert.assertTrue((boolean)this.columnExists(tableName, validColumnName));
        this.assertUpdate("DROP TABLE " + tableName);
        if (this.maxColumnNameLength().isEmpty()) {
            return;
        }
        String invalidColumnName = validColumnName + "z";
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE " + tableName + " (" + invalidColumnName + " bigint)")).satisfies(new ThrowingConsumer[]{this::verifyColumnNameLengthFailurePermissible});
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testAlterTableAddLongColumnName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN));
        String tableName = "test_long_column" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 123 x", 1L);
        String baseColumnName = "col";
        int maxLength = this.maxColumnNameLength().orElse(65541);
        String validTargetColumnName = baseColumnName + "z".repeat(maxLength - baseColumnName.length());
        this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN " + validTargetColumnName + " int");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertQuery("SELECT x FROM " + tableName, "VALUES 123");
        this.assertUpdate("DROP TABLE " + tableName);
        if (this.maxColumnNameLength().isEmpty()) {
            return;
        }
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 123 x", 1L);
        String invalidTargetColumnName = validTargetColumnName + "z";
        Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN " + invalidTargetColumnName + " int")).satisfies(new ThrowingConsumer[]{this::verifyColumnNameLengthFailurePermissible});
        this.assertQuery("SELECT x FROM " + tableName, "VALUES 123");
    }

    @Test
    public void testAlterTableRenameColumnToLongName() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_COLUMN));
        String tableName = "test_long_column" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 123 x", 1L);
        String baseColumnName = "col";
        int maxLength = this.maxColumnNameLength().orElse(65541);
        String validTargetColumnName = baseColumnName + "z".repeat(maxLength - baseColumnName.length());
        this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN x TO " + validTargetColumnName);
        this.assertQuery("SELECT " + validTargetColumnName + " FROM " + tableName, "VALUES 123");
        this.assertUpdate("DROP TABLE " + tableName);
        if (this.maxColumnNameLength().isEmpty()) {
            return;
        }
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 123 x", 1L);
        String invalidTargetTableName = validTargetColumnName + "z";
        Assertions.assertThatThrownBy(() -> this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN x TO " + invalidTargetTableName)).satisfies(new ThrowingConsumer[]{this::verifyColumnNameLengthFailurePermissible});
        this.assertQuery("SELECT x FROM " + tableName, "VALUES 123");
    }

    protected boolean columnExists(String tableName, String columnName) {
        MaterializedResult materializedResult = this.computeActual(String.format("SELECT 1 FROM information_schema.columns WHERE table_schema = '%s' AND table_name = '%s' AND column_name = '%s'", this.getSession().getSchema().orElseThrow(), tableName, columnName));
        return materializedResult.getRowCount() == 1;
    }

    protected OptionalInt maxColumnNameLength() {
        return OptionalInt.empty();
    }

    protected void verifyColumnNameLengthFailurePermissible(Throwable e) {
        throw new AssertionError("Unexpected column name length failure", e);
    }

    @Test
    public void testCreateTableWithTableComment() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String tableName = "test_create_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_TABLE_COMMENT)) {
            this.assertQueryFails("CREATE TABLE " + tableName + " (a bigint) COMMENT 'test comment'", "This connector does not support creating tables with table comment");
            return;
        }
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint) COMMENT 'test comment'");
        org.testng.Assert.assertEquals((String)this.getTableComment((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), tableName), (String)"test comment");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateTableWithColumnComment() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String tableName = "test_create_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_COLUMN_COMMENT)) {
            this.assertQueryFails("CREATE TABLE " + tableName + " (a bigint COMMENT 'test comment')", "This connector does not support creating tables with column comment");
            return;
        }
        this.assertUpdate("CREATE TABLE " + tableName + " (a bigint COMMENT 'test comment')");
        org.testng.Assert.assertEquals((String)this.getColumnComment(tableName, "a"), (String)"test comment");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateTableSchemaNotFound() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String schemaName = "test_schema_" + TestingNames.randomNameSuffix();
        String tableName = "test_create_no_schema_" + TestingNames.randomNameSuffix();
        try {
            this.assertQueryFails(String.format("CREATE TABLE %s.%s (a bigint)", schemaName, tableName), String.format("Schema %s not found", schemaName));
        }
        catch (Throwable throwable) {
            this.assertUpdate(String.format("DROP TABLE IF EXISTS %s.%s", schemaName, tableName));
            throw throwable;
        }
        this.assertUpdate(String.format("DROP TABLE IF EXISTS %s.%s", schemaName, tableName));
    }

    @Test
    public void testCreateTableAsSelect() {
        String tableName = "test_ctas" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA)) {
            this.assertQueryFails("CREATE TABLE IF NOT EXISTS " + tableName + " AS SELECT name, regionkey FROM nation", "This connector does not support creating tables with data");
            return;
        }
        this.assertUpdate("CREATE TABLE IF NOT EXISTS " + tableName + " AS SELECT name, regionkey FROM nation", "SELECT count(*) FROM nation");
        this.assertTableColumnNames(tableName, "name", "regionkey");
        org.testng.Assert.assertNull((Object)this.getTableComment((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), tableName));
        this.assertUpdate("DROP TABLE " + tableName);
        this.assertUpdate("CREATE TABLE IF NOT EXISTS nation AS SELECT nationkey, regionkey FROM nation", 0L);
        this.assertTableColumnNames("nation", "nationkey", "name", "regionkey", "comment");
        this.assertCreateTableAsSelect("SELECT nationkey, name, regionkey FROM nation", "SELECT count(*) FROM nation");
        this.assertCreateTableAsSelect("SELECT mktsegment, sum(acctbal) x FROM customer GROUP BY mktsegment", "SELECT count(DISTINCT mktsegment) FROM customer");
        this.assertCreateTableAsSelect("SELECT count(*) x FROM nation JOIN region ON nation.regionkey = region.regionkey", "SELECT 1");
        this.assertCreateTableAsSelect("SELECT nationkey FROM nation ORDER BY nationkey LIMIT 10", "SELECT 10");
        this.assertCreateTableAsSelect("SELECT * FROM nation WITH DATA", "SELECT * FROM nation", "SELECT count(*) FROM nation");
        this.assertCreateTableAsSelect("SELECT * FROM nation WITH NO DATA", "SELECT * FROM nation LIMIT 0", "SELECT 0");
        this.assertCreateTableAsSelect("SELECT name, nationkey, regionkey FROM nation WHERE nationkey % 2 = 0 UNION ALL SELECT name, nationkey, regionkey FROM nation WHERE nationkey % 2 = 1", "SELECT name, nationkey, regionkey FROM nation", "SELECT count(*) FROM nation");
        this.assertCreateTableAsSelect(Session.builder((Session)this.getSession()).setSystemProperty("redistribute_writes", "true").build(), "SELECT CAST(nationkey AS BIGINT) nationkey, regionkey FROM nation UNION ALL SELECT 1234567890, 123", "SELECT nationkey, regionkey FROM nation UNION ALL SELECT 1234567890, 123", "SELECT count(*) + 1 FROM nation");
        this.assertCreateTableAsSelect(Session.builder((Session)this.getSession()).setSystemProperty("redistribute_writes", "false").build(), "SELECT CAST(nationkey AS BIGINT) nationkey, regionkey FROM nation UNION ALL SELECT 1234567890, 123", "SELECT nationkey, regionkey FROM nation UNION ALL SELECT 1234567890, 123", "SELECT count(*) + 1 FROM nation");
        tableName = "test_ctas" + TestingNames.randomNameSuffix();
        this.assertExplainAnalyze("EXPLAIN ANALYZE CREATE TABLE " + tableName + " AS SELECT name FROM nation", new String[0]);
        this.assertQuery("SELECT * from " + tableName, "SELECT name FROM nation");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateTableAsSelectWithTableComment() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        String tableName = "test_ctas_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_TABLE_COMMENT)) {
            this.assertQueryFails("CREATE TABLE " + tableName + " COMMENT 'test comment' AS SELECT name FROM nation", "This connector does not support creating tables with table comment");
            return;
        }
        this.assertUpdate("CREATE TABLE " + tableName + " COMMENT 'test comment' AS SELECT name FROM nation", 25L);
        org.testng.Assert.assertEquals((String)this.getTableComment((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), tableName), (String)"test comment");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateTableAsSelectSchemaNotFound() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        String schemaName = "test_schema_" + TestingNames.randomNameSuffix();
        String tableName = "test_ctas_no_schema_" + TestingNames.randomNameSuffix();
        try {
            this.assertQueryFails(String.format("CREATE TABLE %s.%s AS SELECT name FROM nation", schemaName, tableName), String.format("Schema %s not found", schemaName));
        }
        catch (Throwable throwable) {
            this.assertUpdate(String.format("DROP TABLE IF EXISTS %s.%s", schemaName, tableName));
            throw throwable;
        }
        this.assertUpdate(String.format("DROP TABLE IF EXISTS %s.%s", schemaName, tableName));
    }

    @Test
    public void testCreateTableAsSelectWithUnicode() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        this.assertCreateTableAsSelect("SELECT '\u2603' unicode", "SELECT 1");
    }

    protected void assertCreateTableAsSelect(@Language(value="SQL") String query, @Language(value="SQL") String rowCountQuery) {
        this.assertCreateTableAsSelect(this.getSession(), query, query, rowCountQuery);
    }

    protected void assertCreateTableAsSelect(@Language(value="SQL") String query, @Language(value="SQL") String expectedQuery, @Language(value="SQL") String rowCountQuery) {
        this.assertCreateTableAsSelect(this.getSession(), query, expectedQuery, rowCountQuery);
    }

    protected void assertCreateTableAsSelect(Session session, @Language(value="SQL") String query, @Language(value="SQL") String expectedQuery, @Language(value="SQL") String rowCountQuery) {
        String table = "test_ctas_" + TestingNames.randomNameSuffix();
        this.assertUpdate(session, "CREATE TABLE " + table + " AS " + query, rowCountQuery);
        this.assertQuery(session, "SELECT * FROM " + table, expectedQuery);
        this.assertUpdate(session, "DROP TABLE " + table);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, table));
    }

    @Test
    public void testCreateTableAsSelectNegativeDate() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        String tableName = "negative_date_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NEGATIVE_DATE)) {
            this.assertQueryFails(String.format("CREATE TABLE %s AS SELECT DATE '-0001-01-01' AS dt", tableName), this.errorMessageForCreateTableAsSelectNegativeDate("-0001-01-01"));
            return;
        }
        try {
            this.assertUpdate(String.format("CREATE TABLE %s AS SELECT DATE '-0001-01-01' AS dt", tableName), 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES DATE '-0001-01-01'");
            this.assertQuery(String.format("SELECT * FROM %s WHERE dt = DATE '-0001-01-01'", tableName), "VALUES DATE '-0001-01-01'");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Language(value="RegExp")
    protected String errorMessageForCreateTableAsSelectNegativeDate(String date) {
        throw new UnsupportedOperationException("This method should be overridden");
    }

    @Test
    public void testRenameTable() throws Exception {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String tableName = "test_rename_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 123 x", 1L);
        String renamedTable = "test_rename_new_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE)) {
            this.assertQueryFails("ALTER TABLE " + tableName + " RENAME TO " + renamedTable, "This connector does not support renaming tables");
            this.assertUpdate("DROP TABLE " + tableName);
            return;
        }
        try {
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME TO " + renamedTable);
        }
        catch (Throwable e) {
            AutoCloseable ignore = () -> this.assertUpdate("DROP TABLE " + tableName);
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (ignore != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        this.assertQuery("SELECT x FROM " + renamedTable, "VALUES 123");
        String testExistsTableName = "test_rename_exists_" + TestingNames.randomNameSuffix();
        this.assertUpdate("ALTER TABLE IF EXISTS " + renamedTable + " RENAME TO " + testExistsTableName);
        this.assertQuery("SELECT x FROM " + testExistsTableName, "VALUES 123");
        String uppercaseName = "TEST_RENAME_" + TestingNames.randomNameSuffix();
        this.assertUpdate("ALTER TABLE " + testExistsTableName + " RENAME TO " + uppercaseName);
        this.assertQuery("SELECT x FROM " + uppercaseName.toLowerCase(Locale.ENGLISH), "VALUES 123");
        this.assertUpdate("DROP TABLE " + uppercaseName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), renamedTable));
        this.assertUpdate("ALTER TABLE IF EXISTS " + tableName + " RENAME TO " + renamedTable);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), renamedTable));
    }

    @Test
    public void testRenameTableAcrossSchema() throws Exception {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE_ACROSS_SCHEMAS)) {
            if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE)) {
                throw new SkipException("Skipping since rename table is not supported at all");
            }
            this.assertQueryFails("ALTER TABLE nation RENAME TO other_schema.yyyy", "This connector does not support renaming tables across schemas");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            throw new AssertionError((Object)"Cannot test ALTER TABLE RENAME across schemas without CREATE SCHEMA, the test needs to be implemented in a connector-specific way");
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            throw new AssertionError((Object)"Cannot test ALTER TABLE RENAME across schemas without CREATE TABLE, the test needs to be implemented in a connector-specific way");
        }
        String tableName = "test_rename_old_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 123 x", 1L);
        String schemaName = "test_schema_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createSchemaSql(schemaName));
        String renamedTable = "test_rename_new_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME TO " + schemaName + "." + renamedTable);
        }
        catch (Throwable e) {
            AutoCloseable ignore = () -> this.assertUpdate("DROP TABLE " + tableName);
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (ignore != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertQuery("SELECT x FROM " + schemaName + "." + renamedTable, "VALUES 123");
        this.assertUpdate("DROP TABLE " + schemaName + "." + renamedTable);
        this.assertUpdate("DROP SCHEMA " + schemaName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(Session.builder((Session)this.getSession()).setSchema(schemaName).build(), renamedTable));
    }

    @Test
    public void testRenameTableToUnqualifiedPreservesSchema() throws Exception {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_TABLE));
        String sourceSchemaName = "test_source_schema_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createSchemaSql(sourceSchemaName));
        String tableName = "test_rename_unqualified_name_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + sourceSchemaName + "." + tableName + " AS SELECT 123 x", 1L);
        String renamedTable = "test_rename_unqualified_name_new_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("ALTER TABLE " + sourceSchemaName + "." + tableName + " RENAME TO " + renamedTable);
        }
        catch (Throwable e) {
            AutoCloseable ignore = () -> this.assertUpdate("DROP TABLE " + tableName);
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (ignore != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        this.assertQuery("SELECT x FROM " + sourceSchemaName + "." + renamedTable, "VALUES 123");
        this.assertUpdate("DROP TABLE " + sourceSchemaName + "." + renamedTable);
        this.assertUpdate("DROP SCHEMA " + sourceSchemaName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommentTable() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_TABLE)) {
            this.assertQueryFails("COMMENT ON TABLE nation IS 'new comment'", "This connector does not support setting table comments");
            return;
        }
        String catalogName = (String)this.getSession().getCatalog().orElseThrow();
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_", "(a integer)");){
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, table.getName())).isEqualTo(null);
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS 'new comment'");
            Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + table.getName()))).contains(new CharSequence[]{"COMMENT 'new comment'"});
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, table.getName())).isEqualTo("new comment");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT table_name, comment FROM system.metadata.table_comments WHERE catalog_name = '" + catalogName + "' AND schema_name = '" + schemaName + "'"))).skippingTypesCheck().containsAll("VALUES ('" + table.getName() + "', 'new comment')");
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS 'updated comment'");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, table.getName())).isEqualTo("updated comment");
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS ''");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, table.getName())).isIn(new Object[]{"", null});
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS 'a comment'");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, table.getName())).isEqualTo("a comment");
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS NULL");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, table.getName())).isEqualTo(null);
        }
        String tableName = "test_comment_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("CREATE TABLE " + tableName + "(key integer) COMMENT 'new table comment'");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, tableName)).isEqualTo("new table comment");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    protected String getTableComment(String catalogName, String schemaName, String tableName) {
        String sql = String.format("SELECT comment FROM system.metadata.table_comments WHERE catalog_name = '%s' AND schema_name = '%s' AND table_name = '%s'", catalogName, schemaName, tableName);
        return (String)this.computeScalar(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCommentView() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_VIEW)) {
            if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW)) {
                try (TestView view = new TestView(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_view", "SELECT * FROM region");){
                    this.assertQueryFails("COMMENT ON VIEW " + view.getName() + " IS 'new comment'", "This connector does not support setting view comments");
                }
                return;
            }
            throw new SkipException("Skipping as connector does not support CREATE VIEW");
        }
        String catalogName = (String)this.getSession().getCatalog().orElseThrow();
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        try (TestView view = new TestView(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_view", "SELECT * FROM region");){
            this.assertUpdate("COMMENT ON VIEW " + view.getName() + " IS 'new comment'");
            Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE VIEW " + view.getName()))).contains(new CharSequence[]{"COMMENT 'new comment'"});
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, view.getName())).isEqualTo("new comment");
            this.assertUpdate("COMMENT ON VIEW " + view.getName() + " IS 'updated comment'");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, view.getName())).isEqualTo("updated comment");
            this.assertUpdate("COMMENT ON VIEW " + view.getName() + " IS ''");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, view.getName())).isEqualTo("");
            this.assertUpdate("COMMENT ON VIEW " + view.getName() + " IS 'a comment'");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, view.getName())).isEqualTo("a comment");
            this.assertUpdate("COMMENT ON VIEW " + view.getName() + " IS NULL");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, view.getName())).isEqualTo(null);
        }
        String viewName = "test_comment_view" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("CREATE VIEW " + viewName + " COMMENT 'new view comment' AS SELECT * FROM region");
            Assertions.assertThat((String)this.getTableComment(catalogName, schemaName, viewName)).isEqualTo("new view comment");
        }
        finally {
            this.assertUpdate("DROP VIEW IF EXISTS " + viewName);
        }
    }

    @Test
    public void testCommentColumn() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_COLUMN)) {
            this.assertQueryFails("COMMENT ON COLUMN nation.nationkey IS 'new comment'", "This connector does not support setting column comments");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_column_", "(a integer)");){
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS 'new comment'");
            Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + table.getName()))).contains(new CharSequence[]{"COMMENT 'new comment'"});
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isEqualTo("new comment");
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS 'updated comment'");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isEqualTo("updated comment");
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS ''");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isIn(new Object[]{"", null});
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS 'a comment'");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isEqualTo("a comment");
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS NULL");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isEqualTo(null);
        }
    }

    @Test(dataProvider="testColumnNameDataProvider")
    public void testCommentColumnName(String columnName) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_COLUMN));
        if (!BaseConnectorTest.requiresDelimiting(columnName)) {
            this.testCommentColumnName(columnName, false);
        }
        this.testCommentColumnName(columnName, true);
    }

    protected void testCommentColumnName(String columnName, boolean delimited) {
        String nameInSql = BaseConnectorTest.toColumnNameInSql(columnName, delimited);
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_column", "(" + nameInSql + " integer)");){
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + "." + nameInSql + " IS 'test comment'");
            Assertions.assertThat((String)this.getColumnComment(table.getName(), columnName.replace("'", "''").toLowerCase(Locale.ENGLISH))).isEqualTo("test comment");
        }
        catch (RuntimeException e) {
            if (this.isColumnNameRejected(e, columnName, delimited)) {
                return;
            }
            throw e;
        }
    }

    @Test
    public void testCommentViewColumn() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_VIEW_COLUMN)) {
            if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_VIEW)) {
                try (TestView view = new TestView(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_view_column", "SELECT * FROM region");){
                    this.assertQueryFails("COMMENT ON COLUMN " + view.getName() + ".regionkey IS 'new region key comment'", "This connector does not support setting view column comments");
                }
                return;
            }
            throw new SkipException("Skipping as connector does not support CREATE VIEW");
        }
        String viewColumnName = "regionkey";
        try (TestView view = new TestView(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_view_column", "SELECT * FROM region");){
            this.assertUpdate("COMMENT ON COLUMN " + view.getName() + "." + viewColumnName + " IS 'new region key comment'");
            Assertions.assertThat((String)this.getColumnComment(view.getName(), viewColumnName)).isEqualTo("new region key comment");
            this.assertUpdate("COMMENT ON COLUMN " + view.getName() + "." + viewColumnName + " IS 'updated region key comment'");
            Assertions.assertThat((String)this.getColumnComment(view.getName(), viewColumnName)).isEqualTo("updated region key comment");
            this.assertUpdate("COMMENT ON COLUMN " + view.getName() + "." + viewColumnName + " IS ''");
            Assertions.assertThat((String)this.getColumnComment(view.getName(), viewColumnName)).isEqualTo("");
            this.assertUpdate("COMMENT ON COLUMN " + view.getName() + "." + viewColumnName + " IS NULL");
            Assertions.assertThat((String)this.getColumnComment(view.getName(), viewColumnName)).isEqualTo(null);
        }
    }

    protected String getColumnComment(String tableName, String columnName) {
        return (String)this.computeScalar(String.format("SELECT comment FROM information_schema.columns WHERE table_schema = '%s' AND table_name = '%s' AND column_name = '%s'", this.getSession().getSchema().orElseThrow(), tableName, columnName));
    }

    @Test
    public void testInsert() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT)) {
            this.assertQueryFails("INSERT INTO nation(nationkey) VALUES (42)", "This connector does not support inserts");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA)) {
            throw new AssertionError((Object)"Cannot test INSERT without CTAS, the test needs to be implemented in a connector-specific way");
        }
        String query = "SELECT phone, custkey, acctbal FROM customer";
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_", "AS " + query + " WITH NO DATA");){
            this.assertQuery("SELECT count(*) FROM " + table.getName(), "SELECT 0");
            this.assertUpdate("INSERT INTO " + table.getName() + " " + query, "SELECT count(*) FROM customer");
            this.assertQuery("SELECT * FROM " + table.getName(), query);
            this.assertUpdate("INSERT INTO " + table.getName() + " (custkey) VALUES (-1)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (custkey) VALUES (null)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (phone) VALUES ('3283-2001-01-01')", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (custkey, phone) VALUES (-2, '3283-2001-01-02')", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (phone, custkey) VALUES ('3283-2001-01-03', -3)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (acctbal) VALUES (1234)", 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), query + " UNION ALL SELECT null, -1, null UNION ALL SELECT null, null, null UNION ALL SELECT '3283-2001-01-01', null, null UNION ALL SELECT '3283-2001-01-02', -2, null UNION ALL SELECT '3283-2001-01-03', -3, null UNION ALL SELECT null, null, 1234");
            this.assertUpdate("INSERT INTO " + table.getName() + " (custkey, phone, acctbal) SELECT custkey, phone, acctbal FROM customer UNION ALL SELECT custkey, phone, acctbal FROM customer", "SELECT 2 * count(*) FROM customer");
        }
    }

    @Test
    public void testInsertForDefaultColumn() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        try (TestTable testTable = this.createTableWithDefaultColumns();){
            this.assertUpdate(String.format("INSERT INTO %s (col_required, col_required2) VALUES (1, 10)", testTable.getName()), 1L);
            this.assertUpdate(String.format("INSERT INTO %s VALUES (2, 3, 4, 5, 6)", testTable.getName()), 1L);
            this.assertUpdate(String.format("INSERT INTO %s VALUES (7, null, null, 8, 9)", testTable.getName()), 1L);
            this.assertUpdate(String.format("INSERT INTO %s (col_required2, col_required) VALUES (12, 13)", testTable.getName()), 1L);
            this.assertQuery("SELECT * FROM " + testTable.getName(), "VALUES (1, null, 43, 42, 10), (2, 3, 4, 5, 6), (7, null, null, 8, 9), (13, null, 43, 42, 12)");
        }
    }

    protected TestTable createTableWithDefaultColumns() {
        throw new UnsupportedOperationException();
    }

    @Test
    public void testInsertUnicode() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            throw new AssertionError((Object)"Cannot test INSERT without CREATE TABLE, the test needs to be implemented in a connector-specific way");
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_unicode_", "(test varchar(50))");){
            this.assertUpdate("INSERT INTO " + table.getName() + "(test) VALUES 'Hello', U&'hello\\6d4B\\8Bd5world\\7F16\\7801' ", 2L);
            Assertions.assertThat((Collection)this.computeActual("SELECT test FROM " + table.getName()).getOnlyColumnAsSet()).containsExactlyInAnyOrder(new Object[]{"Hello", "hello\u6d4b\u8bd5world\u7f16\u7801"});
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_unicode_", "(test varchar(50))");
        try {
            this.assertUpdate("INSERT INTO " + table.getName() + "(test) VALUES 'aa', 'b\u00e9'", 2L);
            this.assertQuery("SELECT test FROM " + table.getName(), "VALUES 'aa', 'b\u00e9'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test = 'aa'", "VALUES 'aa'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test > 'ba'", "VALUES 'b\u00e9'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test < 'ba'", "VALUES 'aa'");
            this.assertQueryReturnsEmptyResult("SELECT test FROM " + table.getName() + " WHERE test = 'ba'");
        }
        finally {
            table.close();
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_unicode_", "(test varchar(50))");
        try {
            this.assertUpdate("INSERT INTO " + table.getName() + "(test) VALUES 'a', '\u00e9'", 2L);
            this.assertQuery("SELECT test FROM " + table.getName(), "VALUES 'a', '\u00e9'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test = 'a'", "VALUES 'a'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test > 'b'", "VALUES '\u00e9'");
            this.assertQuery("SELECT test FROM " + table.getName() + " WHERE test < 'b'", "VALUES 'a'");
            this.assertQueryReturnsEmptyResult("SELECT test FROM " + table.getName() + " WHERE test = 'b'");
        }
        finally {
            table.close();
        }
    }

    @Test
    public void testInsertHighestUnicodeCharacter() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            throw new AssertionError((Object)"Cannot test INSERT without CREATE TABLE, the test needs to be implemented in a connector-specific way");
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_unicode_", "(test varchar(50))");){
            this.assertUpdate("INSERT INTO " + table.getName() + "(test) VALUES 'Hello', U&'hello\\6d4B\\8Bd5\\+10FFFFworld\\7F16\\7801' ", 2L);
            Assertions.assertThat((Collection)this.computeActual("SELECT test FROM " + table.getName()).getOnlyColumnAsSet()).containsExactlyInAnyOrder(new Object[]{"Hello", "hello\u6d4b\u8bd5\udbff\udfffworld\u7f16\u7801"});
        }
    }

    @Test
    public void testInsertArray() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            throw new AssertionError((Object)"Cannot test INSERT without CREATE TABLE, the test needs to be implemented in a connector-specific way");
        }
        String tableName = "test_insert_array_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ARRAY)) {
            Assertions.assertThatThrownBy(() -> this.query("CREATE TABLE " + tableName + " (a array(bigint))")).hasMessageMatching("[Uu]nsupported (column )?type: \\Qarray(bigint)");
            throw new SkipException("not supported");
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_array_", "(a ARRAY<DOUBLE>, b ARRAY<BIGINT>)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " (a) VALUES (ARRAY[null])", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " (a, b) VALUES (ARRAY[1.23E1], ARRAY[1.23E1])", 1L);
            this.assertQuery("SELECT a[1], b[1] FROM " + table.getName(), "VALUES (null, null), (12.3, 12)");
        }
    }

    @Test
    public void testInsertSameValues() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "insert_same_values", "AS " + String.join((CharSequence)" UNION ALL ", Collections.nCopies(2, "SELECT * FROM region")));){
            this.assertQuery("SELECT count(*) FROM " + table.getName(), "VALUES 10");
        }
    }

    @Test
    public void testInsertNegativeDate() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT)) {
            this.assertQueryFails("INSERT INTO orders (orderdate) VALUES (DATE '-0001-01-01')", "This connector does not support inserts");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE)) {
            throw new AssertionError((Object)"Cannot test INSERT negative dates without CREATE TABLE, the test needs to be implemented in a connector-specific way");
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NEGATIVE_DATE)) {
            try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "insert_date", "(dt DATE)");){
                this.assertQueryFails(String.format("INSERT INTO %s VALUES (DATE '-0001-01-01')", table.getName()), this.errorMessageForInsertNegativeDate("-0001-01-01"));
            }
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "insert_date", "(dt DATE)");){
            this.assertUpdate(String.format("INSERT INTO %s VALUES (DATE '-0001-01-01')", table.getName()), 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES DATE '-0001-01-01'");
            this.assertQuery(String.format("SELECT * FROM %s WHERE dt = DATE '-0001-01-01'", table.getName()), "VALUES DATE '-0001-01-01'");
        }
    }

    @Language(value="RegExp")
    protected String errorMessageForInsertNegativeDate(String date) {
        throw new UnsupportedOperationException("This method should be overridden");
    }

    @Test
    public void testInsertIntoNotNullColumn() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NOT_NULL_CONSTRAINT)) {
            this.assertQueryFails("CREATE TABLE not_null_constraint (not_null_col INTEGER NOT NULL)", String.format("line 1:35: Catalog '%s' does not support non-null column for column name 'not_null_col'", this.getSession().getCatalog().orElseThrow()));
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "insert_not_null", "(nullable_col INTEGER, not_null_col INTEGER NOT NULL)");){
            this.assertUpdate(String.format("INSERT INTO %s (not_null_col) VALUES (2)", table.getName()), 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (NULL, 2)");
            this.assertQueryFails(String.format("INSERT INTO %s (nullable_col) VALUES (1)", table.getName()), this.errorMessageForInsertIntoNotNullColumn("not_null_col"));
            this.assertQueryFails(String.format("INSERT INTO %s (not_null_col, nullable_col) VALUES (NULL, 3)", table.getName()), "NULL value not allowed for NOT NULL column: not_null_col");
            this.assertQueryFails(String.format("INSERT INTO %s (not_null_col, nullable_col) VALUES (TRY(5/0), 4)", table.getName()), "NULL value not allowed for NOT NULL column: not_null_col");
            this.assertQueryFails(String.format("INSERT INTO %s (not_null_col) VALUES (TRY(6/0))", table.getName()), "NULL value not allowed for NOT NULL column: not_null_col");
            this.assertQueryFails(String.format("INSERT INTO %s (nullable_col) SELECT nationkey FROM nation", table.getName()), this.errorMessageForInsertIntoNotNullColumn("not_null_col"));
            this.assertUpdate(String.format("INSERT INTO %s (nullable_col) SELECT nationkey FROM nation WHERE regionkey < 0", table.getName()), 0L);
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "commuted_not_null", "(nullable_col BIGINT, not_null_col BIGINT NOT NULL)");
        try {
            this.assertUpdate(String.format("INSERT INTO %s (not_null_col) VALUES (2)", table.getName()), 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (NULL, 2)");
            this.assertQueryFails(String.format("INSERT INTO %s (not_null_col, nullable_col) VALUES (NULL, 3)", table.getName()), "NULL value not allowed for NOT NULL column: not_null_col");
        }
        finally {
            table.close();
        }
    }

    @Test
    public void testUpdateNotNullColumn() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE));
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NOT_NULL_CONSTRAINT)) {
            this.assertQueryFails("CREATE TABLE not_null_constraint (not_null_col INTEGER NOT NULL)", String.format("line 1:35: Catalog '%s' does not support non-null column for column name 'not_null_col'", this.getSession().getCatalog().orElseThrow()));
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "update_not_null", "(nullable_col INTEGER, not_null_col INTEGER NOT NULL)");){
            this.assertUpdate(String.format("INSERT INTO %s (nullable_col, not_null_col) VALUES (1, 10)", table.getName()), 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (1, 10)");
            this.assertQueryFails("UPDATE " + table.getName() + " SET not_null_col = NULL WHERE nullable_col = 1", "NULL value not allowed for NOT NULL column: not_null_col");
            this.assertQueryFails("UPDATE " + table.getName() + " SET not_null_col = TRY(5/0) where nullable_col = 1", "NULL value not allowed for NOT NULL column: not_null_col");
        }
    }

    @Language(value="RegExp")
    protected String errorMessageForInsertIntoNotNullColumn(String columnName) {
        throw new UnsupportedOperationException("This method should be overridden");
    }

    @Test
    public void testInsertInTransaction() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MULTI_STATEMENT_WRITES));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_tx_insert", "(a bigint)");){
            String tableName = table.getName();
            this.inTransaction(session -> this.assertUpdate((Session)session, "INSERT INTO " + tableName + " VALUES 42", 1L));
            this.assertQuery("TABLE " + tableName, "VALUES 42");
        }
    }

    @Test
    public void testSelectAfterInsertInTransaction() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT) || !this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MULTI_STATEMENT_WRITES)) {
            log.info("Connector does not support insert in transaction context, so nothing to test");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_insert_select_", "AS SELECT nationkey, name, regionkey FROM nation WHERE nationkey = 1");){
            boolean commit;
            String tableName = table.getName();
            try {
                this.inTransaction(session -> {
                    this.assertQuery((Session)session, "TABLE " + tableName, "SELECT nationkey, name, regionkey FROM nation WHERE nationkey = 1");
                    this.assertUpdate((Session)session, "INSERT INTO " + tableName + "(nationkey, name, regionkey) SELECT nationkey, name, regionkey FROM nation WHERE nationkey = 2", 1L);
                    try {
                        this.assertQuery((Session)session, "TABLE " + tableName, "SELECT nationkey, name, regionkey FROM nation WHERE nationkey IN (1, 2)");
                    }
                    catch (Throwable e) {
                        this.verifySelectAfterInsertFailurePermissible(e);
                        throw new RollbackException();
                    }
                });
                commit = true;
            }
            catch (RollbackException ignored) {
                commit = false;
            }
            this.assertQuery("TABLE " + tableName, "SELECT nationkey, name, regionkey FROM nation WHERE nationkey IN " + (commit ? "(1, 2)" : "(1)"));
        }
    }

    protected void verifySelectAfterInsertFailurePermissible(Throwable e) {
        org.testng.Assert.fail((String)"Unexpected failure", (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelete() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_", "AS SELECT * FROM orders");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE custkey <= 100", "SELECT count(*) FROM orders WHERE custkey <= 100");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders WHERE custkey > 100");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE custkey <= 300", "SELECT count(*) FROM orders WHERE custkey > 100 AND custkey <= 300");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders WHERE custkey > 300");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE custkey <= 500", "SELECT count(*) FROM orders WHERE custkey > 300 AND custkey <= 500");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders WHERE custkey > 500");
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_", "AS SELECT * FROM orders");
        try {
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderkey < 0", 0L);
        }
        finally {
            table.close();
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_", "AS SELECT * FROM orders");
        try {
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderkey > 5 AND orderkey < 4", 0L);
        }
        finally {
            table.close();
        }
        String tableName = "test_delete_" + TestingNames.randomNameSuffix();
        try {
            this.assertExplainAnalyze("EXPLAIN ANALYZE CREATE TABLE " + tableName + " AS SELECT CAST(orderstatus AS VARCHAR(15)) orderstatus FROM orders", new String[0]);
            this.assertQuery("SELECT * from " + tableName, "SELECT orderstatus FROM orders");
            this.assertExplainAnalyze("EXPLAIN ANALYZE INSERT INTO " + tableName + " SELECT clerk FROM orders", new String[0]);
            this.assertQuery("SELECT * from " + tableName, "SELECT orderstatus FROM orders UNION ALL SELECT clerk FROM orders");
            this.assertExplainAnalyze("EXPLAIN ANALYZE DELETE FROM " + tableName + " WHERE TRUE", new String[0]);
            this.assertQuery("SELECT COUNT(*) from " + tableName, "SELECT 0");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Test
    public void testDeleteWithLike() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_with_like_", "AS SELECT * FROM nation");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE name LIKE '%a%'", "VALUES 0");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE name LIKE '%A%'", "SELECT count(*) FROM nation WHERE name LIKE '%A%'");
        }
    }

    @Test
    public void testDeleteWithComplexPredicate() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_complex_", "AS SELECT * FROM nation");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE nationkey % 2 = 0", "SELECT count(*) FROM nation WHERE nationkey % 2 = 0");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM nation WHERE nationkey % 2 <> 0");
            this.assertUpdate("DELETE FROM " + table.getName(), "SELECT count(*) FROM nation WHERE nationkey % 2 <> 0");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders LIMIT 0");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE rand() < 0", 0L);
        }
    }

    @Test
    public void testDeleteWithSubquery() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_subquery", "AS SELECT * FROM nation");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE regionkey IN (SELECT regionkey FROM region WHERE name LIKE 'A%')", 15L);
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM nation WHERE regionkey IN (SELECT regionkey FROM region WHERE name NOT LIKE 'A%')");
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_subquery", "AS SELECT * FROM orders");
        try {
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderkey = (SELECT orderkey FROM orders ORDER BY orderkey LIMIT 1)", 1L);
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderkey = (SELECT orderkey FROM orders WHERE false)", 0L);
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE EXISTS(SELECT 1 WHERE false)", 0L);
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE EXISTS(SELECT 1)", "SELECT count(*) - 1 FROM orders");
        }
        finally {
            table.close();
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_correlated_exists_subquery", "AS SELECT * FROM nation");
        try {
            this.assertUpdate(String.format("DELETE FROM %1$s WHERE EXISTS(SELECT regionkey FROM region WHERE regionkey = %1$s.regionkey AND name LIKE 'A%%')", table.getName()), 15L);
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM nation WHERE regionkey IN (SELECT regionkey FROM region WHERE name NOT LIKE 'A%')");
        }
        finally {
            table.close();
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_correlated_exists_subquery", "AS SELECT * FROM nation");
        try {
            this.assertUpdate(String.format("DELETE FROM %1$s WHERE regionkey IN (SELECT regionkey FROM region WHERE regionkey = %1$s.regionkey AND name LIKE 'A%%')", table.getName()), 15L);
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM nation WHERE regionkey IN (SELECT regionkey FROM region WHERE name NOT LIKE 'A%')");
        }
        finally {
            table.close();
        }
    }

    @Test
    public void testExplainAnalyzeWithDeleteWithSubquery() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        String tableName = "test_delete_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM nation", 25L);
        this.assertExplainAnalyze("EXPLAIN ANALYZE DELETE FROM " + tableName + " WHERE regionkey IN (SELECT regionkey FROM region WHERE name LIKE 'A%' LIMIT 1)", "SemiJoin.*");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDeleteWithSemiJoin() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_semijoin", "AS SELECT * FROM nation");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE regionkey IN (SELECT regionkey FROM region WHERE name LIKE 'A%')   AND regionkey IN (SELECT regionkey FROM region WHERE length(comment) < 50)", 10L);
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM nation WHERE regionkey IN (SELECT regionkey FROM region WHERE name NOT LIKE 'A%')   OR regionkey IN (SELECT regionkey FROM region WHERE length(comment) >= 50)");
        }
        table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_semijoin", "AS SELECT * FROM orders");
        try {
            this.assertUpdate("DELETE FROM " + table.getName() + "\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM tpch.tiny.lineitem)) IS NULL\n", "SELECT count(*) FROM orders\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM lineitem)) IS NULL\n");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders\nWHERE (orderkey IN (SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END FROM lineitem)) IS NOT NULL\n");
        }
        finally {
            table.close();
        }
    }

    @Test
    public void testDeleteWithVarcharPredicate() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_with_varchar_predicate_", "AS SELECT * FROM orders");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE orderstatus = 'O'", "SELECT count(*) FROM orders WHERE orderstatus = 'O'");
            this.assertQuery("SELECT * FROM " + table.getName(), "SELECT * FROM orders WHERE orderstatus <> 'O'");
        }
    }

    @Test
    public void verifySupportsDeleteDeclaration() {
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE)) {
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_supports_delete", "(regionkey int)");){
            this.assertQueryFails("DELETE FROM " + table.getName(), "This connector does not support modifying table rows");
        }
    }

    @Test
    public void verifySupportsRowLevelDeleteDeclaration() {
        if (this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_DELETE)) {
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_supports_row_level_delete", "(regionkey int)");){
            this.assertQueryFails("DELETE FROM " + table.getName() + " WHERE regionkey = 2", "This connector does not support modifying table rows");
        }
    }

    @Test
    public void testDeleteAllDataFromTable() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_delete_all_data", "AS SELECT * FROM region");){
            this.getQueryRunner().execute("DELETE FROM " + table.getName());
            this.assertQuery("SELECT count(*) FROM " + table.getName(), "VALUES 0");
        }
    }

    @Test
    public void testRowLevelDelete() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_LEVEL_DELETE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_row_delete", "AS SELECT * FROM region");){
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE regionkey = 2", 1L);
            this.assertQuery("SELECT count(*) FROM " + table.getName(), "VALUES 4");
        }
    }

    @Test
    public void testUpdate() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE)) {
            this.assertQueryFails("UPDATE nation SET nationkey = nationkey + regionkey WHERE regionkey < 1", "This connector does not support modifying table rows");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_update", "AS TABLE tpch.tiny.nation");){
            String tableName = table.getName();
            this.assertUpdate("UPDATE " + tableName + " SET nationkey = 100 + nationkey WHERE regionkey = 2", 5L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + tableName))).skippingTypesCheck().matches("SELECT IF(regionkey=2, nationkey + 100, nationkey) nationkey, name, regionkey, comment FROM tpch.tiny.nation");
            this.assertUpdate("UPDATE " + tableName + " SET nationkey = nationkey * 2 WHERE regionkey IN (2,3)", 10L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM " + tableName))).skippingTypesCheck().matches("SELECT CASE regionkey WHEN 2 THEN 2*(nationkey+100) WHEN 3 THEN 2*nationkey ELSE nationkey END nationkey, name, regionkey, comment FROM tpch.tiny.nation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=60000L, invocationCount=4)
    public void testUpdateRowConcurrently() throws Exception {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE)) {
            return;
        }
        int threads = 4;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_concurrent_update", IntStream.range(0, threads).mapToObj(i -> String.format("col%s integer", i)).collect(Collectors.joining(", ", "(", ")")));){
            String tableName = table.getName();
            this.assertUpdate(String.format("INSERT INTO %s VALUES (%s)", tableName, String.join((CharSequence)",", Collections.nCopies(threads, "0"))), 1L);
            List futures = (List)IntStream.range(0, threads).mapToObj(threadNumber -> executor.submit(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                try {
                    String columnName = "col" + threadNumber;
                    this.getQueryRunner().execute(String.format("UPDATE %s SET %s = %s + 1", tableName, columnName, columnName));
                    return true;
                }
                catch (Exception e) {
                    RuntimeException trinoException = QueryAssertions.getTrinoExceptionCause(e);
                    try {
                        this.verifyConcurrentUpdateFailurePermissible(trinoException);
                    }
                    catch (Throwable verifyFailure) {
                        if (verifyFailure != e) {
                            verifyFailure.addSuppressed(e);
                        }
                        throw verifyFailure;
                    }
                    return false;
                }
            })).collect(ImmutableList.toImmutableList());
            String expected = futures.stream().map(future -> (Boolean)MoreFutures.tryGetFutureValue((Future)future, (int)10, (TimeUnit)TimeUnit.SECONDS).orElseThrow(() -> new RuntimeException("Wait timed out"))).map(success -> success != false ? "1" : "0").collect(Collectors.joining(",", "VALUES (", ")"));
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("TABLE " + tableName))).matches(expected);
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
    }

    protected void verifyConcurrentUpdateFailurePermissible(Exception e) {
        throw new AssertionError("Unexpected concurrent update failure", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=60000L, invocationCount=4)
    public void testInsertRowConcurrently() throws Exception {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT)) {
            return;
        }
        int threads = 4;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        try (TestTable table = this.createTableWithOneIntegerColumn("test_insert");){
            String tableName = table.getName();
            List futures = (List)IntStream.range(0, threads).mapToObj(threadNumber -> executor.submit(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                try {
                    this.getQueryRunner().execute("INSERT INTO " + tableName + " VALUES (" + threadNumber + ")");
                    return OptionalInt.of(threadNumber);
                }
                catch (Exception e) {
                    RuntimeException trinoException = QueryAssertions.getTrinoExceptionCause(e);
                    try {
                        this.verifyConcurrentInsertFailurePermissible(trinoException);
                    }
                    catch (Throwable verifyFailure) {
                        if (verifyFailure != e) {
                            verifyFailure.addSuppressed(e);
                        }
                        throw verifyFailure;
                    }
                    return OptionalInt.empty();
                }
            })).collect(ImmutableList.toImmutableList());
            List values = (List)futures.stream().map(future -> (OptionalInt)MoreFutures.tryGetFutureValue((Future)future, (int)10, (TimeUnit)TimeUnit.SECONDS).orElseThrow(() -> new RuntimeException("Wait timed out"))).filter(OptionalInt::isPresent).map(OptionalInt::getAsInt).collect(ImmutableList.toImmutableList());
            if (values.isEmpty()) {
                this.assertQueryReturnsEmptyResult("TABLE " + tableName);
            } else {
                ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT CAST(col AS INTEGER) FROM " + tableName))).matches(values.stream().map(value -> String.format("(%s)", value)).collect(Collectors.joining(",", "VALUES ", "")));
            }
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
    }

    protected void verifyConcurrentInsertFailurePermissible(Exception e) {
        throw new AssertionError("Unexpected concurrent insert failure", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=60000L, invocationCount=4)
    public void testAddColumnConcurrently() throws Exception {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN)) {
            return;
        }
        int threads = 4;
        CyclicBarrier barrier = new CyclicBarrier(threads);
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        try (TestTable table = this.createTableWithOneIntegerColumn("test_add_column");){
            String tableName = table.getName();
            List futures = (List)IntStream.range(0, threads).mapToObj(threadNumber -> executor.submit(() -> {
                barrier.await(30L, TimeUnit.SECONDS);
                try {
                    String columnName = "col" + threadNumber;
                    this.getQueryRunner().execute("ALTER TABLE " + tableName + " ADD COLUMN " + columnName + " integer");
                    return Optional.of(columnName);
                }
                catch (Exception e) {
                    RuntimeException trinoException = QueryAssertions.getTrinoExceptionCause(e);
                    try {
                        this.verifyConcurrentAddColumnFailurePermissible(trinoException);
                    }
                    catch (Throwable verifyFailure) {
                        if (verifyFailure != e) {
                            verifyFailure.addSuppressed(e);
                        }
                        throw verifyFailure;
                    }
                    return Optional.empty();
                }
            })).collect(ImmutableList.toImmutableList());
            List addedColumns = (List)futures.stream().map(future -> (Optional)MoreFutures.tryGetFutureValue((Future)future, (int)30, (TimeUnit)TimeUnit.SECONDS).orElseThrow(() -> new RuntimeException("Wait timed out"))).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("DESCRIBE " + tableName))).projected(new String[]{"Column"}).skippingTypesCheck().matches(Stream.concat(Stream.of("col"), addedColumns.stream()).map(value -> String.format("'%s'", value)).collect(Collectors.joining(",", "VALUES ", "")));
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    protected void verifyConcurrentAddColumnFailurePermissible(Exception e) {
        throw new AssertionError("Unexpected concurrent add column failure", e);
    }

    protected TestTable createTableWithOneIntegerColumn(String namePrefix) {
        return new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), namePrefix, "(col integer)");
    }

    @Test
    public void testUpdateWithPredicates() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE)) {
            this.assertQueryFails("UPDATE nation SET nationkey = nationkey + regionkey WHERE regionkey < 1", "This connector does not support modifying table rows");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_update_with_predicates", "(a INT, b INT, c INT)");){
            String tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 2, 3), (11, 12, 13), (21, 22, 23)", 3L);
            this.assertUpdate("UPDATE " + tableName + " SET a = a - 1 WHERE c = 3", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (0, 2, 3), (11, 12, 13), (21, 22, 23)");
            this.assertUpdate("UPDATE " + tableName + " SET c = c + 1 WHERE a = 11", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (0, 2, 3), (11, 12, 14), (21, 22, 23)");
            this.assertUpdate("UPDATE " + tableName + " SET b = b * 2 WHERE b = 22", 1L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (0, 2, 3), (11, 12, 14), (21, 44, 23)");
        }
    }

    @Test
    public void testUpdateRowType() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE)) {
            this.assertQueryFails("UPDATE nation SET nationkey = nationkey + regionkey WHERE regionkey < 1", "This connector does not support modifying table rows");
            return;
        }
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_TYPE)) {
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_update_with_predicates_on_row_types", "(int_t INT, row_t ROW(f1 INT, f2 INT))");){
            String tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, ROW(2, 3)), (11, ROW(12, 13)), (21, ROW(22, 23))", 3L);
            this.assertUpdate("UPDATE " + tableName + " SET int_t = int_t - 1 WHERE row_t.f2 = 3", 1L);
            this.assertQuery("SELECT int_t, row_t.f1, row_t.f2 FROM " + tableName, "VALUES (0, 2, 3), (11, 12, 13), (21, 22, 23)");
            this.assertUpdate("UPDATE " + tableName + " SET row_t = ROW(row_t.f1, row_t.f2 + 1) WHERE int_t = 11", 1L);
            this.assertQuery("SELECT int_t, row_t.f1, row_t.f2 FROM " + tableName, "VALUES (0, 2, 3), (11, 12, 14), (21, 22, 23)");
            this.assertUpdate("UPDATE " + tableName + " SET row_t = ROW(row_t.f1 * 2, row_t.f2) WHERE row_t.f1 = 22", 1L);
            this.assertQuery("SELECT int_t, row_t.f1, row_t.f2 FROM " + tableName, "VALUES (0, 2, 3), (11, 12, 14), (21, 44, 23)");
        }
    }

    @Test
    public void testPredicateOnRowTypeField() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_TYPE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_predicate_on_row_type_field", "(int_t INT, row_t row(varchar_t VARCHAR, int_t INT))");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (2, row('first', 1)), (20, row('second', 10)), (200, row('third', 100))", 3L);
            this.assertQuery("SELECT int_t FROM " + table.getName() + " WHERE row_t.int_t = 1", "VALUES 2");
            this.assertQuery("SELECT int_t FROM " + table.getName() + " WHERE row_t.int_t > 1", "VALUES 20, 200");
            this.assertQuery("SELECT int_t FROM " + table.getName() + " WHERE int_t = 2 AND row_t.int_t = 1", "VALUES 2");
        }
    }

    @Test
    public void testUpdateAllValues() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_UPDATE)) {
            this.assertQueryFails("UPDATE nation SET nationkey = nationkey + regionkey WHERE regionkey < 1", "This connector does not support modifying table rows");
            return;
        }
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_update_all_columns", "(a INT, b INT, c INT)");){
            String tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 2, 3), (11, 12, 13), (21, 22, 23)", 3L);
            this.assertUpdate("UPDATE " + tableName + " SET a = a + 1, b = b - 1, c = c * 2", 3L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES (2, 1, 6), (12, 11, 26), (22, 21, 46)");
        }
    }

    @Test
    public void testDropTable() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String tableName = "test_drop_table_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(col bigint)");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testDropTableIfExists() {
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_drop_if_exists"));
        this.assertUpdate("DROP TABLE IF EXISTS test_drop_if_exists");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_drop_if_exists"));
    }

    @Test
    public void testTruncateTable() {
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_TRUNCATE)) {
            this.assertQueryFails("TRUNCATE TABLE nation", "This connector does not support truncating tables");
            return;
        }
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_truncate", "AS SELECT * FROM region");){
            this.assertUpdate("TRUNCATE TABLE " + table.getName());
            this.assertQuery("SELECT count(*) FROM " + table.getName(), "VALUES 0");
        }
    }

    @Test
    public void testQueryLoggingCount() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        QueryManager queryManager = this.getDistributedQueryRunner().getCoordinator().getQueryManager();
        this.executeExclusively(() -> {
            Assert.assertEventually((Duration)new Duration(1.0, TimeUnit.MINUTES), () -> org.testng.Assert.assertEquals((Collection)queryManager.getQueries().stream().map(BasicQueryInfo::getQueryId).map(arg_0 -> ((QueryManager)queryManager).getFullQueryInfo(arg_0)).filter(info -> !info.isFinalQueryInfo()).collect(Collectors.toList()), (Collection)ImmutableList.of()));
            DispatchManager dispatchManager = ((DistributedQueryRunner)this.getQueryRunner()).getCoordinator().getDispatchManager();
            long beforeCompletedQueriesCount = this.waitUntilStable(() -> dispatchManager.getStats().getCompletedQueries().getTotalCount(), new Duration(5.0, TimeUnit.SECONDS));
            long beforeSubmittedQueriesCount = dispatchManager.getStats().getSubmittedQueries().getTotalCount();
            String tableName = "test_logging_count" + TestingNames.randomNameSuffix();
            this.assertUpdate("CREATE TABLE " + tableName + this.tableDefinitionForQueryLoggingCount());
            this.assertQueryReturnsEmptyResult("SELECT foo_1, foo_2_4 FROM " + tableName);
            this.assertUpdate("DROP TABLE " + tableName);
            this.assertQueryFails("SELECT * FROM " + tableName, ".*Table .* does not exist");
            Assert.assertEventually((Duration)new Duration(1.0, TimeUnit.MINUTES), () -> org.testng.Assert.assertEquals((long)(dispatchManager.getStats().getCompletedQueries().getTotalCount() - beforeCompletedQueriesCount), (long)4L));
            org.testng.Assert.assertEquals((long)(dispatchManager.getStats().getSubmittedQueries().getTotalCount() - beforeSubmittedQueriesCount), (long)4L);
        });
    }

    @Language(value="SQL")
    protected String tableDefinitionForQueryLoggingCount() {
        return "(foo_1 int, foo_2_4 int)";
    }

    private <T> T waitUntilStable(Supplier<T> computation, Duration timeout) {
        T lastValue = computation.get();
        long start = System.nanoTime();
        while (!Thread.currentThread().isInterrupted() && Duration.nanosSince((long)start).compareTo(timeout) < 0) {
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            T currentValue = computation.get();
            if (currentValue.equals(lastValue)) {
                return currentValue;
            }
            lastValue = currentValue;
        }
        throw new UncheckedTimeoutException();
    }

    @Test
    public void testShowSchemasFromOther() {
        MaterializedResult result = this.computeActual("SHOW SCHEMAS FROM tpch");
        org.testng.Assert.assertTrue((boolean)result.getOnlyColumnAsSet().containsAll((Collection<?>)ImmutableSet.of((Object)"information_schema", (Object)"tiny", (Object)"sf1")));
    }

    @Test
    public void testSymbolAliasing() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String tableName = "test_symbol_aliasing" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 foo_1, 2 foo_2_4", 1L);
        this.assertQuery("SELECT foo_1, foo_2_4 FROM " + tableName, "SELECT 1, 2");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrittenStats() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        String tableName = "test_written_stats_" + TestingNames.randomNameSuffix();
        try {
            String sql = "CREATE TABLE " + tableName + " AS SELECT * FROM nation";
            MaterializedResultWithQueryId resultResultWithQueryId = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), sql);
            QueryInfo queryInfo = this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(resultResultWithQueryId.getQueryId());
            org.testng.Assert.assertEquals((long)queryInfo.getQueryStats().getOutputPositions(), (long)1L);
            org.testng.Assert.assertEquals((long)queryInfo.getQueryStats().getWrittenPositions(), (long)25L);
            org.testng.Assert.assertTrue((queryInfo.getQueryStats().getLogicalWrittenDataSize().toBytes() > 0L ? 1 : 0) != 0);
            sql = "INSERT INTO " + tableName + " SELECT * FROM nation LIMIT 10";
            resultResultWithQueryId = this.getDistributedQueryRunner().executeWithQueryId(this.getSession(), sql);
            queryInfo = this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(resultResultWithQueryId.getQueryId());
            org.testng.Assert.assertEquals((long)queryInfo.getQueryStats().getOutputPositions(), (long)1L);
            org.testng.Assert.assertEquals((long)queryInfo.getQueryStats().getWrittenPositions(), (long)10L);
            org.testng.Assert.assertTrue((queryInfo.getQueryStats().getLogicalWrittenDataSize().toBytes() > 0L ? 1 : 0) != 0);
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrittenDataSize() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        AtomicBoolean isReportingWrittenBytesSupported = new AtomicBoolean();
        TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (AccessControl)this.getQueryRunner().getAccessControl()).singleStatement().execute(this.getSession(), session -> {
            String catalogName = (String)session.getCatalog().orElseThrow();
            TestingTrinoServer coordinator = this.getDistributedQueryRunner().getCoordinator();
            Map properties = coordinator.getTablePropertyManager().getProperties(catalogName, (CatalogHandle)coordinator.getMetadata().getCatalogHandle(session, catalogName).orElseThrow(), List.of(), session, null, (AccessControl)new AllowAllAccessControl(), Map.of(), true);
            QualifiedObjectName fullTableName = new QualifiedObjectName(catalogName, "any", "any");
            isReportingWrittenBytesSupported.set(coordinator.getMetadata().supportsReportingWrittenBytes(session, fullTableName, properties));
        });
        String tableName = "write_stats_" + TestingNames.randomNameSuffix();
        try {
            String query = "CREATE TABLE " + tableName + " AS SELECT * FROM tpch.tiny.nation";
            this.assertQueryStats(this.getSession(), query, queryStats -> {
                if (isReportingWrittenBytesSupported.get()) {
                    Assertions.assertThat((long)queryStats.getPhysicalWrittenDataSize().toBytes()).isPositive();
                } else {
                    Assertions.assertThat((long)queryStats.getPhysicalWrittenDataSize().toBytes()).isZero();
                }
            }, results -> {});
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Test
    public void testNoDataSystemTable() {
        this.assertQuerySucceeds("TABLE nation");
        this.assertQueryFails("TABLE \"nation$data\"", "line 1:1: Table '\\w+.\\w+.nation\\$data' does not exist");
    }

    @Test(dataProvider="testColumnNameDataProvider")
    public void testColumnName(String columnName) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        if (!BaseConnectorTest.requiresDelimiting(columnName)) {
            this.testColumnName(columnName, false);
        }
        this.testColumnName(columnName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testColumnName(String columnName, boolean delimited) {
        String nameInSql = BaseConnectorTest.toColumnNameInSql(columnName, delimited);
        String tableName = "tcn_" + nameInSql.toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]", "") + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("CREATE TABLE " + tableName + "(key varchar(50), " + nameInSql + " varchar(50))");
        }
        catch (RuntimeException e) {
            if (this.isColumnNameRejected(e, columnName, delimited)) {
                return;
            }
            throw e;
        }
        try {
            this.assertUpdate("INSERT INTO " + tableName + " VALUES ('null value', NULL), ('sample value', 'abc'), ('other value', 'xyz')", 3L);
            this.assertQuery("SELECT * FROM " + tableName, "VALUES ('null value', NULL), ('sample value', 'abc'), ('other value', 'xyz')");
            this.assertQuery("SELECT " + nameInSql + " FROM " + tableName, "VALUES (NULL), ('abc'), ('xyz')");
            this.assertQuery("SELECT key FROM " + tableName + " WHERE " + nameInSql + " IS NULL", "VALUES ('null value')");
            this.assertQuery("SELECT key FROM " + tableName + " WHERE " + nameInSql + " = 'abc'", "VALUES ('sample value')");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    @Test(dataProvider="testColumnNameDataProvider")
    public void testAddAndDropColumnName(String columnName) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_DROP_COLUMN));
        if (!BaseConnectorTest.requiresDelimiting(columnName)) {
            this.testAddAndDropColumnName(columnName, false);
        }
        this.testAddAndDropColumnName(columnName, true);
    }

    protected void testAddAndDropColumnName(String columnName, boolean delimited) {
        String nameInSql = BaseConnectorTest.toColumnNameInSql(columnName, delimited);
        String tableName = "tcn_" + nameInSql.toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]", "") + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate(this.createTableSqlForAddingAndDroppingColumn(tableName, nameInSql));
        }
        catch (RuntimeException e) {
            if (this.isColumnNameRejected(e, columnName, delimited)) {
                return;
            }
            throw e;
        }
        this.assertTableColumnNames(tableName, columnName.toLowerCase(Locale.ENGLISH), "value");
        this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN " + nameInSql);
        this.assertTableColumnNames(tableName, "value");
        this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN " + nameInSql + " varchar(50)");
        this.assertTableColumnNames(tableName, "value", columnName.toLowerCase(Locale.ENGLISH));
        this.assertUpdate("DROP TABLE " + tableName);
    }

    protected String createTableSqlForAddingAndDroppingColumn(String tableName, String columnNameInSql) {
        return "CREATE TABLE " + tableName + "(" + columnNameInSql + " varchar(50), value varchar(50))";
    }

    @Test(dataProvider="testColumnNameDataProvider")
    public void testRenameColumnName(String columnName) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_RENAME_COLUMN));
        if (!BaseConnectorTest.requiresDelimiting(columnName)) {
            this.testRenameColumnName(columnName, false);
        }
        this.testRenameColumnName(columnName, true);
    }

    protected void testRenameColumnName(String columnName, boolean delimited) {
        String nameInSql = BaseConnectorTest.toColumnNameInSql(columnName, delimited);
        String tableName = "tcn_" + nameInSql.replaceAll("[^a-z0-9]", "") + TestingNames.randomNameSuffix();
        String sourceColumnName = "a;b$c";
        try {
            this.assertUpdate("CREATE TABLE " + tableName + "(\"" + sourceColumnName + "\" varchar(50))");
            this.assertTableColumnNames(tableName, sourceColumnName);
            this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN \"" + sourceColumnName + "\" TO " + nameInSql);
            this.assertTableColumnNames(tableName, columnName.toLowerCase(Locale.ENGLISH));
        }
        catch (RuntimeException e) {
            if (this.isColumnNameRejected(e, columnName, delimited)) {
                return;
            }
            throw e;
        }
        this.assertUpdate("DROP TABLE " + tableName);
    }

    private static String toColumnNameInSql(String columnName, boolean delimited) {
        Object nameInSql = columnName;
        if (delimited) {
            nameInSql = "\"" + columnName.replace("\"", "\"\"") + "\"";
        }
        return nameInSql;
    }

    protected boolean isColumnNameRejected(Exception exception, String columnName, boolean delimited) {
        return false;
    }

    protected static boolean requiresDelimiting(String identifierName) {
        return !identifierName.matches("[a-zA-Z][a-zA-Z0-9_]*");
    }

    @DataProvider
    public Object[][] testColumnNameDataProvider() {
        return (Object[][])this.testColumnNameTestData().stream().map(this::filterColumnNameTestData).filter(Optional::isPresent).map(Optional::get).collect(DataProviders.toDataProvider());
    }

    private List<String> testColumnNameTestData() {
        return ImmutableList.builder().add((Object)"lowercase").add((Object)"UPPERCASE").add((Object)"MixedCase").add((Object)"an_underscore").add((Object)"a-hyphen-minus").add((Object)"a space").add((Object)"atrailingspace ").add((Object)" aleadingspace").add((Object)"a.dot").add((Object)"a,comma").add((Object)"a:colon").add((Object)"a;semicolon").add((Object)"an@at").add((Object)"a\"quote").add((Object)"an'apostrophe").add((Object)"a`backtick`").add((Object)"a/slash`").add((Object)"a\\backslash`").add((Object)"adigit0").add((Object)"0startwithdigit").build();
    }

    protected Optional<String> filterColumnNameTestData(String columnName) {
        return Optional.of(columnName);
    }

    protected String dataMappingTableName(String trinoTypeName) {
        return "test_data_mapping_smoke_" + trinoTypeName.replaceAll("[^a-zA-Z0-9]", "_") + TestingNames.randomNameSuffix();
    }

    @Test(dataProvider="testCommentDataProvider")
    public void testCreateTableWithTableCommentSpecialCharacter(String comment) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_TABLE_COMMENT));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_create_", "(a bigint) COMMENT " + BaseConnectorTest.varcharLiteral(comment));){
            org.testng.Assert.assertEquals((String)this.getTableComment((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), table.getName()), (String)comment);
        }
    }

    @Test(dataProvider="testCommentDataProvider")
    public void testCreateTableAsSelectWithTableCommentSpecialCharacter(String comment) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_TABLE_COMMENT));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_create_", " COMMENT " + BaseConnectorTest.varcharLiteral(comment) + " AS SELECT 1 a");){
            org.testng.Assert.assertEquals((String)this.getTableComment((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), table.getName()), (String)comment);
        }
    }

    @Test(dataProvider="testCommentDataProvider")
    public void testCreateTableWithColumnCommentSpecialCharacter(String comment) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_COLUMN_COMMENT));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_create_", " (a bigint COMMENT " + BaseConnectorTest.varcharLiteral(comment) + ")");){
            org.testng.Assert.assertEquals((String)this.getColumnComment(table.getName(), "a"), (String)comment);
        }
    }

    @Test(dataProvider="testCommentDataProvider")
    public void testAddColumnWithCommentSpecialCharacter(String comment) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ADD_COLUMN_WITH_COMMENT));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_add_col_", "(a_varchar varchar)");){
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN b_varchar varchar COMMENT " + BaseConnectorTest.varcharLiteral(comment));
            org.testng.Assert.assertEquals((String)this.getColumnComment(table.getName(), "b_varchar"), (String)comment);
        }
    }

    @Test(dataProvider="testCommentDataProvider")
    public void testCommentTableSpecialCharacter(String comment) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_TABLE));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_table_", "(a integer)");){
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS " + BaseConnectorTest.varcharLiteral(comment));
            org.testng.Assert.assertEquals((String)this.getTableComment((String)this.getSession().getCatalog().orElseThrow(), (String)this.getSession().getSchema().orElseThrow(), table.getName()), (String)comment);
        }
    }

    @Test(dataProvider="testCommentDataProvider")
    public void testCommentColumnSpecialCharacter(String comment) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_COMMENT_ON_COLUMN));
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_comment_column_", "(a integer)");){
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".a IS " + BaseConnectorTest.varcharLiteral(comment));
            org.testng.Assert.assertEquals((String)this.getColumnComment(table.getName(), "a"), (String)comment);
        }
    }

    @DataProvider
    public Object[][] testCommentDataProvider() {
        return new Object[][]{{"a;semicolon"}, {"an@at"}, {"a\"quote"}, {"an'apostrophe"}, {"a`backtick`"}, {"a/slash"}, {"a\\backslash"}, {"a?question"}, {"[square bracket]"}};
    }

    protected static String varcharLiteral(String value) {
        Objects.requireNonNull(value, "value is null");
        return "'" + value.replace("'", "''") + "'";
    }

    @Test(dataProvider="testDataMappingSmokeTestDataProvider")
    public void testDataMappingSmokeTest(DataMappingTestSetup dataMappingTestSetup) {
        this.testDataMapping(dataMappingTestSetup);
    }

    private void testDataMapping(DataMappingTestSetup dataMappingTestSetup) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE));
        String trinoTypeName = dataMappingTestSetup.getTrinoTypeName();
        String sampleValueLiteral = dataMappingTestSetup.getSampleValueLiteral();
        String highValueLiteral = dataMappingTestSetup.getHighValueLiteral();
        String tableName = this.dataMappingTableName(trinoTypeName);
        Runnable setup = () -> {
            String createTable = "CREATE TABLE " + tableName + " AS SELECT CAST(row_id AS varchar(50)) row_id, CAST(value AS " + trinoTypeName + ") value, CAST(value AS " + trinoTypeName + ") another_column FROM (VALUES   ('null value', NULL),   ('sample value', " + sampleValueLiteral + "),   ('high value', " + highValueLiteral + "))  t(row_id, value)";
            this.assertUpdate(createTable, 3L);
        };
        if (dataMappingTestSetup.isUnsupportedType()) {
            Assertions.assertThatThrownBy(setup::run).satisfies(new ThrowingConsumer[]{exception -> this.verifyUnsupportedTypeException((Throwable)exception, trinoTypeName)});
            return;
        }
        setup.run();
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE rand() = 42 OR value IS NULL", "VALUES 'null value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE rand() = 42 OR value IS NOT NULL", "VALUES 'sample value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE rand() = 42 OR value = " + sampleValueLiteral, "VALUES 'sample value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE rand() = 42 OR value = " + highValueLiteral, "VALUES 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL", "VALUES 'null value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NOT NULL", "VALUES 'sample value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value = " + sampleValueLiteral, "VALUES 'sample value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value != " + sampleValueLiteral, "VALUES 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value <= " + sampleValueLiteral, "VALUES 'sample value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value > " + sampleValueLiteral, "VALUES 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value <= " + highValueLiteral, "VALUES 'sample value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL OR value = " + sampleValueLiteral, "VALUES 'null value', 'sample value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL OR value != " + sampleValueLiteral, "VALUES 'null value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL OR value <= " + sampleValueLiteral, "VALUES 'null value', 'sample value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL OR value > " + sampleValueLiteral, "VALUES 'null value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value IS NULL OR value <= " + highValueLiteral, "VALUES 'null value', 'sample value', 'high value'");
        this.assertQuery("SELECT row_id FROM " + tableName + " WHERE value = " + sampleValueLiteral + " OR another_column = " + sampleValueLiteral, "VALUES 'sample value'");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @DataProvider
    public final Object[][] testDataMappingSmokeTestDataProvider() {
        return (Object[][])this.testDataMappingSmokeTestData().stream().map(this::filterDataMappingSmokeTestData).flatMap(Optional::stream).collect(DataProviders.toDataProvider());
    }

    private List<DataMappingTestSetup> testDataMappingSmokeTestData() {
        return ImmutableList.builder().add((Object)new DataMappingTestSetup("boolean", "false", "true")).add((Object)new DataMappingTestSetup("tinyint", "37", "127")).add((Object)new DataMappingTestSetup("smallint", "32123", "32767")).add((Object)new DataMappingTestSetup("integer", "1274942432", "2147483647")).add((Object)new DataMappingTestSetup("bigint", "312739231274942432", "9223372036854775807")).add((Object)new DataMappingTestSetup("real", "REAL '567.123'", "REAL '999999.999'")).add((Object)new DataMappingTestSetup("double", "DOUBLE '1234567890123.123'", "DOUBLE '9999999999999.999'")).add((Object)new DataMappingTestSetup("decimal(5,3)", "12.345", "99.999")).add((Object)new DataMappingTestSetup("decimal(15,3)", "123456789012.345", "999999999999.99")).add((Object)new DataMappingTestSetup("date", "DATE '0001-01-01'", "DATE '1582-10-04'")).add((Object)new DataMappingTestSetup("date", "DATE '1582-10-05'", "DATE '1582-10-14'")).add((Object)new DataMappingTestSetup("date", "DATE '2020-02-12'", "DATE '9999-12-31'")).add((Object)new DataMappingTestSetup("time", "TIME '15:03:00'", "TIME '23:59:59.999'")).add((Object)new DataMappingTestSetup("time(6)", "TIME '15:03:00'", "TIME '23:59:59.999999'")).add((Object)new DataMappingTestSetup("timestamp", "TIMESTAMP '1969-12-31 15:03:00.123'", "TIMESTAMP '1969-12-31 17:03:00.456'")).add((Object)new DataMappingTestSetup("timestamp", "TIMESTAMP '2020-02-12 15:03:00'", "TIMESTAMP '2199-12-31 23:59:59.999'")).add((Object)new DataMappingTestSetup("timestamp(6)", "TIMESTAMP '1969-12-31 15:03:00.123456'", "TIMESTAMP '1969-12-31 17:03:00.123456'")).add((Object)new DataMappingTestSetup("timestamp(6)", "TIMESTAMP '2020-02-12 15:03:00'", "TIMESTAMP '2199-12-31 23:59:59.999999'")).add((Object)new DataMappingTestSetup("timestamp(3) with time zone", "TIMESTAMP '1969-12-31 15:03:00.123 +01:00'", "TIMESTAMP '1969-12-31 17:03:00.456 +01:00'")).add((Object)new DataMappingTestSetup("timestamp(3) with time zone", "TIMESTAMP '2020-02-12 15:03:00 +01:00'", "TIMESTAMP '9999-12-31 23:59:59.999 +12:00'")).add((Object)new DataMappingTestSetup("timestamp(6) with time zone", "TIMESTAMP '1969-12-31 15:03:00.123456 +01:00'", "TIMESTAMP '1969-12-31 17:03:00.123456 +01:00'")).add((Object)new DataMappingTestSetup("timestamp(6) with time zone", "TIMESTAMP '2020-02-12 15:03:00 +01:00'", "TIMESTAMP '9999-12-31 23:59:59.999999 +12:00'")).add((Object)new DataMappingTestSetup("char(3)", "'ab'", "'zzz'")).add((Object)new DataMappingTestSetup("varchar(3)", "'de'", "'zzz'")).add((Object)new DataMappingTestSetup("varchar", "'\u0142\u0105ka for the win'", "'\u017b\u017b\u017b\u017b\u017b\u017b\u017b\u017b\u017b\u017b'")).add((Object)new DataMappingTestSetup("varchar", "'a \\backslash'", "'a a'")).add((Object)new DataMappingTestSetup("varchar", "'end backslash \\'", "'end backslash a'")).add((Object)new DataMappingTestSetup("varchar", "U&'a \\000a newline'", "'a a'")).add((Object)new DataMappingTestSetup("varbinary", "X'12ab3f'", "X'ffffffffffffffffffff'")).build();
    }

    protected Optional<DataMappingTestSetup> filterDataMappingSmokeTestData(DataMappingTestSetup dataMappingTestSetup) {
        return Optional.of(dataMappingTestSetup);
    }

    @Test(dataProvider="testCaseSensitiveDataMappingProvider")
    public void testCaseSensitiveDataMapping(DataMappingTestSetup dataMappingTestSetup) {
        this.testDataMapping(dataMappingTestSetup);
    }

    @DataProvider
    public final Object[][] testCaseSensitiveDataMappingProvider() {
        return (Object[][])this.testCaseSensitiveDataMappingData().stream().map(this::filterCaseSensitiveDataMappingTestData).flatMap(Optional::stream).collect(DataProviders.toDataProvider());
    }

    protected Optional<DataMappingTestSetup> filterCaseSensitiveDataMappingTestData(DataMappingTestSetup dataMappingTestSetup) {
        return Optional.of(dataMappingTestSetup);
    }

    private List<DataMappingTestSetup> testCaseSensitiveDataMappingData() {
        return ImmutableList.builder().add((Object)new DataMappingTestSetup("char(1)", "'A'", "'a'")).add((Object)new DataMappingTestSetup("varchar(1)", "'A'", "'a'")).add((Object)new DataMappingTestSetup("char(1)", "'A'", "'b'")).add((Object)new DataMappingTestSetup("varchar(1)", "'A'", "'b'")).add((Object)new DataMappingTestSetup("char(1)", "'B'", "'a'")).add((Object)new DataMappingTestSetup("varchar(1)", "'B'", "'a'")).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPotentialDuplicateDereferencePushdown() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        String tableName = "test_dup_deref_" + TestingNames.randomNameSuffix();
        String createTable = "CREATE TABLE " + tableName + " AS SELECT CAST(ROW('abc', 1) AS row(a varchar, b bigint)) r";
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_ROW_TYPE)) {
            try {
                this.assertUpdate(createTable);
            }
            catch (Exception expected) {
                this.verifyUnsupportedTypeException(expected, "row(a varchar, b bigint)");
                return;
            }
            this.assertUpdate("DROP TABLE " + tableName);
            org.testng.Assert.fail((String)"Expected create table failure");
        }
        this.assertUpdate(createTable, 1L);
        try {
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r, r.b + 2 FROM " + tableName))).matches("SELECT CAST(ROW('abc', 1) AS ROW(a varchar, b bigint)), BIGINT '3'");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r[1], r[2], r.b + 2 FROM " + tableName))).matches("VALUES (VARCHAR 'abc', BIGINT '1', BIGINT '3')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r[2], r.b + 2 FROM " + tableName))).matches("VALUES (BIGINT '1', BIGINT '3')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r.b, r.b + 2 FROM " + tableName))).matches("VALUES (BIGINT '1', BIGINT '3')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r, r.a LIKE '%c' FROM " + tableName))).matches("SELECT CAST(ROW('abc', 1) AS ROW(a varchar, b bigint)), true");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r[1], r[2], r.a LIKE '%c' FROM " + tableName))).matches("VALUES (VARCHAR 'abc', BIGINT '1', true)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r[1], r.a LIKE '%c' FROM " + tableName))).matches("VALUES (VARCHAR 'abc', true)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT r.a, r.a LIKE '%c' FROM " + tableName))).matches("VALUES (VARCHAR 'abc', true)");
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    @Test
    public void testMergeDeleteWithCTAS() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_TABLE_WITH_DATA));
        String target = "merge_target_with_ctas_" + TestingNames.randomNameSuffix();
        String source = "merge_source_with_ctas_" + TestingNames.randomNameSuffix();
        String createTableSql = "CREATE TABLE %s AS\nSELECT * FROM (\n        VALUES\n        (1, 'a', 'aa'),\n        (2, 'b', 'bb'),\n        (3, 'c', 'cc'),\n        (4, 'd', 'dd')\n) AS t (id, name, value)\n";
        this.assertUpdate(createTableSql.formatted(target), 4L);
        this.assertUpdate(createTableSql.formatted(source), 4L);
        this.assertQuery("SELECT COUNT(*) FROM " + target, "VALUES 4");
        this.assertUpdate("DELETE FROM %s WHERE id IN (SELECT id FROM %s WHERE id > 2)".formatted(target, source), 2L);
        this.assertQuery("SELECT * FROM " + target, "VALUES (1, 'a', 'aa'), (2, 'b', 'bb')");
        this.assertUpdate("MERGE INTO %s t USING %s s ON (t.id = s.id) WHEN MATCHED AND s.id > 1 THEN DELETE".formatted(target, source), 1L);
        this.assertQuery("SELECT * FROM " + target, "VALUES (1, 'a', 'aa')");
        this.assertUpdate("DROP TABLE " + target);
        this.assertUpdate("DROP TABLE " + source);
    }

    protected String createTableForWrites(String createTable) {
        return createTable;
    }

    @Test
    public void testMergeLarge() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_INSERT));
        String tableName = "test_merge_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (orderkey BIGINT, custkey BIGINT, totalprice DOUBLE)", tableName)));
        this.assertUpdate(String.format("INSERT INTO %s SELECT orderkey, custkey, totalprice FROM tpch.sf1.orders", tableName), (Long)this.computeScalar("SELECT count(*) FROM tpch.sf1.orders"));
        String mergeSql = "MERGE INTO " + tableName + " t USING (SELECT * FROM tpch.sf1.orders) s ON (t.orderkey = s.orderkey)\nWHEN MATCHED AND mod(s.orderkey, 3) = 0 THEN UPDATE SET totalprice = t.totalprice + s.totalprice\nWHEN MATCHED AND mod(s.orderkey, 3) = 1 THEN DELETE";
        this.assertUpdate(mergeSql, 1000000L);
        this.assertQuery("SELECT count(*) FROM " + tableName + " WHERE mod(orderkey, 3) = 1", "SELECT 0");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT count(*), cast(sum(totalprice) AS decimal(18,2)) FROM " + tableName + " WHERE mod(orderkey, 3) = 2"))).matches("SELECT count(*), cast(sum(totalprice) AS decimal(18,2)) FROM tpch.sf1.orders WHERE mod(orderkey, 3) = 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT count(*), cast(sum(totalprice) AS decimal(18,2)) FROM " + tableName + " WHERE mod(orderkey, 3) = 0"))).matches("SELECT count(*), cast(sum(totalprice * 2) AS decimal(18,2)) FROM tpch.sf1.orders WHERE mod(orderkey, 3) = 0");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testMergeSimpleSelect() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_simple_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_simple_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), 4L);
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", sourceTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 6, 'Arches'), ('Ed', 7, 'Etherville'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire')", sourceTable), 4L);
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purchases = s.purchases + t.purchases, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)", 4L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Arches'), ('Ed', 7, 'Etherville'), ('Bill', 7, 'Buena'), ('Dave', 22, 'Darbyshire')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeFruits() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_various_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_various_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchase VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchase) VALUES ('Dave', 'dates'), ('Lou', 'limes'), ('Carol', 'candles')", targetTable), 3L);
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchase VARCHAR)", sourceTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchase) VALUES ('Craig', 'candles'), ('Len', 'limes'), ('Joe', 'jellybeans')", sourceTable), 3L);
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s ON (t.purchase = s.purchase)", targetTable, sourceTable) + "    WHEN MATCHED AND s.purchase = 'limes' THEN DELETE    WHEN MATCHED THEN UPDATE SET customer = CONCAT(t.customer, '_', s.customer)    WHEN NOT MATCHED THEN INSERT (customer, purchase) VALUES(s.customer, s.purchase)", 3L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Dave', 'dates'), ('Carol_Craig', 'candles'), ('Joe', 'jellybeans')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeMultipleOperations() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        int targetCustomerCount = 32;
        String targetTable = "merge_multiple_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, zipcode INT, spouse VARCHAR, address VARCHAR)", targetTable)));
        String originalInsertFirstHalf = IntStream.range(1, targetCustomerCount / 2).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jan_%s', '%s Poe Ct')", intValue, 1000, 91000, intValue, intValue)).collect(Collectors.joining(", "));
        String originalInsertSecondHalf = IntStream.range(targetCustomerCount / 2, targetCustomerCount).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jan_%s', '%s Poe Ct')", intValue, 2000, 92000, intValue, intValue)).collect(Collectors.joining(", "));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, zipcode, spouse, address) VALUES %s, %s", targetTable, originalInsertFirstHalf, originalInsertSecondHalf), targetCustomerCount - 1);
        String firstMergeSource = IntStream.range(targetCustomerCount / 2, targetCustomerCount).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jill_%s', '%s Eop Ct')", intValue, 3000, 83000, intValue, intValue)).collect(Collectors.joining(", "));
        this.assertUpdate(String.format("MERGE INTO %s t USING (VALUES %s) AS s(customer, purchases, zipcode, spouse, address)", targetTable, firstMergeSource) + "    ON t.customer = s.customer    WHEN MATCHED THEN UPDATE SET purchases = s.purchases, zipcode = s.zipcode, spouse = s.spouse, address = s.address", targetCustomerCount / 2);
        this.assertQuery("SELECT customer, purchases, zipcode, spouse, address FROM " + targetTable, String.format("VALUES %s, %s", originalInsertFirstHalf, firstMergeSource));
        String nextInsert = IntStream.range(targetCustomerCount, targetCustomerCount * 3 / 2).mapToObj(intValue -> String.format("('jack_%s', %s, %s, 'jan_%s', '%s Poe Ct')", intValue, 4000, 74000, intValue, intValue)).collect(Collectors.joining(", "));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, zipcode, spouse, address) VALUES %s", targetTable, nextInsert), targetCustomerCount / 2);
        String secondMergeSource = IntStream.range(1, targetCustomerCount * 3 / 2).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jen_%s', '%s Poe Ct')", intValue, 5000, 85000, intValue, intValue)).collect(Collectors.joining(", "));
        this.assertUpdate(String.format("MERGE INTO %s t USING (VALUES %s) AS s(customer, purchases, zipcode, spouse, address)", targetTable, secondMergeSource) + "    ON t.customer = s.customer    WHEN MATCHED AND t.zipcode = 91000 THEN DELETE    WHEN MATCHED AND s.zipcode = 85000 THEN UPDATE SET zipcode = 60000    WHEN MATCHED THEN UPDATE SET zipcode = s.zipcode, spouse = s.spouse, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchases, zipcode, spouse, address) VALUES(s.customer, s.purchases, s.zipcode, s.spouse, s.address)", targetCustomerCount * 3 / 2 - 1);
        String updatedBeginning = IntStream.range(targetCustomerCount / 2, targetCustomerCount).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jill_%s', '%s Eop Ct')", intValue, 3000, 60000, intValue, intValue)).collect(Collectors.joining(", "));
        String updatedMiddle = IntStream.range(targetCustomerCount, targetCustomerCount * 3 / 2).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jen_%s', '%s Poe Ct')", intValue, 5000, 85000, intValue, intValue)).collect(Collectors.joining(", "));
        String updatedEnd = IntStream.range(targetCustomerCount, targetCustomerCount * 3 / 2).mapToObj(intValue -> String.format("('jack_%s', %s, %s, 'jan_%s', '%s Poe Ct')", intValue, 4000, 74000, intValue, intValue)).collect(Collectors.joining(", "));
        this.assertQuery("SELECT customer, purchases, zipcode, spouse, address FROM " + targetTable, String.format("VALUES %s, %s, %s", updatedBeginning, updatedMiddle, updatedEnd));
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeSimpleQuery() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_query_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), 4L);
        this.assertUpdate(String.format("MERGE INTO %s t USING ", targetTable) + "(VALUES ('Aaron', 6, 'Arches'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire'), ('Ed', 7, 'Etherville')) AS s(customer, purchases, address) ON (t.customer = s.customer)    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purchases = s.purchases + t.purchases, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)", 4L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Arches'), ('Bill', 7, 'Buena'), ('Dave', 22, 'Darbyshire'), ('Ed', 7, 'Etherville')");
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeAllInserts() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_inserts_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 11, 'Antioch'), ('Bill', 7, 'Buena')", targetTable), 2L);
        this.assertUpdate(String.format("MERGE INTO %s t USING ", targetTable) + "(VALUES ('Carol', 9, 'Centreville'), ('Dave', 22, 'Darbyshire')) AS s(customer, purchases, address) ON (t.customer = s.customer)    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)", 2L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 9, 'Centreville'), ('Dave', 22, 'Darbyshire')");
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeFalseJoinCondition() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_join_false_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 11, 'Antioch'), ('Bill', 7, 'Buena')", targetTable), 2L);
        this.assertUpdate("MERGE INTO %s t USING (VALUES ('Carol', 9, 'Centreville')) AS s(customer, purchases, address)\n  ON (FALSE)\n    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)\n".formatted(targetTable), 1L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 9, 'Centreville')");
        this.assertUpdate("MERGE INTO %s t USING (VALUES ('Dave', 22, 'Darbyshire')) AS s(customer, purchases, address)\n  ON (t.customer != t.customer)\n    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)\n".formatted(targetTable), 1L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 9, 'Centreville'), ('Dave', 22, 'Darbyshire')");
        this.assertUpdate("MERGE INTO %s t USING (VALUES ('Ed', 7, 'Etherville')) AS s(customer, purchases, address)\n  ON (23 - (12 + 10) > 1)\n    WHEN MATCHED THEN UPDATE SET customer = concat(s.customer, '_fooled_you')\n    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)\n".formatted(targetTable), 1L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 9, 'Centreville'), ('Dave', 22, 'Darbyshire'), ('Ed', 7, 'Etherville')");
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeAllColumnsUpdated() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_all_columns_updated_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_all_columns_updated_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Dave', 11, 'Devon'), ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge')", targetTable), 4L);
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", sourceTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Dave', 11, 'Darbyshire'), ('Aaron', 6, 'Arches'), ('Carol', 9, 'Centreville'), ('Ed', 7, 'Etherville')", sourceTable), 4L);
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED THEN UPDATE SET customer = CONCAT(t.customer, '_updated'), purchases = s.purchases + t.purchases, address = s.address", 3L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Dave_updated', 22, 'Darbyshire'), ('Aaron_updated', 11, 'Arches'), ('Bill', 7, 'Buena'), ('Carol_updated', 12, 'Centreville')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeAllMatchesDeleted() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_all_matches_deleted_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_all_matches_deleted_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), 4L);
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", sourceTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 6, 'Arches'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire'), ('Ed', 7, 'Etherville')", sourceTable), 4L);
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED THEN DELETE", 3L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Bill', 7, 'Buena')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeMultipleRowsMatchFails() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_multiple_fail_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_multiple_fail_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Antioch')", targetTable), 2L);
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (id INT, customer VARCHAR, purchases INT, address VARCHAR)", sourceTable)));
        this.assertUpdate(String.format("INSERT INTO %s (id, customer, purchases, address) VALUES (1, 'Aaron', 6, 'Adelphi'), (2, 'Aaron', 8, 'Ashland')", sourceTable), 2L);
        this.assertQueryFails(String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED THEN UPDATE SET address = s.address", "One MERGE target table row matched more than one source row");
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED AND s.address = 'Adelphi' THEN UPDATE SET address = s.address", 1L);
        this.assertQuery("SELECT customer, purchases, address FROM " + targetTable, "VALUES ('Aaron', 5, 'Adelphi'), ('Bill', 7, 'Antioch')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeQueryWithStrangeCapitalization() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_strange_capitalization_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), 4L);
        this.assertUpdate(String.format("MERGE INTO %s t USING ", targetTable.toUpperCase(Locale.ENGLISH)) + "(VALUES ('Aaron', 6, 'Arches'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire'), ('Ed', 7, 'Etherville')) AS s(customer, purchases, address)ON (t.customer = s.customer)    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purCHases = s.PurchaseS + t.pUrchases, aDDress = s.addrESs    WHEN NOT MATCHED THEN INSERT (CUSTOMER, purchases, addRESS) VALUES(s.custoMer, s.Purchases, s.ADDress)", 4L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Arches'), ('Bill', 7, 'Buena'), ('Dave', 22, 'Darbyshire'), ('Ed', 7, 'Etherville')");
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeWithoutTablesAliases() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "test_without_aliases_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "test_without_aliases_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), 4L);
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", sourceTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 6, 'Arches'), ('Ed', 7, 'Etherville'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire')", sourceTable), 4L);
        this.assertUpdate(String.format("MERGE INTO %s USING %s", targetTable, sourceTable) + String.format(" ON (%s.customer = %s.customer)", targetTable, sourceTable) + String.format("    WHEN MATCHED AND %s.address = 'Centreville' THEN DELETE", sourceTable) + String.format("    WHEN MATCHED THEN UPDATE SET purchases = %s.pURCHases + %s.pUrchases, aDDress = %s.addrESs", sourceTable, targetTable, sourceTable) + String.format("    WHEN NOT MATCHED THEN INSERT (cusTomer, purchases, addRESS) VALUES(%s.custoMer, %s.Purchases, %s.ADDress)", sourceTable, sourceTable, sourceTable), 4L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Arches'), ('Bill', 7, 'Buena'), ('Dave', 22, 'Darbyshire'), ('Ed', 7, 'Etherville')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeWithUnpredictablePredicates() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_predicates_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_predicates_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (id INT, customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (id, customer, purchases, address) VALUES (1, 'Aaron', 5, 'Antioch'), (2, 'Bill', 7, 'Buena'), (3, 'Carol', 3, 'Cambridge'), (4, 'Dave', 11, 'Devon')", targetTable), 4L);
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (id INT, customer VARCHAR, purchases INT, address VARCHAR)", sourceTable)));
        this.assertUpdate(String.format("INSERT INTO %s (id, customer, purchases, address) VALUES (5, 'Aaron', 6, 'Arches'), (6, 'Carol', 9, 'Centreville'), (7, 'Dave', 11, 'Darbyshire'), (8, 'Ed', 7, 'Etherville')", sourceTable), 4L);
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s", targetTable, sourceTable) + " ON t.customer = s.customer AND s.purchases < 10.2    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purchases = s.purchases + t.purchases, address = s.address    WHEN NOT MATCHED THEN INSERT (id, customer, purchases, address) VALUES (s.id, s.customer, s.purchases, s.address)", 4L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES (1, 'Aaron', 11, 'Arches'), (2, 'Bill', 7, 'Buena'), (7, 'Dave', 11, 'Darbyshire'), (4, 'Dave', 11, 'Devon'), (8, 'Ed', 7, 'Etherville')");
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s", targetTable, sourceTable) + " ON t.customer = s.customer    WHEN MATCHED AND t.address <> 'Darbyshire' AND s.purchases * 2 > 20        THEN DELETE    WHEN MATCHED        THEN UPDATE SET purchases = s.purchases + t.purchases, address = concat(t.address, '/', s.address)    WHEN NOT MATCHED        THEN INSERT (id, customer, purchases, address) VALUES (s.id, s.customer, s.purchases, s.address)", 5L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES (1, 'Aaron', 17, 'Arches/Arches'), (2, 'Bill', 7, 'Buena'), (6, 'Carol', 9, 'Centreville'), (7, 'Dave', 22, 'Darbyshire/Darbyshire'), (8, 'Ed', 14, 'Etherville/Etherville')");
        this.assertUpdate(String.format("INSERT INTO %s (id, customer, purchases, address) VALUES (9, 'Fred', 30, 'Franklin')", targetTable), 1L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES (1, 'Aaron', 17, 'Arches/Arches'), (2, 'Bill', 7, 'Buena'), (6, 'Carol', 9, 'Centreville'), (7, 'Dave', 22, 'Darbyshire/Darbyshire'), (8, 'Ed', 14, 'Etherville/Etherville'), (9, 'Fred', 30, 'Franklin')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeWithSimplifiedUnpredictablePredicates() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_predicates_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_predicates_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (id INT, customer VARCHAR, purchases INT, address VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (id, customer, purchases, address) VALUES (1, 'Dave', 11, 'Devon'), (2, 'Dave', 11, 'Darbyshire')", targetTable), 2L);
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR)", sourceTable)));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Dave', 11, 'Darbyshire')", sourceTable), 1L);
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s", targetTable, sourceTable) + " ON t.customer = s.customer    WHEN MATCHED AND t.address <> 'Darbyshire' AND s.purchases * 2 > 20        THEN DELETE", 1L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES (2, 'Dave', 11, 'Darbyshire')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeCasts() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_cast_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_cast_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (col1 INT, col2 DOUBLE, col3 INT, col4 BIGINT, col5 REAL, col6 DOUBLE)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s VALUES (1, 2, 3, 4, 5, 6)", targetTable), 1L);
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (col1 BIGINT, col2 REAL, col3 DOUBLE, col4 INT, col5 INT, col6 REAL)", sourceTable)));
        this.assertUpdate(String.format("INSERT INTO %s VALUES (2, 3, 4, 5, 6, 7)", sourceTable), 1L);
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s", targetTable, sourceTable) + "    ON (t.col1 + 1 = s.col1)    WHEN MATCHED THEN UPDATE SET col1 = s.col1, col2 = s.col2, col3 = s.col3, col4 = s.col4, col5 = s.col5, col6 = s.col6", 1L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES (2, 3.0, 4, 5, 6.0, 7.0)");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeSubqueries() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE));
        String targetTable = "merge_nation_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_nation_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (nation_name VARCHAR, region_name VARCHAR)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (nation_name, region_name) VALUES ('FRANCE', 'EUROPE'), ('ALGERIA', 'AFRICA'), ('GERMANY', 'EUROPE')", targetTable), 3L);
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (nation_name VARCHAR, region_name VARCHAR)", sourceTable)));
        this.assertUpdate(String.format("INSERT INTO %s VALUES ('ALGERIA', 'AFRICA'), ('FRANCE', 'EUROPE'), ('EGYPT', 'MIDDLE EAST'), ('RUSSIA', 'EUROPE')", sourceTable), 4L);
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s", targetTable, sourceTable) + "    ON (t.nation_name = s.nation_name)    WHEN MATCHED AND t.nation_name > (SELECT name FROM tpch.tiny.region WHERE name = t.region_name AND name LIKE ('A%'))        THEN DELETE    WHEN NOT MATCHED AND s.region_name = 'EUROPE'        THEN INSERT VALUES(s.nation_name, (SELECT 'EUROPE'))", 2L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('FRANCE', 'EUROPE'), ('GERMANY', 'EUROPE'), ('RUSSIA', 'EUROPE')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeNonNullableColumns() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NOT_NULL_CONSTRAINT));
        String targetTable = "merge_non_nullable_target_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites(String.format("CREATE TABLE %s (nation_name VARCHAR, region_name VARCHAR NOT NULL)", targetTable)));
        this.assertUpdate(String.format("INSERT INTO %s (nation_name, region_name) VALUES ('FRANCE', 'EUROPE'), ('ALGERIA', 'AFRICA'), ('GERMANY', 'EUROPE')", targetTable), 3L);
        Assertions.assertThatThrownBy(() -> this.computeActual(String.format("MERGE INTO %s t\n", targetTable) + " USING (VALUES ('ALGERIA', 'AFRICA')) s(nation_name, region_name)\n ON (t.nation_name = s.nation_name)\n WHEN MATCHED THEN UPDATE SET region_name = NULL")).hasMessage("Assigning NULL to non-null MERGE target table column region_name");
        Assertions.assertThatThrownBy(() -> this.computeActual(String.format("MERGE INTO %s t\n", targetTable) + " USING (VALUES ('IMAGINARIA', 'AFRICA')) s(nation_name, region_name)\n ON (t.nation_name = s.nation_name)\n WHEN NOT MATCHED THEN INSERT (nation_name, region_name) VALUES ('IMAGINARIA', NULL)")).hasMessage("Assigning NULL to non-null MERGE target table column region_name");
        Assertions.assertThatThrownBy(() -> this.computeActual(String.format("MERGE INTO %s t\n", targetTable) + " USING (VALUES ('ALGERIA', 'AFRICA')) s(nation_name, region_name)\n ON (t.nation_name = s.nation_name)\n WHEN MATCHED THEN UPDATE SET region_name = CAST(TRY(5/0) AS VARCHAR)")).hasMessage("Assigning NULL to non-null MERGE target table column region_name");
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeAllColumnsReversed() {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_MERGE) && this.hasBehavior(TestingConnectorBehavior.SUPPORTS_NOT_NULL_CONSTRAINT));
        String targetTable = "merge_update_columns_reversed_" + TestingNames.randomNameSuffix();
        this.assertUpdate(this.createTableForWrites("CREATE TABLE " + targetTable + " (a, b, c) AS VALUES (1, 2, 3)"), 1L);
        this.assertUpdate("MERGE INTO %s t USING (VALUES(1)) AS s(a) ON (t.a = s.a)\n    WHEN MATCHED THEN UPDATE\n        SET c = 100, b = 42, a = 0\n".formatted(targetTable), 1L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES (0, 42, 100)");
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    private void verifyUnsupportedTypeException(Throwable exception, String trinoTypeName) {
        String typeNameBase = trinoTypeName.replaceFirst("\\(.*", "");
        String expectedMessagePart = String.format("(%1$s.*not (yet )?supported)|((?i)unsupported.*%1$s)|((?i)not supported.*%1$s)", Pattern.quote(typeNameBase));
        Assertions.assertThat((Throwable)exception).hasMessageFindingMatch(expectedMessagePart).satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Throwable)QueryAssertions.getTrinoExceptionCause(e)).hasMessageFindingMatch(expectedMessagePart)});
    }

    @Test(dataProvider="testColumnNameDataProvider")
    public void testMaterializedViewColumnName(String columnName) {
        BaseConnectorTest.skipTestUnless(this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW));
        if (!BaseConnectorTest.requiresDelimiting(columnName)) {
            this.testMaterializedViewColumnName(columnName, false);
        }
        this.testMaterializedViewColumnName(columnName, true);
    }

    private void testMaterializedViewColumnName(String columnName, boolean delimited) {
        Object nameInSql = columnName;
        if (delimited) {
            nameInSql = "\"" + columnName.replace("\"", "\"\"") + "\"";
        }
        String viewName = "tcn_" + ((String)nameInSql).toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]", "_") + "_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("CREATE MATERIALIZED VIEW " + viewName + " AS SELECT 'sample value' key, 'abc' " + (String)nameInSql);
        }
        catch (RuntimeException e) {
            if (this.isColumnNameRejected(e, columnName, delimited)) {
                return;
            }
            throw e;
        }
        this.assertUpdate("REFRESH MATERIALIZED VIEW " + viewName, 1L);
        this.assertQuery("SELECT * FROM " + viewName, "VALUES ('sample value', 'abc')");
        this.assertUpdate("DROP MATERIALIZED VIEW " + viewName);
    }

    protected Consumer<Plan> assertPartialLimitWithPreSortedInputsCount(Session session, int expectedCount) {
        return plan -> {
            int actualCount = PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> node instanceof LimitNode && ((LimitNode)node).isPartial() && ((LimitNode)node).requiresPreSortedInputs()).findAll().size();
            if (actualCount != expectedCount) {
                Metadata metadata = this.getDistributedQueryRunner().getMetadata();
                FunctionManager functionManager = this.getDistributedQueryRunner().getFunctionManager();
                String formattedPlan = PlanPrinter.textLogicalPlan((PlanNode)plan.getRoot(), (TypeProvider)plan.getTypes(), (Metadata)metadata, (FunctionManager)functionManager, (StatsAndCosts)StatsAndCosts.empty(), (Session)session, (int)0, (boolean)false);
                throw new AssertionError((Object)String.format("Expected [\n%s\n] partial limit but found [\n%s\n] partial limit. Actual plan is [\n\n%s\n]", expectedCount, actualCount, formattedPlan));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withMockTableListing(String forSchema, Function<ConnectorSession, List<String>> listing, Runnable closure) {
        Objects.requireNonNull(forSchema, "forSchema is null");
        Objects.requireNonNull(listing, "listing is null");
        Preconditions.checkState((this.mockTableListings.putIfAbsent(forSchema, listing) == null ? 1 : 0) != 0, (String)"Listing function already registered for [%s]", (Object)forSchema);
        try {
            closure.run();
        }
        finally {
            this.mockTableListings.remove(forSchema, listing);
        }
    }

    protected String createSchemaSql(String schemaName) {
        return "CREATE SCHEMA " + schemaName;
    }

    private static class RollbackException
    extends RuntimeException {
        private RollbackException() {
        }
    }

    public record SetColumnTypeSetup(String sourceColumnType, String sourceValueLiteral, String newColumnType, String newValueLiteral, boolean unsupportedType) {
        public SetColumnTypeSetup(String sourceColumnType, String sourceValueLiteral, String newColumnType) {
            this(sourceColumnType, sourceValueLiteral, newColumnType, "CAST(CAST(%s AS %s) AS %s)".formatted(sourceValueLiteral, sourceColumnType, newColumnType));
        }

        public SetColumnTypeSetup(String sourceColumnType, String sourceValueLiteral, String newColumnType, String newValueLiteral) {
            this(sourceColumnType, sourceValueLiteral, newColumnType, newValueLiteral, false);
        }

        public SetColumnTypeSetup {
            Objects.requireNonNull(sourceColumnType, "sourceColumnType is null");
            Objects.requireNonNull(sourceValueLiteral, "sourceValueLiteral is null");
            Objects.requireNonNull(newColumnType, "newColumnType is null");
            Objects.requireNonNull(newValueLiteral, "newValueLiteral is null");
        }

        public SetColumnTypeSetup withNewValueLiteral(String newValueLiteral) {
            Preconditions.checkState((!this.unsupportedType ? 1 : 0) != 0);
            return new SetColumnTypeSetup(this.sourceColumnType, this.sourceValueLiteral, this.newColumnType, newValueLiteral, this.unsupportedType);
        }

        public SetColumnTypeSetup asUnsupported() {
            return new SetColumnTypeSetup(this.sourceColumnType, this.sourceValueLiteral, this.newColumnType, this.newValueLiteral, true);
        }
    }

    protected static final class DataMappingTestSetup {
        private final String trinoTypeName;
        private final String sampleValueLiteral;
        private final String highValueLiteral;
        private final boolean unsupportedType;

        public DataMappingTestSetup(String trinoTypeName, String sampleValueLiteral, String highValueLiteral) {
            this(trinoTypeName, sampleValueLiteral, highValueLiteral, false);
        }

        private DataMappingTestSetup(String trinoTypeName, String sampleValueLiteral, String highValueLiteral, boolean unsupportedType) {
            this.trinoTypeName = Objects.requireNonNull(trinoTypeName, "trinoTypeName is null");
            this.sampleValueLiteral = Objects.requireNonNull(sampleValueLiteral, "sampleValueLiteral is null");
            this.highValueLiteral = Objects.requireNonNull(highValueLiteral, "highValueLiteral is null");
            this.unsupportedType = unsupportedType;
        }

        public String getTrinoTypeName() {
            return this.trinoTypeName;
        }

        public String getSampleValueLiteral() {
            return this.sampleValueLiteral;
        }

        public String getHighValueLiteral() {
            return this.highValueLiteral;
        }

        public boolean isUnsupportedType() {
            return this.unsupportedType;
        }

        public DataMappingTestSetup asUnsupported() {
            return new DataMappingTestSetup(this.trinoTypeName, this.sampleValueLiteral, this.highValueLiteral, true);
        }

        public String toString() {
            return this.trinoTypeName + (this.unsupportedType ? "!" : "") + ":" + this.sampleValueLiteral.replaceAll("[^a-zA-Z0-9_-]", "");
        }
    }
}

