/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.tpch;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

class AppendingRecordSet
implements RecordSet {
    private final RecordSet delegate;
    private final List<Object> appendedValues;
    private final List<Type> appendedTypes;

    public AppendingRecordSet(RecordSet delegate, List<Object> appendedValues, List<Type> appendedTypes) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.appendedValues = new ArrayList<Object>((Collection)Objects.requireNonNull(appendedValues, "appendedValues is null"));
        this.appendedTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(appendedTypes, "appendedTypes is null"));
        Preconditions.checkArgument((appendedValues.size() == appendedTypes.size() ? 1 : 0) != 0, (Object)"appendedValues must have the same size as appendedTypes");
        for (int i = 0; i < appendedValues.size(); ++i) {
            Object value = appendedValues.get(i);
            if (value == null) continue;
            Preconditions.checkArgument((boolean)Primitives.wrap((Class)appendedTypes.get(i).getJavaType()).isInstance(value), (Object)"Object value does not match declared type");
        }
    }

    public List<Type> getColumnTypes() {
        return ImmutableList.builder().addAll((Iterable)this.delegate.getColumnTypes()).addAll(this.appendedTypes).build();
    }

    public RecordCursor cursor() {
        return new AppendingRecordCursor(this.delegate.cursor(), this.delegate.getColumnTypes().size(), this.appendedValues, this.appendedTypes);
    }

    private static class AppendingRecordCursor
    implements RecordCursor {
        private final RecordCursor delegate;
        private final int delegateFieldCount;
        private final List<Object> appendedValues;
        private final List<Type> appendedTypes;

        private AppendingRecordCursor(RecordCursor delegate, int delegateFieldCount, List<Object> appendedValues, List<Type> appendedTypes) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            this.delegateFieldCount = delegateFieldCount;
            Preconditions.checkArgument((delegateFieldCount >= 0 ? 1 : 0) != 0, (Object)"delegateFieldCount must be greater than or equal to zero");
            this.appendedValues = Objects.requireNonNull(appendedValues, "appendedValues is null");
            this.appendedTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(appendedTypes, "appendedTypes is null"));
            Preconditions.checkArgument((appendedValues.size() == appendedTypes.size() ? 1 : 0) != 0, (Object)"appendedValues must have the same size as appendedTypes");
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            Preconditions.checkPositionIndex((int)field, (int)(this.delegateFieldCount + this.appendedTypes.size()));
            if (field < this.delegateFieldCount) {
                return this.delegate.getType(field);
            }
            return this.appendedTypes.get(field - this.delegateFieldCount);
        }

        public boolean advanceNextPosition() {
            return this.delegate.advanceNextPosition();
        }

        public boolean getBoolean(int field) {
            Preconditions.checkPositionIndex((int)field, (int)(this.delegateFieldCount + this.appendedTypes.size()));
            if (field < this.delegateFieldCount) {
                return this.delegate.getBoolean(field);
            }
            return (Boolean)this.appendedValues.get(field - this.delegateFieldCount);
        }

        public long getLong(int field) {
            Preconditions.checkPositionIndex((int)field, (int)(this.delegateFieldCount + this.appendedTypes.size()));
            if (field < this.delegateFieldCount) {
                return this.delegate.getLong(field);
            }
            return (Long)this.appendedValues.get(field - this.delegateFieldCount);
        }

        public double getDouble(int field) {
            Preconditions.checkPositionIndex((int)field, (int)(this.delegateFieldCount + this.appendedTypes.size()));
            if (field < this.delegateFieldCount) {
                return this.delegate.getDouble(field);
            }
            return (Double)this.appendedValues.get(field - this.delegateFieldCount);
        }

        public Slice getSlice(int field) {
            Preconditions.checkPositionIndex((int)field, (int)(this.delegateFieldCount + this.appendedTypes.size()));
            if (field < this.delegateFieldCount) {
                return this.delegate.getSlice(field);
            }
            return (Slice)this.appendedValues.get(field - this.delegateFieldCount);
        }

        public Object getObject(int field) {
            throw new UnsupportedOperationException();
        }

        public boolean isNull(int field) {
            Preconditions.checkPositionIndex((int)field, (int)(this.delegateFieldCount + this.appendedTypes.size()));
            if (field < this.delegateFieldCount) {
                return this.delegate.isNull(field);
            }
            return this.appendedValues.get(field - this.delegateFieldCount) == null;
        }

        public void close() {
            this.delegate.close();
        }
    }
}

