/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.tpch;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import io.trino.testing.tpch.TpchScaledTable;
import java.util.Objects;
import java.util.Set;

public class TpchIndexSpec {
    public static final TpchIndexSpec NO_INDEXES = new TpchIndexSpec((SetMultimap<TpchScaledTable, Set<String>>)ImmutableSetMultimap.of());
    private final SetMultimap<TpchScaledTable, Set<String>> spec;

    private TpchIndexSpec(SetMultimap<TpchScaledTable, Set<String>> spec) {
        this.spec = ImmutableSetMultimap.copyOf((Multimap)((Multimap)Objects.requireNonNull(spec, "spec is null")));
    }

    public Set<TpchScaledTable> listIndexedTables() {
        return this.spec.keySet();
    }

    public Iterable<Set<String>> getColumnIndexes(TpchScaledTable table) {
        return this.spec.get((Object)table);
    }

    public static class Builder {
        private final ImmutableSetMultimap.Builder<TpchScaledTable, Set<String>> builder = ImmutableSetMultimap.builder();

        public Builder addIndex(String tableName, double scaleFactor, Set<String> columnNames) {
            this.builder.put((Object)new TpchScaledTable(tableName, scaleFactor), columnNames);
            return this;
        }

        public TpchIndexSpec build() {
            return new TpchIndexSpec((SetMultimap<TpchScaledTable, Set<String>>)this.builder.build());
        }
    }
}

