/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.Signature;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.util.Reflection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

public class StatefulSleepingSum
extends SqlScalarFunction {
    public static final StatefulSleepingSum STATEFUL_SLEEPING_SUM = new StatefulSleepingSum();

    private StatefulSleepingSum() {
        super(FunctionMetadata.scalarBuilder((String)"stateful_sleeping_sum").signature(Signature.builder().typeVariable("bigint").returnType((Type)BigintType.BIGINT).argumentType((Type)DoubleType.DOUBLE).argumentType((Type)BigintType.BIGINT).argumentType((Type)BigintType.BIGINT).argumentType((Type)BigintType.BIGINT).build()).hidden().description("testing not thread safe function").build());
    }

    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        int args = 4;
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, Collections.nCopies(args, InvocationConvention.InvocationArgumentConvention.NEVER_NULL), Reflection.methodHandle(StatefulSleepingSum.class, (String)"statefulSleepingSum", (Class[])new Class[]{State.class, Double.TYPE, Long.TYPE, Long.TYPE, Long.TYPE}), Optional.of(Reflection.constructorMethodHandle(State.class, (Class[])new Class[0])));
    }

    public static long statefulSleepingSum(State state, double sleepProbability, long sleepDurationMillis, long a, long b) {
        int currentThreads = state.currentThreads.incrementAndGet();
        try {
            Preconditions.checkState((currentThreads == 1 ? 1 : 0) != 0, (String)"%s threads concurrently executing a stateful function", (int)currentThreads);
            if (ThreadLocalRandom.current().nextDouble() < sleepProbability) {
                Thread.sleep(sleepDurationMillis);
            }
            long l = a + b;
            return l;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted", e);
        }
        finally {
            state.currentThreads.decrementAndGet();
        }
    }

    public static class State {
        private final AtomicInteger currentThreads = new AtomicInteger();
    }
}

