/*
 * Decompiled with CFR 0.152.
 */
package io.trino.common.assertions;

import io.trino.spi.eventlistener.ColumnInfo;
import io.trino.spi.eventlistener.TableInfo;
import io.trino.spi.eventlistener.TableReferenceInfo;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

public class TableInfoAssert
extends AbstractAssert<TableInfoAssert, TableInfo> {
    TableInfoAssert(TableInfo actual) {
        super((Object)actual, TableInfoAssert.class);
    }

    public TableInfoAssert hasCatalogSchemaTable(String expectedCatalog, String expectedSchema, String expectedTable) {
        Assertions.assertThat((String)((TableInfo)this.actual).getCatalog()).isEqualTo(expectedCatalog);
        Assertions.assertThat((String)((TableInfo)this.actual).getSchema()).isEqualTo(expectedSchema);
        Assertions.assertThat((String)((TableInfo)this.actual).getTable()).isEqualTo(expectedTable);
        return this;
    }

    public TableInfoAssert hasAuthorization(String expectedAuthorization) {
        Assertions.assertThat((String)((TableInfo)this.actual).getAuthorization()).isEqualTo(expectedAuthorization);
        return this;
    }

    public TableInfoAssert isNotDirectlyReferenced() {
        Assertions.assertThat((boolean)((TableInfo)this.actual).isDirectlyReferenced()).isFalse();
        return this;
    }

    public TableInfoAssert isDirectlyReferenced() {
        Assertions.assertThat((boolean)((TableInfo)this.actual).isDirectlyReferenced()).isTrue();
        return this;
    }

    public TableInfoAssert hasColumnsWithoutMasking(String ... columnNames) {
        Assertions.assertThat((List)((TableInfo)this.actual).getColumns()).extracting(ColumnInfo::getColumn).containsExactly((Object[])columnNames);
        Assertions.assertThat((List)((TableInfo)this.actual).getColumns()).allSatisfy(columnInfo -> Assertions.assertThat((Optional)columnInfo.getMask()).isEmpty());
        return this;
    }

    public TableInfoAssert hasColumnNames(String ... columnNames) {
        Assertions.assertThat((List)((TableInfo)this.actual).getColumns()).extracting(ColumnInfo::getColumn).containsExactly((Object[])columnNames);
        return this;
    }

    public TableInfoAssert hasColumnMasks(String ... columnMasks) {
        Assertions.assertThat((List)((TableInfo)this.actual).getColumns()).hasSize(columnMasks.length);
        for (int i = 0; i < columnMasks.length; ++i) {
            String expectedMask = columnMasks[i];
            Optional actualMask = ((ColumnInfo)((TableInfo)this.actual).getColumns().get(i)).getMask();
            if (expectedMask == null) {
                Assertions.assertThat((Optional)actualMask).isEmpty();
                continue;
            }
            Assertions.assertThat((Optional)actualMask).hasValueSatisfying(maskText -> Assertions.assertThat((String)maskText).isEqualToIgnoringWhitespace((CharSequence)expectedMask));
        }
        return this;
    }

    public TableInfoAssert hasNoRowFilters() {
        Assertions.assertThat((List)((TableInfo)this.actual).getFilters()).isEmpty();
        return this;
    }

    public TableInfoAssert hasRowFilters(String ... filterTexts) {
        Assertions.assertThat((List)((TableInfo)this.actual).getFilters()).hasSize(filterTexts.length);
        for (int i = 0; i < filterTexts.length; ++i) {
            Assertions.assertThat((String)((String)((TableInfo)this.actual).getFilters().get(i))).isEqualToIgnoringWhitespace((CharSequence)filterTexts[i]);
        }
        return this;
    }

    public TableInfoAssert hasViewText(String viewText) {
        Assertions.assertThat((Optional)((TableInfo)this.actual).getViewText()).hasValueSatisfying(sql -> Assertions.assertThat((String)sql).isEqualToIgnoringWhitespace((CharSequence)viewText));
        return this;
    }

    public TableInfoAssert hasNoTableReferences() {
        Assertions.assertThat((List)((TableInfo)this.actual).getReferenceChain()).isEmpty();
        return this;
    }

    @SafeVarargs
    public final TableInfoAssert hasTableReferencesSatisfying(Consumer<TableReferenceInfo> ... tableReferenceAssertions) {
        Assertions.assertThat((List)((TableInfo)this.actual).getReferenceChain()).hasSize(tableReferenceAssertions.length);
        for (int i = 0; i < tableReferenceAssertions.length; ++i) {
            tableReferenceAssertions[i].accept((TableReferenceInfo)((TableInfo)this.actual).getReferenceChain().get(i));
        }
        return this;
    }
}

