/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.informationschema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.jmh.Benchmarks;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorSession;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Warmup(iterations=4)
@Fork(value=1)
@Measurement(iterations=10)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkInformationSchema {
    @Benchmark
    public MaterializedResult queryInformationSchema(BenchmarkData benchmarkData) {
        return benchmarkData.queryRunner.execute(benchmarkData.query);
    }

    @Test
    public void test() throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        try {
            this.queryInformationSchema(data);
        }
        finally {
            data.tearDown();
        }
    }

    public static void main(String[] args) throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        try {
            new BenchmarkInformationSchema().queryInformationSchema(data);
        }
        finally {
            data.tearDown();
        }
        Benchmarks.benchmark(BenchmarkInformationSchema.class).run();
    }

    @State(value=Scope.Benchmark)
    public static class BenchmarkData {
        private final Map<String, String> queries = ImmutableMap.of((Object)"FULL_SCAN", (Object)"SELECT count(*) FROM information_schema.columns", (Object)"LIKE_PREDICATE", (Object)"SELECT count(*) FROM information_schema.columns WHERE table_name LIKE 'table_0' AND table_schema LIKE 'schema_0'", (Object)"MIXED_PREDICATE", (Object)"SELECT count(*) FROM information_schema.columns WHERE table_name LIKE 'table_0' AND table_schema = 'schema_0'", (Object)"LIMIT_SCAN", (Object)"SELECT column_name FROM information_schema.columns LIMIT 100");
        @Param(value={"FULL_SCAN", "LIKE_PREDICATE", "MIXED_PREDICATE", "LIMIT_SCAN"})
        private String queryId = "LIKE_PREDICATE";
        @Param(value={"200"})
        private String schemasCount = "200";
        @Param(value={"200"})
        private String tablesCount = "200";
        private QueryRunner queryRunner;
        private Session session = TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("test_schema").build();
        private String query;

        @Setup
        public void setup() throws Exception {
            this.queryRunner = DistributedQueryRunner.builder((Session)this.session).build();
            this.queryRunner.installPlugin(new Plugin(){

                public Iterable<ConnectorFactory> getConnectorFactories() {
                    Function<ConnectorSession, List> listSchemaNames = session -> (List)IntStream.range(0, Integer.parseInt(schemasCount)).boxed().map(i -> "stream_" + i).collect(ImmutableList.toImmutableList());
                    BiFunction<ConnectorSession, String, List> listTables = (session, schemaName) -> (List)IntStream.range(0, Integer.parseInt(tablesCount)).boxed().map(i -> "table_" + i).collect(ImmutableList.toImmutableList());
                    MockConnectorFactory connectorFactory = MockConnectorFactory.builder().withListSchemaNames(listSchemaNames).withListTables(listTables).withGetViews((session, prefix) -> ImmutableMap.of()).build();
                    return ImmutableList.of((Object)connectorFactory);
                }
            });
            this.queryRunner.createCatalog("test_catalog", "mock", (Map)ImmutableMap.of());
            this.query = this.queries.get(this.queryId);
        }

        @TearDown
        public void tearDown() {
            this.queryRunner.close();
            this.queryRunner = null;
        }
    }
}

