/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.informationschema;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import io.trino.Session;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.CountingMockConnector;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MultisetAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.tests.FailingMockConnectorPlugin;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestInformationSchemaConnector
extends AbstractTestQueryFramework {
    private static final int MAX_PREFIXES_COUNT = 10;
    private CountingMockConnector countingMockConnector;

    protected QueryRunner createQueryRunner() throws Exception {
        this.countingMockConnector = (CountingMockConnector)this.closeAfterClass((AutoCloseable)new CountingMockConnector());
        Session session = TestingSession.testSessionBuilder().build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)session).setWorkerCount(0).addCoordinatorProperty("optimizer.experimental-max-prefetched-information-schema-prefixes", Integer.toString(10)).build();
        try {
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog("tpch", "tpch");
            queryRunner.installPlugin(this.countingMockConnector.getPlugin());
            queryRunner.createCatalog("test_catalog", "mock", (Map)ImmutableMap.of());
            queryRunner.installPlugin((Plugin)new FailingMockConnectorPlugin());
            queryRunner.createCatalog("broken_catalog", "failing_mock", (Map)ImmutableMap.of());
            return queryRunner;
        }
        catch (Exception e) {
            queryRunner.close();
            throw e;
        }
    }

    @AfterAll
    public void cleanUp() {
        this.countingMockConnector = null;
    }

    @Test
    public void testBasic() {
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.schemata", "VALUES 10");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.tables", "VALUES 80");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.columns", "VALUES 583");
        this.assertQuery("SELECT * FROM tpch.information_schema.schemata ORDER BY 1 DESC, 2 DESC LIMIT 1", "VALUES ('tpch', 'tiny')");
        this.assertQuery("SELECT * FROM tpch.information_schema.tables ORDER BY 1 DESC, 2 DESC, 3 DESC, 4 DESC LIMIT 1", "VALUES ('tpch', 'tiny', 'supplier', 'BASE TABLE')");
        this.assertQuery("SELECT * FROM tpch.information_schema.columns ORDER BY 1 DESC, 2 DESC, 3 DESC, 4 DESC LIMIT 1", "VALUES ('tpch', 'tiny', 'supplier', 'suppkey', 1, NULL, 'NO', 'bigint')");
        this.assertQuery("SELECT * FROM test_catalog.information_schema.columns ORDER BY 1 DESC, 2 DESC, 3 DESC, 4 DESC LIMIT 1", "VALUES ('test_catalog', 'test_schema2', 'test_table999', 'column_99', 100, NULL, 'YES', 'varchar')");
        this.assertQuery("SELECT count(*) FROM test_catalog.information_schema.columns", "VALUES 300034");
    }

    @Test
    public void testSchemaNamePredicate() {
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.schemata WHERE schema_name = 'sf1'", "VALUES 1");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.schemata WHERE schema_name IS NOT NULL", "VALUES 10");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.tables WHERE table_schema = 'sf1'", "VALUES 8");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.tables WHERE table_schema IS NOT NULL", "VALUES 80");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.columns WHERE table_schema = 'sf1'", "VALUES 61");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.columns WHERE table_schema = 'information_schema'", "VALUES 34");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.columns WHERE table_schema > 'sf100'", "VALUES 427");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.columns WHERE table_schema != 'sf100'", "VALUES 522");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.columns WHERE table_schema LIKE 'sf100'", "VALUES 61");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.columns WHERE table_schema LIKE 'sf%'", "VALUES 488");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.columns WHERE table_schema IS NOT NULL", "VALUES 583");
    }

    @Test
    public void testTableNamePredicate() {
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.tables WHERE table_name = 'orders'", "VALUES 9");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.tables WHERE table_name = 'ORDERS'", "VALUES 0");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.tables WHERE table_name LIKE 'orders'", "VALUES 9");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.tables WHERE table_name < 'orders'", "VALUES 30");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.tables WHERE table_name LIKE 'part'", "VALUES 9");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.tables WHERE table_name LIKE 'part%'", "VALUES 18");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.tables WHERE table_name IS NOT NULL", "VALUES 80");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.columns WHERE table_name = 'orders'", "VALUES 81");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.columns WHERE table_name LIKE 'orders'", "VALUES 81");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.columns WHERE table_name < 'orders'", "VALUES 265");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.columns WHERE table_name LIKE 'part'", "VALUES 81");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.columns WHERE table_name LIKE 'part%'", "VALUES 126");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.columns WHERE table_name IS NOT NULL", "VALUES 583");
    }

    @Test
    public void testMixedPredicate() {
        this.assertQuery("SELECT * FROM tpch.information_schema.tables WHERE table_schema = 'sf1' and table_name = 'orders'", "VALUES ('tpch', 'sf1', 'orders', 'BASE TABLE')");
        this.assertQuery("SELECT table_schema FROM tpch.information_schema.tables WHERE table_schema IS NOT NULL and table_name = 'orders'", "VALUES 'tiny', 'sf1', 'sf100', 'sf1000', 'sf10000', 'sf100000', 'sf300', 'sf3000', 'sf30000'");
        this.assertQuery("SELECT table_name FROM tpch.information_schema.tables WHERE table_schema = 'sf1' and table_name IS NOT NULL", "VALUES 'customer', 'lineitem', 'orders', 'part', 'partsupp', 'supplier', 'nation', 'region'");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.columns WHERE table_schema = 'sf1' and table_name = 'orders'", "VALUES 9");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.columns WHERE table_schema IS NOT NULL and table_name = 'orders'", "VALUES 81");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.columns WHERE table_schema = 'sf1' and table_name IS NOT NULL", "VALUES 61");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.tables WHERE table_schema > 'sf1' and table_name < 'orders'", "VALUES 24");
        this.assertQuery("SELECT count(*) FROM tpch.information_schema.columns WHERE table_schema > 'sf1' and table_name < 'orders'", "VALUES 224");
    }

    @Test
    public void testProject() {
        this.assertQuery("SELECT schema_name FROM tpch.information_schema.schemata ORDER BY 1 DESC LIMIT 1", "VALUES 'tiny'");
        this.assertQuery("SELECT table_name, table_type FROM tpch.information_schema.tables ORDER BY 1 DESC, 2 DESC LIMIT 1", "VALUES ('views', 'BASE TABLE')");
        this.assertQuery("SELECT column_name, data_type FROM tpch.information_schema.columns ORDER BY 1 DESC, 2 DESC LIMIT 1", "VALUES ('with_hierarchy', 'varchar')");
    }

    @Test
    public void testLimit() {
        this.assertQuery("SELECT count(*) FROM (SELECT * from tpch.information_schema.columns LIMIT 1)", "VALUES 1");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM tpch.information_schema.columns LIMIT 100)", "VALUES 100");
        this.assertQuery("SELECT count(*) FROM (SELECT * FROM test_catalog.information_schema.tables LIMIT 1000)", "VALUES 1000");
    }

    @Test
    @Timeout(value=60L)
    public void testMetadataCalls() {
        this.assertMetadataCalls("SELECT count(*) from test_catalog.information_schema.schemata WHERE schema_name LIKE 'test_sch_ma1'", "VALUES 1", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.listSchemaNames").build());
        this.assertMetadataCalls("SELECT count(*) from test_catalog.information_schema.schemata WHERE schema_name LIKE 'test_sch_ma1' AND schema_name IN ('test_schema1', 'test_schema2')", "VALUES 1", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.listSchemaNames").build());
        this.assertMetadataCalls("SELECT count(table_name), count(table_type) from test_catalog.information_schema.tables", "VALUES (3008, 3008)", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getRelationTypes").build());
        this.assertMetadataCalls("SELECT count(table_name), count(table_type) from test_catalog.information_schema.tables WHERE table_schema = 'test_schema1'", "VALUES (1000, 1000)", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getRelationTypes(schema=test_schema1)").build());
        this.assertMetadataCalls("SELECT count(table_name), count(table_type) from test_catalog.information_schema.tables WHERE table_schema LIKE 'test_sch_ma1'", "VALUES (1000, 1000)", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.listSchemaNames").add((Object)"ConnectorMetadata.getRelationTypes(schema=test_schema1)").build());
        this.assertMetadataCalls("SELECT count(table_name), count(table_type) from test_catalog.information_schema.tables WHERE table_schema LIKE 'test_sch_ma1' AND table_schema IN ('test_schema1', 'test_schema2')", "VALUES (1000, 1000)", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getRelationTypes(schema=test_schema1)").add((Object)"ConnectorMetadata.getRelationTypes(schema=test_schema2)").build());
        String string = "'%s'";
        this.assertMetadataCalls("SELECT count(table_name), count(table_type) from test_catalog.information_schema.tables WHERE table_schema IN " + Stream.concat(Stream.of("test_schema1", "test_schema2"), IntStream.range(1, 11).mapToObj(i -> "bogus_schema" + i)).map(arg_0 -> TestInformationSchemaConnector.lambda$testMetadataCalls$1("'%s'", arg_0)).collect(Collectors.joining(",", "(", ")")), "VALUES (3000, 3000)", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getRelationTypes").build());
        this.assertMetadataCalls("SELECT count(table_name), count(table_type) from test_catalog.information_schema.tables WHERE table_name = 'test_table1'", "VALUES (2, 2)", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.listSchemaNames").addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema1, table=test_table1)", 4).addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema2, table=test_table1)", 4).addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema3_empty, table=test_table1)", 4).addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema4_empty, table=test_table1)", 4).add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema2, table=test_table1)").add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema3_empty, table=test_table1)").add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema4_empty, table=test_table1)").add((Object)"ConnectorMetadata.isView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.isView(schema=test_schema2, table=test_table1)").add((Object)"ConnectorMetadata.isView(schema=test_schema3_empty, table=test_table1)").add((Object)"ConnectorMetadata.isView(schema=test_schema4_empty, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema2, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema3_empty, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema4_empty, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema2, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema3_empty, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema4_empty, table=test_table1)").build());
        this.assertMetadataCalls("SELECT count(table_name), count(table_type) from test_catalog.information_schema.tables WHERE table_name LIKE 'test_t_ble1'", "VALUES (2, 2)", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.listSchemaNames").add((Object)"ConnectorMetadata.getRelationTypes(schema=test_schema1)").add((Object)"ConnectorMetadata.getRelationTypes(schema=test_schema2)").add((Object)"ConnectorMetadata.getRelationTypes(schema=test_schema3_empty)").add((Object)"ConnectorMetadata.getRelationTypes(schema=test_schema4_empty)").build());
        this.assertMetadataCalls("SELECT count(table_name), count(table_type) from test_catalog.information_schema.tables WHERE table_name LIKE 'test_t_ble1' AND table_name IN ('test_table1', 'test_table2')", "VALUES (2, 2)", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.listSchemaNames").addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema1, table=test_table1)", 4).addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema1, table=test_table2)", 4).addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema2, table=test_table1)", 4).addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema2, table=test_table2)", 4).addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema3_empty, table=test_table1)", 4).addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema3_empty, table=test_table2)", 4).addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema4_empty, table=test_table1)", 4).addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema4_empty, table=test_table2)", 4).add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema1, table=test_table2)").add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema2, table=test_table2)").add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema2, table=test_table1)").add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema3_empty, table=test_table2)").add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema3_empty, table=test_table1)").add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema4_empty, table=test_table2)").add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema4_empty, table=test_table1)").add((Object)"ConnectorMetadata.isView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.isView(schema=test_schema1, table=test_table2)").add((Object)"ConnectorMetadata.isView(schema=test_schema2, table=test_table1)").add((Object)"ConnectorMetadata.isView(schema=test_schema2, table=test_table2)").add((Object)"ConnectorMetadata.isView(schema=test_schema3_empty, table=test_table1)").add((Object)"ConnectorMetadata.isView(schema=test_schema3_empty, table=test_table2)").add((Object)"ConnectorMetadata.isView(schema=test_schema4_empty, table=test_table1)").add((Object)"ConnectorMetadata.isView(schema=test_schema4_empty, table=test_table2)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema1, table=test_table2)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema2, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema2, table=test_table2)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema3_empty, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema3_empty, table=test_table2)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema4_empty, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema4_empty, table=test_table2)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema1, table=test_table2)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema2, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema2, table=test_table2)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema3_empty, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema3_empty, table=test_table2)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema4_empty, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema4_empty, table=test_table2)").build());
        this.assertMetadataCalls("SELECT count(*) from test_catalog.information_schema.columns WHERE table_schema = 'test_schema1' AND table_name = 'test_table1'", "VALUES 100", (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema1, table=test_table1)", 4).add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableMetadata(handle=test_schema1.test_table1)").build());
        this.assertMetadataCalls("SELECT count(*) from test_catalog.information_schema.columns WHERE table_catalog = 'wrong'", "VALUES 0", (Multiset<String>)ImmutableMultiset.of());
        this.assertMetadataCalls("SELECT count(*) from test_catalog.information_schema.columns WHERE table_catalog = 'test_catalog' AND table_schema = 'wrong_schema1' AND table_name = 'test_table1'", "VALUES 0", (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"ConnectorMetadata.getSystemTable(schema=wrong_schema1, table=test_table1)", 4).add((Object)"ConnectorMetadata.getMaterializedView(schema=wrong_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getView(schema=wrong_schema1, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=wrong_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=wrong_schema1, table=test_table1)").build());
        this.assertMetadataCalls("SELECT count(*) from test_catalog.information_schema.columns WHERE table_catalog IN ('wrong', 'test_catalog') AND table_schema = 'wrong_schema1' AND table_name = 'test_table1'", "VALUES 0", (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"ConnectorMetadata.getSystemTable(schema=wrong_schema1, table=test_table1)", 4).add((Object)"ConnectorMetadata.getMaterializedView(schema=wrong_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getView(schema=wrong_schema1, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=wrong_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=wrong_schema1, table=test_table1)").build());
        this.assertMetadataCalls("SELECT count(*) FROM (SELECT * from test_catalog.information_schema.columns LIMIT 1)", "VALUES 1", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.listSchemaNames").build());
        this.assertMetadataCalls("SELECT count(*) FROM (SELECT * from test_catalog.information_schema.columns LIMIT 1000)", "VALUES 1000", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.listSchemaNames").add((Object)"ConnectorMetadata.streamRelationColumns(schema=test_schema1)").build());
        this.assertMetadataCalls("SELECT count(table_name), count(table_type) from test_catalog.information_schema.tables WHERE table_schema = '' AND table_name = ''", "VALUES (0, 0)", (Multiset<String>)ImmutableMultiset.of());
        this.assertMetadataCalls("SELECT count(table_name), count(table_type) from test_catalog.information_schema.tables WHERE table_schema = ''", "VALUES (0, 0)", (Multiset<String>)ImmutableMultiset.of());
        this.assertMetadataCalls("SELECT count(table_name), count(table_type) from test_catalog.information_schema.tables WHERE table_name = ''", "VALUES (0, 0)", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.listSchemaNames").build());
        this.assertMetadataCalls("SELECT count(table_name) from test_catalog.information_schema.tables WHERE table_schema LIKE 'test_sch_ma1'", "VALUES 1000", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.listSchemaNames").add((Object)"ConnectorMetadata.listTables(schema=test_schema1)").build());
    }

    @Test
    public void testMetadataListingExceptionHandling() {
        this.assertQueryFails("SELECT * FROM broken_catalog.information_schema.schemata", "Error listing schemas for catalog broken_catalog: Catalog is broken");
        this.assertQueryFails("SELECT * FROM broken_catalog.information_schema.tables", "Error listing tables for catalog broken_catalog: Catalog is broken");
        this.assertQueryFails("SELECT * FROM broken_catalog.information_schema.views", "Error listing views for catalog broken_catalog: Catalog is broken");
        this.assertQueryFails("SELECT * FROM broken_catalog.information_schema.table_privileges", "Error listing table privileges for catalog broken_catalog: Catalog is broken");
        this.assertQueryFails("SELECT * FROM broken_catalog.information_schema.columns", "Error listing table columns for catalog broken_catalog: Catalog is broken");
    }

    private void assertMetadataCalls(@Language(value="SQL") String actualSql, @Language(value="SQL") String expectedSql, Multiset<String> expectedMetadataCallsCount) {
        expectedMetadataCallsCount = ImmutableMultiset.builder().add((Object[])new String[]{"ConnectorMetadata.beginQuery", "ConnectorMetadata.cleanupQuery"}).addAll(expectedMetadataCallsCount).build();
        Multiset actualMetadataCallsCount = this.countingMockConnector.runTracing(() -> this.assertQuery(actualSql, expectedSql));
        MultisetAssertions.assertMultisetsEqual((Multiset)actualMetadataCallsCount, (Multiset)expectedMetadataCallsCount);
    }

    private static /* synthetic */ String lambda$testMetadataCalls$1(String rec$, Object xva$0) {
        return "'%s'".formatted(xva$0);
    }
}

