/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system.metadata;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import io.trino.Session;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.CountingMockConnector;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MultisetAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.tests.FailingMockConnectorPlugin;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestSystemMetadataConnector
extends AbstractTestQueryFramework {
    private static final int MAX_PREFIXES_COUNT = 10;
    private CountingMockConnector countingMockConnector;

    protected QueryRunner createQueryRunner() throws Exception {
        this.countingMockConnector = (CountingMockConnector)this.closeAfterClass((AutoCloseable)new CountingMockConnector());
        this.closeAfterClass(() -> {
            this.countingMockConnector = null;
        });
        Session session = TestingSession.testSessionBuilder().build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)session).setWorkerCount(0).addCoordinatorProperty("optimizer.experimental-max-prefetched-information-schema-prefixes", Integer.toString(10)).build();
        try {
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog("tpch", "tpch");
            queryRunner.installPlugin(this.countingMockConnector.getPlugin());
            queryRunner.createCatalog("test_catalog", "mock", Map.of());
            queryRunner.installPlugin((Plugin)new FailingMockConnectorPlugin());
            queryRunner.createCatalog("broken_catalog", "failing_mock", Map.of());
            return queryRunner;
        }
        catch (Exception e) {
            queryRunner.close();
            throw e;
        }
    }

    @Test
    void testMetadataCatalogs() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT catalog_name, connector_id, connector_name FROM system.metadata.catalogs"))).matches("VALUES (CAST('system' AS VARCHAR), CAST('system' AS VARCHAR), CAST('system' AS VARCHAR)),(CAST('test_catalog' AS VARCHAR), CAST('test_catalog' AS VARCHAR), CAST('mock' AS VARCHAR)),(CAST('broken_catalog' AS VARCHAR), CAST('broken_catalog' AS VARCHAR), CAST('failing_mock' AS VARCHAR)),(CAST('tpch' AS VARCHAR), CAST('tpch' AS VARCHAR), CAST('tpch' AS VARCHAR))");
    }

    @Test
    public void testTableCommentsMetadataCalls() {
        this.assertMetadataCalls("SELECT comment FROM system.metadata.table_comments WHERE catalog_name = 'test_catalog' AND schema_name = 'test_schema1' AND table_name = 'test_table1'", "VALUES 'comment for test_schema1.test_table1'", (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema1, table=test_table1)", 4).add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableMetadata(handle=test_schema1.test_table1)").build());
        this.assertMetadataCalls("SELECT comment FROM system.metadata.table_comments WHERE catalog_name = 'test_catalog' AND schema_name = 'test_schema1' AND table_name = 'does_not_exist'", "SELECT '' WHERE false", (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema1, table=does_not_exist)", 4).add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema1, table=does_not_exist)").add((Object)"ConnectorMetadata.getView(schema=test_schema1, table=does_not_exist)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema1, table=does_not_exist)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema1, table=does_not_exist)").build());
        this.assertMetadataCalls("SELECT comment FROM system.metadata.table_comments WHERE catalog_name = 'test_catalog' AND schema_name = 'wrong_schema1' AND table_name = 'test_table1'", "SELECT '' WHERE false", (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"ConnectorMetadata.getSystemTable(schema=wrong_schema1, table=test_table1)", 4).add((Object)"ConnectorMetadata.getMaterializedView(schema=wrong_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getView(schema=wrong_schema1, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=wrong_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=wrong_schema1, table=test_table1)").build());
        this.assertMetadataCalls("SELECT comment FROM system.metadata.table_comments WHERE catalog_name IN ('wrong', 'test_catalog') AND schema_name = 'wrong_schema1' AND table_name = 'test_table1'", "SELECT '' WHERE false", (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"ConnectorMetadata.getSystemTable(schema=wrong_schema1, table=test_table1)", 4).add((Object)"ConnectorMetadata.getMaterializedView(schema=wrong_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getView(schema=wrong_schema1, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=wrong_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=wrong_schema1, table=test_table1)").build());
        this.assertMetadataCalls("SELECT count(DISTINCT schema_name), count(DISTINCT table_name), count(comment), count(*) FROM system.metadata.table_comments WHERE catalog_name = 'test_catalog'", "VALUES (3, 2008, 3000, 3008)", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.streamRelationComments").build());
        this.assertMetadataCalls("SELECT count(DISTINCT schema_name), count(DISTINCT table_name), count(comment), count(*) FROM system.metadata.table_comments WHERE catalog_name = 'test_catalog' AND schema_name != 'information_schema'", "VALUES (2, 2000, 3000, 3000)", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.streamRelationComments").build());
        this.assertMetadataCalls("SELECT count(DISTINCT schema_name), count(DISTINCT table_name), count(comment), count(*) FROM system.metadata.table_comments WHERE catalog_name IN ('test_catalog', 'tpch')", "VALUES (12, 2016, 3000, 3088)", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.streamRelationComments").build());
        this.assertMetadataCalls("SELECT count(table_name), count(comment) FROM system.metadata.table_comments WHERE catalog_name = 'test_catalog' AND schema_name = 'test_schema1'", "VALUES (1000, 1000)", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.streamRelationComments(schema=test_schema1)").build());
        this.assertMetadataCalls("SELECT count(DISTINCT schema_name), count(DISTINCT table_name), count(comment), count(*) FROM system.metadata.table_comments WHERE catalog_name = 'test_catalog' AND schema_name IN ('test_schema1', 'test_schema2')", "VALUES (2, 2000, 3000, 3000)", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.streamRelationComments(schema=test_schema1)").add((Object)"ConnectorMetadata.streamRelationComments(schema=test_schema2)").build());
        String string = "'%s'";
        string = "ConnectorMetadata.streamRelationComments(schema=bogus_schema%s)";
        this.assertMetadataCalls("SELECT count(DISTINCT schema_name), count(DISTINCT table_name), count(comment), count(*) FROM system.metadata.table_comments WHERE catalog_name = 'test_catalog' AND schema_name IN " + Stream.concat(Stream.of("test_schema1", "test_schema2"), IntStream.range(1, 11).mapToObj(i -> "bogus_schema" + i)).map(arg_0 -> TestSystemMetadataConnector.lambda$testTableCommentsMetadataCalls$1("'%s'", arg_0)).collect(Collectors.joining(",", "(", ")")), "VALUES (2, 2000, 3000, 3000)", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.streamRelationComments(schema=test_schema1)").add((Object)"ConnectorMetadata.streamRelationComments(schema=test_schema2)").addAll(IntStream.range(1, 11).mapToObj(arg_0 -> TestSystemMetadataConnector.lambda$testTableCommentsMetadataCalls$2("ConnectorMetadata.streamRelationComments(schema=bogus_schema%s)", arg_0)).toList()).build());
        this.assertMetadataCalls("SELECT count(*) FROM (SELECT * FROM system.metadata.table_comments WHERE catalog_name = 'test_catalog' LIMIT 1)", "VALUES 1", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.streamRelationComments").build());
        this.assertMetadataCalls("SELECT count(*) FROM (SELECT * FROM system.metadata.table_comments WHERE catalog_name = 'test_catalog' LIMIT 1000)", "VALUES 1000", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.streamRelationComments").build());
        this.assertMetadataCalls("SELECT comment FROM system.metadata.table_comments WHERE catalog_name = 'wrong'", "SELECT '' WHERE false", (Multiset<String>)ImmutableMultiset.of());
        this.assertMetadataCalls("SELECT comment FROM system.metadata.table_comments WHERE catalog_name = ''", "SELECT '' WHERE false", (Multiset<String>)ImmutableMultiset.of());
        this.assertMetadataCalls("SELECT comment FROM system.metadata.table_comments WHERE schema_name = '' AND table_name = ''", "SELECT '' WHERE false", (Multiset<String>)ImmutableMultiset.of());
        this.assertMetadataCalls("SELECT count(comment) FROM system.metadata.table_comments WHERE schema_name = ''", "VALUES 0", (Multiset<String>)ImmutableMultiset.of());
        this.assertMetadataCalls("SELECT count(comment) FROM system.metadata.table_comments WHERE table_name = ''", "VALUES 0", (Multiset<String>)ImmutableMultiset.of());
    }

    @Test
    public void testMaterializedViewsMetadataCalls() {
        this.assertMetadataCalls("SELECT comment FROM system.metadata.materialized_views WHERE catalog_name = 'test_catalog' AND schema_name = 'test_schema1' AND name = 'test_table1'", "SELECT '' WHERE false", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema1, table=test_table1)").build());
        this.assertMetadataCalls("SELECT comment FROM system.metadata.materialized_views WHERE catalog_name = 'test_catalog' AND schema_name = 'test_schema1' AND name = 'does_not_exist'", "SELECT '' WHERE false", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema1, table=does_not_exist)").build());
        this.assertMetadataCalls("SELECT comment FROM system.metadata.materialized_views WHERE catalog_name = 'test_catalog' AND schema_name = 'wrong_schema1' AND name = 'test_table1'", "SELECT '' WHERE false", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getMaterializedView(schema=wrong_schema1, table=test_table1)").build());
        this.assertMetadataCalls("SELECT comment FROM system.metadata.materialized_views WHERE catalog_name IN ('wrong', 'test_catalog') AND schema_name = 'wrong_schema1' AND name = 'test_table1'", "SELECT '' WHERE false", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getMaterializedView(schema=wrong_schema1, table=test_table1)").build());
        this.assertMetadataCalls("SELECT count(DISTINCT schema_name), count(DISTINCT name), count(comment), count(*) FROM system.metadata.materialized_views WHERE catalog_name = 'test_catalog'", "VALUES (0, 0, 0, 0)", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getMaterializedViews").build());
        this.assertMetadataCalls("SELECT count(DISTINCT schema_name), count(DISTINCT name), count(comment), count(*) FROM system.metadata.materialized_views WHERE catalog_name = 'test_catalog' AND schema_name != 'information_schema'", "VALUES (0, 0, 0, 0)", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getMaterializedViews").build());
        this.assertMetadataCalls("SELECT count(DISTINCT schema_name), count(DISTINCT name), count(comment), count(*) FROM system.metadata.materialized_views WHERE catalog_name IN ('test_catalog', 'tpch')", "VALUES (0, 0, 0, 0)", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getMaterializedViews").build());
        this.assertMetadataCalls("SELECT count(name), count(comment) FROM system.metadata.materialized_views WHERE catalog_name = 'test_catalog' AND schema_name = 'test_schema1'", "VALUES (0, 0)", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getMaterializedViews(schema=test_schema1)").build());
        this.assertMetadataCalls("SELECT count(DISTINCT schema_name), count(DISTINCT name), count(comment), count(*) FROM system.metadata.materialized_views WHERE catalog_name = 'test_catalog' AND schema_name IN ('test_schema1', 'test_schema2')", "VALUES (0, 0, 0, 0)", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getMaterializedViews(schema=test_schema1)").add((Object)"ConnectorMetadata.getMaterializedViews(schema=test_schema2)").build());
        String string = "'%s'";
        string = "ConnectorMetadata.getMaterializedViews(schema=bogus_schema%s)";
        this.assertMetadataCalls("SELECT count(DISTINCT schema_name), count(DISTINCT name), count(comment), count(*) FROM system.metadata.materialized_views WHERE catalog_name = 'test_catalog' AND schema_name IN " + Stream.concat(Stream.of("test_schema1", "test_schema2"), IntStream.range(1, 11).mapToObj(i -> "bogus_schema" + i)).map(arg_0 -> TestSystemMetadataConnector.lambda$testMaterializedViewsMetadataCalls$1("'%s'", arg_0)).collect(Collectors.joining(",", "(", ")")), "VALUES (0, 0, 0, 0)", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getMaterializedViews(schema=test_schema1)").add((Object)"ConnectorMetadata.getMaterializedViews(schema=test_schema2)").addAll(IntStream.range(1, 11).mapToObj(arg_0 -> TestSystemMetadataConnector.lambda$testMaterializedViewsMetadataCalls$2("ConnectorMetadata.getMaterializedViews(schema=bogus_schema%s)", arg_0)).toList()).build());
        this.assertMetadataCalls("SELECT count(*) FROM (SELECT * FROM system.metadata.materialized_views WHERE catalog_name = 'test_catalog' LIMIT 1)", "VALUES 0", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.listMaterializedViews").build());
        this.assertMetadataCalls("SELECT count(*) FROM (SELECT * FROM system.metadata.materialized_views WHERE catalog_name = 'test_catalog' LIMIT 1000)", "VALUES 0", (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.listMaterializedViews").build());
        this.assertMetadataCalls("SELECT comment FROM system.metadata.materialized_views WHERE catalog_name = 'wrong'", "SELECT '' WHERE false", (Multiset<String>)ImmutableMultiset.of());
        this.assertMetadataCalls("SELECT comment FROM system.metadata.materialized_views WHERE catalog_name = ''", "SELECT '' WHERE false", (Multiset<String>)ImmutableMultiset.of());
        this.assertMetadataCalls("SELECT comment FROM system.metadata.materialized_views WHERE schema_name = '' AND name = ''", "SELECT '' WHERE false", (Multiset<String>)ImmutableMultiset.of());
        this.assertMetadataCalls("SELECT count(comment) FROM system.metadata.materialized_views WHERE schema_name = ''", "VALUES 0", (Multiset<String>)ImmutableMultiset.of());
        this.assertMetadataCalls("SELECT count(comment) FROM system.metadata.materialized_views WHERE name = ''", "VALUES 0", (Multiset<String>)ImmutableMultiset.of());
    }

    @Test
    public void testMetadataListingExceptionHandling() {
        this.assertQueryFails("SELECT * FROM system.metadata.table_comments", "Catalog is broken");
        this.assertQueryFails("SELECT * FROM system.metadata.materialized_views", "Error listing materialized views for catalog broken_catalog: Catalog is broken");
    }

    private void assertMetadataCalls(@Language(value="SQL") String actualSql, @Language(value="SQL") String expectedSql, Multiset<String> expectedMetadataCallsCount) {
        Multiset actualMetadataCallsCount = this.countingMockConnector.runTracing(() -> this.assertQuery(actualSql, expectedSql));
        actualMetadataCallsCount = (Multiset)actualMetadataCallsCount.stream().filter(method -> !"ConnectorMetadata.beginQuery".equals(method) && !"ConnectorMetadata.cleanupQuery".equals(method)).collect(ImmutableMultiset.toImmutableMultiset());
        MultisetAssertions.assertMultisetsEqual((Multiset)actualMetadataCallsCount, expectedMetadataCallsCount);
    }

    private static /* synthetic */ String lambda$testMaterializedViewsMetadataCalls$2(String rec$, Object xva$0) {
        return "ConnectorMetadata.getMaterializedViews(schema=bogus_schema%s)".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$testMaterializedViewsMetadataCalls$1(String rec$, Object xva$0) {
        return "'%s'".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$testTableCommentsMetadataCalls$2(String rec$, Object xva$0) {
        return "ConnectorMetadata.streamRelationComments(schema=bogus_schema%s)".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$testTableCommentsMetadataCalls$1(String rec$, Object xva$0) {
        return "'%s'".formatted(xva$0);
    }
}

