/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system.runtime;

import com.google.common.collect.MoreCollectors;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.concurrent.Threads;
import io.trino.Session;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.security.Identity;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingSession;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestKillQuery
extends AbstractTestQueryFramework {
    private final ExecutorService executor = Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)TestKillQuery.class.getSimpleName()));

    protected QueryRunner createQueryRunner() throws Exception {
        Session defaultSession = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)defaultSession).build();
        queryRunner.installPlugin((Plugin)new TpchPlugin());
        queryRunner.createCatalog("tpch", "tpch");
        return queryRunner;
    }

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    @Timeout(value=60L)
    public void testKillQuery() {
        this.killQuery(queryId -> String.format("CALL system.runtime.kill_query('%s', 'because')", queryId), "Message: because");
        this.killQuery(queryId -> String.format("CALL system.runtime.kill_query('%s')", queryId), "No message provided.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killQuery(Function<String, String> sql, String expectedKilledMessage) {
        String testQueryId = "test_query_id_" + UUID.randomUUID().toString().replace("-", "");
        Future<?> queryFuture = this.executor.submit(() -> this.getQueryRunner().execute(String.format("SELECT count(comment) as %s FROM tpch.sf100000.lineitem", testQueryId)));
        Optional queryIdValue = Optional.empty();
        while (queryIdValue.isEmpty()) {
            Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
            queryIdValue = (Optional)this.computeActual(String.format("SELECT query_id FROM system.runtime.queries WHERE query LIKE '%%%s%%' AND query NOT LIKE '%%system.runtime.queries%%'", testQueryId)).getOnlyColumn().collect(MoreCollectors.toOptional());
        }
        String queryId = queryIdValue.get().toString();
        Assertions.assertThat((boolean)queryFuture.isDone()).isFalse();
        this.getQueryRunner().getAccessControl().deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"query", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.KILL_QUERY)});
        try {
            Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(this.getSession("other_user"), String.format("CALL system.runtime.kill_query('%s', 'should fail')", queryId))).hasMessageContaining("Cannot kill query");
        }
        finally {
            this.getQueryRunner().getAccessControl().reset();
        }
        this.getQueryRunner().execute(sql.apply(queryId));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> queryFuture.get(1L, TimeUnit.MINUTES)).isInstanceOf(ExecutionException.class)).hasMessageContaining("Query killed. " + expectedKilledMessage);
    }

    @Test
    public void testKillQueryWithNullArgument() {
        this.assertQueryFails("CALL system.runtime.kill_query(NULL, 'should fail')", "query_id cannot be null");
    }

    private Session getSession(String user) {
        return TestingSession.testSessionBuilder().setCatalog(this.getSession().getCatalog()).setSchema(this.getSession().getSchema()).setIdentity(Identity.ofUser((String)user)).build();
    }
}

