/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system.runtime;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreCollectors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.Threads;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.Assert;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.assertj.core.api.AbstractZonedDateTimeAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestSystemRuntimeConnector
extends AbstractTestQueryFramework {
    private static final Function<SchemaTableName, List<ColumnMetadata>> DEFAULT_GET_COLUMNS = table -> ImmutableList.of((Object)new ColumnMetadata("c", (Type)VarcharType.VARCHAR));
    private static final AtomicLong counter = new AtomicLong();
    private static Function<SchemaTableName, List<ColumnMetadata>> getColumns;
    private final ExecutorService executor = Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)TestSystemRuntimeConnector.class.getSimpleName()));

    protected QueryRunner createQueryRunner() throws Exception {
        Session defaultSession = TestingSession.testSessionBuilder().setCatalog("mock").setSchema("default").build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)defaultSession).enableBackupCoordinator().setWorkerCount(1).build();
        queryRunner.installPlugin(new Plugin(this){

            public Iterable<ConnectorFactory> getConnectorFactories() {
                MockConnectorFactory connectorFactory = MockConnectorFactory.builder().withGetViews((session, schemaTablePrefix) -> ImmutableMap.of()).withListTables((session, s) -> ImmutableList.of((Object)"test_table")).withGetColumns(tableName -> getColumns.apply((SchemaTableName)tableName)).build();
                return ImmutableList.of((Object)connectorFactory);
            }
        });
        queryRunner.createCatalog("mock", "mock", (Map)ImmutableMap.of());
        return queryRunner;
    }

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testRuntimeNodes() {
        this.assertQuery("SELECT node_version, coordinator, state FROM system.runtime.nodes", "VALUES ('testversion', true, 'active'),('testversion', true, 'active'),('testversion', false, 'active')");
    }

    @Test
    void testOptimizerRuleStats() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT rule_name, invocations, matches, failures FROM system.runtime.optimizer_rule_stats"))).result().hasTypes((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    }

    @Test
    public void testRuntimeQueriesTimestamps() {
        TestSystemRuntimeConnector.run(10, 0.8, () -> {
            ZonedDateTime timeBefore = ZonedDateTime.now();
            this.computeActual("SELECT 1");
            MaterializedResult result = this.computeActual("SELECT max(created), max(started), max(last_heartbeat), max(\"end\") FROM system.runtime.queries");
            ZonedDateTime timeAfter = ZonedDateTime.now();
            MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)result.toTestTypes().getMaterializedRows());
            List fields = row.getFields();
            Assertions.assertThat((List)fields).hasSize(4);
            for (int i = 0; i < fields.size(); ++i) {
                Object value = fields.get(i);
                ((AbstractZonedDateTimeAssert)((AbstractZonedDateTimeAssert)Assertions.assertThat((ZonedDateTime)((ZonedDateTime)value)).as("value for field " + i, new Object[0])).isNotNull()).isAfterOrEqualTo(timeBefore).isBeforeOrEqualTo(timeAfter);
            }
        });
    }

    @Test
    public void testRuntimeTasksTimestamps() {
        TestSystemRuntimeConnector.run(10, 0.8, () -> {
            ZonedDateTime timeBefore = ZonedDateTime.now();
            this.computeActual("SELECT 1");
            MaterializedResult result = this.computeActual("SELECT max(created), max(start), max(last_heartbeat), max(\"end\") FROM system.runtime.tasks");
            ZonedDateTime timeAfter = ZonedDateTime.now();
            MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)result.toTestTypes().getMaterializedRows());
            List fields = row.getFields();
            Assertions.assertThat((List)fields).hasSize(4);
            for (int i = 0; i < fields.size(); ++i) {
                Object value = fields.get(i);
                ((AbstractZonedDateTimeAssert)((AbstractZonedDateTimeAssert)Assertions.assertThat((ZonedDateTime)((ZonedDateTime)value)).as("value for field " + i, new Object[0])).isNotNull()).isAfterOrEqualTo(timeBefore).isBeforeOrEqualTo(timeAfter);
            }
        });
    }

    @Test
    public void testRuntimeTransactionsTimestamps() {
        TestSystemRuntimeConnector.run(10, 0.8, () -> {
            ZonedDateTime timeBefore = ZonedDateTime.now();
            this.computeActual("START TRANSACTION");
            MaterializedResult result = this.computeActual("SELECT max(create_time) FROM system.runtime.transactions");
            ZonedDateTime timeAfter = ZonedDateTime.now();
            MaterializedRow row = (MaterializedRow)Iterables.getOnlyElement((Iterable)result.toTestTypes().getMaterializedRows());
            List fields = row.getFields();
            Assertions.assertThat((List)fields).hasSize(1);
            for (int i = 0; i < fields.size(); ++i) {
                Object value = fields.get(i);
                ((AbstractZonedDateTimeAssert)((AbstractZonedDateTimeAssert)Assertions.assertThat((ZonedDateTime)((ZonedDateTime)value)).as("value for field " + i, new Object[0])).isNotNull()).isAfterOrEqualTo(timeBefore).isBeforeOrEqualTo(timeAfter);
            }
        });
    }

    @Test
    public void testFinishedQueryIsCaptured() {
        getColumns = DEFAULT_GET_COLUMNS;
        String testQueryId = "test_query_id_" + counter.incrementAndGet();
        this.getQueryRunner().execute(String.format("EXPLAIN SELECT 1 AS %s FROM test_table", testQueryId));
        this.assertQuery(String.format("SELECT state FROM system.runtime.queries WHERE query LIKE '%%%s%%' AND query NOT LIKE '%%system.runtime.queries%%'", testQueryId), "VALUES 'FINISHED'");
    }

    @Test
    @Timeout(value=60L)
    public void testQueryDuringAnalysisIsCaptured() {
        SettableFuture metadataFuture = SettableFuture.create();
        getColumns = schemaTableName -> {
            try {
                return (List)metadataFuture.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        String testQueryId = "test_query_id_" + counter.incrementAndGet();
        Future<?> queryFuture = this.executor.submit(() -> this.getQueryRunner().execute(String.format("EXPLAIN SELECT 1 AS %s FROM test_table", testQueryId)));
        this.assertQueryEventually(this.getSession(), String.format("SELECT state FROM system.runtime.queries WHERE query LIKE '%%%s%%' AND query NOT LIKE '%%system.runtime.queries%%'", testQueryId), "VALUES 'WAITING_FOR_RESOURCES'", new Duration(10.0, TimeUnit.SECONDS));
        Assertions.assertThat((boolean)metadataFuture.isDone()).isFalse();
        Assertions.assertThat((boolean)queryFuture.isDone()).isFalse();
        metadataFuture.set((Object)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT)));
        this.assertQueryEventually(this.getSession(), String.format("SELECT state FROM system.runtime.queries WHERE query LIKE '%%%s%%' AND query NOT LIKE '%%system.runtime.queries%%'", testQueryId), "VALUES 'FINISHED'", new Duration(10.0, TimeUnit.SECONDS));
        Assert.assertEventually((Duration)new Duration(5.0, TimeUnit.SECONDS), () -> Assertions.assertThat((boolean)queryFuture.isDone()).isTrue());
    }

    @Test
    @Timeout(value=60L)
    public void testQueryKillingDuringAnalysis() {
        SettableFuture metadataFuture = SettableFuture.create();
        getColumns = schemaTableName -> {
            try {
                return (List)metadataFuture.get();
            }
            catch (InterruptedException e) {
                metadataFuture.cancel(true);
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        };
        String testQueryId = "test_query_id_" + counter.incrementAndGet();
        Future<?> queryFuture = this.executor.submit(() -> this.getQueryRunner().execute(String.format("EXPLAIN SELECT 1 AS %s FROM test_table", testQueryId)));
        this.assertQueryEventually(this.getSession(), String.format("SELECT count(*) FROM system.runtime.queries WHERE query LIKE '%%%s%%' AND query NOT LIKE '%%system.runtime.queries%%'", testQueryId), "VALUES 1", new Duration(5.0, TimeUnit.SECONDS));
        Optional queryId = (Optional)this.computeActual(String.format("SELECT query_id FROM system.runtime.queries WHERE query LIKE '%%%s%%' AND query NOT LIKE '%%system.runtime.queries%%'", testQueryId)).getOnlyColumn().collect(MoreCollectors.toOptional());
        Assertions.assertThat((boolean)metadataFuture.isDone()).isFalse();
        Assertions.assertThat((boolean)queryFuture.isDone()).isFalse();
        Assertions.assertThat((Optional)queryId).isPresent();
        this.getQueryRunner().execute(String.format("CALL system.runtime.kill_query('%s', 'because')", queryId.get()));
        Assert.assertEventually((Duration)new Duration(5.0, TimeUnit.SECONDS), () -> Assertions.assertThat((boolean)metadataFuture.isCancelled()).isTrue());
        Assert.assertEventually((Duration)new Duration(5.0, TimeUnit.SECONDS), () -> Assertions.assertThat((boolean)queryFuture.isDone()).isTrue());
    }

    @Test
    public void testTasksTable() {
        this.getQueryRunner().execute("SELECT 1");
        this.getQueryRunner().execute("SELECT * FROM system.runtime.tasks");
    }

    private static void run(int repetitions, double successRate, Runnable test) {
        AssertionError lastError = null;
        int failures = 0;
        for (int iteration = 0; iteration < repetitions; ++iteration) {
            try {
                test.run();
                continue;
            }
            catch (AssertionError e) {
                ++failures;
                lastError = e;
            }
        }
        if (lastError != null && 1.0 - (double)failures * 1.0 / (double)repetitions < successRate) {
            throw lastError;
        }
    }
}

