/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.operator.RetryPolicy;
import io.trino.plugin.memory.MemoryPlugin;
import io.trino.plugin.tpcds.TpcdsPlugin;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingPageSinkProvider;
import io.trino.testing.TestingSession;
import io.trino.testing.TestingSplit;
import io.trino.testing.TestingTransactionHandle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.LongStream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public abstract class AbstractTestCoordinatorDynamicFiltering
extends AbstractTestQueryFramework {
    private static final TestingMetadata.TestingColumnHandle ORDERKEY_HANDLE = new TestingMetadata.TestingColumnHandle("orderkey", 0, (Type)BigintType.BIGINT);
    private static final TestingMetadata.TestingColumnHandle SUPP_KEY_HANDLE = new TestingMetadata.TestingColumnHandle("suppkey", 2, (Type)BigintType.BIGINT);
    private static final TestingMetadata.TestingColumnHandle ADDRESS_KEY_HANDLE = new TestingMetadata.TestingColumnHandle("address", 2, (Type)VarcharType.createVarcharType((int)40));
    private static final TestingMetadata.TestingColumnHandle SS_SOLD_SK_HANDLE = new TestingMetadata.TestingColumnHandle("ss_sold_date_sk", 0, (Type)BigintType.BIGINT);
    private volatile Set<ColumnHandle> expectedDynamicFilterColumnsCovered;
    private volatile Consumer<TupleDomain<ColumnHandle>> expectedCoordinatorDynamicFilterAssertion;
    private volatile Consumer<TupleDomain<ColumnHandle>> expectedTableScanDynamicFilterAssertion;

    @BeforeAll
    public void setup() {
        this.getQueryRunner().installPlugin((Plugin)new TestingPlugin(this.getRetryPolicy() == RetryPolicy.TASK));
        this.getQueryRunner().installPlugin((Plugin)new TpchPlugin());
        this.getQueryRunner().installPlugin((Plugin)new TpcdsPlugin());
        this.getQueryRunner().installPlugin((Plugin)new MemoryPlugin());
        this.getQueryRunner().createCatalog("test", "test", (Map)ImmutableMap.of());
        this.getQueryRunner().createCatalog("tpch", "tpch", (Map)ImmutableMap.of((Object)"tpch.partitioning-enabled", (Object)"false", (Object)"tpch.splits-per-node", (Object)"16"));
        this.getQueryRunner().createCatalog("tpcds", "tpcds", (Map)ImmutableMap.of());
        this.getQueryRunner().createCatalog("memory", "memory", (Map)ImmutableMap.of((Object)"memory.splits-per-node", (Object)"16"));
        this.computeActual("CREATE TABLE lineitem AS SELECT * FROM tpch.tiny.lineitem");
        this.computeActual("CREATE TABLE customer AS SELECT * FROM tpch.tiny.customer");
        this.computeActual("CREATE TABLE store_sales AS SELECT * FROM tpcds.tiny.store_sales");
    }

    protected abstract RetryPolicy getRetryPolicy();

    @Test
    @Timeout(value=30L)
    public void testJoinWithEmptyBuildSide() {
        this.testJoinWithEmptyBuildSide(OptimizerConfig.JoinDistributionType.BROADCAST);
        this.testJoinWithEmptyBuildSide(OptimizerConfig.JoinDistributionType.PARTITIONED);
    }

    private void testJoinWithEmptyBuildSide(OptimizerConfig.JoinDistributionType joinDistributionType) {
        this.assertQueryDynamicFilters(this.noJoinReordering(joinDistributionType), "SELECT * FROM lineitem JOIN tpch.tiny.supplier ON lineitem.suppkey = supplier.suppkey AND supplier.name = 'abc'", Set.of(SUPP_KEY_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.none());
    }

    @Test
    @Timeout(value=30L)
    public void testJoinWithLargeBuildSide() {
        this.testJoinWithLargeBuildSide(OptimizerConfig.JoinDistributionType.BROADCAST);
        this.testJoinWithLargeBuildSide(OptimizerConfig.JoinDistributionType.PARTITIONED);
    }

    private void testJoinWithLargeBuildSide(OptimizerConfig.JoinDistributionType joinDistributionType) {
        this.assertQueryDynamicFilters(this.noJoinReordering(joinDistributionType), "SELECT * FROM lineitem JOIN tpch.tiny.orders ON lineitem.orderkey = orders.orderkey", Set.of(ORDERKEY_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.all());
    }

    @Test
    @Timeout(value=30L)
    public void testMultiColumnJoinWithDifferentCardinalitiesInBuildSide() {
        this.testMultiColumnJoinWithDifferentCardinalitiesInBuildSide(OptimizerConfig.JoinDistributionType.BROADCAST);
        this.testMultiColumnJoinWithDifferentCardinalitiesInBuildSide(OptimizerConfig.JoinDistributionType.PARTITIONED);
    }

    private void testMultiColumnJoinWithDifferentCardinalitiesInBuildSide(OptimizerConfig.JoinDistributionType joinDistributionType) {
        this.assertQueryDynamicFilters(this.noJoinReordering(joinDistributionType), "SELECT * FROM lineitem l1 JOIN tpch.tiny.lineitem l2 ON l1.orderkey = l2.orderkey AND l1.suppkey = l2.suppkey WHERE l2.suppkey BETWEEN 1 AND 10", Set.of(ORDERKEY_HANDLE, SUPP_KEY_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)SUPP_KEY_HANDLE, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)((List)LongStream.rangeClosed(1L, 10L).boxed().collect(ImmutableList.toImmutableList()))))));
    }

    @Test
    @Timeout(value=30L)
    public void testJoinWithSelectiveBuildSide() {
        this.testJoinWithSelectiveBuildSide(OptimizerConfig.JoinDistributionType.BROADCAST);
        this.testJoinWithSelectiveBuildSide(OptimizerConfig.JoinDistributionType.PARTITIONED);
    }

    private void testJoinWithSelectiveBuildSide(OptimizerConfig.JoinDistributionType joinDistributionType) {
        this.assertQueryDynamicFilters(this.noJoinReordering(joinDistributionType), "SELECT * FROM lineitem JOIN tpch.tiny.supplier ON lineitem.suppkey = supplier.suppkey AND supplier.name = 'Supplier#000000001'", Set.of(SUPP_KEY_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)SUPP_KEY_HANDLE, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))));
    }

    @Test
    @Timeout(value=30L)
    public void testInequalityJoinWithSelectiveBuildSide() {
        this.assertQueryDynamicFilters("SELECT * FROM lineitem JOIN tpch.tiny.supplier ON lineitem.suppkey <= supplier.suppkey AND supplier.name IN ('Supplier#000000001', 'Supplier#000000002')", Set.of(SUPP_KEY_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)SUPP_KEY_HANDLE, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertQueryDynamicFilters("SELECT * FROM lineitem JOIN tpch.tiny.supplier ON lineitem.suppkey < supplier.suppkey AND supplier.name IN ('Supplier#000000001', 'Supplier#000000002')", Set.of(SUPP_KEY_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)SUPP_KEY_HANDLE, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertQueryDynamicFilters("SELECT * FROM lineitem JOIN tpch.tiny.supplier ON lineitem.suppkey >= supplier.suppkey AND supplier.name IN ('Supplier#000000001', 'Supplier#000000002')", Set.of(SUPP_KEY_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)SUPP_KEY_HANDLE, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false))));
        this.assertQueryDynamicFilters("SELECT * FROM lineitem JOIN tpch.tiny.supplier ON lineitem.suppkey > supplier.suppkey AND supplier.name IN ('Supplier#000000001', 'Supplier#000000002')", Set.of(SUPP_KEY_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)SUPP_KEY_HANDLE, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false))));
    }

    @Test
    @Timeout(value=30L)
    public void testIsNotDistinctFromJoinWithSelectiveBuildSide() {
        this.assertQueryDynamicFilters("SELECT * FROM store_sales JOIN tpcds.tiny.store ON store_sales.ss_sold_date_sk = store.s_closed_date_sk", Set.of(SS_SOLD_SK_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)SS_SOLD_SK_HANDLE, (Object)Domain.create((ValueSet)ValueSet.of((Type)BigintType.BIGINT, (Object)2451189L, (Object[])new Object[0]), (boolean)false))));
        this.assertQueryDynamicFilters("SELECT * FROM store_sales JOIN tpcds.tiny.store ON store_sales.ss_sold_date_sk IS NOT DISTINCT FROM store.s_closed_date_sk", Set.of(SS_SOLD_SK_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)SS_SOLD_SK_HANDLE, (Object)Domain.create((ValueSet)ValueSet.of((Type)BigintType.BIGINT, (Object)2451189L, (Object[])new Object[0]), (boolean)true))));
        this.assertQueryDynamicFilters("SELECT * FROM store_sales JOIN tpcds.tiny.store ON store_sales.ss_sold_date_sk IS NOT DISTINCT FROM store.s_closed_date_sk AND store.s_closed_date_sk < 0", Set.of(SS_SOLD_SK_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)SS_SOLD_SK_HANDLE, (Object)Domain.onlyNull((Type)BigintType.BIGINT))));
    }

    @Test
    @Timeout(value=30L)
    public void testJoinWithImplicitCoercion() {
        this.computeActual("CREATE TABLE memory.default.supplier_decimal AS SELECT name, CAST(suppkey as decimal(19, 0)) suppkey_decimal FROM tpch.tiny.supplier");
        this.assertQueryDynamicFilters("SELECT * FROM lineitem JOIN memory.default.supplier_decimal s ON lineitem.suppkey = s.suppkey_decimal AND s.name >= 'Supplier#000000080'", Set.of(SUPP_KEY_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)SUPP_KEY_HANDLE, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)((List)LongStream.rangeClosed(80L, 100L).boxed().collect(ImmutableList.toImmutableList()))))));
        this.computeActual("CREATE TABLE memory.default.supplier_varchar AS SELECT name, CAST(address as varchar(42)) address FROM tpch.tiny.supplier");
        List values = (List)this.computeActual("SELECT address FROM memory.default.supplier_varchar WHERE name >= 'Supplier#000000080'").getOnlyColumn().map(Object::toString).collect(ImmutableList.toImmutableList());
        this.assertQueryDynamicFilters("SELECT * FROM customer JOIN memory.default.supplier_varchar s ON customer.address = s.address AND s.name >= 'Supplier#000000080'", Set.of(ADDRESS_KEY_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)ADDRESS_KEY_HANDLE, (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)40), (List)values))));
    }

    @Test
    @Timeout(value=30L)
    public void testJoinWithNonSelectiveBuildSide() {
        this.testJoinWithNonSelectiveBuildSide(OptimizerConfig.JoinDistributionType.BROADCAST);
        this.testJoinWithNonSelectiveBuildSide(OptimizerConfig.JoinDistributionType.PARTITIONED);
    }

    protected void testJoinWithNonSelectiveBuildSide(OptimizerConfig.JoinDistributionType joinDistributionType) {
        this.assertQueryDynamicFilters(this.noJoinReordering(joinDistributionType), "SELECT * FROM lineitem JOIN tpch.tiny.supplier ON lineitem.suppkey = supplier.suppkey", Set.of(SUPP_KEY_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)SUPP_KEY_HANDLE, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)false))));
    }

    @Test
    @Timeout(value=30L)
    public void testJoinWithMultipleDynamicFiltersOnProbe() {
        this.testJoinWithMultipleDynamicFiltersOnProbe(OptimizerConfig.JoinDistributionType.BROADCAST);
        this.testJoinWithMultipleDynamicFiltersOnProbe(OptimizerConfig.JoinDistributionType.PARTITIONED);
    }

    private void testJoinWithMultipleDynamicFiltersOnProbe(OptimizerConfig.JoinDistributionType joinDistributionType) {
        this.assertQueryDynamicFilters(this.noJoinReordering(joinDistributionType), "SELECT * FROM (SELECT supplier.suppkey FROM lineitem JOIN tpch.tiny.supplier ON lineitem.suppkey = supplier.suppkey AND supplier.name IN ('Supplier#000000001', 'Supplier#000000002')) t JOIN tpch.tiny.partsupp ON t.suppkey = partsupp.suppkey AND partsupp.suppkey IN (2, 3)", Set.of(SUPP_KEY_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)SUPP_KEY_HANDLE, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))));
    }

    @Test
    @Timeout(value=30L)
    public void testRightJoinWithEmptyBuildSide() {
        this.assertQueryDynamicFilters("SELECT * FROM lineitem RIGHT JOIN tpch.tiny.supplier ON lineitem.suppkey = supplier.suppkey WHERE supplier.name = 'abc'", Set.of(SUPP_KEY_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.none());
    }

    @Test
    @Timeout(value=30L)
    public void testRightJoinWithNonSelectiveBuildSide() {
        this.assertQueryDynamicFilters("SELECT * FROM lineitem RIGHT JOIN tpch.tiny.supplier ON lineitem.suppkey = supplier.suppkey", Set.of(SUPP_KEY_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)SUPP_KEY_HANDLE, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)false))));
    }

    @Test
    @Timeout(value=30L)
    public void testRightJoinWithSelectiveBuildSide() {
        this.assertQueryDynamicFilters("SELECT * FROM lineitem RIGHT JOIN tpch.tiny.supplier ON lineitem.suppkey = supplier.suppkey WHERE supplier.name = 'Supplier#000000001'", Set.of(SUPP_KEY_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)SUPP_KEY_HANDLE, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))));
    }

    @Test
    @Timeout(value=30L)
    public void testSemiJoinWithEmptyBuildSide() {
        this.testSemiJoinWithEmptyBuildSide(OptimizerConfig.JoinDistributionType.BROADCAST);
        this.testSemiJoinWithEmptyBuildSide(OptimizerConfig.JoinDistributionType.PARTITIONED);
    }

    private void testSemiJoinWithEmptyBuildSide(OptimizerConfig.JoinDistributionType joinDistributionType) {
        this.assertQueryDynamicFilters(this.noJoinReordering(joinDistributionType), "SELECT * FROM lineitem WHERE lineitem.suppkey IN (SELECT supplier.suppkey FROM tpch.tiny.supplier WHERE supplier.name = 'abc')", Set.of(SUPP_KEY_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.none());
    }

    @Test
    @Timeout(value=30L)
    public void testSemiJoinWithLargeBuildSide() {
        this.testSemiJoinWithLargeBuildSide(OptimizerConfig.JoinDistributionType.BROADCAST);
        this.testSemiJoinWithLargeBuildSide(OptimizerConfig.JoinDistributionType.PARTITIONED);
    }

    private void testSemiJoinWithLargeBuildSide(OptimizerConfig.JoinDistributionType joinDistributionType) {
        this.assertQueryDynamicFilters(this.noJoinReordering(joinDistributionType), "SELECT * FROM lineitem WHERE lineitem.orderkey IN (SELECT orders.orderkey FROM tpch.tiny.orders)", Set.of(ORDERKEY_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.all());
    }

    @Test
    @Timeout(value=30L)
    public void testSemiJoinWithSelectiveBuildSide() {
        this.testSemiJoinWithSelectiveBuildSide(OptimizerConfig.JoinDistributionType.BROADCAST);
        this.testSemiJoinWithSelectiveBuildSide(OptimizerConfig.JoinDistributionType.PARTITIONED);
    }

    private void testSemiJoinWithSelectiveBuildSide(OptimizerConfig.JoinDistributionType joinDistributionType) {
        this.assertQueryDynamicFilters(this.noJoinReordering(joinDistributionType), "SELECT * FROM lineitem WHERE lineitem.suppkey IN (SELECT supplier.suppkey FROM tpch.tiny.supplier WHERE supplier.name = 'Supplier#000000001')", Set.of(SUPP_KEY_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)SUPP_KEY_HANDLE, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))));
    }

    @Test
    @Timeout(value=30L)
    public void testSemiJoinWithNonSelectiveBuildSide() {
        this.testSemiJoinWithNonSelectiveBuildSide(OptimizerConfig.JoinDistributionType.BROADCAST);
        this.testSemiJoinWithNonSelectiveBuildSide(OptimizerConfig.JoinDistributionType.PARTITIONED);
    }

    protected void testSemiJoinWithNonSelectiveBuildSide(OptimizerConfig.JoinDistributionType joinDistributionType) {
        this.assertQueryDynamicFilters(this.noJoinReordering(joinDistributionType), "SELECT * FROM lineitem WHERE lineitem.suppkey IN (SELECT supplier.suppkey FROM tpch.tiny.supplier)", Set.of(SUPP_KEY_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)SUPP_KEY_HANDLE, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)false))));
    }

    @Test
    @Timeout(value=30L)
    public void testSemiJoinWithMultipleDynamicFiltersOnProbe() {
        this.testSemiJoinWithMultipleDynamicFiltersOnProbe(OptimizerConfig.JoinDistributionType.BROADCAST);
        this.testSemiJoinWithMultipleDynamicFiltersOnProbe(OptimizerConfig.JoinDistributionType.PARTITIONED);
    }

    private void testSemiJoinWithMultipleDynamicFiltersOnProbe(OptimizerConfig.JoinDistributionType joinDistributionType) {
        this.assertQueryDynamicFilters(this.noJoinReordering(joinDistributionType), "SELECT * FROM (SELECT lineitem.suppkey FROM lineitem WHERE lineitem.suppkey IN (SELECT supplier.suppkey FROM tpch.tiny.supplier WHERE supplier.name IN ('Supplier#000000001', 'Supplier#000000002'))) t WHERE t.suppkey IN (SELECT partsupp.suppkey FROM tpch.tiny.partsupp WHERE partsupp.suppkey IN (2, 3))", Set.of(SUPP_KEY_HANDLE), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)SUPP_KEY_HANDLE, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))));
    }

    protected Session getDefaultSession() {
        return TestingSession.testSessionBuilder().setCatalog("test").setSchema("default").setSystemProperty("task_concurrency", "2").setSystemProperty("join_reordering_strategy", OptimizerConfig.JoinReorderingStrategy.NONE.name()).setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.PARTITIONED.name()).setSystemProperty("rewrite_filtering_semi_join_to_inner_join", "false").build();
    }

    private void assertQueryDynamicFilters(@Language(value="SQL") String query, Set<ColumnHandle> expectedColumnsCovered, TupleDomain<ColumnHandle> expectedTupleDomain) {
        this.assertQueryDynamicFilters(this.getSession(), query, expectedColumnsCovered, expectedTupleDomain);
    }

    private void assertQueryDynamicFilters(Session session, @Language(value="SQL") String query, Set<ColumnHandle> expectedColumnsCovered, TupleDomain<ColumnHandle> expectedTupleDomain) {
        this.assertQueryDynamicFilters(session, query, expectedColumnsCovered, (TupleDomain<ColumnHandle> collectedDomain) -> Assertions.assertThat((Object)collectedDomain).isEqualTo((Object)expectedTupleDomain));
    }

    protected void assertQueryDynamicFilters(Session session, @Language(value="SQL") String query, Set<ColumnHandle> expectedColumnsCovered, Consumer<TupleDomain<ColumnHandle>> expectedTupleDomainAssertion) {
        this.expectedDynamicFilterColumnsCovered = expectedColumnsCovered;
        this.expectedCoordinatorDynamicFilterAssertion = expectedTupleDomainAssertion;
        this.expectedTableScanDynamicFilterAssertion = expectedTupleDomainAssertion;
        this.computeActual(session, query);
    }

    private class TestingPlugin
    implements Plugin {
        private final boolean isTaskRetryMode;

        public TestingPlugin(boolean isTaskRetryMode) {
            this.isTaskRetryMode = isTaskRetryMode;
        }

        public Iterable<ConnectorFactory> getConnectorFactories() {
            return ImmutableList.of((Object)new ConnectorFactory(){
                private final ConnectorMetadata metadata = new TestingMetadata();

                public String getName() {
                    return "test";
                }

                public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
                    return new TestConnector(this.metadata, TestingPlugin.this.isTaskRetryMode);
                }
            });
        }
    }

    private class TestConnector
    implements Connector {
        private final ConnectorMetadata metadata;
        private final boolean isTaskRetryMode;

        private TestConnector(ConnectorMetadata metadata, boolean isTaskRetryMode) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.isTaskRetryMode = isTaskRetryMode;
        }

        public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
            return TestingTransactionHandle.create();
        }

        public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
            return this.metadata;
        }

        public ConnectorSplitManager getSplitManager() {
            return new ConnectorSplitManager(){

                public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, final DynamicFilter dynamicFilter, Constraint constraint) {
                    if (!TestConnector.this.isTaskRetryMode) {
                        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dynamicFilter.isBlocked().isDone()).describedAs("Dynamic filter should be initially blocked", new Object[0])).isFalse();
                    }
                    ((AbstractCollectionAssert)Assertions.assertThat((Collection)dynamicFilter.getColumnsCovered()).describedAs("columns covered", new Object[0])).isEqualTo(AbstractTestCoordinatorDynamicFiltering.this.expectedDynamicFilterColumnsCovered);
                    final AtomicBoolean splitProduced = new AtomicBoolean();
                    return new ConnectorSplitSource(){
                        final /* synthetic */ 1 this$2;
                        {
                            this.this$2 = this$2;
                        }

                        public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(int maxSize) {
                            CompletableFuture blocked = dynamicFilter.isBlocked();
                            if (blocked.isDone()) {
                                splitProduced.set(true);
                                return CompletableFuture.completedFuture(new ConnectorSplitSource.ConnectorSplitBatch((List)ImmutableList.of((Object)TestingSplit.createRemoteSplit()), this.isFinished()));
                            }
                            return blocked.thenApply(object -> new ConnectorSplitSource.ConnectorSplitBatch((List)ImmutableList.of(), false));
                        }

                        public void close() {
                        }

                        public boolean isFinished() {
                            ((AbstractCollectionAssert)Assertions.assertThat((Collection)dynamicFilter.getColumnsCovered()).describedAs("columns covered", new Object[0])).isEqualTo(this.this$2.AbstractTestCoordinatorDynamicFiltering.this.expectedDynamicFilterColumnsCovered);
                            if (!dynamicFilter.isComplete() || !splitProduced.get()) {
                                return false;
                            }
                            Assertions.assertThat((boolean)dynamicFilter.isBlocked().isDone()).isTrue();
                            this.this$2.AbstractTestCoordinatorDynamicFiltering.this.expectedCoordinatorDynamicFilterAssertion.accept((TupleDomain<ColumnHandle>)dynamicFilter.getCurrentPredicate());
                            return true;
                        }
                    };
                }
            };
        }

        public ConnectorPageSourceProvider getPageSourceProvider() {
            return new ConnectorPageSourceProvider(){

                public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, final DynamicFilter dynamicFilter) {
                    ((AbstractCollectionAssert)Assertions.assertThat((Collection)dynamicFilter.getColumnsCovered()).describedAs("columns covered", new Object[0])).isEqualTo(AbstractTestCoordinatorDynamicFiltering.this.expectedDynamicFilterColumnsCovered);
                    return new EmptyPageSource(this){
                        final /* synthetic */ 2 this$2;
                        {
                            this.this$2 = this$2;
                        }

                        public CompletableFuture<?> isBlocked() {
                            return dynamicFilter.isBlocked();
                        }

                        public boolean isFinished() {
                            ((AbstractCollectionAssert)Assertions.assertThat((Collection)dynamicFilter.getColumnsCovered()).describedAs("columns covered", new Object[0])).isEqualTo(this.this$2.AbstractTestCoordinatorDynamicFiltering.this.expectedDynamicFilterColumnsCovered);
                            if (!dynamicFilter.isComplete()) {
                                return false;
                            }
                            Assertions.assertThat((boolean)dynamicFilter.isBlocked().isDone()).isTrue();
                            this.this$2.AbstractTestCoordinatorDynamicFiltering.this.expectedTableScanDynamicFilterAssertion.accept((TupleDomain<ColumnHandle>)dynamicFilter.getCurrentPredicate());
                            return true;
                        }
                    };
                }
            };
        }

        public ConnectorPageSinkProvider getPageSinkProvider() {
            return new TestingPageSinkProvider();
        }
    }
}

