/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Strings;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.execution.EventsCollector;
import io.trino.spi.QueryId;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryFailedException;
import io.trino.testing.QueryRunner;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Fail;
import org.intellij.lang.annotations.Language;

class EventsAwaitingQueries {
    private final EventsCollector eventsCollector;
    private final QueryRunner queryRunner;

    EventsAwaitingQueries(EventsCollector eventsCollector, QueryRunner queryRunner) {
        this.eventsCollector = Objects.requireNonNull(eventsCollector, "eventsCollector is null");
        this.queryRunner = Objects.requireNonNull(queryRunner, "queryRunner is null");
    }

    MaterializedResultWithEvents runQueryAndWaitForEvents(@Language(value="SQL") String sql, Session session) throws Exception {
        return this.runQueryAndWaitForEvents(sql, session, Optional.empty());
    }

    MaterializedResultWithEvents runQueryAndWaitForEvents(@Language(value="SQL") String sql, Session session, boolean requireAnonymizedPlan) throws Exception {
        this.eventsCollector.setRequiresAnonymizedPlan(requireAnonymizedPlan);
        return this.runQueryAndWaitForEvents(sql, session, Optional.empty());
    }

    MaterializedResultWithEvents runQueryAndWaitForEvents(@Language(value="SQL") String sql, Session session, Optional<String> expectedExceptionRegEx) throws Exception {
        MaterializedResult result;
        QueryId queryId;
        block6: {
            queryId = null;
            result = null;
            try {
                QueryRunner.MaterializedResultWithPlan materializedResultWithQueryId = this.queryRunner.executeWithPlan(session, sql);
                queryId = materializedResultWithQueryId.queryId();
                result = materializedResultWithQueryId.result();
            }
            catch (RuntimeException exception) {
                if (expectedExceptionRegEx.isPresent()) {
                    String regex = expectedExceptionRegEx.get();
                    if (!Strings.nullToEmpty((String)exception.getMessage()).matches(regex)) {
                        Fail.fail((String)String.format("Expected exception message '%s' to match '%s' for query: %s", exception.getMessage(), regex, sql), (Throwable)exception);
                    }
                } else {
                    throw exception;
                }
                if (!(exception instanceof QueryFailedException)) break block6;
                QueryFailedException queryFailedException = (QueryFailedException)exception;
                queryId = queryFailedException.getQueryId();
            }
        }
        if (queryId == null) {
            return null;
        }
        EventsCollector.QueryEvents queryEvents = this.eventsCollector.getQueryEvents(queryId);
        queryEvents.waitForQueryCompletion(new Duration(30.0, TimeUnit.SECONDS));
        TimeUnit.SECONDS.sleep(1L);
        return new MaterializedResultWithEvents(result, queryEvents);
    }

    public static class MaterializedResultWithEvents {
        private final MaterializedResult materializedResult;
        private final EventsCollector.QueryEvents queryEvents;

        public MaterializedResultWithEvents(MaterializedResult materializedResult, EventsCollector.QueryEvents queryEvents) {
            this.materializedResult = materializedResult;
            this.queryEvents = Objects.requireNonNull(queryEvents, "queryEvents is null");
        }

        public MaterializedResult getMaterializedResult() {
            return this.materializedResult;
        }

        public EventsCollector.QueryEvents getQueryEvents() {
            return this.queryEvents;
        }
    }
}

