/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.units.Duration;
import io.trino.spi.QueryId;
import io.trino.spi.eventlistener.QueryCompletedEvent;
import io.trino.spi.eventlistener.QueryCreatedEvent;
import io.trino.spi.eventlistener.SplitCompletedEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

@ThreadSafe
final class EventsCollector {
    private final ConcurrentHashMap<QueryId, QueryEvents> queryEvents = new ConcurrentHashMap();
    private final AtomicBoolean requiresAnonymizedPlan = new AtomicBoolean(false);

    EventsCollector() {
    }

    public synchronized void addQueryCreated(QueryCreatedEvent event) {
        this.getQueryEvents(new QueryId(event.getMetadata().getQueryId())).addQueryCreated(event);
    }

    public synchronized void addQueryCompleted(QueryCompletedEvent event) {
        this.getQueryEvents(new QueryId(event.getMetadata().getQueryId())).addQueryCompleted(event);
    }

    public synchronized void addSplitCompleted(SplitCompletedEvent event) {
        this.getQueryEvents(new QueryId(event.getQueryId())).addSplitCompleted(event);
    }

    public void setRequiresAnonymizedPlan(boolean value) {
        this.requiresAnonymizedPlan.set(value);
    }

    public boolean requiresAnonymizedPlan() {
        return this.requiresAnonymizedPlan.get();
    }

    public QueryEvents getQueryEvents(QueryId queryId2) {
        return this.queryEvents.computeIfAbsent(queryId2, queryId -> new QueryEvents());
    }

    @ThreadSafe
    public static class QueryEvents {
        @GuardedBy(value="this")
        private QueryCreatedEvent queryCreatedEvent;
        @GuardedBy(value="this")
        private QueryCompletedEvent queryCompletedEvent;
        @GuardedBy(value="this")
        private final CountDownLatch queryCompleteLatch = new CountDownLatch(1);
        @GuardedBy(value="this")
        private final List<SplitCompletedEvent> splitCompletedEvents = new ArrayList<SplitCompletedEvent>();
        @GuardedBy(value="this")
        private CountDownLatch splitEventLatch;
        @GuardedBy(value="this")
        private final List<Exception> failures = new ArrayList<Exception>();

        public synchronized QueryCreatedEvent getQueryCreatedEvent() {
            this.checkFailure();
            if (this.queryCreatedEvent == null) {
                throw new IllegalStateException("QueryCreatedEvent has not been set");
            }
            return this.queryCreatedEvent;
        }

        public synchronized QueryCompletedEvent getQueryCompletedEvent() {
            this.checkFailure();
            if (this.queryCompletedEvent == null) {
                throw new IllegalStateException("QueryCompletedEvent has not been set");
            }
            return this.queryCompletedEvent;
        }

        private synchronized void addQueryCreated(QueryCreatedEvent event) {
            Objects.requireNonNull(event, "event is null");
            if (this.queryCreatedEvent != null) {
                this.failures.add(new RuntimeException("QueryCreateEvent already set"));
                return;
            }
            this.queryCreatedEvent = event;
            if (this.queryCompletedEvent != null) {
                this.queryCompleteLatch.countDown();
            }
        }

        private synchronized void addQueryCompleted(QueryCompletedEvent event) {
            Objects.requireNonNull(event, "event is null");
            if (this.queryCompletedEvent != null) {
                this.failures.add(new RuntimeException("QueryCompletedEvent already set"));
                return;
            }
            this.queryCompletedEvent = event;
            if (this.queryCreatedEvent != null) {
                this.queryCompleteLatch.countDown();
            }
        }

        private synchronized void addSplitCompleted(SplitCompletedEvent event) {
            this.splitCompletedEvents.add(event);
            if (this.splitEventLatch != null) {
                this.splitEventLatch.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForQueryCompletion(Duration timeout) throws InterruptedException, TimeoutException {
            CountDownLatch latch;
            QueryEvents queryEvents = this;
            synchronized (queryEvents) {
                latch = this.queryCompleteLatch;
            }
            boolean finished = latch.await(timeout.toMillis(), TimeUnit.MILLISECONDS);
            if (!finished) {
                QueryEvents queryEvents2 = this;
                synchronized (queryEvents2) {
                    TimeoutException exception = new TimeoutException("Query did not complete in %s. Currently, queryCreatedEvent=%s queryCompletedEvent=%s queryCompleteLatch=%s".formatted(timeout, this.queryCreatedEvent, this.queryCompletedEvent, this.queryCompleteLatch));
                    this.failures.forEach(exception::addSuppressed);
                    throw exception;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized List<SplitCompletedEvent> waitForSplitCompletedEvents(int numberOfSplitEvents, Duration timeout) throws InterruptedException, TimeoutException {
            CountDownLatch latch;
            QueryEvents queryEvents = this;
            synchronized (queryEvents) {
                this.checkFailure();
                if (this.splitCompletedEvents.size() >= numberOfSplitEvents) {
                    return ImmutableList.copyOf(this.splitCompletedEvents);
                }
                if (this.splitEventLatch != null) {
                    throw new IllegalStateException("Wait for split completion already triggered for this query");
                }
                latch = this.splitEventLatch = new CountDownLatch(numberOfSplitEvents - this.splitCompletedEvents.size());
            }
            boolean finished = latch.await(timeout.toMillis(), TimeUnit.MILLISECONDS);
            if (!finished) {
                throw new TimeoutException("Split events did not complete in " + String.valueOf(timeout));
            }
            QueryEvents queryEvents2 = this;
            synchronized (queryEvents2) {
                this.checkFailure();
                return ImmutableList.copyOf(this.splitCompletedEvents);
            }
        }

        private synchronized void checkFailure() {
            if (this.failures.isEmpty()) {
                return;
            }
            RuntimeException exception = new RuntimeException("Event collection failed");
            this.failures.forEach(exception::addSuppressed);
        }
    }
}

