/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.MoreFutures;
import io.opentelemetry.api.trace.Span;
import io.trino.Session;
import io.trino.dispatcher.DispatchManager;
import io.trino.execution.QueryState;
import io.trino.server.BasicQueryInfo;
import io.trino.server.SessionContext;
import io.trino.server.protocol.Slug;
import io.trino.spi.QueryId;
import io.trino.testing.QueryRunner;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class QueryRunnerUtil {
    private QueryRunnerUtil() {
    }

    public static QueryId createQuery(QueryRunner queryRunner, Session session, String sql) {
        DispatchManager dispatchManager = queryRunner.getCoordinator().getDispatchManager();
        MoreFutures.getFutureValue((Future)dispatchManager.createQuery(session.getQueryId(), Span.getInvalid(), Slug.createNew(), SessionContext.fromSession((Session)session), sql));
        return session.getQueryId();
    }

    public static void cancelQuery(QueryRunner queryRunner, QueryId queryId) {
        queryRunner.getCoordinator().getDispatchManager().cancelQuery(queryId);
    }

    public static void waitForQueryState(QueryRunner queryRunner, QueryId queryId, QueryState expectedQueryState) throws InterruptedException {
        QueryRunnerUtil.waitForQueryState(queryRunner, queryId, (Set<QueryState>)ImmutableSet.of((Object)expectedQueryState));
    }

    public static void waitForQueryState(QueryRunner queryRunner, QueryId queryId, Set<QueryState> expectedQueryStates) throws InterruptedException {
        DispatchManager dispatchManager = queryRunner.getCoordinator().getDispatchManager();
        do {
            for (BasicQueryInfo queryInfo : dispatchManager.getQueries()) {
                if (queryInfo.getState() != QueryState.RUNNING) continue;
                dispatchManager.getQueryInfo(queryInfo.getQueryId());
            }
            TimeUnit.MILLISECONDS.sleep(100L);
        } while (!expectedQueryStates.contains(dispatchManager.getQueryInfo(queryId).getState()));
    }
}

