/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingPageSinkProvider;
import io.trino.testing.TestingSession;
import io.trino.testing.TestingSplitManager;
import io.trino.testing.TestingTransactionHandle;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestBeginQuery
extends AbstractTestQueryFramework {
    private final TestMetadata metadata = new TestMetadata();

    protected QueryRunner createQueryRunner() throws Exception {
        Session session = TestingSession.testSessionBuilder().setCatalog("test").setSchema("default").build();
        return DistributedQueryRunner.builder((Session)session).setAdditionalSetup(runner -> {
            runner.installPlugin((Plugin)new TestingPlugin(this.metadata));
            runner.installPlugin((Plugin)new TpchPlugin());
            runner.createCatalog("test", "test", (Map)ImmutableMap.of());
            runner.createCatalog("tpch", "tpch", (Map)ImmutableMap.of());
        }).build();
    }

    @Test
    public void testCreateTableAsSelect() {
        this.metadata.clear();
        this.assertBeginQuery("CREATE TABLE nation AS SELECT * FROM tpch.tiny.nation");
    }

    @Test
    public void testCreateTableAsSelectSameConnector() {
        this.metadata.clear();
        this.assertBeginQuery("CREATE TABLE nation AS SELECT * FROM tpch.tiny.nation");
        this.assertBeginQuery("CREATE TABLE nation_copy AS SELECT * FROM nation");
    }

    @Test
    public void testInsert() {
        this.metadata.clear();
        this.assertBeginQuery("CREATE TABLE nation AS SELECT * FROM tpch.tiny.nation");
        this.assertBeginQuery("INSERT INTO nation SELECT * FROM tpch.tiny.nation");
        this.assertBeginQuery("INSERT INTO nation VALUES (12345, 'name', 54321, 'comment')");
    }

    @Test
    public void testInsertSelectSameConnector() {
        this.metadata.clear();
        this.assertBeginQuery("CREATE TABLE nation AS SELECT * FROM tpch.tiny.nation");
        this.assertBeginQuery("INSERT INTO nation SELECT * FROM nation");
    }

    @Test
    public void testSelect() {
        this.metadata.clear();
        this.assertBeginQuery("CREATE TABLE nation AS SELECT * FROM tpch.tiny.nation");
        this.assertBeginQuery("SELECT * FROM nation");
    }

    private void assertBeginQuery(String query) {
        this.metadata.resetCounters();
        this.computeActual(query);
        Assertions.assertThat((int)this.metadata.begin.get()).isEqualTo(1);
        Assertions.assertThat((int)this.metadata.end.get()).isEqualTo(1);
        this.metadata.resetCounters();
    }

    private static class TestMetadata
    extends TestingMetadata {
        private final AtomicInteger begin = new AtomicInteger();
        private final AtomicInteger end = new AtomicInteger();

        private TestMetadata() {
        }

        public void beginQuery(ConnectorSession session) {
            this.begin.incrementAndGet();
        }

        public void cleanupQuery(ConnectorSession session) {
            this.end.incrementAndGet();
        }

        public void resetCounters() {
            this.begin.set(0);
            this.end.set(0);
        }
    }

    private static class TestingPlugin
    implements Plugin {
        private final TestMetadata metadata;

        private TestingPlugin(TestMetadata metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        }

        public Iterable<ConnectorFactory> getConnectorFactories() {
            return ImmutableList.of((Object)new ConnectorFactory(){

                public String getName() {
                    return "test";
                }

                public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
                    return new TestConnector((ConnectorMetadata)metadata);
                }
            });
        }
    }

    private static class TestConnector
    implements Connector {
        private final ConnectorMetadata metadata;

        private TestConnector(ConnectorMetadata metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        }

        public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
            return TestingTransactionHandle.create();
        }

        public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
            return this.metadata;
        }

        public ConnectorSplitManager getSplitManager() {
            return new TestingSplitManager((List)ImmutableList.of());
        }

        public ConnectorPageSourceProvider getPageSourceProvider() {
            return new ConnectorPageSourceProvider(this){

                public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
                    return new EmptyPageSource();
                }
            };
        }

        public ConnectorPageSinkProvider getPageSinkProvider() {
            return new TestingPageSinkProvider();
        }
    }
}

