/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closer;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.execution.EventsAwaitingQueries;
import io.trino.execution.EventsCollector;
import io.trino.execution.TestEventListenerPlugin;
import io.trino.execution.warnings.WarningCollectorConfig;
import io.trino.spi.Plugin;
import io.trino.spi.TrinoWarning;
import io.trino.spi.WarningCode;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingWarningCollector;
import io.trino.testing.TestingWarningCollectorConfig;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Fail;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestCompletedEventWarnings {
    private static final int TEST_WARNINGS = 5;
    private final EventsCollector generatedEvents = new EventsCollector();
    private Closer closer;
    private EventsAwaitingQueries queries;

    @BeforeAll
    public void setUp() throws Exception {
        this.closer = Closer.create();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)SessionTestUtils.TEST_SESSION).setExtraProperties((Map)ImmutableMap.of((Object)"testing-warning-collector.preloaded-warnings", (Object)String.valueOf(5))).setWorkerCount(0).build();
        this.closer.register((Closeable)queryRunner);
        queryRunner.installPlugin((Plugin)new TestEventListenerPlugin.TestingEventListenerPlugin(this.generatedEvents));
        this.queries = new EventsAwaitingQueries(this.generatedEvents, (QueryRunner)queryRunner);
    }

    @AfterAll
    public void tearDown() throws IOException {
        if (this.closer != null) {
            this.closer.close();
        }
        this.closer = null;
    }

    @Test
    public void testCompletedEventWarnings() throws Exception {
        TestingWarningCollectorConfig warningCollectorConfig = new TestingWarningCollectorConfig().setPreloadedWarnings(5);
        TestingWarningCollector testingWarningCollector = new TestingWarningCollector(new WarningCollectorConfig(), warningCollectorConfig);
        this.assertWarnings("select 1", (List)testingWarningCollector.getWarnings().stream().map(TrinoWarning::getWarningCode).collect(ImmutableList.toImmutableList()));
    }

    private void assertWarnings(@Language(value="SQL") String sql, List<WarningCode> expectedWarnings) throws Exception {
        EventsCollector.QueryEvents queryEvents = this.queries.runQueryAndWaitForEvents(sql, SessionTestUtils.TEST_SESSION).getQueryEvents();
        Set warnings = (Set)queryEvents.getQueryCompletedEvent().getWarnings().stream().map(TrinoWarning::getWarningCode).collect(ImmutableSet.toImmutableSet());
        for (WarningCode warningCode : expectedWarnings) {
            if (warnings.contains(warningCode)) continue;
            Fail.fail((String)("Expected warning: " + String.valueOf(warningCode)));
        }
    }
}

