/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.multibindings.OptionalBinder;
import io.trino.Session;
import io.trino.common.Randoms;
import io.trino.connector.Grants;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.connector.MutableGrants;
import io.trino.metadata.DisabledSystemSecurityMetadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.SystemSecurityMetadata;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.Identity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestDenyOnTable {
    private final SchemaTableName table = new SchemaTableName("default", "table_one");
    private final Session admin = TestDenyOnTable.sessionOf("admin");
    private final Grants<SchemaTableName> tableGrants = new MutableGrants();
    private QueryRunner queryRunner;
    private QueryAssertions assertions;
    private QualifiedObjectName expectedTableName;
    private Set<Privilege> expectedPrivileges;
    private TrinoPrincipal expectedGrantee;
    private boolean denyCalled;

    @BeforeAll
    public void initClass() throws Exception {
        this.queryRunner = DistributedQueryRunner.builder((Session)this.admin).setAdditionalModule(binder -> OptionalBinder.newOptionalBinder((Binder)binder, SystemSecurityMetadata.class).setBinding().toInstance((Object)new DisabledSystemSecurityMetadata(){

            public void denyTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee) {
                Assertions.assertThat((Object)TestDenyOnTable.this.expectedTableName).isEqualTo((Object)tableName);
                Assertions.assertThat(TestDenyOnTable.this.expectedPrivileges).isEqualTo(privileges);
                Assertions.assertThat((Object)TestDenyOnTable.this.expectedGrantee).isEqualTo((Object)grantee);
                Assertions.assertThat((boolean)TestDenyOnTable.this.denyCalled).isFalse();
                TestDenyOnTable.this.denyCalled = true;
            }
        })).build();
        MockConnectorFactory connectorFactory = MockConnectorFactory.builder().withListSchemaNames(session -> ImmutableList.of((Object)"default")).withListTables((session, schemaName) -> "default".equalsIgnoreCase((String)schemaName) ? ImmutableList.of((Object)this.table.getTableName()) : ImmutableList.of()).withGetTableHandle((session, tableName) -> tableName.equals((Object)this.table) ? new MockConnectorTableHandle(tableName) : null).build();
        this.queryRunner.installPlugin((Plugin)new MockConnectorPlugin((ConnectorFactory)connectorFactory));
        this.queryRunner.createCatalog("local", "mock");
        this.assertions = new QueryAssertions(this.queryRunner);
        this.tableGrants.grant(new TrinoPrincipal(PrincipalType.USER, "admin"), (Object)this.table, EnumSet.allOf(Privilege.class), true);
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
        this.queryRunner = null;
    }

    @Test
    public void testValidDenyTable() {
        this.testValidDenyTable("CREATE");
        this.testValidDenyTable("SELECT");
        this.testValidDenyTable("INSERT");
        this.testValidDenyTable("UPDATE");
        this.testValidDenyTable("DELETE");
        this.testValidDenyTable("ALL PRIVILEGES");
    }

    private void testValidDenyTable(String privilege) {
        String username = Randoms.randomUsername();
        this.denyCalled = false;
        this.expectedTableName = new QualifiedObjectName("local", "default", "table_one");
        this.expectedPrivileges = privilege.equalsIgnoreCase("all privileges") ? ImmutableSet.copyOf((Object[])Privilege.values()) : ImmutableSet.of((Object)Privilege.valueOf((String)privilege.toUpperCase(Locale.ROOT)));
        this.expectedGrantee = new TrinoPrincipal(PrincipalType.USER, username);
        this.queryRunner.execute(this.admin, String.format("DENY %s ON TABLE table_one TO %s", privilege, username));
        Assertions.assertThat((boolean)this.denyCalled).isTrue();
    }

    @Test
    public void testDenyOnNonExistingCatalog() {
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("DENY CREATE ON TABLE missing_catalog.missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'missing_catalog.missing_schema.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("DENY SELECT ON TABLE missing_catalog.missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'missing_catalog.missing_schema.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("DENY INSERT ON TABLE missing_catalog.missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'missing_catalog.missing_schema.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("DENY UPDATE ON TABLE missing_catalog.missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'missing_catalog.missing_schema.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("DENY DELETE ON TABLE missing_catalog.missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'missing_catalog.missing_schema.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("DENY ALL PRIVILEGES ON TABLE missing_catalog.missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'missing_catalog.missing_schema.missing_table' does not exist");
    }

    @Test
    public void testDenyOnNonExistingSchema() {
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("DENY CREATE ON TABLE missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.missing_schema.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("DENY SELECT ON TABLE missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.missing_schema.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("DENY INSERT ON TABLE missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.missing_schema.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("DENY UPDATE ON TABLE missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.missing_schema.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("DENY DELETE ON TABLE missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.missing_schema.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("DENY ALL PRIVILEGES ON TABLE missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.missing_schema.missing_table' does not exist");
    }

    @Test
    public void testDenyOnNonExistingTable() {
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("DENY CREATE ON TABLE default.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.default.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("DENY SELECT ON TABLE default.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.default.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("DENY INSERT ON TABLE default.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.default.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("DENY UPDATE ON TABLE default.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.default.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("DENY DELETE ON TABLE default.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.default.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("DENY ALL PRIVILEGES ON TABLE default.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.default.missing_table' does not exist");
    }

    private static Session sessionOf(String username) {
        return TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)username)).setCatalog("local").setSchema("default").build();
    }
}

