/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.client.Warning;
import io.trino.execution.DeprecatedFunctionsPlugin;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.operator.aggregation.state.LongAndDoubleState;
import io.trino.operator.window.RankFunction;
import io.trino.spi.Plugin;
import io.trino.spi.WarningCode;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.StandardWarningCode;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.WindowFunctionSignature;
import io.trino.spi.type.DoubleType;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Fail;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestDeprecatedFunctionWarning {
    private static final WarningCode DEPRECATED_FUNCTION_WARNING_CODE = StandardWarningCode.DEPRECATED_FUNCTION.toWarningCode();
    private static final String EXPECTED_WARNING_MSG = "(DEPRECATED) Use foo() instead.";
    private QueryRunner queryRunner;

    @BeforeAll
    public void setUp() throws Exception {
        this.queryRunner = DistributedQueryRunner.builder((Session)TestingSession.testSessionBuilder().build()).build();
        ImmutableList.of(TestScalaFunction.class, TestDeprecatedParametericScalaFunction.class, TestNonDeprecatedParametericScalaFunction.class, TestDeprecatedAggregation.class, TestNonDeprecatedAggregation.class, TestDeprecatedWindow.class, TestNonDeprecatedWindow.class).forEach(udfClass -> this.queryRunner.addFunctions((FunctionBundle)InternalFunctionBundle.builder().functions(udfClass).build()));
        this.queryRunner.installPlugin((Plugin)new DeprecatedFunctionsPlugin());
    }

    @AfterAll
    public void tearDown() {
        this.queryRunner.close();
        this.queryRunner = null;
    }

    @Test
    public void testDeprecatedScalaFunction() {
        TestDeprecatedFunctionWarning.assertPlannerWarnings(this.queryRunner, "SELECT 123", (List<WarningCode>)ImmutableList.of());
        TestDeprecatedFunctionWarning.assertPlannerWarnings(this.queryRunner, "SELECT lower('A')", (List<WarningCode>)ImmutableList.of());
        TestDeprecatedFunctionWarning.assertPlannerWarnings(this.queryRunner, "SELECT deprecated_scalar()", (List<WarningCode>)ImmutableList.of((Object)DEPRECATED_FUNCTION_WARNING_CODE));
        TestDeprecatedFunctionWarning.assertPlannerWarnings(this.queryRunner, "SELECT non_deprecated_scalar()", (List<WarningCode>)ImmutableList.of());
    }

    @Test
    public void testDeprecatedDescription() {
        String sql = "SELECT deprecated_scalar()";
        List warnings = this.queryRunner.execute(sql).getWarnings();
        if (warnings.size() != 1 || !((Warning)warnings.get(0)).getMessage().contains(EXPECTED_WARNING_MSG)) {
            Fail.fail((String)"Expected warning: (DEPRECATED) Use foo() instead.");
        }
    }

    @Test
    public void testPluginDeprecatedScalaFunction() {
        TestDeprecatedFunctionWarning.assertPlannerWarnings(this.queryRunner, "SELECT plugin_deprecated_scalar()", (List<WarningCode>)ImmutableList.of((Object)DEPRECATED_FUNCTION_WARNING_CODE));
        TestDeprecatedFunctionWarning.assertPlannerWarnings(this.queryRunner, "SELECT plugin_non_deprecated_scalar()", (List<WarningCode>)ImmutableList.of());
    }

    @Test
    public void testDeprecatedParametericScalaFunction() {
        TestDeprecatedFunctionWarning.assertPlannerWarnings(this.queryRunner, "SELECT deprecated_parameteric_scala(1.2)", (List<WarningCode>)ImmutableList.of((Object)DEPRECATED_FUNCTION_WARNING_CODE));
        TestDeprecatedFunctionWarning.assertPlannerWarnings(this.queryRunner, "SELECT deprecated_parameteric_scala(123)", (List<WarningCode>)ImmutableList.of((Object)DEPRECATED_FUNCTION_WARNING_CODE));
        TestDeprecatedFunctionWarning.assertPlannerWarnings(this.queryRunner, "SELECT non_deprecated_parameteric_scala(1.2)", (List<WarningCode>)ImmutableList.of());
        TestDeprecatedFunctionWarning.assertPlannerWarnings(this.queryRunner, "SELECT non_deprecated_parameteric_scala(123)", (List<WarningCode>)ImmutableList.of());
    }

    @Test
    public void testDeprecatedAggregationFunction() {
        TestDeprecatedFunctionWarning.assertPlannerWarnings(this.queryRunner, "SELECT deprecated_aggregation(val) from (VALUES (1),(2),(3)) AS t(val)", (List<WarningCode>)ImmutableList.of((Object)DEPRECATED_FUNCTION_WARNING_CODE));
        TestDeprecatedFunctionWarning.assertPlannerWarnings(this.queryRunner, "SELECT non_deprecated_aggregation(val) from (VALUES (1),(2),(3)) AS t(val)", (List<WarningCode>)ImmutableList.of());
    }

    @Test
    public void testDeprecatedWindowFunction() {
        TestDeprecatedFunctionWarning.assertPlannerWarnings(this.queryRunner, "SELECT deprecated_window() OVER (PARTITION BY id) FROM (VALUES (1,10),(2,20),(3,30)) AS t(id, val)", (List<WarningCode>)ImmutableList.of((Object)DEPRECATED_FUNCTION_WARNING_CODE));
        TestDeprecatedFunctionWarning.assertPlannerWarnings(this.queryRunner, "SELECT non_deprecated_window() OVER (PARTITION BY id) FROM (VALUES (1,10),(2,20),(3,30)) AS t(id, val)", (List<WarningCode>)ImmutableList.of());
    }

    private static void assertPlannerWarnings(QueryRunner queryRunner, @Language(value="SQL") String sql, List<WarningCode> expectedWarnings) {
        Set warnings = (Set)queryRunner.execute(sql).getWarnings().stream().map(Warning::getWarningCode).map(Warning.Code::getCode).collect(ImmutableSet.toImmutableSet());
        expectedWarnings.stream().map(WarningCode::getCode).forEach(expectedWarning -> {
            if (!warnings.contains(expectedWarning)) {
                Fail.fail((String)("Expected warning: " + expectedWarning));
            }
        });
        if (expectedWarnings.isEmpty() && !warnings.isEmpty()) {
            Fail.fail((String)"Expect no warning");
        }
    }

    public static class TestScalaFunction {
        @Deprecated
        @ScalarFunction(value="deprecated_scalar")
        @Description(value="(DEPRECATED) Use foo() instead.")
        @SqlType(value="boolean")
        public static boolean deprecatedScalar() {
            return true;
        }

        @ScalarFunction(value="non_deprecated_scalar")
        @SqlType(value="boolean")
        public static boolean nonDeprecatedScalar() {
            return true;
        }
    }

    @Deprecated
    @ScalarFunction(value="deprecated_parameteric_scala")
    public static class TestDeprecatedParametericScalaFunction {
        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean deprecatedParametericScalaDouble(@SqlNullable @SqlType(value="T") Double value) {
            return value == null;
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean deprecatedParametericScalaLong(@SqlNullable @SqlType(value="T") Long value) {
            return value == null;
        }
    }

    @ScalarFunction(value="non_deprecated_parameteric_scala")
    public static class TestNonDeprecatedParametericScalaFunction {
        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean deprecatedParametericScalaDouble(@SqlNullable @SqlType(value="T") Double value) {
            return value == null;
        }

        @TypeParameter(value="T")
        @SqlType(value="boolean")
        public static boolean deprecatedParametericScalaLong(@SqlNullable @SqlType(value="T") Long value) {
            return value == null;
        }
    }

    @Deprecated
    @AggregationFunction(value="deprecated_aggregation")
    public static class TestDeprecatedAggregation {
        @InputFunction
        public static void input(LongAndDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(LongAndDoubleState state, LongAndDoubleState otherState) {
        }

        @OutputFunction(value="double")
        public static void output(LongAndDoubleState state, BlockBuilder out) {
            DoubleType.DOUBLE.writeDouble(out, 1.0);
        }
    }

    @AggregationFunction(value="non_deprecated_aggregation")
    public static class TestNonDeprecatedAggregation {
        @InputFunction
        public static void input(LongAndDoubleState state, @SqlType(value="double") double value) {
        }

        @CombineFunction
        public static void combine(LongAndDoubleState state, LongAndDoubleState otherState) {
        }

        @OutputFunction(value="double")
        public static void output(LongAndDoubleState state, BlockBuilder out) {
            DoubleType.DOUBLE.writeDouble(out, 1.0);
        }
    }

    @Deprecated
    @WindowFunctionSignature(name="deprecated_window", returnType="bigint")
    public static class TestDeprecatedWindow
    extends RankFunction {
    }

    @WindowFunctionSignature(name="non_deprecated_window", returnType="bigint")
    public static class TestNonDeprecatedWindow
    extends RankFunction {
    }
}

